/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.dao.PeriodicTaskDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.server.script.TaskExecutionItem;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="periodicTaskExecutor")
@DependsOn(value={"startupService", "solverServerService"})
public class TaskExecutorService
implements InitializingBean,
DisposableBean {
    private static Logger sLog = Logger.getLogger(TaskExecutorService.class);
    private TaskExecutor iExecutor = null;
    @Autowired
    SolverServerService solverServerService;
    @Autowired
    PermissionCheck unitimePermissionCheck;

    public void destroy() throws Exception {
        this.iExecutor.interrupt();
    }

    public void afterPropertiesSet() throws Exception {
        this.iExecutor = new TaskExecutor();
        this.iExecutor.start();
    }

    public void checkForQueuedTasks() throws Exception {
        ArrayList<TaskExecutionItem> items = new ArrayList<TaskExecutionItem>();
        Session hibSession = PeriodicTaskDAO.getInstance().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            try {
                List executions = hibSession.createQuery("from TaskExecution e where e.executionStatus = :status and e.scheduledDate <= :now").setTimestamp("now", new Date()).setInteger("status", TaskInterface.ExecutionStatus.QUEUED.ordinal()).list();
                for (TaskExecution execution : executions) {
                    if (this.solverServerService.getQueueProcessor().getByExecutionId(execution.getUniqueId()) != null) continue;
                    try {
                        TaskExecutionItem item = new TaskExecutionItem(execution, this.unitimePermissionCheck);
                        item.setTaskExecutionId(execution.getUniqueId());
                        items.add(item);
                        execution.setExecutionStatus(TaskInterface.ExecutionStatus.QUEUED.ordinal());
                        execution.setQueuedDate(new Date());
                    }
                    catch (Exception e) {
                        execution.setExecutionStatus(TaskInterface.ExecutionStatus.FAILED.ordinal());
                        execution.setStatusMessageCheckLength("Failed to execute: " + e.getMessage());
                        sLog.warn((Object)("Failed to execute " + execution.getTask().getName() + ": " + e.getMessage()), (Throwable)e);
                    }
                    hibSession.update((Object)execution);
                }
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            hibSession.close();
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        hibSession.close();
        _RootDAO.closeCurrentThreadSessions();
        for (TaskExecutionItem item : items) {
            this.solverServerService.getQueueProcessor().add(item);
        }
    }

    public void checkForTasks() throws Exception {
        ArrayList<TaskExecutionItem> items = new ArrayList<TaskExecutionItem>();
        Session hibSession = PeriodicTaskDAO.getInstance().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            try {
                List executions = hibSession.createQuery("from TaskExecution e where e.executionStatus = :status and e.scheduledDate <= :now").setTimestamp("now", new Date()).setInteger("status", TaskInterface.ExecutionStatus.CREATED.ordinal()).list();
                for (TaskExecution execution : executions) {
                    try {
                        TaskExecutionItem item = new TaskExecutionItem(execution, this.unitimePermissionCheck);
                        item.setTaskExecutionId(execution.getUniqueId());
                        items.add(item);
                        execution.setExecutionStatus(TaskInterface.ExecutionStatus.QUEUED.ordinal());
                        execution.setQueuedDate(new Date());
                    }
                    catch (Exception e) {
                        execution.setExecutionStatus(TaskInterface.ExecutionStatus.FAILED.ordinal());
                        execution.setStatusMessageCheckLength("Failed to execute: " + e.getMessage());
                        sLog.warn((Object)("Failed to execute " + execution.getTask().getName() + ": " + e.getMessage()), (Throwable)e);
                    }
                    hibSession.update((Object)execution);
                }
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            hibSession.close();
            _RootDAO.closeCurrentThreadSessions();
            throw throwable;
        }
        hibSession.close();
        _RootDAO.closeCurrentThreadSessions();
        for (TaskExecutionItem item : items) {
            this.solverServerService.getQueueProcessor().add(item);
        }
    }

    public class TaskExecutor
    extends Thread {
        private int iSleepTimeInMinutes;
        private boolean iActive = true;

        public TaskExecutor() {
            this.setName("TaskExecutorService");
            this.setDaemon(true);
            this.iSleepTimeInMinutes = ApplicationProperty.TaskSchedulerCheckIntervalInMinutes.intValue();
        }

        protected boolean isEnabled() {
            return this.iActive && ApplicationProperty.TaskSchedulerEnabled.isTrue() && TaskExecutorService.this.solverServerService.getLocalServer() != null && TaskExecutorService.this.solverServerService.getLocalServer().isActive() && TaskExecutorService.this.solverServerService.getLocalServer().isLocalCoordinator();
        }

        public void run() {
            try {
                sLog.info((Object)"Task executor service started.");
                long iteration = 0L;
                while (this.iActive) {
                    try {
                        TaskExecutor.sleep(this.iSleepTimeInMinutes * 60000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        if (!this.isEnabled()) continue;
                        if (iteration == 0L) {
                            TaskExecutorService.this.checkForQueuedTasks();
                        } else {
                            TaskExecutorService.this.checkForTasks();
                        }
                        ++iteration;
                    }
                    catch (Exception e) {
                        sLog.error((Object)("Failed to check for tasks: " + e.getMessage()), (Throwable)e);
                    }
                }
                sLog.info((Object)"Task executor service stopped.");
            }
            catch (Exception e) {
                sLog.info((Object)("Task executor service failed, " + e.getMessage()), (Throwable)e);
            }
        }

        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

