/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.TeachingRequestInterface;
import org.unitime.timetable.interfaces.ExternalCourseOfferingEditAction;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseClassInstructor;
import org.unitime.timetable.model.base.BaseInstructorAttributePref;
import org.unitime.timetable.model.base.BaseInstructorPref;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseTeachingClassRequest;
import org.unitime.timetable.model.base.BaseTeachingRequest;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=TeachingRequestInterface.SaveRequestsRpcRequest.class)
public class SaveTeachingRequestsBackend
implements GwtRpcImplementation<TeachingRequestInterface.SaveRequestsRpcRequest, GwtRpcResponseNull> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public GwtRpcResponseNull execute(TeachingRequestInterface.SaveRequestsRpcRequest request, SessionContext context) {
        String className;
        org.hibernate.Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
        InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId(), hibSession);
        if (offering == null) {
            throw new GwtRpcException(MESSAGES.errorOfferingDoesNotExist(request.getOfferingId().toString()));
        }
        boolean commit = Department.isInstructorSchedulingCommitted(offering.getDepartment().getUniqueId());
        context.checkPermission(offering.getDepartment(), Right.InstructorAssignmentPreferences);
        HashSet<InstrOfferingConfig> updateConfigs = new HashSet<InstrOfferingConfig>();
        boolean updateOffering = false;
        HashSet<Long> updatedClassIds = new HashSet<Long>();
        Transaction tx = hibSession.beginTransaction();
        try {
            Object ci;
            Iterator<Comparable> i;
            HashMap<Long, TeachingRequest> requests = new HashMap<Long, TeachingRequest>();
            for (TeachingRequest teachingRequest : offering.getTeachingRequests()) {
                requests.put(teachingRequest.getUniqueId(), teachingRequest);
            }
            for (TeachingRequestInterface.Request request2 : request.getRequests()) {
                if (request2 instanceof TeachingRequestInterface.SingleRequest) {
                    TeachingRequestInterface.SingleRequest single = (TeachingRequestInterface.SingleRequest)request2;
                    Object tr = null;
                    if (single.getRequestId() != null) {
                        tr = (TeachingRequest)requests.remove(single.getRequestId());
                    }
                    if (tr == null) {
                        tr = new TeachingRequest();
                        ((BaseTeachingRequest)tr).setOffering(offering);
                        offering.getTeachingRequests().add((TeachingRequest)tr);
                        ((BaseTeachingRequest)tr).setClassRequests(new HashSet<TeachingClassRequest>());
                        ((BasePreferenceGroup)tr).setPreferences(new HashSet<Preference>());
                    } else {
                        Iterator<Preference> i2 = ((BasePreferenceGroup)tr).getPreferences().iterator();
                        while (i2.hasNext()) {
                            Iterator<Object> p = i2.next();
                            hibSession.delete((Object)p);
                            i2.remove();
                        }
                    }
                    ((BaseTeachingRequest)tr).setNbrInstructors(single.getNbrInstructors());
                    this.fillRequestInfo(request2, (TeachingRequest)tr, hibSession);
                    ArrayList<TeachingClassRequest> remains = new ArrayList<TeachingClassRequest>(((BaseTeachingRequest)tr).getClassRequests());
                    for (TeachingRequestInterface.IncludeLine includeLine : single.getClasses()) {
                        TeachingClassRequest cr = null;
                        Iterator i3 = remains.iterator();
                        while (i3.hasNext()) {
                            TeachingClassRequest adept = (TeachingClassRequest)i3.next();
                            if (!adept.getTeachingClass().getUniqueId().equals(includeLine.getOwnerId())) continue;
                            cr = adept;
                            i3.remove();
                            break;
                        }
                        if (cr == null) {
                            cr = new TeachingClassRequest();
                            cr.setTeachingClass((Class_)Class_DAO.getInstance().get(includeLine.getOwnerId(), hibSession));
                            if (cr.getTeachingClass() == null) continue;
                            cr.getTeachingClass().getTeachingRequests().add(cr);
                            cr.setTeachingRequest((TeachingRequest)tr);
                            ((BaseTeachingRequest)tr).getClassRequests().add(cr);
                        }
                        cr.setAssignInstructor(includeLine.isAssign());
                        cr.setCommon(includeLine.isCommon());
                        cr.setCanOverlap(includeLine.isCanOverlap());
                        cr.setLead(includeLine.isLead());
                        cr.setPercentShare(includeLine.getShare());
                    }
                    for (TeachingClassRequest teachingClassRequest : remains) {
                        teachingClassRequest.getTeachingClass().getTeachingRequests().remove(teachingClassRequest);
                        ((BaseTeachingRequest)tr).getClassRequests().remove(teachingClassRequest);
                        hibSession.delete((Object)teachingClassRequest);
                    }
                    hibSession.saveOrUpdate(tr);
                    for (TeachingClassRequest teachingClassRequest : ((BaseTeachingRequest)tr).getClassRequests()) {
                        hibSession.saveOrUpdate((Object)teachingClassRequest);
                    }
                    continue;
                }
                TeachingRequestInterface.MultiRequest multi = (TeachingRequestInterface.MultiRequest)request2;
                for (TeachingRequestInterface.RequestedClass rc : multi.getClasses()) {
                    void var17_36;
                    void var17_34;
                    Class_ clazz = (Class_)Class_DAO.getInstance().get(rc.getClassId(), hibSession);
                    if (clazz == null) continue;
                    Object var17_32 = null;
                    if (rc.getRequestId() != null) {
                        TeachingRequest teachingRequest = (TeachingRequest)requests.remove(rc.getRequestId());
                    }
                    if (var17_34 == null) {
                        TeachingRequest teachingRequest = new TeachingRequest();
                        teachingRequest.setOffering(offering);
                        offering.getTeachingRequests().add(teachingRequest);
                        teachingRequest.setClassRequests(new HashSet<TeachingClassRequest>());
                        teachingRequest.setPreferences(new HashSet<Preference>());
                    } else {
                        i = var17_34.getPreferences().iterator();
                        while (i.hasNext()) {
                            Iterator<Object> p = i.next();
                            hibSession.delete((Object)p);
                            i.remove();
                        }
                    }
                    var17_36.setNbrInstructors(rc.getNbrInstructors());
                    this.fillRequestInfo(request2, (TeachingRequest)var17_36, hibSession);
                    var17_36.setAssignCoordinator(false);
                    var17_36.setPercentShare(0);
                    ArrayList<TeachingClassRequest> remains = new ArrayList<TeachingClassRequest>(var17_36.getClassRequests());
                    for (TeachingRequestInterface.IncludeLine line : multi.getSubparts()) {
                        for (Class_ c : this.getClasses(clazz, line.getOwnerId(), hibSession)) {
                            TeachingClassRequest cr = null;
                            Iterator i4 = remains.iterator();
                            while (i4.hasNext()) {
                                TeachingClassRequest adept = (TeachingClassRequest)i4.next();
                                if (!c.equals(adept.getTeachingClass())) continue;
                                cr = adept;
                                i4.remove();
                                break;
                            }
                            if (cr == null) {
                                cr = new TeachingClassRequest();
                                cr.setTeachingClass(c);
                                if (cr.getTeachingClass() == null) continue;
                                cr.getTeachingClass().getTeachingRequests().add(cr);
                                cr.setTeachingRequest((TeachingRequest)var17_36);
                                var17_36.getClassRequests().add(cr);
                            }
                            cr.setAssignInstructor(line.isAssign());
                            cr.setCommon(line.isCommon());
                            cr.setCanOverlap(line.isCanOverlap());
                            cr.setLead(line.isLead());
                            cr.setPercentShare(line.getShare());
                        }
                    }
                    for (TeachingClassRequest cr : remains) {
                        cr.getTeachingClass().getTeachingRequests().remove(cr);
                        var17_36.getClassRequests().remove(cr);
                        hibSession.delete((Object)cr);
                    }
                    hibSession.saveOrUpdate((Object)var17_36);
                    for (TeachingClassRequest tcr : var17_36.getClassRequests()) {
                        hibSession.saveOrUpdate((Object)tcr);
                    }
                }
            }
            HashSet<DepartmentalInstructor> updatedInstructors = new HashSet<DepartmentalInstructor>();
            for (TeachingRequest tr : requests.values()) {
                tr.getOffering().getTeachingRequests().remove(tr);
                Iterator<TeachingClassRequest> i5 = tr.getClassRequests().iterator();
                while (i5.hasNext()) {
                    TeachingClassRequest cr = i5.next();
                    Iterator<Serializable> j = cr.getTeachingClass().getClassInstructors().iterator();
                    while (j.hasNext()) {
                        ClassInstructor classInstructor = j.next();
                        if (!tr.equals(classInstructor.getTeachingRequest())) continue;
                        Debug.info(cr.getTeachingClass().getClassLabel(hibSession) + ": UNASSIGN " + classInstructor.getInstructor().getNameLastFirst());
                        updatedInstructors.add(classInstructor.getInstructor());
                        classInstructor.getInstructor().getClasses().remove(classInstructor);
                        hibSession.delete((Object)classInstructor);
                        j.remove();
                        updateConfigs.add(cr.getTeachingClass().getSchedulingSubpart().getInstrOfferingConfig());
                        updatedClassIds.add(cr.getTeachingClass().getUniqueId());
                    }
                    cr.getTeachingClass().getTeachingRequests().remove(cr);
                    i5.remove();
                    hibSession.delete((Object)cr);
                }
                Iterator<Comparable> i2 = tr.getPreferences().iterator();
                while (i2.hasNext()) {
                    Preference p = i2.next();
                    hibSession.delete((Object)p);
                    i2.remove();
                }
                i2 = tr.getOffering().getOfferingCoordinators().iterator();
                while (i2.hasNext()) {
                    OfferingCoordinator oc = (OfferingCoordinator)i2.next();
                    if (!tr.equals(oc.getTeachingRequest())) continue;
                    Debug.info(tr.getOffering().getCourseName() + ": UNASSIGN " + oc.getInstructor().getNameLastFirst());
                    updatedInstructors.add(oc.getInstructor());
                    oc.getInstructor().getOfferingCoordinators().remove(oc);
                    hibSession.delete((Object)oc);
                    i2.remove();
                    updateOffering = true;
                }
                hibSession.delete((Object)tr);
            }
            Iterator<OfferingCoordinator> iterator = offering.getOfferingCoordinators().iterator();
            while (iterator.hasNext()) {
                OfferingCoordinator oc = iterator.next();
                if (oc.getTeachingRequest() == null || oc.getTeachingRequest().isAssignCoordinator().booleanValue()) continue;
                Debug.info(offering.getCourseName() + ": UNASSIGN " + oc.getInstructor().getNameLastFirst());
                updatedInstructors.add(oc.getInstructor());
                oc.getInstructor().getOfferingCoordinators().remove(oc);
                hibSession.delete((Object)oc);
                iterator.remove();
                updateOffering = true;
            }
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ class_ : subpart.getClasses()) {
                        i = class_.getClassInstructors().iterator();
                        while (i.hasNext()) {
                            ci = (ClassInstructor)i.next();
                            if (((BaseClassInstructor)ci).getTeachingRequest() == null) continue;
                            BaseTeachingClassRequest support = null;
                            for (TeachingClassRequest tcr : ((BaseClassInstructor)ci).getTeachingRequest().getClassRequests()) {
                                if (!tcr.getTeachingClass().equals(class_) || !tcr.isAssignInstructor().booleanValue()) continue;
                                support = tcr;
                                break;
                            }
                            if (support == null) {
                                Debug.info(class_.getClassLabel(hibSession) + ": UNASSIGN " + ((BaseClassInstructor)ci).getInstructor().getNameLastFirst());
                                updatedInstructors.add(((BaseClassInstructor)ci).getInstructor());
                                ((BaseClassInstructor)ci).getInstructor().getClasses().remove(ci);
                                hibSession.delete(ci);
                                i.remove();
                                updateConfigs.add(config);
                                updatedClassIds.add(class_.getUniqueId());
                                continue;
                            }
                            if (((BaseClassInstructor)ci).getPercentShare().equals(support.getPercentShare()) && ((BaseClassInstructor)ci).isLead().equals(support.getLead()) && ToolBox.equals((Object)((BaseClassInstructor)ci).getResponsibility(), (Object)support.getTeachingRequest().getResponsibility())) continue;
                            Debug.info(class_.getClassLabel(hibSession) + ": UPDATE " + ((BaseClassInstructor)ci).getInstructor().getNameLastFirst());
                            ((BaseClassInstructor)ci).setPercentShare(support.getPercentShare());
                            ((BaseClassInstructor)ci).setLead(support.getLead());
                            ((BaseClassInstructor)ci).setResponsibility(support.getTeachingRequest().getResponsibility());
                            hibSession.saveOrUpdate(ci);
                            updateConfigs.add(config);
                            updatedClassIds.add(class_.getUniqueId());
                        }
                    }
                }
            }
            if (commit) {
                for (TeachingRequest tr : offering.getTeachingRequests()) {
                    if (tr.getAssignedInstructors() == null || tr.getAssignedInstructors().isEmpty()) continue;
                    if (tr.isAssignCoordinator().booleanValue()) {
                        for (DepartmentalInstructor instructor : tr.getAssignedInstructors()) {
                            OfferingCoordinator support = null;
                            for (OfferingCoordinator oc : offering.getOfferingCoordinators()) {
                                if (!instructor.equals(oc.getInstructor()) || !tr.equals(oc.getTeachingRequest())) continue;
                                support = oc;
                                break;
                            }
                            if (support != null) continue;
                            Debug.info(offering.getCourseName() + ": ASSIGN " + instructor.getNameLastFirst());
                            OfferingCoordinator offeringCoordinator = new OfferingCoordinator();
                            offeringCoordinator.setInstructor(instructor);
                            offeringCoordinator.setOffering(offering);
                            offeringCoordinator.setResponsibility(tr.getResponsibility());
                            offeringCoordinator.setPercentShare(tr.getPercentShare());
                            offeringCoordinator.setTeachingRequest(tr);
                            offering.getOfferingCoordinators().add(offeringCoordinator);
                            hibSession.save((Object)offeringCoordinator);
                            updateOffering = true;
                        }
                    }
                    for (TeachingClassRequest cr : tr.getClassRequests()) {
                        if (!cr.isAssignInstructor().booleanValue()) continue;
                        for (DepartmentalInstructor departmentalInstructor : tr.getAssignedInstructors()) {
                            ClassInstructor support = null;
                            for (ClassInstructor ci3 : cr.getTeachingClass().getClassInstructors()) {
                                if (!departmentalInstructor.equals(ci3.getInstructor()) || !tr.equals(ci3.getTeachingRequest())) continue;
                                support = ci3;
                                break;
                            }
                            if (support != null) continue;
                            Debug.info(cr.getTeachingClass().getClassLabel(hibSession) + ": ASSIGN " + departmentalInstructor.getNameLastFirst());
                            ci = new ClassInstructor();
                            ((BaseClassInstructor)ci).setClassInstructing(cr.getTeachingClass());
                            ((BaseClassInstructor)ci).setInstructor(departmentalInstructor);
                            ((BaseClassInstructor)ci).setLead(cr.isLead());
                            ((BaseClassInstructor)ci).setPercentShare(cr.getPercentShare());
                            ((BaseClassInstructor)ci).setResponsibility(tr.getResponsibility());
                            ((BaseClassInstructor)ci).setTeachingRequest(tr);
                            cr.getTeachingClass().getClassInstructors().add((ClassInstructor)ci);
                            departmentalInstructor.getClasses().add((ClassInstructor)ci);
                            hibSession.saveOrUpdate(ci);
                            updateConfigs.add(cr.getTeachingClass().getSchedulingSubpart().getInstrOfferingConfig());
                            updatedClassIds.add(cr.getTeachingClass().getUniqueId());
                        }
                    }
                }
            }
            hibSession.saveOrUpdate((Object)offering);
            tx.commit();
            tx = null;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
        if (!updateConfigs.isEmpty()) {
            try {
                className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalInstrOfferingConfigAssignInstructorsAction assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).newInstance();
                    for (InstrOfferingConfig ioc : updateConfigs) {
                        assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, hibSession);
                    }
                }
            }
            catch (Exception e) {
                Debug.error("Failed to call external action: " + e.getMessage(), e);
            }
        }
        if (updateOffering) {
            try {
                className = ApplicationProperty.ExternalActionCourseOfferingEdit.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className).newInstance();
                    editAction.performExternalCourseOfferingEditAction(offering, hibSession);
                }
            }
            catch (Exception e) {
                Debug.error("Failed to call external action: " + e.getMessage(), e);
            }
        }
        if (!updatedClassIds.isEmpty()) {
            Session session = offering.getSession();
            if (!session.getStatusType().isTestSession()) {
                if (session.getStatusType().canOnlineSectionStudents()) {
                    if (!session.isOfferingLocked(offering.getUniqueId())) {
                        StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), session.getUniqueId(), offering.getUniqueId());
                    }
                } else if (session.getStatusType().canSectionAssistStudents() && !session.isOfferingLocked(offering.getUniqueId())) {
                    StudentSectioningQueue.classAssignmentChanged(hibSession, context.getUser(), session.getUniqueId(), updatedClassIds);
                }
            }
            hibSession.flush();
        }
        return new GwtRpcResponseNull();
    }

    protected void fillRequestInfo(TeachingRequestInterface.Request r, TeachingRequest tr, org.hibernate.Session hibSession) {
        Preference pref;
        tr.setAssignCoordinator(r.isAssignCoordinator());
        tr.setPercentShare(r.getPercentShare());
        tr.setTeachingLoad(Float.valueOf(r.getTeachingLoad()));
        tr.setResponsibility(r.getTeachingResponsibility() == null ? null : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(r.getTeachingResponsibility().getId(), hibSession));
        tr.setSameCoursePreference(r.getSameCoursePreference() == null ? null : (PreferenceLevel)PreferenceLevelDAO.getInstance().get(r.getSameCoursePreference(), hibSession));
        tr.setSameCommonPart(r.getSameCommonPreference() == null ? null : (PreferenceLevel)PreferenceLevelDAO.getInstance().get(r.getSameCommonPreference(), hibSession));
        if (r.hasInstructorPrefernces()) {
            for (TeachingRequestInterface.Preference p : r.getInstructorPreferences()) {
                pref = new InstructorPref();
                pref.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(p.getPreferenceId(), hibSession));
                ((BaseInstructorPref)pref).setInstructor((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(p.getOwnerId(), hibSession));
                if (pref.getPrefLevel() == null || ((BaseInstructorPref)pref).getInstructor() == null) continue;
                pref.setOwner(tr);
                tr.getPreferences().add(pref);
            }
        }
        if (r.hasAttributePrefernces()) {
            for (TeachingRequestInterface.Preference p : r.getAttributePreferences()) {
                pref = new InstructorAttributePref();
                pref.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(p.getPreferenceId(), hibSession));
                ((BaseInstructorAttributePref)pref).setAttribute((InstructorAttribute)InstructorAttributeDAO.getInstance().get(p.getOwnerId(), hibSession));
                if (pref.getPrefLevel() == null || ((BaseInstructorAttributePref)pref).getAttribute() == null) continue;
                pref.setOwner(tr);
                tr.getPreferences().add(pref);
            }
        }
    }

    public Collection<Class_> getClasses(Class_ clazz, Long subpartId, org.hibernate.Session hibSession) {
        SchedulingSubpart parent;
        ArrayList<Class_> ret = new ArrayList<Class_>();
        if (clazz.getSchedulingSubpart().getUniqueId().equals(subpartId)) {
            ret.add(clazz);
            return ret;
        }
        SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(subpartId, hibSession);
        if (subpart == null) {
            return ret;
        }
        if (subpart.isParentOf(clazz.getSchedulingSubpart())) {
            Class_ parent2;
            for (parent2 = clazz.getParentClass(); parent2 != null && !parent2.getSchedulingSubpart().equals(subpart); parent2 = parent2.getParentClass()) {
            }
            if (parent2 != null) {
                ret.add(parent2);
            }
            return ret;
        }
        if (clazz.getSchedulingSubpart().isParentOf(subpart)) {
            for (Class_ c : subpart.getClasses()) {
                if (!clazz.isParentOf(c)) continue;
                ret.add(c);
            }
            return ret;
        }
        for (parent = clazz.getSchedulingSubpart().getParentSubpart(); parent != null && !parent.isParentOf(subpart); parent = parent.getParentSubpart()) {
        }
        if (parent != null) {
            Class_ parentClazz;
            for (parentClazz = clazz.getParentClass(); parentClazz != null && !parentClazz.getSchedulingSubpart().equals(parent); parentClazz = parentClazz.getParentClass()) {
            }
            if (parentClazz != null) {
                for (Class_ c : subpart.getClasses()) {
                    if (!parentClazz.isParentOf(c)) continue;
                    ret.add(c);
                }
                return ret;
            }
        }
        return subpart.getClasses();
    }
}

