/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.PosMinorDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=minor]")
public class Minors
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageMinor(), MESSAGES.pageMinors());
    }

    @PreAuthorize(value="checkPermission('Minors')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> areas = new ArrayList<SimpleEditInterface.ListItem>();
        for (AcademicArea area : AcademicAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            areas.add(new SimpleEditInterface.ListItem(area.getUniqueId().toString(), area.getAcademicAreaAbbreviation() + " - " + area.getTitle()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldAcademicArea(), SimpleEditInterface.FieldType.list, 300, areas, new SimpleEditInterface.Flag[0]));
        data.setSortBy(3, 1, 2);
        for (PosMinor minor : PosMinorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(minor.getUniqueId());
            r.setField(0, minor.getExternalUniqueId());
            r.setField(1, minor.getCode());
            r.setField(2, minor.getName());
            for (AcademicArea area : minor.getAcademicAreas()) {
                r.setField(3, area.getUniqueId().toString());
            }
            r.setDeletable(minor.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.MinorEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('MinorEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (PosMinor minor : PosMinorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(minor.getUniqueId());
            if (r == null) {
                ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
                hibSession.delete((Object)minor);
                continue;
            }
            boolean changed = !ToolBox.equals((Object)minor.getExternalUniqueId(), (Object)r.getField(0)) || !ToolBox.equals((Object)minor.getCode(), (Object)r.getField(1)) || !ToolBox.equals((Object)minor.getName(), (Object)r.getField(2));
            minor.setExternalUniqueId(r.getField(0));
            minor.setCode(r.getField(1));
            minor.setName(r.getField(2));
            HashSet<AcademicArea> delete = new HashSet<AcademicArea>(minor.getAcademicAreas());
            for (String areaId : r.getValues(3)) {
                AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
                if (delete.remove(area)) continue;
                minor.getAcademicAreas().add(area);
                area.getPosMinors().add(minor);
                changed = true;
            }
            for (AcademicArea area : delete) {
                minor.getAcademicAreas().remove(area);
                area.getPosMinors().remove(minor);
                changed = true;
            }
            hibSession.saveOrUpdate((Object)minor);
            if (!changed) continue;
            ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            PosMinor minor = new PosMinor();
            minor.setExternalUniqueId(r.getField(0));
            minor.setCode(r.getField(1));
            minor.setName(r.getField(2));
            minor.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
            minor.setAcademicAreas(new HashSet<AcademicArea>());
            for (String areaId : r.getValues(3)) {
                AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
                minor.getAcademicAreas().add(area);
                area.getPosMinors().add(minor);
            }
            r.setUniqueId((Long)hibSession.save((Object)minor));
            ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
        }
    }

    @PreAuthorize(value="checkPermission('MinorEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        PosMinor minor = new PosMinor();
        minor.setExternalUniqueId(record.getField(0));
        minor.setCode(record.getField(1));
        minor.setName(record.getField(2));
        minor.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        minor.setAcademicAreas(new HashSet<AcademicArea>());
        for (String areaId : record.getValues(3)) {
            AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
            minor.getAcademicAreas().add(area);
            area.getPosMinors().add(minor);
        }
        record.setUniqueId((Long)hibSession.save((Object)minor));
        ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(PosMinor minor, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (minor == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)minor.getExternalUniqueId(), (Object)record.getField(0)) || !ToolBox.equals((Object)minor.getCode(), (Object)record.getField(1)) || !ToolBox.equals((Object)minor.getName(), (Object)record.getField(2));
        minor.setExternalUniqueId(record.getField(0));
        minor.setCode(record.getField(1));
        minor.setName(record.getField(2));
        HashSet<AcademicArea> delete = new HashSet<AcademicArea>(minor.getAcademicAreas());
        for (String areaId : record.getValues(3)) {
            AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
            if (delete.remove(area)) continue;
            minor.getAcademicAreas().add(area);
            area.getPosMinors().add(minor);
            changed = true;
        }
        for (AcademicArea area : delete) {
            minor.getAcademicAreas().remove(area);
            area.getPosMinors().remove(minor);
            changed = true;
        }
        hibSession.saveOrUpdate((Object)minor);
        if (changed) {
            ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @PreAuthorize(value="checkPermission('MinorEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((PosMinor)PosMinorDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(PosMinor minor, SessionContext context, org.hibernate.Session hibSession) {
        if (minor == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, minor, minor.getCode() + " " + minor.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)minor);
    }

    @PreAuthorize(value="checkPermission('MinorEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((PosMinor)PosMinorDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

