/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.admin.AdminTable;

public class AdminBackend {
    private static Logger sLog = Logger.getLogger(AdminBackend.class);

    public static AdminTable getTable(ApplicationContext context, String type) {
        return (AdminTable)context.getBean("gwtAdminTable[type=" + type + "]", AdminTable.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=SimpleEditInterface.DeleteRecordRpcRequest.class)
    public static class DeleteRecordBackend
    implements GwtRpcImplementation<SimpleEditInterface.DeleteRecordRpcRequest, SimpleEditInterface.Record> {
        @Autowired
        ApplicationContext applicationContext;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SimpleEditInterface.Record execute(SimpleEditInterface.DeleteRecordRpcRequest request, SessionContext context) {
            SimpleEditInterface.Record record;
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                try {
                    tx = hibSession.beginTransaction();
                    AdminBackend.getTable(this.applicationContext, request.getType()).delete(request.getRecord(), context, hibSession);
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    record = request.getRecord();
                    Object var7_9 = null;
                }
                catch (PageAccessException e) {
                    throw e;
                }
                catch (GwtRpcException e) {
                    throw e;
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new GwtRpcException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (tx == null) throw throwable;
                    if (!tx.isActive()) throw throwable;
                    tx.rollback();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return record;
            }
            if (tx == null) return record;
            if (!tx.isActive()) return record;
            tx.rollback();
            return record;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=SimpleEditInterface.SaveRecordRpcRequest.class)
    public static class SaveRecordBackend
    implements GwtRpcImplementation<SimpleEditInterface.SaveRecordRpcRequest, SimpleEditInterface.Record> {
        @Autowired
        ApplicationContext applicationContext;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SimpleEditInterface.Record execute(SimpleEditInterface.SaveRecordRpcRequest request, SessionContext context) {
            SimpleEditInterface.Record record;
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                try {
                    tx = hibSession.beginTransaction();
                    if (request.getRecord().getUniqueId() == null) {
                        AdminBackend.getTable(this.applicationContext, request.getType()).save(request.getRecord(), context, hibSession);
                    } else {
                        AdminBackend.getTable(this.applicationContext, request.getType()).update(request.getRecord(), context, hibSession);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    record = request.getRecord();
                    Object var7_9 = null;
                }
                catch (PageAccessException e) {
                    throw e;
                }
                catch (GwtRpcException e) {
                    throw e;
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new GwtRpcException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (tx == null) throw throwable;
                    if (!tx.isActive()) throw throwable;
                    tx.rollback();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return record;
            }
            if (tx == null) return record;
            if (!tx.isActive()) return record;
            tx.rollback();
            return record;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=SimpleEditInterface.SaveDataRpcRequest.class)
    public static class SaveDataBackend
    implements GwtRpcImplementation<SimpleEditInterface.SaveDataRpcRequest, SimpleEditInterface> {
        @Autowired
        ApplicationContext applicationContext;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SimpleEditInterface execute(SimpleEditInterface.SaveDataRpcRequest request, SessionContext context) {
            SimpleEditInterface simpleEditInterface;
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                try {
                    tx = hibSession.beginTransaction();
                    SimpleEditInterface data = request.getData();
                    AdminBackend.getTable(this.applicationContext, request.getType()).save(request.getData(), context, hibSession);
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Iterator<SimpleEditInterface.Record> i = data.getRecords().iterator();
                    while (i.hasNext()) {
                        if (i.next().getUniqueId() != null) continue;
                        i.remove();
                    }
                    simpleEditInterface = data;
                    Object var8_10 = null;
                }
                catch (PageAccessException e) {
                    throw e;
                }
                catch (GwtRpcException e) {
                    throw e;
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new GwtRpcException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (tx == null) throw throwable;
                    if (!tx.isActive()) throw throwable;
                    tx.rollback();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return simpleEditInterface;
            }
            if (tx == null) return simpleEditInterface;
            if (!tx.isActive()) return simpleEditInterface;
            tx.rollback();
            return simpleEditInterface;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=SimpleEditInterface.LoadDataRpcRequest.class)
    public static class LoadDataBackend
    implements GwtRpcImplementation<SimpleEditInterface.LoadDataRpcRequest, SimpleEditInterface> {
        @Autowired
        ApplicationContext applicationContext;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SimpleEditInterface execute(SimpleEditInterface.LoadDataRpcRequest request, SessionContext context) {
            SimpleEditInterface simpleEditInterface;
            Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                try {
                    tx = hibSession.beginTransaction();
                    SimpleEditInterface data = AdminBackend.getTable(this.applicationContext, request.getType()).load(context, hibSession);
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    simpleEditInterface = data;
                    Object var8_11 = null;
                }
                catch (PageAccessException e) {
                    throw e;
                }
                catch (GwtRpcException e) {
                    throw e;
                }
                catch (AccessDeniedException e) {
                    throw new PageAccessException(e.getMessage(), e);
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new GwtRpcException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (tx == null) throw throwable;
                    if (!tx.isActive()) throw throwable;
                    tx.rollback();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {
                // empty catch block
                return simpleEditInterface;
            }
            if (tx == null) return simpleEditInterface;
            if (!tx.isActive()) return simpleEditInterface;
            tx.rollback();
            return simpleEditInterface;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtRpcImplements(value=SimpleEditInterface.GetPageNameRpcRequest.class)
    public static class PageNameBackend
    implements GwtRpcImplementation<SimpleEditInterface.GetPageNameRpcRequest, SimpleEditInterface.PageName> {
        @Autowired
        ApplicationContext applicationContext;

        @Override
        public SimpleEditInterface.PageName execute(SimpleEditInterface.GetPageNameRpcRequest request, SessionContext context) {
            return AdminBackend.getTable(this.applicationContext, request.getType()).name();
        }
    }
}

