/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.rights.Right;

public class InstructorSchedulingPermissions {

    @PermissionForRight(value=Right.InstructorSchedulingSolutionExportXml)
    public static class InstructorSchedulingSolutionExportXml
    extends InstructorSchedulingSolver {
    }

    @PermissionForRight(value=Right.InstructorSchedulingSolverLog)
    public static class InstructorSchedulingSolverLog
    extends InstructorSchedulingSolver {
    }

    @PermissionForRight(value=Right.InstructorSchedulingSolver)
    public static class InstructorSchedulingSolver
    extends InstructorScheduling {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PermissionForRight(value=Right.InstructorScheduling)
    public static class InstructorScheduling
    implements Permission<SolverGroup> {
        @Autowired
        Permission.PermissionDepartment permissionDepartment;

        @Override
        public boolean check(UserContext user, SolverGroup source) {
            for (Department department : source.getDepartments()) {
                if (this.permissionDepartment.check(user, department, DepartmentStatusType.Status.OwnerLimitedEdit)) continue;
                return false;
            }
            for (Department department : source.getDepartments()) {
                for (DepartmentalInstructor di : department.getInstructors()) {
                    if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class<SolverGroup> type() {
            return SolverGroup.class;
        }
    }
}

