/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.evaluation;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;

@Service(value="unitimePermissionCheck")
public class UniTimePermissionCheck
implements PermissionCheck,
InitializingBean {
    protected static SecurityMessages MSG = Localization.create(SecurityMessages.class);
    private static Log sLog = LogFactory.getLog(UniTimePermissionCheck.class);
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    Permission.PermissionDepartment permissionDepartment;
    @Autowired
    Permission.PermissionSession permissionSession;

    public void checkPermission(UserContext user, Serializable targetId, String targetType, Right right) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        if (user.getCurrentAuthority() == null) {
            throw new AccessDeniedException(MSG.noAuthority(right == null ? "NULL" : right.toString()));
        }
        if (right == null) {
            throw new AccessDeniedException(MSG.noRight());
        }
        if (!user.getCurrentAuthority().hasRight(right)) {
            throw new AccessDeniedException(MSG.missingRight(right.toString()));
        }
        if (targetType == null && right.hasType()) {
            targetType = right.type().getSimpleName();
        }
        if (targetType == null) {
            return;
        }
        if (targetId != null && targetId instanceof Collection) {
            for (Serializable id : (Collection)((Object)targetId)) {
                this.checkPermission(user, id, targetType, right);
            }
            return;
        }
        if (targetId != null && targetId.getClass().isArray()) {
            for (Serializable id : (Serializable[])targetId) {
                this.checkPermission(user, id, targetType, right);
            }
            return;
        }
        try {
            Object domainObject;
            Department dept2;
            String className = targetType;
            if (className.indexOf(46) < 0) {
                className = "org.unitime.timetable.model." + className;
            }
            if (targetId == null && Session.class.getName().equals(className)) {
                targetId = user.getCurrentAcademicSessionId();
            }
            if (targetId == null && Department.class.getName().equals(className)) {
                AccessDeniedException firstDenial = null;
                for (Department d : Department.getUserDepartments(user)) {
                    try {
                        this.checkPermission(user, d, right);
                        return;
                    }
                    catch (AccessDeniedException e) {
                        if (firstDenial != null) continue;
                        firstDenial = e;
                    }
                }
                if (firstDenial != null) {
                    throw firstDenial;
                }
                throw new AccessDeniedException(MSG.noDepartment(right.toString()));
            }
            if (targetId == null && SubjectArea.class.getName().equals(className)) {
                AccessDeniedException firstDenial = null;
                for (SubjectArea sa : SubjectArea.getUserSubjectAreas(user)) {
                    try {
                        this.checkPermission(user, sa, right);
                        return;
                    }
                    catch (AccessDeniedException e) {
                        if (firstDenial != null) continue;
                        firstDenial = e;
                    }
                }
                if (firstDenial != null) {
                    throw firstDenial;
                }
                throw new AccessDeniedException(MSG.noSubject(right.toString()));
            }
            if (targetId == null && SolverGroup.class.getName().equals(className)) {
                AccessDeniedException firstDenial = null;
                for (SolverGroup g : SolverGroup.getUserSolverGroups(user)) {
                    try {
                        this.checkPermission(user, g, right);
                        return;
                    }
                    catch (AccessDeniedException e) {
                        if (firstDenial != null) continue;
                        firstDenial = e;
                    }
                }
                if (firstDenial != null) {
                    throw firstDenial;
                }
                throw new AccessDeniedException(MSG.noSolverGroup(right.toString()));
            }
            if (targetId == null && DepartmentalInstructor.class.getName().equals(className)) {
                AccessDeniedException firstDenial = null;
                List<DepartmentalInstructor> instructors = DepartmentalInstructor.getUserInstructors(user);
                if (instructors != null) {
                    for (DepartmentalInstructor i : instructors) {
                        try {
                            this.checkPermission(user, i, right);
                            return;
                        }
                        catch (AccessDeniedException e) {
                            if (firstDenial != null) continue;
                            firstDenial = e;
                        }
                    }
                }
                if (firstDenial != null) {
                    throw firstDenial;
                }
                throw new AccessDeniedException(MSG.noDepartmentalInstructor(right.toString()));
            }
            if (targetId == null) {
                throw new AccessDeniedException(MSG.noDomainObject(right.toString(), targetType));
            }
            if (targetId instanceof Qualifiable) {
                Qualifiable q = (Qualifiable)((Object)targetId);
                if (targetType == null || targetType.equals(q.getQualifierType())) {
                    this.checkPermission(user, q.getQualifierId(), q.getQualifierType(), right);
                    return;
                }
                throw new AccessDeniedException(MSG.wrongDomainObject(right.toString(), q.getQualifierType(), targetType));
            }
            if (targetId instanceof String && Department.class.getName().equals(className) && (dept2 = Department.findByDeptCode((String)((Object)targetId), user.getCurrentAcademicSessionId())) != null) {
                this.checkPermission(user, dept2, right);
                return;
            }
            if (targetId instanceof String) {
                try {
                    targetId = Long.valueOf((String)((Object)targetId));
                }
                catch (NumberFormatException dept2) {
                    // empty catch block
                }
            }
            if (!(targetId instanceof Long)) {
                try {
                    targetId = (Serializable)targetId.getClass().getMethod("getUniqueId", new Class[0]).invoke((Object)targetId, new Object[0]);
                }
                catch (Exception dept2) {
                    // empty catch block
                }
                try {
                    targetId = (Serializable)targetId.getClass().getMethod("getId", new Class[0]).invoke((Object)targetId, new Object[0]);
                }
                catch (Exception dept2) {
                    // empty catch block
                }
            }
            if ((domainObject = new _RootDAO().getSession().get(Class.forName(className), targetId)) == null) {
                throw new AccessDeniedException(MSG.domainObjectNotExists(right.toString(), targetType));
            }
            this.checkPermission(user, domainObject, right);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccessDeniedException(MSG.permissionCheckFailedException(right.toString(), targetType, e.getMessage()));
        }
    }

    public void checkPermission(UserContext user, Object domainObject, Right right) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        if (user.getCurrentAuthority() == null) {
            throw new AccessDeniedException(MSG.noAuthority(right == null ? "NULL" : right.toString()));
        }
        if (right == null) {
            throw new AccessDeniedException(MSG.noRight());
        }
        if (!user.getCurrentAuthority().hasRight(right)) {
            throw new AccessDeniedException(MSG.missingRight(right.toString()));
        }
        if (domainObject == null) {
            return;
        }
        if (domainObject instanceof Collection) {
            for (Object o : (Collection)domainObject) {
                this.checkPermission(user, o, right);
            }
            return;
        }
        if (domainObject.getClass().isArray()) {
            for (Object o : (Object[])domainObject) {
                this.checkPermission(user, o, right);
            }
            return;
        }
        if (right.hasType() && !right.type().isInstance(domainObject)) {
            if (domainObject instanceof Qualifiable) {
                this.checkPermission(user, ((Qualifiable)domainObject).getQualifierId(), ((Qualifiable)domainObject).getQualifierType(), right);
                return;
            }
            if (domainObject instanceof Long) {
                this.checkPermission(user, (Long)domainObject, right.type().getSimpleName(), right);
                return;
            }
            throw new AccessDeniedException(MSG.wrongDomainObject(right.toString(), domainObject.getClass().getSimpleName(), right.type().getSimpleName()));
        }
        try {
            Permission perm = (Permission)this.applicationContext.getBean("permission" + right.name(), Permission.class);
            if (perm != null && perm.type().isInstance(domainObject)) {
                if (((Boolean)perm.getClass().getMethod("check", UserContext.class, perm.type()).invoke((Object)perm, user, domainObject)).booleanValue()) {
                    return;
                }
                throw new AccessDeniedException(MSG.permissionCheckFailed(right.toString(), domainObject.toString()));
            }
        }
        catch (BeansException perm) {
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccessDeniedException(MSG.permissionCheckFailedException(right.toString(), domainObject.toString(), e.getMessage()));
        }
        if (domainObject instanceof Session) {
            if (this.permissionSession.check(user, (Session)domainObject)) {
                return;
            }
            throw new AccessDeniedException(MSG.sessionCheckFailed(right.toString(), domainObject.toString()));
        }
        if (domainObject instanceof Department) {
            if (this.permissionDepartment.check(user, (Department)domainObject)) {
                return;
            }
            throw new AccessDeniedException(MSG.departmentCheckFailed(right.toString(), domainObject.toString()));
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (Right r : Right.values()) {
            try {
                if (!r.hasType()) continue;
                try {
                    Permission p = (Permission)this.applicationContext.getBean("permission" + r.name());
                    if (p == null) {
                        sLog.warn((Object)("No permission found for " + (Object)((Object)r) + " (" + r.type().getSimpleName() + ")."));
                        continue;
                    }
                    if (r.type().equals(p.type())) continue;
                    sLog.warn((Object)("Permission " + (Object)((Object)r) + " (" + r.type().getSimpleName() + ") has a wrong type (" + p.type().getSimpleName() + ")."));
                }
                catch (BeansException e) {
                    sLog.warn((Object)("Failed to find a permission " + (Object)((Object)r) + " (" + r.type().getSimpleName() + "): " + e.getMessage()));
                }
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to check permission " + (Object)((Object)r) + " (" + r.type().getSimpleName() + "): " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void checkPermissionAnyAuthority(UserContext user, Serializable targetId, String targetType, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        AccessDeniedException ret = null;
        block2: for (UserAuthority userAuthority : user.getAuthorities()) {
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block2;
            }
            try {
                this.checkPermission(new UserContextWrapper(user, userAuthority), targetId, targetType, right);
                return;
            }
            catch (AccessDeniedException e) {
                if (ret != null) continue;
                ret = e;
            }
        }
        throw ret != null ? ret : new AccessDeniedException(MSG.noMatchingAuthority(right.toString()));
    }

    public void checkPermissionAnyAuthority(UserContext user, Object targetObject, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        AccessDeniedException ret = null;
        block2: for (UserAuthority userAuthority : user.getAuthorities()) {
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block2;
            }
            try {
                this.checkPermission(new UserContextWrapper(user, userAuthority), targetObject, right);
                return;
            }
            catch (AccessDeniedException e) {
                if (ret != null) continue;
                ret = e;
            }
        }
        throw ret != null ? ret : new AccessDeniedException(MSG.noMatchingAuthority(right.toString()));
    }

    public void checkPermissionAnySession(UserContext user, Serializable targetId, String targetType, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        if (user.getCurrentAuthority() == null) {
            throw new AccessDeniedException(MSG.noAuthority(right == null ? "NULL" : right.toString()));
        }
        String role = user.getCurrentAuthority().getRole();
        AccessDeniedException ret = null;
        block2: for (UserAuthority userAuthority : user.getAuthorities()) {
            if (!role.equals(userAuthority.getRole())) continue;
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block2;
            }
            try {
                this.checkPermission(new UserContextWrapper(user, userAuthority), targetId, targetType, right);
                return;
            }
            catch (AccessDeniedException e) {
                if (ret != null) continue;
                ret = e;
            }
        }
        throw ret != null ? ret : new AccessDeniedException(MSG.noMatchingAuthority(right.toString()));
    }

    public void checkPermissionAnySession(UserContext user, Object targetObject, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException(MSG.noAuthentication(right == null ? "NULL" : right.toString()));
        }
        if (user.getCurrentAuthority() == null) {
            throw new AccessDeniedException(MSG.noAuthority(right == null ? "NULL" : right.toString()));
        }
        String role = user.getCurrentAuthority().getRole();
        AccessDeniedException ret = null;
        block2: for (UserAuthority userAuthority : user.getAuthorities()) {
            if (!role.equals(userAuthority.getRole())) continue;
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block2;
            }
            try {
                this.checkPermission(new UserContextWrapper(user, userAuthority), targetObject, right);
                return;
            }
            catch (AccessDeniedException e) {
                if (ret != null) continue;
                ret = e;
            }
        }
        throw ret != null ? ret : new AccessDeniedException(MSG.noMatchingAuthority(right.toString()));
    }

    public boolean hasPermission(UserContext user, Serializable targetId, String targetType, Right right) {
        if (user == null || user.getCurrentAuthority() == null) {
            return false;
        }
        if (right == null || !user.getCurrentAuthority().hasRight(right)) {
            return false;
        }
        if (targetType == null && right.hasType()) {
            targetType = right.type().getSimpleName();
        }
        if (targetType == null) {
            return true;
        }
        if (targetId != null && targetId instanceof Collection) {
            for (Serializable id : (Collection)((Object)targetId)) {
                if (this.hasPermission(user, id, targetType, right)) continue;
                return false;
            }
            return true;
        }
        if (targetId != null && targetId.getClass().isArray()) {
            for (Serializable id : (Serializable[])targetId) {
                if (this.hasPermission(user, id, targetType, right)) continue;
                return false;
            }
            return true;
        }
        try {
            Object domainObject;
            Department dept2;
            String className = targetType;
            if (className.indexOf(46) < 0) {
                className = "org.unitime.timetable.model." + className;
            }
            if (targetId == null && Session.class.getName().equals(className)) {
                targetId = user.getCurrentAcademicSessionId();
            }
            if (targetId == null && Department.class.getName().equals(className)) {
                for (Department d : Department.getUserDepartments(user)) {
                    if (!this.hasPermission(user, d, right)) continue;
                    return true;
                }
                return false;
            }
            if (targetId == null && SubjectArea.class.getName().equals(className)) {
                for (SubjectArea sa : SubjectArea.getUserSubjectAreas(user)) {
                    if (!this.hasPermission(user, sa, right)) continue;
                    return true;
                }
                return false;
            }
            if (targetId == null && SolverGroup.class.getName().equals(className)) {
                for (SolverGroup g : SolverGroup.getUserSolverGroups(user)) {
                    if (!this.hasPermission(user, g, right)) continue;
                    return true;
                }
                return false;
            }
            if (targetId == null && DepartmentalInstructor.class.getName().equals(className)) {
                List<DepartmentalInstructor> instructors = DepartmentalInstructor.getUserInstructors(user);
                if (instructors != null) {
                    for (DepartmentalInstructor i : instructors) {
                        if (!this.hasPermission(user, i, right)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (targetId == null) {
                return false;
            }
            if (targetId instanceof Qualifiable) {
                Qualifiable q = (Qualifiable)((Object)targetId);
                if (targetType == null || targetType.equals(q.getQualifierType())) {
                    return this.hasPermission(user, q.getQualifierId(), q.getQualifierType(), right);
                }
                return false;
            }
            if (targetId instanceof String && Department.class.getName().equals(className) && (dept2 = Department.findByDeptCode((String)((Object)targetId), user.getCurrentAcademicSessionId())) != null) {
                return this.hasPermission(user, dept2, right);
            }
            if (targetId instanceof String) {
                try {
                    targetId = Long.valueOf((String)((Object)targetId));
                }
                catch (NumberFormatException dept2) {
                    // empty catch block
                }
            }
            if (!(targetId instanceof Long)) {
                try {
                    targetId = (Serializable)targetId.getClass().getMethod("getUniqueId", new Class[0]).invoke((Object)targetId, new Object[0]);
                }
                catch (Exception dept2) {
                    // empty catch block
                }
                try {
                    targetId = (Serializable)targetId.getClass().getMethod("getId", new Class[0]).invoke((Object)targetId, new Object[0]);
                }
                catch (Exception dept2) {
                    // empty catch block
                }
            }
            if ((domainObject = new _RootDAO().getSession().get(Class.forName(className), targetId)) == null) {
                return false;
            }
            return this.hasPermission(user, domainObject, right);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(UserContext user, Object domainObject, Right right) {
        if (user == null || user.getCurrentAuthority() == null) {
            return false;
        }
        if (right == null || !user.getCurrentAuthority().hasRight(right)) {
            return false;
        }
        if (domainObject == null) {
            return true;
        }
        if (domainObject instanceof Collection) {
            for (Object o : (Collection)domainObject) {
                if (this.hasPermission(user, o, right)) continue;
                return false;
            }
            return true;
        }
        if (domainObject.getClass().isArray()) {
            for (Object o : (Object[])domainObject) {
                if (this.hasPermission(user, o, right)) continue;
                return false;
            }
            return true;
        }
        if (right.hasType() && !right.type().isInstance(domainObject)) {
            if (domainObject instanceof Qualifiable) {
                return this.hasPermission(user, ((Qualifiable)domainObject).getQualifierId(), ((Qualifiable)domainObject).getQualifierType(), right);
            }
            if (domainObject instanceof Long) {
                return this.hasPermission(user, (Long)domainObject, right.type().getSimpleName(), right);
            }
            return false;
        }
        try {
            Permission perm = (Permission)this.applicationContext.getBean("permission" + right.name(), Permission.class);
            if (perm != null && perm.type().isInstance(domainObject)) {
                return (Boolean)perm.getClass().getMethod("check", UserContext.class, perm.type()).invoke((Object)perm, user, domainObject);
            }
        }
        catch (Exception e) {
            return false;
        }
        if (domainObject instanceof Session) {
            return this.permissionSession.check(user, (Session)domainObject);
        }
        if (domainObject instanceof Department) {
            return this.permissionDepartment.check(user, (Department)domainObject);
        }
        return true;
    }

    public boolean hasPermissionAnyAuthority(UserContext user, Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        if (user == null) {
            return false;
        }
        block0: for (UserAuthority userAuthority : user.getAuthorities()) {
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block0;
            }
            if (!this.hasPermission(new UserContextWrapper(user, userAuthority), targetId, targetType, right)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissionAnyAuthority(UserContext user, Object targetObject, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null) {
            return false;
        }
        block0: for (UserAuthority userAuthority : user.getAuthorities()) {
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block0;
            }
            if (!this.hasPermission(new UserContextWrapper(user, userAuthority), targetObject, right)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissionAnySession(UserContext user, Serializable targetId, String targetType, Right right, Qualifiable ... filter) {
        if (user == null || user.getCurrentAuthority() == null) {
            return false;
        }
        String role = user.getCurrentAuthority().getRole();
        block0: for (UserAuthority userAuthority : user.getAuthorities()) {
            if (!role.equals(userAuthority.getRole())) continue;
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block0;
            }
            if (!this.hasPermission(new UserContextWrapper(user, userAuthority), targetId, targetType, right)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermissionAnySession(UserContext user, Object targetObject, Right right, Qualifiable ... filter) throws AccessDeniedException {
        if (user == null || user.getCurrentAuthority() == null) {
            return false;
        }
        String role = user.getCurrentAuthority().getRole();
        block0: for (UserAuthority userAuthority : user.getAuthorities()) {
            if (!role.equals(userAuthority.getRole())) continue;
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block0;
            }
            if (!this.hasPermission(new UserContextWrapper(user, userAuthority), targetObject, right)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserContextWrapper
    implements UserContext {
        private static final long serialVersionUID = 1L;
        UserAuthority iAuthority;
        UserContext iContext;

        public UserContextWrapper(UserContext context, UserAuthority authority) {
            this.iContext = context;
            this.iAuthority = authority;
        }

        public boolean isEnabled() {
            return this.iContext.isEnabled();
        }

        public boolean isCredentialsNonExpired() {
            return this.iContext.isCredentialsNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.iContext.isAccountNonLocked();
        }

        public boolean isAccountNonExpired() {
            return this.iContext.isAccountNonExpired();
        }

        public String getUsername() {
            return this.iContext.getUsername();
        }

        public String getPassword() {
            return this.iContext.getPassword();
        }

        @Override
        public void setProperty(UserProperty property, String value) {
            this.iContext.setProperty(property, value);
        }

        @Override
        public void setProperty(String key, String value) {
            this.iContext.setProperty(key, value);
        }

        @Override
        public void setCurrentAuthority(UserAuthority authority) {
            this.iAuthority = authority;
        }

        @Override
        public boolean hasRole(String role) {
            return this.iContext.hasRole(role);
        }

        @Override
        public boolean hasDepartment(Long departmentId) {
            return this.iAuthority.hasQualifier(new SimpleQualifier(Department.class.getSimpleName(), departmentId));
        }

        @Override
        public boolean hasAuthority(String authority) {
            return this.iContext.hasAuthority(authority);
        }

        @Override
        public boolean hasAuthority(String role, Long uniqueId) {
            return this.iContext.hasAuthority(role, uniqueId);
        }

        @Override
        public boolean hasAuthority(UserAuthority authority) {
            return this.iContext.hasAuthority(authority);
        }

        @Override
        public String getProperty(UserProperty property) {
            return this.iContext.getProperty(property);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return this.iContext.getProperty(key, defaultValue);
        }

        @Override
        public String getProperty(String key) {
            return this.iContext.getProperty(key);
        }

        @Override
        public Map<String, String> getProperties() {
            return this.iContext.getProperties();
        }

        @Override
        public String getName() {
            return this.iContext.getName();
        }

        @Override
        public String getExternalUserId() {
            return this.iContext.getExternalUserId();
        }

        @Override
        public String getEmail() {
            return this.iContext.getEmail();
        }

        @Override
        public UserAuthority getCurrentAuthority() {
            return this.iAuthority;
        }

        @Override
        public Long getCurrentAcademicSessionId() {
            return (Long)(this.iAuthority.getAcademicSession() == null ? null : this.iAuthority.getAcademicSession().getQualifierId());
        }

        @Override
        public UserAuthority getAuthority(String authority) {
            return this.iContext.getAuthority(authority);
        }

        @Override
        public UserAuthority getAuthority(String role, Long uniqueId) {
            return this.iContext.getAuthority(role, uniqueId);
        }

        @Override
        public List<? extends UserAuthority> getAuthorities(String role, Qualifiable ... filter) {
            return this.iContext.getAuthorities(role, filter);
        }

        @Override
        public Collection<? extends UserAuthority> getAuthorities() {
            return this.iContext.getAuthorities();
        }

        @Override
        public String getTrueExternalUserId() {
            return this.iContext.getTrueExternalUserId();
        }

        @Override
        public String getTrueName() {
            return this.iContext.getTrueName();
        }
    }
}

