/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.online.selection.ResectioningWeights;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class ReloadOfferingAction
extends WaitlistedOnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private List<Long> iOfferingIds;

    public ReloadOfferingAction forOfferings(Long ... offeringIds) {
        this.iOfferingIds = new ArrayList<Long>();
        for (Long offeringId : offeringIds) {
            this.iOfferingIds.add(offeringId);
        }
        return this;
    }

    public ReloadOfferingAction forOfferings(List<Long> offeringIds) {
        this.iOfferingIds = offeringIds;
        return this;
    }

    public List<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        for (Long offeringId : this.getOfferingIds()) {
            Object var9_7;
            helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
            List studentIds = helper.getHibSession().createQuery("select distinct cr.courseDemand.student.uniqueId from CourseRequest cr where cr.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offeringId.longValue()).list();
            studentIds.addAll(helper.getHibSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.courseRequest is null").setLong("offeringId", offeringId.longValue()).list());
            OnlineSectioningServer.Lock lock = server.lockOffering(offeringId, studentIds, this.name());
            try {
                helper.beginTransaction();
                try {
                    this.reloadOffering(server, helper, offeringId);
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
                var9_7 = null;
                lock.release();
            }
            catch (Throwable throwable) {
                var9_7 = null;
                lock.release();
                throw throwable;
            }
        }
        return true;
    }

    public void reloadOffering(OnlineSectioningServer server, OnlineSectioningHelper helper, Long offeringId) {
        HashMap<Long, Student> newStudents = new HashMap<Long, Student>();
        for (Student student : helper.getHibSession().createQuery("select distinct s from Student s left join s.courseDemands as cd left join cd.courseRequests as cr left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where cr.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offeringId.longValue()).list()) {
            newStudents.put(student.getUniqueId(), student);
        }
        for (Student student : helper.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.courseOffering as co left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.courseRequest is null").setLong("offeringId", offeringId.longValue()).list()) {
            newStudents.put(student.getUniqueId(), student);
        }
        if (server.needPersistExpectedSpaces(offeringId)) {
            PersistExpectedSpacesAction.persistExpectedSpaces(offeringId, false, server, helper);
        }
        XOffering oldOffering = server.getOffering(offeringId);
        XEnrollments oldEnrollments = server.getEnrollments(offeringId);
        XOffering newOffering = null;
        InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, helper.getHibSession());
        ArrayList<XDistribution> distributions = new ArrayList<XDistribution>();
        if (io != null && io.isAllowStudentScheduling()) {
            List distPrefs = helper.getHibSession().createQuery("select distinct p from DistributionPref p inner join p.distributionObjects o, Department d, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and io.uniqueId = :offeringId and (o.prefGroup = c or o.prefGroup = c.schedulingSubpart) and p.owner = d and p.prefLevel.prefProlog = :pref").setString("ref1", GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setString("ref2", "NO_CONFLICT").setString("pref", PreferenceLevel.sRequired).setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).setLong("offeringId", offeringId.longValue()).list();
            if (!distPrefs.isEmpty()) {
                for (DistributionPref pref : distPrefs) {
                    int n = 0;
                    for (Collection<Class_> sections : ReloadAllData.getSections(pref)) {
                        XDistributionType type = XDistributionType.IngoreConflicts;
                        if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                            type = XDistributionType.LinkedSections;
                        }
                        XDistribution distribution = new XDistribution(type, pref.getUniqueId(), n++, sections);
                        distributions.add(distribution);
                    }
                }
            }
            if ((newOffering = ReloadAllData.loadOffering(io, distributions, server, helper)) != null) {
                server.update(newOffering);
            } else if (oldOffering != null) {
                server.remove(oldOffering);
            }
            List infos = helper.getHibSession().createQuery("select i.clazz.uniqueId, i.nbrExpectedStudents from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offeringId.longValue()).list();
            XExpectations expectations = new XExpectations(offeringId);
            for (Object[] objectArray : infos) {
                Long sectionId = (Long)objectArray[0];
                Double expected = (Double)objectArray[1];
                expectations.setExpectedSpace(sectionId, expected);
            }
            server.update(expectations);
        } else if (oldOffering != null) {
            server.remove(oldOffering);
        }
        ArrayList<XStudent[]> students = new ArrayList<XStudent[]>();
        if (oldEnrollments != null) {
            HashSet checked = new HashSet();
            for (XRequest xRequest : oldEnrollments.getRequests()) {
                XStudent newStudent;
                if (!checked.add(xRequest.getStudentId())) continue;
                XStudent xStudent = server.getStudent(xRequest.getStudentId());
                Object student = (Student)newStudents.get(xStudent.getStudentId());
                if (student == null) {
                    student = (Student)StudentDAO.getInstance().get(xStudent.getStudentId(), helper.getHibSession());
                }
                XStudent xStudent2 = newStudent = student == null ? null : ReloadAllData.loadStudent((Student)student, null, server, helper);
                if (newStudent != null) {
                    server.update(newStudent, true);
                } else {
                    server.remove(xStudent);
                }
                students.add(new XStudent[]{xStudent, newStudent});
                newStudents.remove(xStudent.getStudentId());
            }
        }
        for (Student student : newStudents.values()) {
            XStudent xStudent = server.getStudent(student.getUniqueId());
            XStudent xStudent3 = ReloadAllData.loadStudent(student, null, server, helper);
            if (xStudent3 != null) {
                server.update(xStudent3, true);
            } else if (xStudent != null) {
                server.remove(xStudent);
            }
            students.add(new XStudent[]{xStudent, xStudent3});
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            return;
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            return;
        }
        if (newOffering == null && oldOffering == null) {
            return;
        }
        TreeSet<SectioningRequest> queue = new TreeSet<SectioningRequest>();
        HashSet<XCourse> courseIds = new HashSet<XCourse>();
        if (newOffering != null) {
            courseIds.addAll(newOffering.getCourses());
        }
        if (oldOffering != null) {
            courseIds.addAll(oldOffering.getCourses());
        }
        for (XCourseId xCourseId : courseIds) {
            for (XStudent[] student : students) {
                OnlineSectioningLog.Enrollment.Builder enrollment;
                if (student[0] == null && student[1] == null) continue;
                XEnrollment oldEnrollment = null;
                XCourseRequest oldRequest = null;
                if (student[0] != null) {
                    block15: for (XRequest r : student[0].getRequests()) {
                        if (!(r instanceof XCourseRequest)) continue;
                        XCourseRequest cr = (XCourseRequest)r;
                        for (XCourseId c : cr.getCourseIds()) {
                            if (!c.equals(xCourseId)) continue;
                            oldRequest = cr;
                            if (cr.getEnrollment() == null || !offeringId.equals(cr.getEnrollment().getOfferingId())) continue block15;
                            oldEnrollment = cr.getEnrollment();
                            continue block15;
                        }
                    }
                }
                XCourseRequest newRequest = null;
                XEnrollment newEnrollment = null;
                if (student[1] != null) {
                    block17: for (XRequest r : student[1].getRequests()) {
                        if (!(r instanceof XCourseRequest)) continue;
                        Iterator<XSection> cr = (XCourseRequest)r;
                        for (XCourseId c : ((XCourseRequest)((Object)cr)).getCourseIds()) {
                            if (!c.equals(xCourseId)) continue;
                            newRequest = cr;
                            if (((XCourseRequest)((Object)cr)).getEnrollment() == null || !offeringId.equals(((XCourseRequest)((Object)cr)).getEnrollment().getOfferingId())) continue block17;
                            newEnrollment = ((XCourseRequest)((Object)cr)).getEnrollment();
                            continue block17;
                        }
                    }
                }
                if (oldRequest == null && newRequest == null) continue;
                OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student[0] == null ? student[1].getStudentId() : student[0].getStudentId()).setExternalId(student[0] == null ? student[1].getExternalId() : student[0].getExternalId()));
                action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setName(newOffering == null ? oldOffering.getName() : newOffering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
                action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(xCourseId.getCourseId()).setName(xCourseId.getCourseName()).setType(OnlineSectioningLog.Entity.EntityType.COURSE));
                if (oldEnrollment != null) {
                    enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                    enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                    for (Long l : oldEnrollment.getSectionIds()) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(oldOffering.getSection(l), oldEnrollment));
                    }
                    action.addEnrollment(enrollment);
                    if (newRequest == null) {
                        action.addRequest(OnlineSectioningHelper.toProto(oldRequest));
                    }
                }
                if (newRequest == null) {
                    if (oldEnrollment != null && CustomStudentEnrollmentHolder.hasProvider()) {
                        try {
                            CustomStudentEnrollmentHolder.getProvider().resection(server, helper, new SectioningRequest(newOffering, newRequest, student[1], action).setOldOffering(oldOffering).setOldStudent(student[0]).setOldRequest(oldRequest).setLastEnrollment(oldEnrollment), null);
                        }
                        catch (Exception ex) {
                            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(ex.getMessage() == null ? "null" : ex.getMessage()));
                            helper.error("Unable to resection student: " + ex.getMessage(), ex);
                        }
                    }
                    action.setEndTime(System.currentTimeMillis());
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(student[0] == null ? student[1].getStudentId() : student[0].getStudentId()).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                    continue;
                }
                action.addRequest(OnlineSectioningHelper.toProto(newRequest));
                if (oldEnrollment == null && newEnrollment == null) {
                    if (!student[1].canAssign(newRequest) || !this.isWaitListed(student[1], newRequest, server, helper)) continue;
                    queue.add(new SectioningRequest(newOffering, newRequest, student[1], action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(student[0]));
                    continue;
                }
                if (newEnrollment != null && this.check(newOffering, xCourseId, distributions, student[1], newEnrollment, server)) {
                    enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                    enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                    for (XSection xSection : newOffering.getSections(newEnrollment)) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(xSection, newEnrollment));
                    }
                    action.addEnrollment(enrollment);
                    if (CustomStudentEnrollmentHolder.hasProvider()) {
                        try {
                            CustomStudentEnrollmentHolder.getProvider().resection(server, helper, new SectioningRequest(newOffering, newRequest, student[1], action).setOldOffering(oldOffering).setOldStudent(student[0]).setOldRequest(oldRequest).setLastEnrollment(oldEnrollment), newEnrollment);
                        }
                        catch (Exception ex) {
                            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(ex.getMessage() == null ? "null" : ex.getMessage()));
                            helper.error("Unable to resection student: " + ex.getMessage(), ex);
                        }
                    }
                    action.setEndTime(System.currentTimeMillis());
                    if (ReloadOfferingAction.isVerySame(newEnrollment.getCourseId(), newOffering.getSections(newEnrollment), oldOffering.getSections(oldEnrollment))) continue;
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(student[0] == null ? student[1].getStudentId() : student[0].getStudentId()).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                    continue;
                }
                newRequest = server.assign(newRequest, null);
                queue.add(new SectioningRequest(newOffering, newRequest, student[1], action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(student[0]).setLastEnrollment(oldEnrollment).setNewEnrollment(newEnrollment));
            }
        }
        if (!queue.isEmpty()) {
            DataProperties dataProperties = new DataProperties();
            ResectioningWeights resectioningWeights = new ResectioningWeights(dataProperties);
            DistanceConflict dc = new DistanceConflict(server.getDistanceMetric(), dataProperties);
            TimeOverlapsCounter toc = new TimeOverlapsCounter(null, dataProperties);
            Date ts = new Date();
            for (SectioningRequest r : queue) {
                helper.debug("Resectioning " + r.getRequest() + " (was " + (r.getLastEnrollment() == null ? "not assigned" : r.getLastEnrollment().getSectionIds()) + ")");
                long c0 = OnlineSectioningHelper.getCpuTime();
                XEnrollment e = r.resection(server, resectioningWeights, dc, toc);
                if (e != null) {
                    e.setTimeStamp(ts);
                    OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                    enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                    for (Long sectionId : e.getSectionIds()) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(newOffering.getSection(sectionId), e));
                    }
                    r.getAction().addEnrollment(enrollment);
                }
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    try {
                        e = CustomStudentEnrollmentHolder.getProvider().resection(server, helper, r, e);
                    }
                    catch (Exception ex) {
                        r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        r.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(ex.getMessage() == null ? "null" : ex.getMessage()));
                        helper.error("Unable to resection student: " + ex.getMessage(), ex);
                        if (r.getNewEnrollment() == null) continue;
                        server.assign(r.getRequest(), r.getNewEnrollment());
                        continue;
                    }
                }
                if (e == null && r.getLastEnrollment() == null) continue;
                if (e != null) {
                    r.setRequest(server.assign(r.getRequest(), e));
                }
                helper.debug("New: " + (e == null ? "not assigned" : e.getSectionIds()));
                Student student = (Student)StudentDAO.getInstance().get(r.getRequest().getStudentId(), helper.getHibSession());
                HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
                String approvedBy = null;
                Date approvedDate = null;
                Iterator<StudentClassEnrollment> i = student.getClassEnrollments().iterator();
                while (i.hasNext()) {
                    StudentClassEnrollment enrl = i.next();
                    if ((enrl.getCourseRequest() == null || !enrl.getCourseRequest().getCourseDemand().getUniqueId().equals(r.getRequest().getRequestId())) && (enrl.getCourseOffering() == null || !enrl.getCourseOffering().getUniqueId().equals(r.getCourseId().getCourseId()))) continue;
                    helper.debug("Deleting " + enrl.getClazz().getClassLabel());
                    hashMap.put(enrl.getClazz().getUniqueId(), enrl);
                    if (approvedBy == null && enrl.getApprovedBy() != null) {
                        approvedBy = enrl.getApprovedBy();
                        approvedDate = enrl.getApprovedDate();
                    }
                    enrl.getClazz().getStudentEnrollments().remove(enrl);
                    helper.getHibSession().delete((Object)enrl);
                    i.remove();
                }
                BaseCourseDemand cd = null;
                block24: for (CourseDemand x : student.getCourseDemands()) {
                    for (CourseRequest q : x.getCourseRequests()) {
                        if (!q.getCourseOffering().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                        cd = x;
                        break block24;
                    }
                }
                if (r.getRequest().getEnrollment() != null) {
                    CourseRequest cr = null;
                    CourseOffering co = null;
                    if (co == null) {
                        for (CourseOffering x : io.getCourseOfferings()) {
                            if (!x.getUniqueId().equals(r.getRequest().getEnrollment().getCourseId())) continue;
                            co = x;
                        }
                    }
                    for (Long sectionId : r.getRequest().getEnrollment().getSectionIds()) {
                        Class_ clazz = (Class_)Class_DAO.getInstance().get(sectionId, helper.getHibSession());
                        if (cd != null && cr == null) {
                            for (CourseRequest x : cd.getCourseRequests()) {
                                if (!x.getCourseOffering().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                                cr = x;
                                break;
                            }
                        }
                        if (co == null) {
                            co = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                        }
                        StudentClassEnrollment enrl = new StudentClassEnrollment();
                        enrl.setClazz(clazz);
                        clazz.getStudentEnrollments().add(enrl);
                        enrl.setCourseOffering(co);
                        enrl.setCourseRequest(cr);
                        StudentClassEnrollment old = (StudentClassEnrollment)hashMap.get(sectionId);
                        enrl.setTimestamp(old != null ? old.getTimestamp() : ts);
                        enrl.setChangedBy(old != null ? old.getChangedBy() : (helper.getUser() == null ? StudentClassEnrollment.SystemChange.SYSTEM.toString() : helper.getUser().getExternalId()));
                        enrl.setStudent(student);
                        enrl.setApprovedBy(approvedBy);
                        enrl.setApprovedDate(approvedDate);
                        student.getClassEnrollments().add(enrl);
                        helper.debug("Adding " + enrl.getClazz().getClassLabel());
                    }
                } else if (!r.getRequest().isAlternative()) {
                    if (cd != null && !cd.isWaitlist().booleanValue()) {
                        cd.setWaitlist(true);
                        helper.getHibSession().saveOrUpdate((Object)cd);
                    }
                    if (!r.getRequest().isWaitlist()) {
                        r.setRequest(server.waitlist(r.getRequest(), true));
                    }
                }
                helper.getHibSession().save((Object)student);
                EnrollStudent.updateSpace(server, r.getRequest().getEnrollment() == null ? null : SectioningRequest.convert(r.getStudent(), r.getRequest(), server, newOffering, r.getRequest().getEnrollment()), r.getLastEnrollment() == null ? null : SectioningRequest.convert(r.getOldStudent(), r.getOldRequest(), server, oldOffering, r.getLastEnrollment()), newOffering, oldOffering);
                server.persistExpectedSpaces(offeringId);
                server.execute(server.createAction(NotifyStudentAction.class).forStudent(r.getRequest().getStudentId()).oldEnrollment(oldOffering, r.getCourseId(), r.getLastEnrollment()), helper.getUser());
                r.getAction().setResult(e == null ? OnlineSectioningLog.Action.ResultType.NULL : OnlineSectioningLog.Action.ResultType.SUCCESS);
                r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                r.getAction().setEndTime(System.currentTimeMillis());
            }
        }
    }

    public boolean check(XOffering offering, XCourseId course, Collection<XDistribution> distributions, XStudent student, XEnrollment enrollment, OnlineSectioningServer server) {
        List<XSection> sections = offering.getSections(enrollment);
        if (sections.size() != offering.getConfig(enrollment.getConfigId()).getSubparts().size()) {
            return false;
        }
        for (XSection s1 : sections) {
            for (XSection s2 : sections) {
                if (s1.getSectionId() >= s2.getSectionId() || !s1.isOverlapping(distributions, s2)) continue;
                return false;
            }
        }
        if (!offering.isAllowOverlap(student, enrollment.getConfigId(), enrollment, sections)) {
            for (XRequest r : student.getRequests()) {
                XOffering other;
                XCourseRequest cr;
                if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || course.getCourseId().equals(cr.getEnrollment().getCourseId()) || (other = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                List<XSection> assignment = other.getSections(cr.getEnrollment());
                if (other.isAllowOverlap(student, cr.getEnrollment().getConfigId(), cr.getEnrollment(), assignment)) continue;
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment)) continue;
                    return false;
                }
            }
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
            for (XSection section : sections) {
                if (!section.isCancelled()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean sameRooms(XSection s, List<XRoom> rooms) {
        if (s.getRooms() == null && rooms == null) {
            return true;
        }
        if (s.getRooms() == null || rooms == null) {
            return false;
        }
        return s.getRooms().size() == rooms.size() && s.getRooms().containsAll(rooms);
    }

    public static boolean sameTime(XSection s, XTime t) {
        if (s.getTime() == null && t == null) {
            return true;
        }
        if (s.getTime() == null || t == null) {
            return false;
        }
        return s.getTime().getSlot() == t.getSlot() && s.getTime().getLength() == t.getLength() && s.getTime().getDays() == t.getDays() && ToolBox.equals((Object)s.getTime().getDatePatternName(), (Object)t.getDatePatternName());
    }

    public static boolean sameName(Long courseId, XSection s1, XSection s2) {
        return s1.getName(courseId).equals(s2.getName(courseId));
    }

    public static boolean isVerySame(Long courseId, List<XSection> e1, List<XSection> e2) {
        if (e1.size() != e2.size()) {
            return false;
        }
        block0: for (XSection s1 : e1) {
            for (XSection s2 : e2) {
                if (!ReloadOfferingAction.sameName(courseId, s1, s2) || !ReloadOfferingAction.sameTime(s1, s2.getTime()) || !ReloadOfferingAction.sameRooms(s1, s2.getRooms())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public String name() {
        return "reload-offering";
    }

    protected static class StudentPair {
        XStudent iOldStudent;
        XStudent iNewStudent;

        StudentPair(XStudent oldStudent, XStudent newStudent) {
            this.iOldStudent = oldStudent;
            this.iNewStudent = newStudent;
        }

        public XStudent getNewStudent() {
            return this.iNewStudent;
        }

        public boolean hasNewStudent() {
            return this.iNewStudent != null;
        }

        public XStudent getOldStudent() {
            return this.iOldStudent;
        }

        public boolean hasOldStudent() {
            return this.iOldStudent != null;
        }
    }
}

