/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.util.DistanceMetric;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindStudentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.StudentInfo>> {
    private static final long serialVersionUID = 1L;
    protected Query iQuery;
    protected Integer iLimit = null;
    protected Set<Long> iCoursesIcoordinate;
    protected Set<Long> iCoursesIcanApprove;
    protected Set<Long> iMyStudents;
    protected Set<String> iSubjectAreas;
    protected boolean iCanShowExtIds = false;
    protected boolean iCanRegister = false;
    protected boolean iCanUseAssistant = false;
    protected boolean iIsAdmin = false;
    protected boolean iIsAdvisor = false;
    protected boolean iCanEditMyStudents = false;
    protected boolean iCanEditOtherStudents = false;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindStudentInfoAction withParams(String query, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove, Set<Long> myStudents, Set<String> subjects, boolean canShowExtIds, boolean canRegister, boolean canUseAssistant) {
        this.iQuery = new Query(query);
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        this.iMyStudents = myStudents;
        this.iCanShowExtIds = canShowExtIds;
        this.iCanRegister = canRegister;
        this.iCanUseAssistant = canUseAssistant;
        this.iSubjectAreas = subjects;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindStudentInfoAction withPermissions(boolean isAdmin, boolean isAdvisor, boolean canEditMyStudents, boolean canEditOtherStudents) {
        this.iIsAdmin = isAdmin;
        this.iIsAdvisor = isAdvisor;
        this.iCanEditMyStudents = canEditMyStudents;
        this.iCanEditOtherStudents = canEditOtherStudents;
        return this;
    }

    public FindStudentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    public boolean hasMatchingSubjectArea(String subject) {
        return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public boolean isCanSelect(XStudentId student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor && (this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student));
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        int gOvrNeed = 0;
        int gtOvrNeed = 0;
        int gDist = 0;
        int gtDist = 0;
        int gNrDC = 0;
        int gtNrDC = 0;
        int gShr = 0;
        int gtShr = 0;
        int gFre = 0;
        int gtFre = 0;
        int gPIM = 0;
        int gtPIM = 0;
        int gPSec = 0;
        int gtPSec = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        HashSet<Long> assigned = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        HashSet<String> regStates = new HashSet<String>();
        HashSet<String> assStates = new HashSet<String>();
        Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.enabled)) {
                assStates.add(status.getReference());
            }
            if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.regenabled)) continue;
            regStates.add(status.getReference());
        }
        DistanceMetric dm = server.getDistanceMetric();
        Set<Long> studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        for (XCourseId xCourseId : this.findCourses(server, helper)) {
            XOffering xOffering = server.getOffering(xCourseId.getOfferingId());
            if (xOffering == null) continue;
            XCourse xCourse = xOffering.getCourse(xCourseId.getCourseId());
            XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
            if (enrollments == null) continue;
            boolean isConsentToDoCourse = this.isConsentToDoCourse(xCourse);
            for (XCourseRequest request : enrollments.getRequests()) {
                Iterator<String> student;
                if (!request.hasCourse(xCourseId.getCourseId()) || request.getEnrollment() != null && !request.getEnrollment().getCourseId().equals(xCourseId.getCourseId()) || studentIds != null && !studentIds.contains(request.getStudentId()) || (student = server.getStudent(request.getStudentId())) == null) continue;
                StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, xCourse, (XStudent)((Object)student), xOffering, request, isConsentToDoCourse, this.isMyStudent((XStudentId)((Object)student)), server);
                if (!this.query().match(m)) continue;
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(request.getStudentId());
                if (s == null) {
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(request.getStudentId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(request.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(((XStudentId)((Object)student)).getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    String status = ((XStudent)((Object)student)).getStatus() == null ? session.getDefaultSectioningStatus() : ((XStudent)((Object)student)).getStatus();
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect((XStudentId)((Object)student)));
                    st.setName(((XStudentId)((Object)student)).getName());
                    for (XAreaClassificationMajor acm : ((XStudent)((Object)student)).getMajors()) {
                        st.addArea(acm.getArea());
                        st.addClassification(acm.getClassification());
                        st.addMajor(acm.getMajor());
                    }
                    for (String acc : ((XStudent)((Object)student)).getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (String gr : ((XStudent)((Object)student)).getGroups()) {
                        st.addGroup(gr);
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    int tOvrNeed = 0;
                    int ovrNeed = 0;
                    float tCred = 0.0f;
                    int nrDisCnf = 0;
                    int maxDist = 0;
                    int share = 0;
                    int ftShare = 0;
                    ArrayList<Float> minsTot = new ArrayList<Float>();
                    ArrayList<Float> maxsTot = new ArrayList<Float>();
                    ArrayList<Float> mins = new ArrayList<Float>();
                    ArrayList<Float> maxs = new ArrayList<Float>();
                    int nrCoursesTot = 0;
                    int nrCourses = 0;
                    for (XRequest r : ((XStudent)((Object)student)).getRequests()) {
                        XOffering o;
                        XConfig g;
                        XCourse i;
                        if (!(r instanceof XCourseRequest)) continue;
                        XCourseRequest cr = (XCourseRequest)r;
                        Float min = null;
                        Float max = null;
                        Float minTot = null;
                        Float maxTot = null;
                        for (XCourseId courseId : cr.getCourseIds()) {
                            XCourse c = server.getCourse(courseId.getCourseId());
                            if (c != null && c.hasCredit()) {
                                if (minTot == null || minTot.floatValue() > c.getMinCredit().floatValue()) {
                                    minTot = c.getMinCredit();
                                }
                                if (maxTot == null || maxTot.floatValue() < c.getMaxCredit().floatValue()) {
                                    maxTot = c.getMaxCredit();
                                }
                            }
                            if (cr.isOverridePending(c)) {
                                ++gtOvrNeed;
                                ++tOvrNeed;
                            }
                            if (!this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, c, (XStudent)((Object)student), server.getOffering(c.getOfferingId()), cr, this.isConsentToDoCourse(c), this.isMyStudent((XStudentId)((Object)student)), server))) continue;
                            if (c != null && c.hasCredit()) {
                                if (min == null || min.floatValue() > c.getMinCredit().floatValue()) {
                                    min = c.getMinCredit();
                                }
                                if (max == null || max.floatValue() < c.getMaxCredit().floatValue()) {
                                    max = c.getMaxCredit();
                                }
                            }
                            if (!cr.isOverridePending(c)) continue;
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        if (minTot != null) {
                            minsTot.add(minTot);
                            maxsTot.add(maxTot);
                            if (!r.isAlternative()) {
                                ++nrCoursesTot;
                            }
                        }
                        if (min != null) {
                            mins.add(min);
                            maxs.add(max);
                            if (!r.isAlternative()) {
                                ++nrCourses;
                            }
                        }
                        if (!r.isAlternative()) {
                            ++tReq;
                        }
                        if (cr.getEnrollment() == null) {
                            if (!((XStudent)((Object)student)).canAssign(cr)) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (!cr.isWaitlist()) continue;
                            ++tWait;
                            ++gtWait;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        if (cr.getEnrollment().getReservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (cr.getEnrollment().getApproval() == null && (i = server.getCourse(cr.getEnrollment().getCourseId())) != null && i.getConsentLabel() != null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        XConfig xConfig = g = (o = server.getOffering(cr.getEnrollment().getOfferingId())) == null ? null : o.getConfig(cr.getEnrollment().getConfigId());
                        if (g != null) {
                            for (XSubpart xs : g.getSubparts()) {
                                tCred += xs.getCreditValue(cr.getEnrollment().getCourseId());
                                if (g.getInstructionalMethod() == null) continue;
                                s.addIMTotalCredit(g.getInstructionalMethod().getReference(), xs.getCreditValue(cr.getEnrollment().getCourseId()));
                            }
                        }
                        if (o == null) continue;
                        for (XSection section : o.getSections(cr.getEnrollment())) {
                            if (section.getTime() == null) continue;
                            for (XRequest q : ((XStudent)((Object)student)).getRequests()) {
                                if (q instanceof XCourseRequest) {
                                    XEnrollment otherEnrollment = ((XCourseRequest)q).getEnrollment();
                                    if (otherEnrollment == null) continue;
                                    XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                    for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                        if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                        if (otherSection.isDistanceConflict((XStudent)((Object)student), section, dm)) {
                                            ++nrDisCnf;
                                            ++gtNrDC;
                                            int d = otherSection.getDistanceInMinutes(section, dm);
                                            if (d > maxDist) {
                                                maxDist = d;
                                            }
                                            if (d > gtDist) {
                                                gtDist = d;
                                            }
                                        }
                                        if (!section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId()) continue;
                                        share += section.getTime().share(otherSection.getTime());
                                        gtShr += section.getTime().share(otherSection.getTime());
                                    }
                                    continue;
                                }
                                if (!(q instanceof XFreeTimeRequest)) continue;
                                XFreeTimeRequest ft = (XFreeTimeRequest)q;
                                if (!section.getTime().hasIntersection(ft.getTime())) continue;
                                ftShare += section.getTime().share(ft.getTime());
                                gtFre += section.getTime().share(ft.getTime());
                            }
                        }
                    }
                    if (((XStudent)((Object)student)).isMaxCreditOverridePending()) {
                        if (nrCourses == nrCoursesTot) {
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        ++gtOvrNeed;
                        ++tOvrNeed;
                    }
                    Collections.sort(mins);
                    Collections.sort(maxs);
                    float min = 0.0f;
                    float max = 0.0f;
                    for (int i = 0; i < nrCourses; ++i) {
                        min += ((Float)mins.get(i)).floatValue();
                        max += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
                    }
                    Collections.sort(minsTot);
                    Collections.sort(maxsTot);
                    float minTot = 0.0f;
                    float maxTot = 0.0f;
                    for (int i = 0; i < nrCoursesTot; ++i) {
                        minTot += ((Float)minsTot.get(i)).floatValue();
                        maxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                    }
                    s.setRequestCredit(min, max);
                    s.setTotalRequestCredit(minTot, maxTot);
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setTotalOverrideNeeded(tOvrNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setWaitlist(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setOverrideNeeded(ovrNeed);
                    s.setRequested(tReq);
                    s.setStatus(((XStudent)((Object)student)).getStatus() == null ? session.getDefaultSectioningStatus() : ((XStudent)((Object)student)).getStatus());
                    s.setEmailDate(((XStudent)((Object)student)).getEmailTimeStamp() == null ? null : ((XStudent)((Object)student)).getEmailTimeStamp());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                    s.setNote(((XStudent)((Object)student)).hasLastNote() ? ((XStudent)((Object)student)).getLastNote().getNote() : null);
                    s.setNrDistanceConflicts(0);
                    s.setLongestDistanceMinutes(0);
                    s.setOverlappingMinutes(0);
                    s.setTotalNrDistanceConflicts(nrDisCnf);
                    s.setTotalLongestDistanceMinutes(maxDist);
                    s.setTotalOverlappingMinutes(share);
                    s.setFreeTimeOverlappingMins(0);
                    s.setTotalFreeTimeOverlappingMins(ftShare);
                    s.setPrefInstrMethConflict(0);
                    s.setTotalPrefInstrMethConflict(0);
                    s.setPrefSectionConflict(0);
                    s.setTotalPrefSectionConflict(0);
                }
                if (m.enrollment() != null) {
                    if (assigned.add(m.request().getRequestId())) {
                        XOffering o;
                        XConfig g;
                        s.setEnrollment(s.getEnrollment() + 1);
                        ++gEnrl;
                        if (m.enrollment().getReservation() != null) {
                            s.setReservation(s.getReservation() + 1);
                            ++gRes;
                        }
                        if (xCourse.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            s.setConsentNeeded(s.getConsentNeeded() + 1);
                            ++gConNeed;
                        }
                        if (m.enrollment().getTimeStamp() != null) {
                            if (s.getEnrolledDate() == null) {
                                s.setEnrolledDate(m.enrollment().getTimeStamp());
                            } else if (m.enrollment().getTimeStamp().after(s.getEnrolledDate())) {
                                s.setEnrolledDate(m.enrollment().getTimeStamp());
                            }
                        }
                        if (m.enrollment().getApproval() != null) {
                            if (s.getApprovedDate() == null) {
                                s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                            } else if (m.enrollment().getApproval().getTimeStamp().after(s.getApprovedDate())) {
                                s.setApprovedDate(m.enrollment().getApproval().getTimeStamp());
                            }
                        }
                        XConfig xConfig = g = (o = server.getOffering(m.enrollment().getOfferingId())) == null ? null : o.getConfig(m.enrollment().getConfigId());
                        if (g != null) {
                            for (XSubpart xs : g.getSubparts()) {
                                s.setCredit(Float.valueOf(s.getCredit().floatValue() + xs.getCreditValue(m.enrollment().getCourseId())));
                                if (g.getInstructionalMethod() == null) continue;
                                s.addIMCredit(g.getInstructionalMethod().getReference(), xs.getCreditValue(m.enrollment().getCourseId()));
                            }
                            OnlineSectioningLog.CourseRequestOption pref = m.request().getPreferences(m.enrollment());
                            if (pref != null) {
                                if (pref.getInstructionalMethodCount() > 0) {
                                    boolean im = false;
                                    if (g.getInstructionalMethod() != null) {
                                        for (OnlineSectioningLog.Entity e : pref.getInstructionalMethodList()) {
                                            if (!g.getInstructionalMethod().getReference().equals(e.getExternalId()) && !g.getInstructionalMethod().getUniqueId().equals(e.getUniqueId())) continue;
                                            im = true;
                                            break;
                                        }
                                    }
                                    s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                                    ++gtPIM;
                                    if (im) {
                                        s.setPrefInstrMethConflict(s.getPrefInstrMethConflict() + 1);
                                        ++gPIM;
                                    }
                                }
                                if (pref.getSectionCount() > 0) {
                                    HashSet<String> allSubpartIds = new HashSet<String>();
                                    HashSet<String> selectedSubpartIds = new HashSet<String>();
                                    for (OnlineSectioningLog.Section sc : pref.getSectionList()) {
                                        allSubpartIds.add(sc.getSubpart().getName());
                                        for (XSection section : o.getSections(m.enrollment())) {
                                            if (!section.getSectionId().equals(sc.getClazz().getUniqueId()) && !section.getName(m.enrollment().getCourseId()).equals(sc.getClazz().getExternalId())) continue;
                                            selectedSubpartIds.add(sc.getSubpart().getName());
                                        }
                                    }
                                    s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + allSubpartIds.size());
                                    gtPSec += allSubpartIds.size();
                                    if (!allSubpartIds.isEmpty()) {
                                        s.setPrefSectionConflict(s.getPrefSectionConflict() + selectedSubpartIds.size());
                                        gPSec += selectedSubpartIds.size();
                                    }
                                }
                            }
                        }
                        if (o != null) {
                            for (XSection section : o.getSections(m.enrollment())) {
                                if (section.getTime() == null) continue;
                                for (XRequest q : ((XStudent)((Object)student)).getRequests()) {
                                    if (q instanceof XCourseRequest) {
                                        XEnrollment otherEnrollment = ((XCourseRequest)q).getEnrollment();
                                        if (otherEnrollment == null) continue;
                                        XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                                        XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                        for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                            if (otherSection.equals(section) || otherSection.getTime() == null) continue;
                                            if (otherSection.isDistanceConflict((XStudent)((Object)student), section, dm)) {
                                                s.setNrDistanceConflicts(s.getNrDistanceConflicts() + 1);
                                                ++gNrDC;
                                                int d = otherSection.getDistanceInMinutes(section, dm);
                                                if (d > s.getLongestDistanceMinutes()) {
                                                    s.setLongestDistanceMinutes(d);
                                                }
                                                if (d > gDist) {
                                                    gDist = d;
                                                }
                                            }
                                            if (!section.getTime().hasIntersection(otherSection.getTime()) || section.isToIgnoreStudentConflictsWith(o.getDistributions(), otherSection.getSectionId()) || section.getSectionId() >= otherSection.getSectionId() && this.query().match(new StatusPageSuggestionsAction.CourseRequestMatcher(session, otherCourse, (XStudent)((Object)student), otherOffering, (XCourseRequest)q, this.isConsentToDoCourse(otherCourse), this.isMyStudent((XStudentId)((Object)student)), server))) continue;
                                            s.setOverlappingMinutes(s.getOverlappingMinutes() + section.getTime().share(otherSection.getTime()));
                                            gShr += section.getTime().share(otherSection.getTime());
                                        }
                                        continue;
                                    }
                                    if (!(q instanceof XFreeTimeRequest)) continue;
                                    XFreeTimeRequest ft = (XFreeTimeRequest)q;
                                    if (!section.getTime().hasIntersection(ft.getTime())) continue;
                                    s.setFreeTimeOverlappingMins(s.getFreeTimeOverlappingMins() + section.getTime().share(ft.getTime()));
                                    gFre += section.getTime().share(ft.getTime());
                                }
                            }
                        }
                    }
                } else if (m.student().canAssign(m.request()) && unassigned.add(m.request().getRequestId())) {
                    if (m.request().isWaitlist()) {
                        s.setWaitlist(s.getWaitlist() + 1);
                        ++gWait;
                        if (s.getTopWaitingPriority() == null) {
                            s.setTopWaitingPriority(1 + m.request().getPriority());
                        } else {
                            s.setTopWaitingPriority(Math.min(1 + m.request().getPriority(), s.getTopWaitingPriority()));
                        }
                    }
                    s.setUnassigned(s.getUnassigned() + 1);
                    ++gUnasg;
                }
                if (m.request().getTimeStamp() == null) continue;
                if (s.getRequestedDate() == null) {
                    s.setRequestedDate(m.request().getTimeStamp());
                    continue;
                }
                if (!m.request().getTimeStamp().after(s.getRequestedDate())) continue;
                s.setRequestedDate(m.request().getTimeStamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        if (this.iSubjectAreas == null && this.iCoursesIcoordinate == null) {
            if (studentIds != null && (studentIds.size() < 1000 || server instanceof DatabaseServer)) {
                FindStudentInfoMatcher findStudentInfoMatcher = new FindStudentInfoMatcher(session, this.query(), this.iMyStudents);
                findStudentInfoMatcher.setServer(server);
                for (Long l : studentIds) {
                    XStudent student;
                    if (students.containsKey(l) || (student = server.getStudent(l)) == null || !findStudentInfoMatcher.match(student)) continue;
                    ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(student.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect(student));
                    st.setName(student.getName());
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        st.addArea(acm.getArea());
                        st.addClassification(acm.getClassification());
                        st.addMajor(acm.getMajor());
                    }
                    for (String acc : student.getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (String gr : student.getGroups()) {
                        st.addGroup(gr);
                    }
                    s.setStatus(student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus());
                    s.setEmailDate(student.getEmailTimeStamp() == null ? null : student.getEmailTimeStamp());
                    s.setNote(student.hasLastNote() ? student.getLastNote().getNote() : null);
                    ret.add(s);
                }
            } else {
                for (XStudentId xStudentId : server.findStudents(new FindStudentInfoMatcher(session, this.query(), this.iMyStudents))) {
                    XStudent xStudent = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                    ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(xStudent.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(xStudent.getExternalId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    String status = xStudent.getStatus() == null ? session.getDefaultSectioningStatus() : xStudent.getStatus();
                    st.setCanRegister(this.iCanRegister && (status == null || regStates.contains(status)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || assStates.contains(status)));
                    st.setCanSelect(this.isCanSelect(xStudent));
                    st.setName(xStudent.getName());
                    for (XAreaClassificationMajor acm : xStudent.getMajors()) {
                        st.addArea(acm.getArea());
                        st.addClassification(acm.getClassification());
                        st.addMajor(acm.getMajor());
                    }
                    for (String acc : xStudent.getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (String gr : xStudent.getGroups()) {
                        st.addGroup(gr);
                    }
                    s.setStatus(xStudent.getStatus() == null ? session.getDefaultSectioningStatus() : xStudent.getStatus());
                    s.setEmailDate(xStudent.getEmailTimeStamp() == null ? null : xStudent.getEmailTimeStamp());
                    s.setNote(xStudent.hasLastNote() ? xStudent.getLastNote().getNote() : null);
                    ret.add(s);
                }
            }
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return new Long(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> arrayList = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo studentInfo : ret) {
                arrayList.add(studentInfo);
                if (arrayList.size() != this.limit().intValue()) continue;
                break;
            }
            ret = arrayList;
        }
        ClassAssignmentInterface.StudentInfo studentInfo = new ClassAssignmentInterface.StudentInfo();
        studentInfo.setEnrollment(gEnrl);
        studentInfo.setReservation(gRes);
        studentInfo.setWaitlist(gWait);
        studentInfo.setUnassigned(gUnasg);
        studentInfo.setTotalEnrollment(gtEnrl);
        studentInfo.setTotalReservation(gtRes);
        studentInfo.setTotalWaitlist(gtWait);
        studentInfo.setTotalUnassigned(gtUnasg);
        studentInfo.setConsentNeeded(gConNeed);
        studentInfo.setTotalConsentNeeded(gtConNeed);
        studentInfo.setOverrideNeeded(gOvrNeed);
        studentInfo.setTotalOverrideNeeded(gtOvrNeed);
        studentInfo.setNrDistanceConflicts(gNrDC);
        studentInfo.setTotalNrDistanceConflicts(gtNrDC);
        studentInfo.setLongestDistanceMinutes(gDist);
        studentInfo.setTotalLongestDistanceMinutes(gtDist);
        studentInfo.setOverlappingMinutes(gShr);
        studentInfo.setTotalOverlappingMinutes(gtShr);
        studentInfo.setFreeTimeOverlappingMins(gFre);
        studentInfo.setTotalFreeTimeOverlappingMins(gtFre);
        studentInfo.setPrefInstrMethConflict(gPIM);
        studentInfo.setTotalPrefInstrMethConflict(gtPIM);
        studentInfo.setPrefSectionConflict(gPSec);
        studentInfo.setTotalPrefSectionConflict(gtPSec);
        ret.add(studentInfo);
        return ret;
    }

    protected Collection<? extends XCourseId> findCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter != null && server instanceof DatabaseServer) {
            ArrayList<XCourse> courses = new ArrayList<XCourse>();
            FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher m = new FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery);
            for (XCourse course : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getCourses(server, helper)) {
                if (!m.match(course)) continue;
                courses.add(course);
            }
            return courses;
        }
        return server.findCourses(new FindEnrollmentInfoAction.FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery));
    }

    @Override
    public String name() {
        return "find-student-infos";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FindStudentInfoMatcher
    extends AbstractStudentMatcher {
        private static final long serialVersionUID = 1L;
        protected Query iQuery;
        protected String iDefaultSectioningStatus;
        protected Set<Long> iMyStudents;

        public FindStudentInfoMatcher(AcademicSessionInfo session, Query query, Set<Long> myStudents) {
            this.iQuery = query;
            this.iDefaultSectioningStatus = session.getDefaultSectioningStatus();
            this.iMyStudents = myStudents;
        }

        public boolean isMyStudent(XStudentId student) {
            return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
        }

        @Override
        public boolean match(XStudentId id) {
            XStudent student = id instanceof XStudent ? (XStudent)id : this.getServer().getStudent(id.getStudentId());
            return student != null && student.getRequests().isEmpty() && this.iQuery.match(new StatusPageSuggestionsAction.StudentMatcher(student, this.iDefaultSectioningStatus, this.getServer(), this.isMyStudent(student)));
        }
    }
}

