/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cpsolver.studentsct.model.Section;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.SectionLimitProvider;
import org.unitime.timetable.onlinesectioning.custom.SectionUrlProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurdueSectionLimitProvider
implements SectionLimitProvider,
SectionUrlProvider {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static Logger sLog = Logger.getLogger(PurdueSectionLimitProvider.class);
    public static String sUrl = "https://esa-oas-prod-wl.itap.purdue.edu/prod/bzwsrch.p_schedule_detail?term=:year:term&crn=:crn";
    public static String sDummyUrl = "https://esa-oas-prod-wl.itap.purdue.edu/prod/bzwsrch.p_schedule_detail?term=201010&crn=10001";
    public static String sContentRE = "(<table [ ]*class=\"[a-z]*\" summary=\"This layout table is used to present the seating numbers.\" .*</table>)";
    public static String sTableRE = "<td class=\"dddefault\">(\\-?[0-9]*)</td>";
    private Pattern iContentRE = Pattern.compile(sContentRE, 11);
    private Pattern iTableRE = Pattern.compile(sTableRE, 11);
    public static int sConcurrencyLimit = 10;
    private Hashtable<Long, int[]> iCache = new Hashtable();

    private String getTerm(AcademicSessionInfo session) throws SectioningException {
        if (session.getTerm().toLowerCase().startsWith("spr")) {
            return "20";
        }
        if (session.getTerm().toLowerCase().startsWith("sum")) {
            return "30";
        }
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return "10";
        }
        throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("academic term " + session.getTerm() + " not known"));
    }

    private String getYear(AcademicSessionInfo session) throws SectioningException {
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return String.valueOf(Integer.parseInt(session.getYear()) + 1);
        }
        return session.getYear();
    }

    @Override
    public URL getSectionUrl(AcademicSessionInfo session, Long courseId, Section section) {
        return this.getSectionUrl(session, courseId, section.getId(), section.getName(courseId.longValue()));
    }

    protected URL getSectionUrl(AcademicSessionInfo session, Long courseId, Long classId, String className) {
        try {
            if (className == null || className.isEmpty()) {
                throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("class CRN not provided"));
            }
            String crn = className;
            if (className.indexOf(45) >= 0) {
                crn = className.substring(0, className.indexOf(45));
            }
            URL url = new URL(sUrl.replace(":year", this.getYear(session)).replace(":term", this.getTerm(session)).replace(":initiative", session.getCampus()).replace(":crn", crn));
            return url;
        }
        catch (MalformedURLException e) {
            throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("course detail url is wrong"));
        }
    }

    @Override
    public int[] getSectionLimit(AcademicSessionInfo session, Long courseId, Section section) throws SectioningException {
        return this.getSectionLimit(session, courseId, section.getId(), section.getName(courseId.longValue()));
    }

    protected int[] getSectionLimit(AcademicSessionInfo session, Long courseId, Long classId, String className) throws SectioningException {
        int[] ret = this.getSectionLimit(this.getSectionUrl(session, courseId, classId, className));
        this.iCache.put(classId, ret);
        return ret;
    }

    protected int[] getSectionLimit(URL secionUrl) throws SectioningException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(secionUrl.openStream()));
            StringBuffer content = new StringBuffer();
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
            in.close();
            Matcher match = this.iContentRE.matcher(content);
            if (!match.find()) {
                throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("unable to parse <a href='" + secionUrl + "'>class detail page</a>"));
            }
            String table = match.group(1);
            if (!(match = this.iTableRE.matcher(table)).find()) {
                throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("unable to parse <a href='" + secionUrl + "'>class detail page</a>"));
            }
            int capacity = Integer.parseInt(match.group(1));
            if (!match.find()) {
                throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("unable to parse <a href='" + secionUrl + "'>class detail page</a>"));
            }
            int actual = Integer.parseInt(match.group(1));
            if (!match.find()) {
                throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("unable to parse <a href='" + secionUrl + "'>class detail page</a>"));
            }
            return new int[]{actual, capacity};
        }
        catch (IOException e) {
            throw new SectioningException(MSG.exceptionCustomSectionLimitsFailed("unable to read <a href='" + secionUrl + "'>class detail page</a>"));
        }
    }

    @Override
    public Map<Long, int[]> getSectionLimits(AcademicSessionInfo session, Long courseId, Collection<Section> sections) {
        Hashtable<Long, int[]> ret = new Hashtable<Long, int[]>();
        ThreadPool pool = new ThreadPool();
        for (Section section : sections) {
            pool.retrieveLimit(session, courseId, section.getId(), section.getName(courseId.longValue()), ret);
        }
        pool.waitForAll();
        return ret;
    }

    @Override
    public Map<Long, int[]> getSectionLimitsFromCache(AcademicSessionInfo session, Long courseId, Collection<Section> sections) {
        Hashtable<Long, int[]> ret = new Hashtable<Long, int[]>();
        ThreadPool pool = new ThreadPool();
        for (Section section : sections) {
            int[] limits = this.iCache.get(section.getId());
            if (limits != null) {
                ret.put(section.getId(), limits);
                continue;
            }
            pool.retrieveLimit(session, courseId, section.getId(), section.getName(courseId.longValue()), ret);
        }
        pool.waitForAll();
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadPool {
        private Set<Worker> iWorkers = new HashSet<Worker>();

        private ThreadPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retrieveLimit(AcademicSessionInfo session, Long courseId, Long classId, String customClassSuffix, Hashtable<Long, int[]> ret) {
            Set<Worker> set = this.iWorkers;
            synchronized (set) {
                while (this.iWorkers.size() > sConcurrencyLimit) {
                    try {
                        this.iWorkers.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Worker w = new Worker(session, courseId, classId, customClassSuffix, ret);
                this.iWorkers.add(w);
                w.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void done(Worker w) {
            Set<Worker> set = this.iWorkers;
            synchronized (set) {
                this.iWorkers.remove(w);
                this.iWorkers.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAll() {
            Set<Worker> set = this.iWorkers;
            synchronized (set) {
                while (!this.iWorkers.isEmpty()) {
                    try {
                        this.iWorkers.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Worker
        extends Thread {
            private AcademicSessionInfo iSession;
            private Long iCourseId;
            private Long iClassId;
            private String iClassName;
            private Hashtable<Long, int[]> iResults;

            private Worker(AcademicSessionInfo session, Long courseId, Long classId, String className, Hashtable<Long, int[]> ret) {
                this.iSession = session;
                this.iCourseId = courseId;
                this.iClassId = classId;
                this.iClassName = className;
                this.iResults = ret;
                this.setName("PuSectLimitP-" + classId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    try {
                        int[] limit = PurdueSectionLimitProvider.this.getSectionLimit(this.iSession, this.iCourseId, this.iClassId, this.iClassName);
                        this.iResults.put(this.iClassId, limit);
                    }
                    catch (SectioningException e) {
                        sLog.warn((Object)("Failed to retrieve section limit for " + this.iClassName + " (" + this.iSession.getTerm() + " " + this.iSession.getYear() + "): " + e.getMessage()));
                        Object var3_4 = null;
                        ThreadPool.this.done(this);
                        return;
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    ThreadPool.this.done(this);
                    throw throwable;
                }
                ThreadPool.this.done(this);
            }
        }
    }
}

