/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.CheckEligibility;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;

public class CourseRequestEligibility
extends CheckEligibility {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    protected void logCheck(OnlineSectioningLog.Action.Builder action, OnlineSectioningInterface.EligibilityCheck check) {
        for (OnlineSectioningInterface.EligibilityCheck.EligibilityFlag f : OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.values()) {
            if (!check.hasFlag(f)) continue;
            action.addOptionBuilder().setKey(f.name().replace('_', ' ')).setValue("true");
        }
        if (check.hasMessage()) {
            action.addMessageBuilder().setText(check.getMessage()).setLevel(OnlineSectioningLog.Message.Level.WARN);
        }
        if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        } else {
            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnlineSectioningInterface.EligibilityCheck execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iCheck == null) {
            this.iCheck = new OnlineSectioningInterface.EligibilityCheck();
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        OnlineSectioningServer.Lock lock = this.iStudentId == null ? null : server.lockStudent(this.iStudentId, null, this.name());
        try {
            OnlineSectioningInterface.EligibilityCheck eligibilityCheck;
            try {
                Student student;
                Session hibSession;
                block30: {
                    OnlineSectioningInterface.EligibilityCheck eligibilityCheck2;
                    block31: {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                        if (this.iStudentId != null) {
                            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
                        }
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, server.getAcademicSession().isSectioningEnabled() && CustomStudentEnrollmentHolder.isAllowWaitListing());
                        hibSession = StudentDAO.getInstance().createNewSession();
                        Student student2 = student = this.iStudentId == null ? null : (Student)StudentDAO.getInstance().get(this.iStudentId, hibSession);
                        if (student != null) break block30;
                        if (!(this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST))) {
                            this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                        }
                        this.logCheck(action, this.iCheck);
                        action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                        eligibilityCheck2 = this.iCheck;
                        Object var13_11 = null;
                        if (hibSession == null) break block31;
                        hibSession.close();
                    }
                    Object var15_14 = null;
                    if (lock == null) return eligibilityCheck2;
                    lock.release();
                    return eligibilityCheck2;
                }
                try {
                    String effectivePeriod;
                    StudentSectioningStatus s;
                    action.getStudentBuilder().setExternalId(student.getExternalUniqueId());
                    action.getStudentBuilder().setName(helper.getStudentNameFormat().format(student));
                    StudentSectioningStatus status = student.getEffectiveStatus();
                    boolean disabled = status != null && !status.hasOption(StudentSectioningStatus.Option.regenabled);
                    boolean noreg = false;
                    if (this.iPermissionCanEnroll != null) {
                        noreg = this.iPermissionCanEnroll == false;
                    } else {
                        boolean bl = noreg = status != null && !status.hasOption(StudentSectioningStatus.Option.registration);
                        if (noreg && status.hasOption(StudentSectioningStatus.Option.regadmin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                            noreg = false;
                        }
                        if (noreg && status.hasOption(StudentSectioningStatus.Option.regadvisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                            noreg = false;
                        }
                    }
                    if (status != null && !status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, false);
                    }
                    if (disabled) {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, false);
                    }
                    if (student.getSession().getStatusType().canPreRegisterStudents()) {
                        if (!noreg) {
                            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, true);
                        }
                    } else {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                    }
                    for (s = student.getSectioningStatus(); s != null && s.isPast() && s.getFallBackStatus() != null; s = s.getFallBackStatus()) {
                    }
                    if (s != null && s.getMessage() != null) {
                        this.iCheck.setMessage(s.getMessage());
                    } else if (status != null && status.getMessage() != null) {
                        this.iCheck.setMessage(status.getMessage());
                    } else if (disabled) {
                        this.iCheck.setMessage(MSG.exceptionAccessDisabled());
                    } else if (noreg) {
                        this.iCheck.setMessage(MSG.exceptionRegistrationDisabled());
                    }
                    String string = s != null ? s.getEffectivePeriod() : (effectivePeriod = status != null ? status.getEffectivePeriod() : null);
                    if (effectivePeriod != null) {
                        this.iCheck.setMessage((this.iCheck.hasMessage() ? this.iCheck.getMessage() + "\n" : "") + MSG.messageTimeWindow(effectivePeriod));
                    }
                    if (this.iCustomCheck && CustomCourseRequestsValidationHolder.hasProvider()) {
                        CustomCourseRequestsValidationHolder.getProvider().checkEligibility(server, helper, this.iCheck, student);
                    }
                    Object var13_12 = null;
                    if (hibSession != null) {
                        hibSession.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (hibSession == null) throw throwable;
                    hibSession.close();
                    throw throwable;
                }
                this.logCheck(action, this.iCheck);
                eligibilityCheck = this.iCheck;
                Object var15_15 = null;
                if (lock == null) return eligibilityCheck;
            }
            catch (SectioningException e) {
                this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                this.iCheck.setMessage(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
                helper.info(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
                this.logCheck(action, this.iCheck);
                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                OnlineSectioningInterface.EligibilityCheck eligibilityCheck3 = this.iCheck;
                Object var15_16 = null;
                if (lock == null) return eligibilityCheck3;
                lock.release();
                return eligibilityCheck3;
            }
            lock.release();
            return eligibilityCheck;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (lock == null) throw throwable;
            lock.release();
            throw throwable;
        }
    }
}

