/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReadWriteLock {
    protected Lock iLock = new ReentrantLock();
    protected Condition iLockNotAvailable = this.iLock.newCondition();
    protected Condition iGlobalLockNotAvailable = this.iLock.newCondition();
    protected Map<Long, ReadWriteLock> iIndividualLocks = new HashMap<Long, ReadWriteLock>();
    protected ReadWriteLock iGlobalLock = new ReentrantReadWriteLock(true);
    protected int iGlobalLockRequests = 0;

    public Unlock lock(boolean write, Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.lock(write, list);
    }

    public Unlock tryLock(boolean write, Long ... ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (Long id : ids) {
            list.add(id);
        }
        return this.tryLock(write, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Unlock lock(boolean write, Collection<Long> ids) {
        Unlock unlock;
        this.iLock.lock();
        try {
            if (ids == null || ids.isEmpty()) {
                Unlock unlock2 = new Unlock(new Lock[0]);
                Object var6_5 = null;
                this.iLock.unlock();
                return unlock2;
            }
            while (true) {
                Unlock unlock3;
                if ((unlock3 = this.tryLock(write, ids)) != null) {
                    unlock = unlock3;
                    break;
                }
                this.iLockNotAvailable.awaitUninterruptibly();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.iLock.unlock();
            throw throwable;
        }
        Object var6_6 = null;
        this.iLock.unlock();
        return unlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Unlock tryLock(boolean write, Collection<Long> ids) {
        Unlock unlock;
        block8: {
            this.iLock.lock();
            try {
                if (ids == null || ids.isEmpty()) {
                    Unlock unlock2 = null;
                    Object var11_5 = null;
                    this.iLock.unlock();
                    return unlock2;
                }
                ArrayList<Lock> acquiredLocks = new ArrayList<Lock>();
                if (!this.iGlobalLock.readLock().tryLock()) {
                    unlock = null;
                    break block8;
                }
                acquiredLocks.add(this.iGlobalLock.readLock());
                for (Long courseId : ids) {
                    Lock lock;
                    ReadWriteLock courseLock = this.iIndividualLocks.get(courseId);
                    if (courseLock == null) {
                        courseLock = new ReentrantReadWriteLock(false);
                        this.iIndividualLocks.put(courseId, courseLock);
                    }
                    Lock lock2 = lock = write ? courseLock.writeLock() : courseLock.readLock();
                    if (lock.tryLock()) {
                        acquiredLocks.add(lock);
                        continue;
                    }
                    for (Lock undo : acquiredLocks) {
                        undo.unlock();
                    }
                    Iterator iterator = null;
                    Object var11_7 = null;
                    this.iLock.unlock();
                    return iterator;
                }
                Unlock unlock3 = new Unlock(acquiredLocks);
                Object var11_8 = null;
                this.iLock.unlock();
                return unlock3;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                this.iLock.unlock();
                throw throwable;
            }
        }
        Object var11_6 = null;
        this.iLock.unlock();
        return unlock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Unlock lockAll() {
        this.iLock.lock();
        try {
            while (true) {
                if (this.iGlobalLock.writeLock().tryLock()) {
                    Unlock unlock = new Unlock(new Lock[]{this.iGlobalLock.writeLock()});
                    Object var3_2 = null;
                    this.iLock.unlock();
                    return unlock;
                }
                ++this.iGlobalLockRequests;
                this.iGlobalLockNotAvailable.awaitUninterruptibly();
                --this.iGlobalLockRequests;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    public Unlock empty() {
        return new Unlock(new Lock[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long id) {
        this.iLock.lock();
        try {
            this.iIndividualLocks.remove(id);
            Object var3_2 = null;
            this.iLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.iLock.lock();
        try {
            this.iIndividualLocks.clear();
            Object var2_1 = null;
            this.iLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.iLock.unlock();
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            Thread t;
            int i;
            final MultiReadWriteLock lock = new MultiReadWriteLock();
            for (i = 1; i <= 1000; ++i) {
                t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            for (int x = 1; x <= 10; ++x) {
                                int nrCourses = 2 + ToolBox.random((int)9);
                                HashSet<Long> courses = new HashSet<Long>();
                                String s = "";
                                for (int i = 0; i < nrCourses; ++i) {
                                    long courseId;
                                    while (!courses.add(courseId = (long)ToolBox.random((int)10000))) {
                                    }
                                    s = s + (i > 0 ? ", " : "") + courseId;
                                }
                                boolean write = ToolBox.random((int)10) == 0;
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "locking: [" + s + "]");
                                Unlock unlock = lock.lock(write, courses);
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "locked: [" + s + "]");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "unlocking: [" + s + "]");
                                unlock.release();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") " + (write ? "Write " : "Read ") + "unlocked: [" + s + "]");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                t.setName("[T" + i + "]: ");
                t.start();
            }
            for (i = 1; i <= 3; ++i) {
                t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            for (int x = 1; x <= 10; ++x) {
                                try {
                                    Thread.sleep(ToolBox.random((int)5000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") Locking all...");
                                Unlock unlock = lock.lockAll();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") All locked.");
                                try {
                                    Thread.sleep(ToolBox.random((int)1000));
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") Unlocking all.");
                                unlock.release();
                                System.out.println(Thread.currentThread().getName() + "(" + x + ") All unlocked.");
                            }
                        }
                        catch (Exception e) {
                            System.err.println(Thread.currentThread().getName() + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                t.setName("[A" + i + "]: ");
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Unlock
    implements OnlineSectioningServer.Lock {
        private List<Lock> iAcquiredLocks;

        private Unlock(List<Lock> acquiredLocks) {
            this.iAcquiredLocks = acquiredLocks;
        }

        private Unlock(Lock ... acquiredLocks) {
            this.iAcquiredLocks = new ArrayList<Lock>();
            for (Lock lock : acquiredLocks) {
                this.iAcquiredLocks.add(lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            MultiReadWriteLock.this.iLock.lock();
            try {
                for (Lock lock : this.iAcquiredLocks) {
                    lock.unlock();
                }
                if (MultiReadWriteLock.this.iGlobalLockRequests > 0) {
                    MultiReadWriteLock.this.iGlobalLockNotAvailable.signal();
                } else {
                    MultiReadWriteLock.this.iLockNotAvailable.signalAll();
                }
                Object var4_3 = null;
                MultiReadWriteLock.this.iLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                MultiReadWriteLock.this.iLock.unlock();
                throw throwable;
            }
        }
    }
}

