/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.TimetableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePeriodicTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iEmail;
    private byte[] iInputFile;
    private Session iSession;
    private Script iScript;
    private TimetableManager iOwner;
    private Set<TaskParameter> iParameters;
    private Set<TaskExecution> iSchedule;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_NAME = "name";
    public static String PROP_EMAIL = "email";
    public static String PROP_INPUT_FILE = "inputFile";

    public BasePeriodicTask() {
        this.initialize();
    }

    public BasePeriodicTask(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public byte[] getInputFile() {
        return this.iInputFile;
    }

    public void setInputFile(byte[] inputFile) {
        this.iInputFile = inputFile;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Script getScript() {
        return this.iScript;
    }

    public void setScript(Script script) {
        this.iScript = script;
    }

    public TimetableManager getOwner() {
        return this.iOwner;
    }

    public void setOwner(TimetableManager owner) {
        this.iOwner = owner;
    }

    public Set<TaskParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<TaskParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToparameters(TaskParameter taskParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<TaskParameter>();
        }
        this.iParameters.add(taskParameter);
    }

    public Set<TaskExecution> getSchedule() {
        return this.iSchedule;
    }

    public void setSchedule(Set<TaskExecution> schedule) {
        this.iSchedule = schedule;
    }

    public void addToschedule(TaskExecution taskExecution) {
        if (this.iSchedule == null) {
            this.iSchedule = new HashSet<TaskExecution>();
        }
        this.iSchedule.add(taskExecution);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PeriodicTask)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PeriodicTask)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PeriodicTask)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PeriodicTask[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PeriodicTask[\n\tEmail: " + this.getEmail() + "\n\tInputFile: " + this.getInputFile() + "\n\tName: " + this.getName() + "\n\tOwner: " + this.getOwner() + "\n\tScript: " + this.getScript() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

