/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseLocation;
import org.unitime.timetable.model.dao.ExamLocationPrefDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Location
extends BaseLocation
implements Comparable {
    public static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final GwtMessages GWT_MSG = Localization.create(GwtMessages.class);
    public static final String AVAILABLE_LOCATIONS_ATTR = "availableLocations";
    private static final long serialVersionUID = 1L;

    public Location() {
    }

    public Location(Long uniqueId) {
        super(uniqueId);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Location)) {
            return -1;
        }
        if (this instanceof Room) {
            if (o instanceof Room) {
                Room r1 = (Room)this;
                Room r2 = (Room)o;
                int cmp = r1.getBuilding().compareTo(r2.getBuilding());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = r1.getRoomNumber().compareTo(r2.getRoomNumber());
                if (cmp != 0) {
                    return cmp;
                }
                return r1.getUniqueId().compareTo(r2.getUniqueId());
            }
            return -1;
        }
        if (this instanceof NonUniversityLocation) {
            if (o instanceof Room) {
                return 1;
            }
            if (o instanceof NonUniversityLocation) {
                NonUniversityLocation l1 = (NonUniversityLocation)this;
                NonUniversityLocation l2 = (NonUniversityLocation)o;
                int cmp = l1.getName().compareTo(l2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return l1.getUniqueId().compareTo(l2.getUniqueId());
            }
            return -1;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(((Location)o).getUniqueId() == null ? -1L : ((Location)o).getUniqueId());
    }

    public abstract String getLabel();

    public RequiredTimeTable getRoomSharingTable() {
        return new RequiredTimeTable(new RoomSharingModel(this, null, null));
    }

    public RequiredTimeTable getEventAvailabilityTable() {
        RoomSharingModel model = new RoomSharingModel(this, null, null);
        model.setEventAvailabilityPreference(this.getEventAvailability());
        return new RequiredTimeTable(model);
    }

    public RequiredTimeTable getRoomSharingTable(Collection departments) {
        return new RequiredTimeTable(new RoomSharingModel(this, null, departments));
    }

    public RequiredTimeTable getRoomSharingTable(UserContext editingUser, Collection departments) {
        return new RequiredTimeTable(this.getRoomSharingModel(editingUser, departments));
    }

    public RequiredTimeTable getRoomSharingTable(UserContext editingUser) {
        return new RequiredTimeTable(this.getRoomSharingModel(editingUser, null));
    }

    public RoomSharingModel getRoomSharingModel() {
        return new RoomSharingModel(this, null, null);
    }

    public RoomSharingModel getRoomSharingModel(UserContext editingUser) {
        return this.getRoomSharingModel(editingUser, null);
    }

    public RoomSharingModel getRoomSharingModel(UserContext editingUser, Collection departments) {
        if (editingUser == null || editingUser.getCurrentAuthority() == null || editingUser.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            return new RoomSharingModel(this, null, departments);
        }
        HashSet<Long> editingDepartments = new HashSet<Long>();
        for (Qualifiable qualifiable : editingUser.getCurrentAuthority().getQualifiers("Department")) {
            editingDepartments.add((Long)qualifiable.getQualifierId());
        }
        for (RoomDept roomDept : this.getRoomDepts()) {
            if (!roomDept.isControl().booleanValue() || !editingDepartments.contains(roomDept.getDepartment().getUniqueId())) continue;
            return new RoomSharingModel(this, null, departments);
        }
        return new RoomSharingModel(this, editingDepartments, departments);
    }

    public RoomSharingModel getRoomSharingModel(Set editingDepartmentIds) {
        return this.getRoomSharingModel(editingDepartmentIds, null);
    }

    public RoomSharingModel getRoomSharingModel(Set editingDepartmentIds, Collection departments) {
        return new RoomSharingModel(this, editingDepartmentIds, departments);
    }

    public void setRoomSharingModel(RoomSharingModel model) {
        if (model == null) {
            this.setPattern(null);
            this.setManagerIds(null);
        } else {
            this.setPattern(model.getPreferences());
            this.setManagerIds(model.getManagerIds());
        }
    }

    public void setRoomSharingTable(RequiredTimeTable table) {
        this.setRoomSharingModel((RoomSharingModel)table.getModel());
    }

    public boolean hasGroup(RoomGroup roomGroup) {
        boolean b = false;
        Iterator<RoomGroup> it = this.getRoomGroups().iterator();
        while (it.hasNext()) {
            if (!roomGroup.equals(it.next())) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean hasGroup(Long roomGroup) {
        Iterator<RoomGroup> it = this.getRoomGroups().iterator();
        while (it.hasNext()) {
            if (!roomGroup.equals(it.next().getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoomDept(Department d) {
        boolean b = false;
        for (RoomDept rd : this.getRoomDepts()) {
            if (!rd.getDepartment().equals(d) || !rd.getRoom().equals(this)) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean hasFeature(RoomFeature roomFeature) {
        boolean b = false;
        Iterator<RoomFeature> it = this.getFeatures().iterator();
        while (it.hasNext()) {
            if (!roomFeature.equals(it.next())) continue;
            b = true;
            break;
        }
        return b;
    }

    public boolean hasFeature(Long roomFeature) {
        Iterator<RoomFeature> it = this.getFeatures().iterator();
        while (it.hasNext()) {
            if (!roomFeature.equals(it.next().getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalFeature(String sisReference) {
        GlobalRoomFeature grf = GlobalRoomFeature.featureWithSisReference(this.getSession(), sisReference);
        if (grf == null) {
            return false;
        }
        return this.hasFeature(grf);
    }

    @Override
    public void addTofeatures(RoomFeature roomFeature) {
        if (null == this.getFeatures()) {
            this.setFeatures(new HashSet<RoomFeature>());
        }
        this.getFeatures().add(roomFeature);
    }

    public void removeFromfeatures(RoomFeature roomFeature) {
        if (null == this.getFeatures()) {
            this.setFeatures(new HashSet<RoomFeature>());
        }
        this.getFeatures().remove(roomFeature);
    }

    public void saveOrUpdate() throws HibernateException {
        new LocationDAO().saveOrUpdate(this);
    }

    public TreeSet<GlobalRoomFeature> getGlobalRoomFeatures() {
        TreeSet<GlobalRoomFeature> grfs = new TreeSet<GlobalRoomFeature>();
        for (RoomFeature rf : this.getFeatures()) {
            if (!(rf instanceof GlobalRoomFeature)) continue;
            grfs.add((GlobalRoomFeature)rf);
        }
        return grfs;
    }

    public TreeSet<RoomGroup> getGlobalRoomGroups() {
        TreeSet<RoomGroup> grgs = new TreeSet<RoomGroup>();
        for (RoomGroup rg : this.getRoomGroups()) {
            if (!rg.isGlobal().booleanValue()) continue;
            grgs.add(rg);
        }
        return grgs;
    }

    public TreeSet<DepartmentRoomFeature> getDepartmentRoomFeatures() {
        TreeSet<DepartmentRoomFeature> drfs = new TreeSet<DepartmentRoomFeature>();
        for (RoomFeature rf : this.getFeatures()) {
            if (!(rf instanceof DepartmentRoomFeature)) continue;
            drfs.add((DepartmentRoomFeature)rf);
        }
        return drfs;
    }

    public PreferenceLevel getRoomPreferenceLevel(Department department) {
        if (department == null) {
            return PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral);
        }
        for (RoomPref rp : department.getRoomPreferences()) {
            if (!rp.getRoom().equals(this)) continue;
            return rp.getPrefLevel();
        }
        return PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral);
    }

    public RoomPref getRoomPreference(Department department) {
        for (RoomPref rp : department.getRoomPreferences()) {
            if (!rp.getRoom().equals(this)) continue;
            return rp;
        }
        return null;
    }

    public void removedFromDepartment(Department department, Session hibSession) {
        Iterator<Comparable> iter = this.getFeatures().iterator();
        while (iter.hasNext()) {
            DepartmentRoomFeature drf;
            RoomFeature rf = iter.next();
            if (!(rf instanceof DepartmentRoomFeature) || !department.equals((drf = (DepartmentRoomFeature)rf).getDepartment())) continue;
            drf.getRooms().remove(this);
            iter.remove();
            hibSession.saveOrUpdate((Object)drf);
        }
        iter = this.getRoomGroups().iterator();
        while (iter.hasNext()) {
            RoomGroup rg = (RoomGroup)iter.next();
            if (rg.isGlobal().booleanValue() || !department.equals(rg.getDepartment())) continue;
            rg.getRooms().remove(this);
            iter.remove();
            hibSession.saveOrUpdate((Object)rg);
        }
        iter = department.getPreferences().iterator();
        while (iter.hasNext()) {
            Preference p = (Preference)iter.next();
            if (!(p instanceof RoomPref) || !((RoomPref)p).getRoom().equals(this)) continue;
            hibSession.delete((Object)p);
            iter.remove();
        }
        hibSession.saveOrUpdate((Object)department);
        List roomPrefs = hibSession.createQuery("select distinct rp from RoomPref rp where rp.room.uniqueId=:locationId").setInteger("locationId", this.getUniqueId().intValue()).list();
        for (RoomPref rp : roomPrefs) {
            DepartmentalInstructor d;
            SchedulingSubpart s;
            Class_ c;
            if (rp.getOwner() instanceof Class_ && department.equals((c = (Class_)rp.getOwner()).getManagingDept())) {
                c.getPreferences().remove(rp);
                hibSession.delete((Object)rp);
                hibSession.saveOrUpdate((Object)c);
            }
            if (rp.getOwner() instanceof SchedulingSubpart && department.equals((s = (SchedulingSubpart)rp.getOwner()).getManagingDept())) {
                s.getPreferences().remove(rp);
                hibSession.delete((Object)rp);
                hibSession.saveOrUpdate((Object)s);
            }
            if (!(rp.getOwner() instanceof DepartmentalInstructor) || !department.equals((d = (DepartmentalInstructor)rp.getOwner()).getDepartment())) continue;
            d.getPreferences().remove(rp);
            hibSession.delete((Object)rp);
            hibSession.saveOrUpdate((Object)d);
        }
        if (this instanceof Room) {
            Building bldg = ((Room)this).getBuilding();
            List bldgPrefs = hibSession.createQuery("select distinct bp from BuildingPref bp where bp.building.uniqueId=:bldgId").setInteger("bldgId", bldg.getUniqueId().intValue()).list();
            for (BuildingPref bp : bldgPrefs) {
                DepartmentalInstructor d;
                SchedulingSubpart s;
                Class_ c;
                if (bp.getOwner() instanceof Class_ && !(c = (Class_)bp.getOwner()).getAvailableBuildings().contains(bldg) && department.equals(c.getManagingDept())) {
                    c.getPreferences().remove(bp);
                    hibSession.delete((Object)bp);
                    hibSession.saveOrUpdate((Object)c);
                }
                if (bp.getOwner() instanceof SchedulingSubpart && !(s = (SchedulingSubpart)bp.getOwner()).getAvailableBuildings().contains(bldg) && department.equals(s.getManagingDept())) {
                    s.getPreferences().remove(bp);
                    hibSession.delete((Object)bp);
                    hibSession.saveOrUpdate((Object)s);
                }
                if (!(bp.getOwner() instanceof DepartmentalInstructor) || (d = (DepartmentalInstructor)bp.getOwner()).getAvailableBuildings().contains(bldg) || !department.equals(d.getDepartment())) continue;
                d.getPreferences().remove(bp);
                hibSession.delete((Object)bp);
                hibSession.saveOrUpdate((Object)d);
            }
        }
    }

    public double getDistance(Location other) {
        if (this.getUniqueId().equals(other.getUniqueId())) {
            return 0.0;
        }
        if (this instanceof Location && this.isIgnoreTooFar() != null && this.isIgnoreTooFar().booleanValue()) {
            return 0.0;
        }
        if (other instanceof Location && other.isIgnoreTooFar() != null && other.isIgnoreTooFar().booleanValue()) {
            return 0.0;
        }
        DistanceMetric m = new DistanceMetric(DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value()));
        return m.getDistanceInMeters(this.getUniqueId(), this.getCoordinateX(), this.getCoordinateY(), other.getUniqueId(), other.getCoordinateX(), other.getCoordinateY());
    }

    public Department getControllingDepartment() {
        for (RoomDept rd : this.getRoomDepts()) {
            if (!rd.isControl().booleanValue()) continue;
            return rd.getDepartment();
        }
        return null;
    }

    public abstract String getRoomTypeLabel();

    public Hashtable<ExamPeriod, PreferenceLevel> getExamPreferences(ExamType examType) {
        return this.getExamPreferences(examType.getUniqueId());
    }

    public Hashtable<ExamPeriod, PreferenceLevel> getExamPreferences(Long examTypeId) {
        Hashtable<ExamPeriod, PreferenceLevel> ret = new Hashtable<ExamPeriod, PreferenceLevel>();
        for (ExamLocationPref pref : this.getExamPreferences()) {
            if (!examTypeId.equals(pref.getExamPeriod().getExamType().getUniqueId())) continue;
            ret.put(pref.getExamPeriod(), pref.getPrefLevel());
        }
        return ret;
    }

    public PreferenceLevel getExamPreference(ExamPeriod period) {
        for (ExamLocationPref pref : this.getExamPreferences()) {
            if (!pref.getExamPeriod().equals(period)) continue;
            return pref.getPrefLevel();
        }
        return PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral);
    }

    public void clearExamPreferences(ExamType examType) {
        this.clearExamPreferences(examType.getUniqueId());
    }

    public void clearExamPreferences(Long examTypeId) {
        if (this.getExamPreferences() == null) {
            this.setExamPreferences(new HashSet<ExamLocationPref>());
        }
        Iterator<ExamLocationPref> i = this.getExamPreferences().iterator();
        while (i.hasNext()) {
            ExamLocationPref pref = i.next();
            if (!examTypeId.equals(pref.getExamPeriod().getExamType().getUniqueId())) continue;
            new ExamLocationPrefDAO().getSession().delete((Object)pref);
            i.remove();
        }
    }

    public void setExamPreference(ExamPeriod period, PreferenceLevel preference) {
        if (this.getExamPreferences() == null) {
            this.setExamPreferences(new HashSet<ExamLocationPref>());
        }
        Iterator<ExamLocationPref> i = this.getExamPreferences().iterator();
        while (i.hasNext()) {
            ExamLocationPref pref = i.next();
            if (!pref.getExamPeriod().equals(period)) continue;
            if (PreferenceLevel.sNeutral.equals(preference.getPrefProlog())) {
                new ExamLocationPrefDAO().getSession().delete((Object)pref);
                i.remove();
            } else {
                pref.setPrefLevel(preference);
                new ExamLocationPrefDAO().getSession().update((Object)pref);
            }
            return;
        }
        if (PreferenceLevel.sNeutral.equals(preference.getPrefProlog())) {
            return;
        }
        ExamLocationPref pref = new ExamLocationPref();
        pref.setExamPeriod(period);
        pref.setPrefLevel(preference);
        pref.setLocation(this);
        this.getExamPreferences().add(pref);
        new ExamLocationPrefDAO().getSession().save((Object)pref);
    }

    public void addExamPreference(ExamPeriod period, PreferenceLevel preference) {
        if (PreferenceLevel.sNeutral.equals(preference.getPrefProlog())) {
            return;
        }
        ExamLocationPref pref = new ExamLocationPref();
        pref.setExamPeriod(period);
        pref.setPrefLevel(preference);
        pref.setLocation(this);
        this.getExamPreferences().add(pref);
        new ExamLocationPrefDAO().getSession().save((Object)pref);
    }

    public String getExamPreferencesHtml(ExamType examType) {
        if (examType.getType() == 1) {
            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(this.getSession(), examType);
            epx.load(this);
            return epx.toString(true).replaceAll(", ", "<br>");
        }
        StringBuffer ret = new StringBuffer();
        for (ExamLocationPref pref : this.getExamPreferences()) {
            if (!examType.equals(pref.getExamPeriod().getExamType())) continue;
            ret.append("<span style='color:" + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + ";'>" + pref.getPrefLevel().getPrefName() + " " + pref.getExamPeriod().getName() + "</span>");
        }
        return ret.toString();
    }

    public String getExamPreferencesAbbreviationHtml(ExamType examType) {
        if (examType.getType() == 1) {
            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(this.getSession(), examType);
            epx.load(this);
            return epx.toString(true).replaceAll(", ", "<br>");
        }
        StringBuffer ret = new StringBuffer();
        for (ExamLocationPref pref : this.getExamPreferences()) {
            if (!examType.equals(pref.getExamPeriod().getExamType())) continue;
            if (ret.length() > 0) {
                ret.append("<br>");
            }
            ret.append("<span title='" + pref.getPrefLevel().getPrefName() + " " + pref.getExamPeriod().getName() + "' style='color:" + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + ";'>" + pref.getExamPeriod().getAbbreviation() + "</span>");
        }
        return ret.toString();
    }

    public String getExamPreferencesAbbreviation(ExamType examType) {
        if (examType.getType() == 1) {
            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(this.getSession(), examType);
            epx.load(this);
            return epx.toString(false).replaceAll(", ", "\n");
        }
        StringBuffer ret = new StringBuffer();
        for (ExamLocationPref pref : this.getExamPreferences()) {
            if (!examType.equals(pref.getExamPeriod().getExamType())) continue;
            if (ret.length() > 0) {
                ret.append("\n");
            }
            ret.append(pref.getPrefLevel().getAbbreviation() + " " + pref.getExamPeriod().getAbbreviation());
        }
        return ret.toString();
    }

    public static TreeSet findAllExamLocations(Long sessionId, ExamType examType) {
        return Location.findAllExamLocations(sessionId, examType == null ? null : examType.getUniqueId());
    }

    public static TreeSet findAllExamLocations(Long sessionId, Long examTypeId) {
        if (examTypeId == null) {
            return new TreeSet(new LocationDAO().getSession().createQuery("select room from Location as room where room.session.uniqueId = :sessionId and room.examTypes is not empty").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        }
        return new TreeSet(new LocationDAO().getSession().createQuery("select room from Location as room inner join room.examTypes as type where room.session.uniqueId = :sessionId and type.uniqueId = :typeId").setLong("sessionId", sessionId.longValue()).setLong("typeId", examTypeId.longValue()).setCacheable(true).list());
    }

    public static TreeSet findNotAvailableExamLocations(Long periodId) {
        return new TreeSet(new LocationDAO().getSession().createQuery("select distinct r from Exam x inner join x.assignedRooms r where x.assignedPeriod.uniqueId=:periodId").setLong("periodId", periodId.longValue()).setCacheable(true).list());
    }

    public static Hashtable<Long, Set<Long>> findExamLocationTable(Long periodId) {
        Hashtable<Long, Set<Long>> table = new Hashtable<Long, Set<Long>>();
        for (Object[] o : new LocationDAO().getSession().createQuery("select distinct r.uniqueId, x.uniqueId from Exam x inner join x.assignedRooms r where x.assignedPeriod.uniqueId=:periodId").setLong("periodId", periodId.longValue()).setCacheable(true).list()) {
            Set<Long> exams = table.get((Long)o[0]);
            if (exams == null) {
                exams = new HashSet<Long>();
                table.put((Long)o[0], exams);
            }
            exams.add((Long)o[1]);
        }
        return table;
    }

    public Collection<Assignment> getCommitedAssignments() {
        return new LocationDAO().getSession().createQuery("select a from Assignment a inner join a.rooms r where a.solution.commited=true and r.uniqueId=:locationId").setLong("locationId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    public Collection<Assignment> getAssignments(Solution solution) {
        ArrayList<Assignment> ret = new ArrayList<Assignment>(new LocationDAO().getSession().createQuery("select a from Assignment a inner join a.rooms r where r.uniqueId = :locationId and a.solution.uniqueId = :solutionId").setLong("locationId", this.getUniqueId().longValue()).setLong("solutionId", solution.getUniqueId().longValue()).setCacheable(true).list());
        ret.addAll(new LocationDAO().getSession().createQuery("select a from Assignment a, Solution x inner join a.rooms r where r.uniqueId = :locationId and a.solution.commited = true and x.uniqueId = :solutionId and a.solution.owner != x.owner").setLong("locationId", this.getUniqueId().longValue()).setLong("solutionId", solution.getUniqueId().longValue()).setCacheable(true).list());
        return ret;
    }

    public Collection<Assignment> getAssignments(Collection<Long> solutionId) {
        if (solutionId.isEmpty()) {
            return this.getCommitedAssignments();
        }
        ArrayList<Assignment> ret = new ArrayList<Assignment>(new LocationDAO().getSession().createQuery("select a from Assignment a inner join a.rooms r where r.uniqueId = :locationId and a.solution.uniqueId in (:solutionIds)").setLong("locationId", this.getUniqueId().longValue()).setParameterList("solutionIds", solutionId, (Type)new LongType()).setCacheable(true).list());
        ret.addAll(new LocationDAO().getSession().createQuery("select a from Assignment a inner join a.rooms r where r.uniqueId = :locationId and a.solution.commited = true and a.solution.owner.uniqueId not in (select s.owner.uniqueId from Solution s where s.uniqueId in (:solutionIds))").setLong("locationId", this.getUniqueId().longValue()).setParameterList("solutionIds", solutionId, (Type)new LongType()).setCacheable(true).list());
        return ret;
    }

    public static TreeSet findAllAvailableExamLocations(ExamPeriod period) {
        TreeSet locations = Location.findAllExamLocations(period.getSession().getUniqueId(), period.getExamType());
        locations.removeAll(Location.findNotAvailableExamLocations(period.getUniqueId()));
        return locations;
    }

    public static double getDistance(Collection rooms1, Collection rooms2) {
        if (rooms1 == null || rooms1.isEmpty() || rooms2 == null || rooms2.isEmpty()) {
            return 0.0;
        }
        double maxDistance = 0.0;
        for (Object o1 : rooms1) {
            Location r1 = null;
            r1 = o1 instanceof ExamRoomInfo ? ((ExamRoomInfo)o1).getLocation() : (Location)o1;
            for (Object o2 : rooms2) {
                Location r2 = null;
                r2 = o2 instanceof ExamRoomInfo ? ((ExamRoomInfo)o2).getLocation() : (Location)o2;
                maxDistance = Math.max(maxDistance, r1.getDistance(r2));
            }
        }
        return maxDistance;
    }

    public List<Exam> getExams(Long periodId) {
        return new LocationDAO().getSession().createQuery("select x from Exam x inner join x.assignedRooms r where x.assignedPeriod.uniqueId=:periodId and r.uniqueId=:locationId").setLong("periodId", periodId.longValue()).setLong("locationId", this.getUniqueId().longValue()).setCacheable(true).list();
    }

    public boolean isExamEnabled(ExamType examType) {
        return this.getExamTypes() != null && this.getExamTypes().contains(examType);
    }

    public boolean isExamEnabled(Long examTypeId) {
        if (this.getExamTypes() == null) {
            return false;
        }
        for (ExamType type : this.getExamTypes()) {
            if (!type.getUniqueId().equals(examTypeId)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFinalExamsEnabled() {
        for (ExamType type : this.getExamTypes()) {
            if (type.getType() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasMidtermExamsEnabled() {
        for (ExamType type : this.getExamTypes()) {
            if (type.getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyExamsEnabled() {
        return this.getExamTypes() != null && !this.getExamTypes().isEmpty();
    }

    public void setExamEnabled(ExamType examType, boolean enabled) {
        if (this.getExamTypes() == null) {
            this.setExamTypes(new HashSet<ExamType>());
        }
        if (enabled) {
            this.getExamTypes().add(examType);
        } else {
            this.getExamTypes().remove(examType);
        }
    }

    public static List<Location> findAll(Long sessionId) {
        return new LocationDAO().getSession().createQuery("select l from Location l where l.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<Location> findAllEventRooms(Long departmentId) {
        return new LocationDAO().getSession().createQuery("select l from Location l where l.eventDepartment.uniqueId=:departmentId").setLong("departmentId", departmentId.longValue()).setCacheable(true).list();
    }

    public static List<Room> findAllRooms(Long sessionId) {
        return new LocationDAO().getSession().createQuery("select l from Room l where l.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static List<NonUniversityLocation> findAllNonUniversityLocations(Long sessionId) {
        return new LocationDAO().getSession().createQuery("select l from NonUniversityLocation l where l.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public abstract RoomType getRoomType();

    public abstract void setRoomType(RoomType var1);

    public static Hashtable<Long, Set<Long>> findClassLocationTable(Long sessionId, int startSlot, int length, Vector<Date> dates) {
        Hashtable<Long, Set<Long>> table = new Hashtable<Long, Set<Long>>();
        String datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = datesStr + ", ";
            }
            datesStr = datesStr + ":date" + i;
        }
        Query q = LocationDAO.getInstance().getSession().createQuery("select distinct r.uniqueId, e.clazz.uniqueId from ClassEvent e inner join e.meetings m, Location r where r.session.uniqueId=:sessionId and r.permanentId=m.locationPermanentId and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + datesStr + ")").setLong("sessionId", sessionId.longValue()).setInteger("startSlot", startSlot).setInteger("endSlot", startSlot + length);
        for (int i = 0; i < dates.size(); ++i) {
            q.setDate("date" + i, dates.elementAt(i));
        }
        for (Object[] o : q.setCacheable(true).list()) {
            Set<Long> ids = table.get((Long)o[0]);
            if (ids == null) {
                ids = new HashSet<Long>();
                table.put((Long)o[0], ids);
            }
            ids.add((Long)o[1]);
        }
        return table;
    }

    public Set<Long> findClassLocationTable(int startSlot, int length, Vector<Date> dates) {
        String datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = datesStr + ", ";
            }
            datesStr = datesStr + ":date" + i;
        }
        Query q = LocationDAO.getInstance().getSession().createQuery("select distinct e.clazz.uniqueId from ClassEvent e inner join e.meetings m where m.locationPermanentId=:permanentId and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + datesStr + ")").setLong("permanentId", this.getPermanentId().longValue()).setInteger("startSlot", startSlot).setInteger("endSlot", startSlot + length);
        for (int i = 0; i < dates.size(); ++i) {
            q.setDate("date" + i, dates.elementAt(i));
        }
        return new HashSet<Long>(q.setCacheable(true).list());
    }

    public static Hashtable<Long, Set<Long>> findClassLocationTable(Long sessionId, Set<Long> permanentIds, int startSlot, int length, List<Date> dates) {
        if (permanentIds.isEmpty() || dates.isEmpty()) {
            return new Hashtable<Long, Set<Long>>();
        }
        EventDateMapping.Class2EventDateMap class2eventMap = EventDateMapping.getMapping(sessionId);
        String datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = datesStr + ", ";
            }
            datesStr = datesStr + ":date" + i;
        }
        Hashtable<Long, Set<Long>> table = new Hashtable<Long, Set<Long>>();
        Iterator<Long> permanentIdIterator = permanentIds.iterator();
        while (permanentIdIterator.hasNext()) {
            String permIds = "";
            for (int cntPermIds = 0; permanentIdIterator.hasNext() && cntPermIds < 1000; ++cntPermIds) {
                Long permanentId = permanentIdIterator.next();
                if (permIds.length() > 0) {
                    permIds = permIds + ",";
                }
                permIds = permIds + permanentId;
            }
            Query q = LocationDAO.getInstance().getSession().createQuery("select distinct m.locationPermanentId, e.clazz.uniqueId from ClassEvent e inner join e.meetings m where m.locationPermanentId in (" + permIds + ") and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + datesStr + ") and m.approvalStatus = 1").setInteger("startSlot", startSlot).setInteger("endSlot", startSlot + length);
            for (int i = 0; i < dates.size(); ++i) {
                q.setDate("date" + i, class2eventMap.getEventDate(dates.get(i)));
            }
            for (Object[] o : q.setCacheable(true).list()) {
                Set<Long> ids = table.get((Long)o[0]);
                if (ids == null) {
                    ids = new HashSet<Long>();
                    table.put((Long)o[0], ids);
                }
                ids.add((Long)o[1]);
            }
        }
        return table;
    }

    public static Hashtable<Long, Set<Event>> findEventTable(Long sessionId, Set<Long> permanentIds, int startSlot, int length, List<Date> dates) {
        if (permanentIds.isEmpty() || dates.isEmpty()) {
            return new Hashtable<Long, Set<Event>>();
        }
        EventDateMapping.Class2EventDateMap class2eventMap = EventDateMapping.getMapping(sessionId);
        String datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = datesStr + ", ";
            }
            datesStr = datesStr + ":date" + i;
        }
        Hashtable<Long, Set<Event>> table = new Hashtable<Long, Set<Event>>();
        Iterator<Long> permanentIdIterator = permanentIds.iterator();
        while (permanentIdIterator.hasNext()) {
            String permIds = "";
            for (int cntPermIds = 0; permanentIdIterator.hasNext() && cntPermIds < 1000; ++cntPermIds) {
                Long permanentId = permanentIdIterator.next();
                if (permIds.length() > 0) {
                    permIds = permIds + ",";
                }
                permIds = permIds + permanentId;
            }
            Query q = LocationDAO.getInstance().getSession().createQuery("select distinct m.locationPermanentId, e from Event e inner join e.meetings m where e.class!=ClassEvent and m.locationPermanentId in (" + permIds + ") and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + datesStr + ") and m.approvalStatus = 1").setInteger("startSlot", startSlot).setInteger("endSlot", startSlot + length);
            for (int i = 0; i < dates.size(); ++i) {
                q.setDate("date" + i, class2eventMap.getEventDate(dates.get(i)));
            }
            for (Object[] o : q.setCacheable(true).list()) {
                Set<Event> events = table.get((Long)o[0]);
                if (events == null) {
                    events = new HashSet<Event>();
                    table.put((Long)o[0], events);
                }
                events.add((Event)o[1]);
            }
        }
        return table;
    }

    @Deprecated
    public String getHtmlHint() {
        return this.getHtmlHint(null);
    }

    @Deprecated
    public String getHtmlHint(String preference) {
        try {
            if (!Hibernate.isPropertyInitialized((Object)this, (String)"roomType") || !Hibernate.isInitialized((Object)this.getRoomType())) {
                return ((Location)LocationDAO.getInstance().get(this.getUniqueId())).getHtmlHintImpl(preference);
            }
            return this.getHtmlHintImpl(preference);
        }
        catch (LazyInitializationException e) {
            return ((Location)LocationDAO.getInstance().get(this.getUniqueId())).getHtmlHintImpl(preference);
        }
    }

    @Deprecated
    private String getHtmlHintImpl(String preference) {
        String hint = (preference == null ? "" : preference + " ") + this.getLabel() + (this.getDisplayName() == null ? " (" + this.getRoomTypeLabel() + ")" : " (" + this.getDisplayName() + ")");
        String minimap = ApplicationProperty.RoomHintMinimapUrl.value();
        if (minimap != null && this.getCoordinateX() != null && this.getCoordinateY() != null) {
            minimap = minimap.replace("%x", this.getCoordinateX().toString()).replace("%y", this.getCoordinateY().toString()).replace("%n", this.getLabel()).replace("%i", this.getExternalUniqueId() == null ? "" : this.getExternalUniqueId());
            String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
            if (apikey != null && !apikey.isEmpty()) {
                minimap = minimap + "&key=" + apikey;
                String secret = ApplicationProperty.RoomMapStaticSecret.value();
                if (secret != null && !secret.isEmpty()) {
                    try {
                        minimap = minimap + "&signature=" + new RoomDetailsBackend.UrlSigner(secret).signRequest(minimap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            hint = hint + "<br><img src=\\'" + minimap + "\\' border=\\'0\\' style=\\'border: 1px solid #9CB0CE;\\'/>";
        }
        hint = hint + "<table width=\\'300px;\\'>";
        hint = hint + "<tr><td>Capacity:</td><td width=\\'99%\\'>" + this.getCapacity();
        if (this.getExamCapacity() != null && this.getExamCapacity() > 0 && !this.getExamCapacity().equals(this.getCapacity()) && !this.getExamTypes().isEmpty()) {
            String type = this.getExamTypes().size() == 1 ? this.getExamTypes().iterator().next().getLabel().toLowerCase() + " " : "";
            hint = hint + " (" + this.getExamCapacity() + " for " + type + "examinations)";
        }
        hint = hint + "</td></tr>";
        if (this.getArea() != null) {
            hint = hint + "<tr><td>" + MSG.propertyRoomArea() + "</td><td width=\\'99%\\'>" + new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).format(this.getArea()) + " " + (ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.roomAreaMetricUnitsShort() : MSG.roomAreaUnitsShort()) + "</td></tr>";
        }
        HashMap<String, String> features = new HashMap<String, String>();
        for (GlobalRoomFeature f : this.getGlobalRoomFeatures()) {
            String type = f.getFeatureType() == null ? "Features" : f.getFeatureType().getReference();
            String featuresThisType = (String)features.get(type);
            featuresThisType = featuresThisType == null ? "" : featuresThisType + ", ";
            featuresThisType = featuresThisType + f.getLabel();
            features.put(type, featuresThisType);
        }
        for (Object type : new TreeSet(features.keySet())) {
            hint = hint + "<tr><td>" + (String)type + ":</td><td>" + (String)features.get(type) + "</td></tr>";
        }
        String groups = "";
        for (RoomGroup g : this.getGlobalRoomGroups()) {
            if (!groups.isEmpty()) {
                groups = groups + ", ";
            }
            groups = groups + g.getName();
        }
        if (!groups.isEmpty()) {
            hint = hint + "<tr><td>Groups:</td><td>" + groups + "</td></tr>";
        }
        hint = hint + "<tr><td>Events:</td><td><i>" + (this.getEventDepartment() == null ? "No Event Department" : this.getEffectiveEventStatus().toString()) + "</i></td></tr>";
        String message = this.getEventMessage();
        if (message != null && !message.isEmpty()) {
            hint = hint + "<tr><td colspan=\\'2\\'>" + message.replace("'", "\\'") + "</td></tr>";
        }
        hint = hint + "</table>";
        return hint;
    }

    public String getLabelWithHint() {
        return "<span onmouseover=\"showGwtRoomHint(this, '" + this.getUniqueId() + "');\" onmouseout=\"hideGwtRoomHint();\">" + this.getLabel() + "</span>";
    }

    public boolean isUsed() {
        Number nrMeetings = (Number)LocationDAO.getInstance().getSession().createQuery("select count(m) from Meeting m, Location l where l.uniqueId = :locId and m.locationPermanentId = l.permanentId and m.meetingDate >= l.session.eventBeginDate and m.meetingDate <= l.session.eventEndDate and m.approvalStatus <= 1").setLong("locId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult();
        return nrMeetings.intValue() > 0;
    }

    public int getEffectiveBreakTime() {
        if (this.getBreakTime() != null) {
            return this.getBreakTime();
        }
        if (this.getEventDepartment() == null) {
            return ApplicationProperty.RoomDefaultBreakTime.intValue(this.getRoomType().getReference());
        }
        return this.getRoomType().getOption(this.getEventDepartment()).getBreakTime();
    }

    public RoomTypeOption.Status getEffectiveEventStatus() {
        if (this.getEventStatus() != null) {
            return RoomTypeOption.Status.values()[this.getEventStatus()];
        }
        if (this.getEventDepartment() == null) {
            return RoomTypeOption.Status.NoEventManagement;
        }
        return this.getRoomType().getOption(this.getEventDepartment()).getEventStatus();
    }

    public String getEventMessage() {
        if (this.getNote() != null && !this.getNote().isEmpty()) {
            return this.getNote();
        }
        if (this.getEventDepartment() == null) {
            return null;
        }
        return this.getRoomType().getOption(this.getEventDepartment()).getMessage();
    }

    public String getLabelWithCapacity() {
        return this.getCapacity() == null ? this.getLabel() : MSG.labelLocationLabelWithCapacity(this.getLabel(), this.getCapacity());
    }

    public String getLabelWithExamCapacity() {
        return this.getExamCapacity() == null ? this.getLabelWithCapacity() : MSG.labelLocationLabelWithCapacity(this.getLabel(), this.getExamCapacity());
    }

    @Override
    public String getPattern() {
        String pattern = super.getPattern();
        if (pattern != null && pattern.length() == 336) {
            StringBuffer p = new StringBuffer();
            for (int i = 0; i < 2016; ++i) {
                p.append(pattern.charAt(i / 6));
            }
            return p.toString();
        }
        return pattern;
    }

    public abstract Set<? extends LocationPicture> getPictures();

    public static Location findByName(Session hibSession, Long sessionId, String name) {
        Room room = (Room)hibSession.createQuery("from Room r where r.session.uniqueId = :sessionId and (r.buildingAbbv || ' ' || r.roomNumber) = :name").setLong("sessionId", sessionId.longValue()).setString("name", name).setMaxResults(1).setCacheable(true).uniqueResult();
        if (room != null) {
            return room;
        }
        return (NonUniversityLocation)hibSession.createQuery("from NonUniversityLocation l where l.session.uniqueId = :sessionId and l.name = :name").setLong("sessionId", sessionId.longValue()).setString("name", name).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public static List<Location> getFutureLocations(Long locationId) {
        Location location = (Location)LocationDAO.getInstance().get(locationId);
        return location == null ? null : location.getFutureLocations();
    }

    public abstract List<Location> getFutureLocations();

    public static Collection<Location> lookupFutureLocations(Session hibSession, List<Long> ids, Long sessionId) {
        HashMap<Long, Location> locations = new HashMap<Long, Location>();
        HashSet<Long> blacklist = new HashSet<Long>();
        for (Object[] o : LocationDAO.getInstance().getSession().createQuery("select l.uniqueId, f from Room l, Room f where l.uniqueId in :ids and f.session.uniqueId = :sessionId and l.session.academicInitiative = f.session.academicInitiative and l.session.sessionBeginDateTime < f.session.sessionBeginDateTime and ((l.permanentId = f.permanentId) or (not exists (from Location x where x.permanentId = f.permanentId and x.session = l.session) and l.roomType = f.roomType and ((length(f.externalUniqueId) > 0 and l.externalUniqueId = f.externalUniqueId) or ((f.externalUniqueId is null or length(f.externalUniqueId) = 0) and (l.externalUniqueId is null or length(l.externalUniqueId) = 0) and f.building.abbreviation = l.building.abbreviation and f.roomNumber = l.roomNumber and f.capacity = l.capacity)))) order by f.session.sessionBeginDateTime").setParameterList("ids", ids).setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            if (locations.put((Long)o[0], (Location)o[1]) == null) continue;
            blacklist.add((Long)o[0]);
        }
        for (Object[] o : LocationDAO.getInstance().getSession().createQuery("select l.uniqueId, f from NonUniversityLocation l, NonUniversityLocation f where l.uniqueId in :ids and f.session.uniqueId = :sessionId and l.session.academicInitiative = f.session.academicInitiative and l.session.sessionBeginDateTime < f.session.sessionBeginDateTime and ((l.permanentId = f.permanentId) or (not exists (from Location x where x.permanentId = f.permanentId and x.session = l.session) and l.roomType = f.roomType and ((length(f.externalUniqueId) > 0 and l.externalUniqueId = f.externalUniqueId) or ((f.externalUniqueId is null or length(f.externalUniqueId) = 0) and (l.externalUniqueId is null or length(l.externalUniqueId) = 0) and f.name = l.name and f.capacity = l.capacity)))) order by f.session.sessionBeginDateTime").setParameterList("ids", ids).setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            if (locations.put((Long)o[0], (Location)o[1]) == null) continue;
            blacklist.add((Long)o[0]);
        }
        if (!blacklist.isEmpty()) {
            for (Long id : blacklist) {
                locations.remove(id);
            }
        }
        return locations.values();
    }

    public String getLabelWithDisplayName() {
        if (this.getDisplayName() == null || this.getDisplayName().isEmpty()) {
            return this.getLabel();
        }
        return GWT_MSG.roomLabelWithDisplayName(this.getLabel(), this.getDisplayName());
    }

    public abstract Set<EventServiceProvider> getAllowedServices();

    public abstract void setAllowedServices(Set<EventServiceProvider> var1);

    public static List<Location> findAllLocations(Long sessionId) {
        return new LocationDAO().getSession().createQuery("select l from Location l where l.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }
}

