/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDepartmentRoomFeature;
import org.unitime.timetable.model.dao.DepartmentRoomFeatureDAO;

public class DepartmentRoomFeature
extends BaseDepartmentRoomFeature {
    private static final long serialVersionUID = 1L;

    public DepartmentRoomFeature() {
    }

    public DepartmentRoomFeature(Long uniqueId) {
        super(uniqueId);
    }

    public static String featureTypeDisplayString() {
        return "Department";
    }

    public String getDeptCode() {
        return this.getDepartment() == null ? null : this.getDepartment().getDeptCode();
    }

    public String htmlLabel() {
        return "<span style='color:#" + this.getDepartment().getRoomSharingColor(null) + ";font-weight:bold;' title='" + this.getLabel() + " (" + (this.getDepartment().isExternalManager() != false ? this.getDepartment().getExternalMgrLabel() : this.getDepartment().getName()) + (this.getFeatureType() == null ? "" : " " + this.getFeatureType().getReference()) + ")'>" + this.getLabel() + (this.getFeatureType() == null ? "" : " (" + this.getFeatureType().getReference() + ")") + "</span>";
    }

    public String getLabelWithType() {
        return this.getLabel() + (this.getFeatureType() == null ? " (Department)" : " (Department " + this.getFeatureType().getReference() + ")");
    }

    public String toString() {
        return this.getLabel();
    }

    public static Collection getAllRoomFeaturesForSession(Session session) {
        if (session == null) {
            return null;
        }
        return new DepartmentRoomFeatureDAO().getSession().createQuery("select distinct d from DepartmentRoomFeature d where d.department.session.uniqueId=:sessionId order by label").setLong("sessionId", session.getUniqueId().longValue()).setCacheable(true).list();
    }

    public Object clone() {
        DepartmentRoomFeature newFeature = new DepartmentRoomFeature();
        newFeature.setLabel(this.getLabel());
        newFeature.setAbbv(this.getAbbv());
        newFeature.setDepartment(this.getDepartment());
        newFeature.setFeatureType(this.getFeatureType());
        return newFeature;
    }
}

