/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequest
extends BaseCourseRequest
implements Comparable {
    private static final long serialVersionUID = 1L;

    public CourseRequest() {
    }

    public CourseRequest(Long uniqueId) {
        super(uniqueId);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof CourseRequest)) {
            return -1;
        }
        CourseRequest cr = (CourseRequest)o;
        int cmp = this.getOrder().compareTo(cr.getOrder());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(cr.getUniqueId() == null ? -1L : cr.getUniqueId());
    }

    public List<StudentClassEnrollment> getClassEnrollments() {
        ArrayList<StudentClassEnrollment> ret = new ArrayList<StudentClassEnrollment>();
        for (StudentClassEnrollment e : this.getCourseDemand().getStudent().getClassEnrollments()) {
            if (!this.getCourseOffering().equals(e.getCourseOffering())) continue;
            ret.add(e);
        }
        return ret;
    }

    public CourseRequestOption getCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type) {
        if (this.getCourseRequestOptions() == null) {
            return null;
        }
        for (CourseRequestOption option : this.getCourseRequestOptions()) {
            if (!type.equals((Object)option.getType())) continue;
            return option;
        }
        return null;
    }

    public void setCourseRequestOption(OnlineSectioningLog.CourseRequestOption option) {
        CourseRequestOption o;
        if (this.getCourseRequestOptions() == null) {
            this.setCourseRequestOptions(new HashSet<CourseRequestOption>());
        }
        if ((o = this.getCourseRequestOption(option.getType())) == null) {
            o = new CourseRequestOption();
            o.setCourseRequest(this);
            o.setOption(option);
            this.getCourseRequestOptions().add(o);
        } else {
            o.setOption(option);
        }
    }

    public void clearCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type) {
        if (this.getCourseRequestOptions() == null) {
            return;
        }
        Iterator<CourseRequestOption> i = this.getCourseRequestOptions().iterator();
        while (i.hasNext()) {
            CourseRequestOption option = i.next();
            if (type != null && !type.equals((Object)option.getType())) continue;
            i.remove();
        }
    }

    public void updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type, OnlineSectioningLog.CourseRequestOption.Builder option) {
        if (this.getCourseRequestOptions() == null) {
            this.setCourseRequestOptions(new HashSet<CourseRequestOption>());
        }
        Iterator<CourseRequestOption> i = this.getCourseRequestOptions().iterator();
        while (i.hasNext()) {
            CourseRequestOption o = i.next();
            if (!type.equals((Object)o.getType())) continue;
            if (option == null) {
                i.remove();
            } else {
                o.setOption(option.build());
            }
            return;
        }
        if (option != null) {
            CourseRequestOption o = new CourseRequestOption();
            o.setCourseRequest(this);
            o.setOption(option.build());
            this.getCourseRequestOptions().add(o);
        }
    }

    public CourseRequestOverrideStatus getCourseRequestOverrideStatus() {
        if (this.getOverrideStatus() == null) {
            return CourseRequestOverrideStatus.APPROVED;
        }
        return CourseRequestOverrideStatus.values()[this.getOverrideStatus()];
    }

    public void setCourseRequestOverrideStatus(CourseRequestOverrideStatus status) {
        this.setOverrideStatus(status == null ? null : new Integer(status.ordinal()));
    }

    public boolean isRequestApproved() {
        return this.getOverrideStatus() == null || this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.APPROVED.ordinal();
    }

    public boolean isRequestPending() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public boolean isRequestCancelled() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.CANCELLED.ordinal();
    }

    public boolean isRequestRejected() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.REJECTED.ordinal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CourseRequestOverrideStatus {
        PENDING,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

