/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class SpecialRegistrationInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;

    public static class RetrieveAllSpecialRegistrationsRequest
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private Long iStudentId;

        public RetrieveAllSpecialRegistrationsRequest() {
        }

        public RetrieveAllSpecialRegistrationsRequest(Long sessionId, Long studentId) {
            this.iStudentId = studentId;
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }
    }

    public static class SubmitSpecialRegistrationResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;
        private String iMessage;
        private boolean iCanSubmit;
        private boolean iCanEnroll;
        private boolean iSuccess;

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean isSuccess() {
            return this.iSuccess;
        }

        public boolean isFailure() {
            return !this.iSuccess;
        }

        public void setSuccess(boolean success) {
            this.iSuccess = success;
        }

        public boolean isCanSubmit() {
            return this.iCanSubmit;
        }

        public void setCanSubmit(boolean canSubmit) {
            this.iCanSubmit = canSubmit;
        }

        public boolean isCanEnroll() {
            return this.iCanEnroll;
        }

        public void setCanEnroll(boolean canEnroll) {
            this.iCanEnroll = canEnroll;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubmitSpecialRegistrationRequest
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private Long iStudentId;
        private String iRequestKey;
        private String iRequestId;
        private CourseRequestInterface iCourses;
        private Collection<ClassAssignmentInterface.ClassAssignment> iClassAssignments;
        private ArrayList<ClassAssignmentInterface.ErrorMessage> iErrors = null;

        public SubmitSpecialRegistrationRequest() {
        }

        public SubmitSpecialRegistrationRequest(Long sessionId, Long studentId, String requestKey, String requestId, CourseRequestInterface courses, Collection<ClassAssignmentInterface.ClassAssignment> assignments, Collection<ClassAssignmentInterface.ErrorMessage> errors) {
            this.iRequestKey = requestKey;
            this.iRequestId = requestId;
            this.iStudentId = studentId;
            this.iSessionId = sessionId;
            this.iCourses = courses;
            this.iClassAssignments = assignments;
            if (errors != null) {
                this.iErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>(errors);
            }
        }

        public Collection<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClassAssignments;
        }

        public void setClassAssignments(Collection<ClassAssignmentInterface.ClassAssignment> assignments) {
            this.iClassAssignments = assignments;
        }

        public CourseRequestInterface getCourses() {
            return this.iCourses;
        }

        public void setCourses(CourseRequestInterface courses) {
            this.iCourses = courses;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public String getRequestKey() {
            return this.iRequestKey;
        }

        public void setRequestKey(String requestKey) {
            this.iRequestKey = requestKey;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public ArrayList<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetrieveSpecialRegistrationResponse
    implements IsSerializable,
    Serializable,
    Comparable<RetrieveSpecialRegistrationResponse> {
        private static final long serialVersionUID = 1L;
        private ClassAssignmentInterface iClassAssignment;
        private SpecialRegistrationStatus iStatus;
        private boolean iCanSubmit;
        private boolean iCanEnroll;
        private Date iSubmitDate;
        private String iRequestId;
        private String iDescription;
        private String iNote;

        public boolean hasClassAssignments() {
            return this.iClassAssignment != null;
        }

        public ClassAssignmentInterface getClassAssignments() {
            return this.iClassAssignment;
        }

        public void setClassAssignments(ClassAssignmentInterface assignments) {
            this.iClassAssignment = assignments;
        }

        public boolean isCanSubmit() {
            return this.iCanSubmit;
        }

        public void setCanSubmit(boolean canSubmit) {
            this.iCanSubmit = canSubmit;
        }

        public boolean isCanEnroll() {
            return this.iCanEnroll;
        }

        public void setCanEnroll(boolean canEnroll) {
            this.iCanEnroll = canEnroll;
        }

        public Date getSubmitDate() {
            return this.iSubmitDate;
        }

        public void setSubmitDate(Date date) {
            this.iSubmitDate = date;
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public SpecialRegistrationStatus getStatus() {
            return this.iStatus;
        }

        public void setStatus(SpecialRegistrationStatus status) {
            this.iStatus = status;
        }

        @Override
        public int compareTo(RetrieveSpecialRegistrationResponse o) {
            int cmp = this.getSubmitDate().compareTo(o.getSubmitDate());
            if (cmp != 0) {
                return -cmp;
            }
            return this.getRequestId().compareTo(o.getRequestId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialRegistrationStatus implements IsSerializable,
    Serializable
    {
        Draft,
        Pending,
        Approved,
        Rejected,
        Cancelled;

    }

    public static class RetrieveSpecialRegistrationRequest
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private Long iStudentId;
        private String iRequestKey;

        public RetrieveSpecialRegistrationRequest() {
        }

        public RetrieveSpecialRegistrationRequest(Long sessionId, Long studentId, String requestKey) {
            this.iRequestKey = requestKey;
            this.iStudentId = studentId;
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public String getRequestKey() {
            return this.iRequestKey;
        }

        public void setRequestKey(String requestKey) {
            this.iRequestKey = requestKey;
        }
    }

    public static class SpecialRegistrationEligibilityResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iMessage;
        private boolean iCanSubmit;

        public SpecialRegistrationEligibilityResponse() {
        }

        public SpecialRegistrationEligibilityResponse(boolean canSubmit, String message) {
            this.iCanSubmit = canSubmit;
            this.iMessage = message;
        }

        public boolean isCanSubmit() {
            return this.iCanSubmit;
        }

        public void setCanSubmit(boolean canSubmit) {
            this.iCanSubmit = canSubmit;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpecialRegistrationEligibilityRequest
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private Long iStudentId;
        private Collection<ClassAssignmentInterface.ClassAssignment> iClassAssignments;
        private ArrayList<ClassAssignmentInterface.ErrorMessage> iErrors = null;

        public SpecialRegistrationEligibilityRequest() {
        }

        public SpecialRegistrationEligibilityRequest(Long sessionId, Long studentId, Collection<ClassAssignmentInterface.ClassAssignment> assignments, Collection<ClassAssignmentInterface.ErrorMessage> errors) {
            this.iClassAssignments = assignments;
            this.iStudentId = studentId;
            this.iSessionId = sessionId;
            if (errors != null) {
                this.iErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>(errors);
            }
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        public Collection<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClassAssignments;
        }

        public void setClassAssignments(Collection<ClassAssignmentInterface.ClassAssignment> assignments) {
            this.iClassAssignments = assignments;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public ArrayList<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }
    }

    public static class SpecialRegistrationContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iSpecReg = false;
        private String iSpecRegRequestId = null;
        private String iSpecRegRequestKey = null;
        private boolean iSpecRegRequestKeyValid = false;
        private boolean iSpecRegSubmit = false;
        private Boolean iSpecRegEnroll = null;
        private boolean iSpecRegDisclaimerAccepted = false;
        private boolean iSpecRegTimeConfs = false;
        private boolean iSpecRegSpaceConfs = false;

        public SpecialRegistrationContext() {
        }

        public SpecialRegistrationContext(SpecialRegistrationContext cx) {
            this.copy(cx);
        }

        public void copy(SpecialRegistrationContext cx) {
            this.iSpecReg = cx.iSpecReg;
            this.iSpecRegRequestId = cx.iSpecRegRequestId;
            this.iSpecRegRequestKey = cx.iSpecRegRequestKey;
            this.iSpecRegSubmit = cx.iSpecRegSubmit;
            this.iSpecRegEnroll = cx.iSpecRegEnroll;
            this.iSpecRegDisclaimerAccepted = cx.iSpecRegDisclaimerAccepted;
            this.iSpecRegTimeConfs = cx.iSpecRegTimeConfs;
            this.iSpecRegSpaceConfs = cx.iSpecRegSpaceConfs;
        }

        public boolean isSpecRegMode() {
            return this.iSpecReg;
        }

        public void setSpecRegMode(boolean specReg) {
            this.iSpecReg = specReg;
        }

        public String getRequestKey() {
            return this.iSpecRegRequestKey;
        }

        public void setRequestKey(String key) {
            this.iSpecRegRequestKey = key;
        }

        public boolean hasRequestKey() {
            return this.iSpecRegRequestKey != null && !this.iSpecRegRequestKey.isEmpty();
        }

        public boolean isSpecRegRequestKeyValid() {
            return this.iSpecRegRequestKeyValid;
        }

        public void setSpecRegRequestKeyValid(boolean valid) {
            this.iSpecRegRequestKeyValid = valid;
        }

        public boolean hasRequestId() {
            return this.iSpecRegRequestId != null;
        }

        public String getRequestId() {
            return this.iSpecRegRequestId;
        }

        public void setRequestId(String id) {
            this.iSpecRegRequestId = id;
        }

        public boolean isCanSubmit() {
            return this.iSpecRegSubmit;
        }

        public void setCanSubmit(boolean canSubmit) {
            this.iSpecRegSubmit = canSubmit;
        }

        public Boolean isCanEnroll() {
            return this.iSpecRegEnroll == null || this.iSpecRegEnroll != false;
        }

        public void setCanEnroll(Boolean canEnroll) {
            this.iSpecRegEnroll = canEnroll;
        }

        public boolean isDisclaimerAccepted() {
            return this.iSpecRegDisclaimerAccepted;
        }

        public void setDisclaimerAccepted(boolean accepted) {
            this.iSpecRegDisclaimerAccepted = accepted;
        }

        public boolean areTimeConflictsAllowed() {
            return this.iSpecRegTimeConfs;
        }

        public void setTimeConflictsAllowed(boolean allow) {
            this.iSpecRegTimeConfs = allow;
        }

        public boolean areSpaceConflictsAllowed() {
            return this.iSpecRegSpaceConfs;
        }

        public void setSpaceConflictsAllowed(boolean allow) {
            this.iSpecRegSpaceConfs = allow;
        }

        public void update(OnlineSectioningInterface.EligibilityCheck check) {
            this.iSpecRegTimeConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_TIME_CONF);
            this.iSpecRegSpaceConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LIMIT_CONF);
            this.iSpecReg = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG);
            this.iSpecRegSubmit = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_ENABLED);
        }

        public void reset() {
            this.iSpecReg = false;
            this.iSpecRegRequestId = null;
            this.iSpecRegRequestKeyValid = false;
            this.iSpecRegSubmit = false;
            this.iSpecRegEnroll = null;
            this.iSpecRegDisclaimerAccepted = false;
            this.iSpecRegTimeConfs = false;
            this.iSpecRegSpaceConfs = false;
        }
    }
}

