/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iSessionId;
    private Long iStudentId;
    private ArrayList<Request> iCourses = new ArrayList();
    private ArrayList<Request> iAlternatives = new ArrayList();
    private boolean iSaved = false;
    private boolean iNoChange = false;
    private boolean iAllowTimeConf = false;
    private boolean iAllowRoomConf = false;
    private Boolean iUpdateLastRequest = null;
    private RequestedCourse iLastCourse = null;
    private List<CourseMessage> iConfirmations = null;
    private Float iMaxCredit = null;
    private Float iMaxCreditOverride = null;
    private RequestedCourseStatus iMaxCreditOverrideStatus = null;
    private String iMaxCreditOverrideExternalId = null;
    private Date iMaxCreditOverrideTimeStamp = null;
    private String iCreditWarning = null;
    private String iCreditNote = null;
    private String iErrorMessage = null;
    private String iSpecRegDashboardUrl = null;

    public Long getAcademicSessionId() {
        return this.iSessionId;
    }

    public void setAcademicSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    public ArrayList<Request> getCourses() {
        return this.iCourses;
    }

    public Request getCourse(int index) {
        if (this.iCourses != null && index < this.iCourses.size()) {
            return this.iCourses.get(index);
        }
        return null;
    }

    public ArrayList<Request> getAlternatives() {
        return this.iAlternatives;
    }

    public Request getAlternative(int index) {
        if (this.iAlternatives != null && index < this.iAlternatives.size()) {
            return this.iAlternatives.get(index);
        }
        return null;
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
    }

    public boolean isNoChange() {
        return this.iNoChange;
    }

    public void setNoChange(boolean noChange) {
        this.iNoChange = noChange;
    }

    public boolean areTimeConflictsAllowed() {
        return this.iAllowTimeConf;
    }

    public void setTimeConflictsAllowed(boolean allow) {
        this.iAllowTimeConf = allow;
    }

    public boolean areSpaceConflictsAllowed() {
        return this.iAllowRoomConf;
    }

    public void setSpaceConflictsAllowed(boolean allow) {
        this.iAllowRoomConf = allow;
    }

    public boolean isUpdateLastRequest() {
        return this.iUpdateLastRequest == null || this.iUpdateLastRequest != false;
    }

    public void setUpdateLastRequest(boolean updateLastRequest) {
        this.iUpdateLastRequest = updateLastRequest;
    }

    public boolean isEmpty() {
        return this.iCourses.isEmpty() && this.iAlternatives.isEmpty();
    }

    public boolean hasMaxCredit() {
        return this.iMaxCredit != null;
    }

    public void setMaxCredit(Float maxCredit) {
        this.iMaxCredit = maxCredit;
    }

    public Float getMaxCredit() {
        return this.iMaxCredit;
    }

    public boolean hasMaxCreditOverride() {
        return this.iMaxCreditOverride != null;
    }

    public void setMaxCreditOverride(Float maxCreditOverride) {
        this.iMaxCreditOverride = maxCreditOverride;
    }

    public Float getMaxCreditOverride() {
        return this.iMaxCreditOverride;
    }

    public void setMaxCreditOverrideStatus(RequestedCourseStatus status) {
        this.iMaxCreditOverrideStatus = status;
    }

    public RequestedCourseStatus getMaxCreditOverrideStatus() {
        return this.iMaxCreditOverrideStatus;
    }

    public void setMaxCreditOverrideExternalId(String externalId) {
        this.iMaxCreditOverrideExternalId = externalId;
    }

    public String getMaxCreditOverrideExternalId() {
        return this.iMaxCreditOverrideExternalId;
    }

    public void setMaxCreditOverrideTimeStamp(Date timeStamp) {
        this.iMaxCreditOverrideTimeStamp = timeStamp;
    }

    public Date getMaxCreditOverrideTimeStamp() {
        return this.iMaxCreditOverrideTimeStamp;
    }

    public boolean hasCreditWarning() {
        return this.iCreditWarning != null && !this.iCreditWarning.isEmpty();
    }

    public String getCreditWarning() {
        return this.iCreditWarning;
    }

    public void setCreditWarning(String warning) {
        this.iCreditWarning = warning;
    }

    public boolean hasCreditNote() {
        return this.iCreditNote != null && !this.iCreditNote.isEmpty() && !" ".equals(this.iCreditNote);
    }

    public String getCreditNote() {
        return this.iCreditNote;
    }

    public void setCreditNote(String note) {
        this.iCreditNote = note;
    }

    public boolean addCourse(RequestedCourse course) {
        this.iLastCourse = course;
        if (this.getRequestPriority(course) != null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (!r.isEmpty()) continue;
            r.addRequestedCourse(course);
            return true;
        }
        Request r = new Request();
        r.addRequestedCourse(course);
        this.getCourses().add(r);
        return true;
    }

    public boolean hasLastCourse() {
        return this.iLastCourse != null;
    }

    public RequestedCourse getLastCourse() {
        return this.iLastCourse;
    }

    private RequestPriority __getRequestPriority(Object course) {
        int i;
        if (course == null) {
            return null;
        }
        int priority = 1;
        for (Request r : this.getCourses()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(false, priority, i, r);
                }
            }
            ++priority;
        }
        priority = 1;
        for (Request r : this.getAlternatives()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(true, priority, i, r);
                }
            }
            ++priority;
        }
        return null;
    }

    public RequestPriority getRequestPriority(ClassAssignmentInterface.CourseAssignment course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(DegreePlanInterface.DegreeCourseInterface course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(RequestedCourse course) {
        return this.__getRequestPriority(course);
    }

    public float[] getCreditRange() {
        Float max;
        Float min;
        ArrayList<Float> mins = new ArrayList<Float>();
        ArrayList<Float> maxs = new ArrayList<Float>();
        int nrCourses = 0;
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            min = null;
            max = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                if (min == null || min.floatValue() > rc.getCreditMin().floatValue()) {
                    min = rc.getCreditMin();
                }
                if (max != null && !(max.floatValue() < rc.getCreditMax().floatValue())) continue;
                max = rc.getCreditMax();
            }
            if (min == null) continue;
            mins.add(min);
            maxs.add(max);
            ++nrCourses;
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            min = null;
            max = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                if (min == null || min.floatValue() > rc.getCreditMin().floatValue()) {
                    min = rc.getCreditMin();
                }
                if (max != null && !(max.floatValue() < rc.getCreditMax().floatValue())) continue;
                max = rc.getCreditMax();
            }
            if (min == null) continue;
            mins.add(min);
            maxs.add(max);
        }
        Collections.sort(mins);
        Collections.sort(maxs);
        float min2 = 0.0f;
        float max2 = 0.0f;
        for (int i = 0; i < nrCourses; ++i) {
            min2 += ((Float)mins.get(i)).floatValue();
            max2 += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
        }
        return new float[]{min2, max2};
    }

    public float getCredit() {
        Float credit;
        ArrayList<Float> credits = new ArrayList<Float>();
        int nrCourses = 0;
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            credit = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue())) continue;
                credit = rc.getCreditMin();
            }
            if (credit == null) continue;
            credits.add(credit);
            ++nrCourses;
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            credit = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue())) continue;
                credit = rc.getCreditMin();
            }
            if (credit == null) continue;
            credits.add(credit);
        }
        Collections.sort(credits);
        float total = 0.0f;
        for (int i = 0; i < nrCourses; ++i) {
            total += ((Float)credits.get(credits.size() - i - 1)).floatValue();
        }
        return total;
    }

    public boolean equals(Object o) {
        int i;
        if (o == null || !(o instanceof CourseRequestInterface)) {
            return false;
        }
        CourseRequestInterface r = (CourseRequestInterface)o;
        if (this.getCourses().size() != r.getCourses().size()) {
            return false;
        }
        for (i = 0; i < this.getCourses().size(); ++i) {
            if (this.getCourse(i).equals(r.getCourse(i))) continue;
            return false;
        }
        if (this.getAlternatives().size() != r.getAlternatives().size()) {
            return false;
        }
        for (i = 0; i < this.getAlternatives().size(); ++i) {
            if (this.getAlternative(i).equals(r.getAlternative(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasConfirmations() {
        return this.iConfirmations != null && !this.iConfirmations.isEmpty();
    }

    public void addConfirmation(CourseMessage message) {
        if (this.iConfirmations != null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        this.iConfirmations.add(message);
    }

    public List<CourseMessage> getConfirmations() {
        return this.iConfirmations;
    }

    public void setConfirmations(Collection<CourseMessage> confirmations) {
        this.iConfirmations = confirmations == null ? null : new ArrayList<CourseMessage>(confirmations);
    }

    public String toString() {
        String ret = "CourseRequests(student = " + this.iStudentId + ", session = " + this.iSessionId + ", requests = {";
        int idx = 1;
        for (Request r : this.iCourses) {
            ret = ret + "\n   " + idx++ + ". " + r;
        }
        idx = 1;
        for (Request r : this.iAlternatives) {
            ret = ret + "\n  A" + idx++ + ". " + r;
        }
        return ret + "\n})";
    }

    public void addConfirmationError(Long courseId, String course, String code, String message, RequestedCourseStatus status, Integer order) {
        if (this.iConfirmations == null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        CourseMessage m = new CourseMessage();
        m.setCourseId(courseId);
        m.setCourse(course);
        m.setCode(code);
        m.setMessage(message);
        m.setError(true);
        m.setConfirm(null);
        m.setStatus(status);
        m.setOrder(order);
        this.iConfirmations.add(m);
    }

    public void addConfirmationMessage(Long courseId, String course, String code, String message, RequestedCourseStatus status, Integer order) {
        if (this.iConfirmations == null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        CourseMessage m = new CourseMessage();
        m.setCourseId(courseId);
        m.setCourse(course);
        m.setCode(code);
        m.setMessage(message);
        m.setError(false);
        m.setConfirm(null);
        m.setStatus(status);
        m.setOrder(order);
        this.iConfirmations.add(m);
    }

    public void addConfirmationMessage(Long courseId, String course, String code, String message, Integer order) {
        this.addConfirmationMessage(courseId, course, code, message, null, order);
    }

    public boolean hasErrorMessage() {
        return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
    }

    public void setErrorMessage(String message) {
        if (this.iErrorMessage == null) {
            this.iErrorMessage = message;
        } else if (!this.iErrorMessage.contains(message)) {
            this.iErrorMessage = this.iErrorMessage + "\n" + message;
        }
    }

    public String getErrorMessaeg() {
        return this.iErrorMessage;
    }

    public String getSpecRegDashboardUrl() {
        return this.iSpecRegDashboardUrl;
    }

    public boolean hasSpecRegDashboardUrl() {
        return this.iSpecRegDashboardUrl != null && !this.iSpecRegDashboardUrl.isEmpty();
    }

    public void setSpecRegDashboardUrl(String url) {
        this.iSpecRegDashboardUrl = url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CourseMessage
    implements IsSerializable,
    Serializable,
    Comparable<CourseMessage> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourse;
        private boolean iError = true;
        private String iMessage;
        private String iCode;
        private Integer iConfirm;
        private Integer iOrder;
        private RequestedCourseStatus iStatus;

        public Long getCourseId() {
            return this.iCourseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public boolean hasCourse() {
            return this.iCourse != null && !this.iCourse.isEmpty();
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public boolean isError() {
            return this.iError;
        }

        public void setError(boolean error) {
            this.iError = error;
        }

        public boolean isConfirm() {
            return this.iConfirm != null;
        }

        public void setConfirm(Integer confirm) {
            this.iConfirm = confirm;
        }

        public int getConfirm() {
            return this.iConfirm == null ? -1 : this.iConfirm;
        }

        public void setOrder(Integer order) {
            this.iOrder = order;
        }

        public boolean hasOrder() {
            return this.iOrder != null;
        }

        public int getOrder() {
            return this.iOrder == null ? Integer.MAX_VALUE : this.iOrder;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public RequestedCourseStatus getStatus() {
            return this.iStatus;
        }

        public CourseMessage setStatus(RequestedCourseStatus status) {
            this.iStatus = status;
            return this;
        }

        public String toString() {
            return (this.hasCourse() ? this.getCourse() + ": " : "") + this.getMessage() + (this.getStatus() == null ? "" : " (" + this.getStatus() + ")");
        }

        public int hashCode() {
            return (this.hasCourse() ? this.getCourse() + ":" + this.getCode() : this.getCode()).hashCode();
        }

        protected int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compareTo(CourseMessage m) {
            int cmp = this.compare(this.getConfirm(), m.getConfirm());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(this.getOrder(), m.getOrder());
            if (cmp != 0) {
                return cmp;
            }
            if (this.hasCourse() != m.hasCourse()) {
                return this.hasCourse() ? -1 : 1;
            }
            if (this.hasCourse() && (cmp = this.getCourse().compareTo(m.getCourse())) != 0) {
                return cmp;
            }
            return this.getCode().compareTo(m.getCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckCoursesResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Set<CourseMessage> iMessages = new TreeSet<CourseMessage>();
        private Map<Integer, String[]> iConfirmationSetup = null;
        private String iErrorMessage = null;
        private String iCreditWarning = null;
        private String iCreditNote = null;
        private RequestedCourseStatus iMaxCreditOverrideStatus = null;

        public CheckCoursesResponse() {
        }

        public CheckCoursesResponse(Collection<CourseMessage> messages) {
            if (messages != null && !messages.isEmpty()) {
                this.iMessages = new TreeSet<CourseMessage>(messages);
            }
        }

        public boolean hasMessages() {
            return this.iMessages != null && !this.iMessages.isEmpty();
        }

        public Set<CourseMessage> getMessages() {
            return this.iMessages;
        }

        public void addMessage(CourseMessage message) {
            this.iMessages.add(message);
        }

        public CourseMessage addMessage(Long courseId, String course, String code, String message, Integer confirm) {
            CourseMessage m = new CourseMessage();
            m.setCourseId(courseId);
            m.setCourse(course);
            m.setCode(code);
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(0);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addError(Long courseId, String course, String code, String message) {
            CourseMessage m = new CourseMessage();
            m.setCourseId(courseId);
            m.setCourse(course);
            m.setCode(code);
            m.setMessage(message);
            m.setError(true);
            m.setConfirm(null);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addConfirmation(String message, Integer confirm, Integer order) {
            CourseMessage m = new CourseMessage();
            m.setCode("CONF_MSG");
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(order);
            this.addMessage(m);
            return m;
        }

        public boolean isError() {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isError()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isOK() {
            return !this.hasMessages();
        }

        public boolean isWarning() {
            return this.hasMessages() && !this.isError();
        }

        public boolean isConfirm() {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isConfirm()) continue;
                    return true;
                }
            }
            return false;
        }

        public Set<Integer> getConfirms() {
            TreeSet<Integer> ret = new TreeSet<Integer>();
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isConfirm()) continue;
                    ret.add(m.getConfirm());
                }
            }
            return ret;
        }

        public List<CourseMessage> getMessages(String courseName) {
            ArrayList<CourseMessage> ret = new ArrayList<CourseMessage>();
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    ret.add(m);
                }
            }
            return ret;
        }

        public String getMessage(String courseName, String delim, String ... exclude) {
            if (!this.hasMessages()) {
                return null;
            }
            String ret = null;
            if (this.hasMessages()) {
                block0: for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    for (String e : exclude) {
                        if (e.equals(m.getCode())) continue block0;
                    }
                    if (ret == null) {
                        ret = m.getMessage();
                        continue;
                    }
                    ret = ret + delim + m.getMessage();
                }
            }
            return ret;
        }

        public RequestedCourseStatus getStatus(String courseName) {
            RequestedCourseStatus status = null;
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (m.getStatus() == null || !m.hasCourse() || !courseName.equals(m.getCourse()) || status != null && m.getStatus().ordinal() <= status.ordinal()) continue;
                    status = m.getStatus();
                }
            }
            return status;
        }

        public String getMessageWithColor(String courseName, String delim, String ... exclude) {
            if (!this.hasMessages()) {
                return null;
            }
            String ret = null;
            if (this.hasMessages()) {
                block0: for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    for (String e : exclude) {
                        if (e.equals(m.getCode())) continue block0;
                    }
                    if (ret == null) {
                        ret = (m.isError() ? "<span class='text-red'>" : "<span class='text-orange'>") + m.getMessage() + "</span>";
                        continue;
                    }
                    ret = ret + delim + (m.isError() ? "<span class='text-red'>" : "<span class='text-orange'>") + m.getMessage() + "</span>";
                }
            }
            return ret;
        }

        public boolean hasMessage(String courseName, String code) {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !code.equals(m.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isError(String courseName) {
            if (!this.hasMessages()) {
                return false;
            }
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !m.isError()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isConfirm(String courseName) {
            if (!this.hasMessages()) {
                return false;
            }
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !m.isConfirm()) continue;
                    return true;
                }
            }
            return false;
        }

        public String getConfirmations(int confirm, String delim) {
            if (!this.hasMessages()) {
                return null;
            }
            String ret = null;
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (confirm != m.getConfirm()) continue;
                    if (ret == null) {
                        ret = (m.hasCourse() ? m.getCourse() + ": " : "") + m.getMessage();
                        continue;
                    }
                    ret = ret + delim + (m.hasCourse() ? m.getCourse() + ": " : "") + m.getMessage();
                }
            }
            return ret;
        }

        public void setConfirmation(int confirm, String dialogTitle, String yesButton, String noButton, String yesButtonTitle, String noButtonTitle) {
            if (this.iConfirmationSetup == null) {
                this.iConfirmationSetup = new HashMap<Integer, String[]>();
            }
            this.iConfirmationSetup.put(confirm, new String[]{dialogTitle, yesButton, noButton, yesButtonTitle, noButtonTitle});
        }

        public String getConfirmationTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[0] == null ? defaultTitle : confirmation[0];
        }

        public String getConfirmationYesButton(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[1] == null ? defaultTitle : confirmation[1];
        }

        public String getConfirmationNoButton(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[2] == null ? defaultTitle : confirmation[2];
        }

        public String getConfirmationYesButtonTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[3] == null ? defaultTitle : confirmation[3];
        }

        public String getConfirmationNoButtonTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[4] == null ? defaultTitle : confirmation[4];
        }

        public boolean hasErrorMessage() {
            return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
        }

        public void setErrorMessage(String message) {
            if (this.iErrorMessage == null) {
                this.iErrorMessage = message;
            } else if (!this.iErrorMessage.contains(message)) {
                this.iErrorMessage = this.iErrorMessage + "\n" + message;
            }
        }

        public String getErrorMessaeg() {
            return this.iErrorMessage;
        }

        public boolean hasCreditWarning() {
            return this.iCreditWarning != null && !this.iCreditWarning.isEmpty();
        }

        public String getCreditWarning() {
            return this.iCreditWarning;
        }

        public void setCreditWarning(String warning) {
            this.iCreditWarning = warning;
        }

        public boolean hasCreditNote() {
            return this.iCreditNote != null && !this.iCreditNote.isEmpty() && !" ".equals(this.iCreditNote);
        }

        public String getCreditNote() {
            return this.iCreditNote;
        }

        public void setCreditNote(String note) {
            this.iCreditNote = note;
        }

        public void setMaxCreditOverrideStatus(RequestedCourseStatus status) {
            this.iMaxCreditOverrideStatus = status;
        }

        public RequestedCourseStatus getMaxCreditOverrideStatus() {
            return this.iMaxCreditOverrideStatus;
        }

        public String toString() {
            return this.hasMessages() ? this.getMessages().toString() : "[]";
        }
    }

    public static class RequestPriority
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iAlternative = false;
        private int iPriority = 0;
        private int iChoice = 0;
        private Request iRequest;

        RequestPriority(boolean alternative, int priority, int choice, Request request) {
            this.iAlternative = alternative;
            this.iPriority = priority;
            this.iChoice = choice;
            this.iRequest = request;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public int getChoice() {
            return this.iChoice;
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String toString() {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return "Alt " + this.iPriority + ".";
                    }
                    case 1: {
                        return "Alt " + this.iPriority + "A.";
                    }
                }
                return "Alt " + this.iPriority + "B.";
            }
            switch (this.iChoice) {
                case 0: {
                    return this.iPriority + ".";
                }
                case 1: {
                    return this.iPriority + "A.";
                }
            }
            return this.iPriority + "B.";
        }

        public String toString(StudentSectioningMessages MESSAGES) {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return MESSAGES.degreeRequestedAlternative(this.iPriority);
                    }
                    case 1: {
                        return MESSAGES.degreeRequestedAlternativeFirstAlt(this.iPriority);
                    }
                }
                return MESSAGES.degreeRequestedAlternativeSecondAlt(this.iPriority);
            }
            switch (this.iChoice) {
                case 0: {
                    return MESSAGES.degreeRequestedCourse(this.iPriority);
                }
                case 1: {
                    return MESSAGES.degreeRequestedCourseFirstAlt(this.iPriority);
                }
            }
            return MESSAGES.degreeRequestedCourseSecondAlt(this.iPriority);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<RequestedCourse> iRequestedCourse = null;
        private Boolean iWaitList = false;
        private Date iTimeStamp = null;

        public List<RequestedCourse> getRequestedCourse() {
            return this.iRequestedCourse;
        }

        public RequestedCourse getRequestedCourse(int index) {
            if (this.iRequestedCourse != null && index < this.iRequestedCourse.size()) {
                return this.iRequestedCourse.get(index);
            }
            return null;
        }

        public boolean hasRequestedCourse() {
            return this.iRequestedCourse != null && !this.iRequestedCourse.isEmpty();
        }

        public void addRequestedCourse(RequestedCourse requestedCourse) {
            if (this.iRequestedCourse == null) {
                this.iRequestedCourse = new ArrayList<RequestedCourse>();
            }
            this.iRequestedCourse.add(requestedCourse);
        }

        public boolean hasRequestedCourse(ClassAssignmentInterface.CourseAssignment course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRequestedCourse(RequestedCourse course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return !this.hasRequestedCourse();
        }

        public boolean isReadOnly() {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.isReadOnly()) continue;
                return true;
            }
            return false;
        }

        public boolean isCanDelete() {
            if (this.iRequestedCourse == null) {
                return true;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isCanDelete()) continue;
                return false;
            }
            return true;
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public boolean hasTimeStamp() {
            return this.iTimeStamp != null;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date ts) {
            this.iTimeStamp = ts;
        }

        public String toString() {
            return (this.hasRequestedCourse() ? this.iRequestedCourse.toString() : "-") + (this.isWaitList() ? " (w)" : "");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Request)) {
                return false;
            }
            Request r = (Request)o;
            if (this.isWaitList() != r.isWaitList() || this.getRequestedCourse().size() != r.getRequestedCourse().size()) {
                return false;
            }
            for (int i = 0; i < this.getRequestedCourse().size(); ++i) {
                RequestedCourse c2;
                RequestedCourse c1 = this.getRequestedCourse(i);
                if (c1.equals(c2 = r.getRequestedCourse(i)) && c1.sameSelectedClasses(c2) && c1.sameSelectedIntructionalMethods(c2)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestedCourse
    implements IsSerializable,
    Serializable,
    Comparable<RequestedCourse> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourseName;
        private String iCourseTitle;
        private Boolean iReadOnly = null;
        private Boolean iCanDelete = null;
        private List<FreeTime> iFreeTime;
        private Set<String> iSelectedIntructionalMethods;
        private Set<String> iSelectedClasses;
        private float[] iCredit = null;
        private RequestedCourseStatus iStatus = null;
        private String iStatusNote = null;
        private String iOverrideExternalId = null;
        private Date iOverrideTimeStamp = null;

        public RequestedCourse() {
        }

        public RequestedCourse(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public RequestedCourse(ClassAssignmentInterface.CourseAssignment course, boolean showTitle) {
            this.iCourseId = course.getCourseId();
            this.iCourseName = course.hasUniqueName() && !showTitle ? course.getCourseName() : course.getCourseNameWithTitle();
        }

        public boolean isCourse() {
            return this.hasCourseId() || this.hasCourseName();
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public boolean hasCourseName() {
            return this.iCourseName != null && !this.iCourseName.isEmpty();
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public String getCourseTitle() {
            return this.iCourseTitle;
        }

        public boolean hasCourseTitle() {
            return this.iCourseTitle != null && !this.iCourseTitle.isEmpty();
        }

        public void setCourseTitle(String courseTitle) {
            this.iCourseTitle = courseTitle;
        }

        public boolean hasCredit() {
            return this.iCredit != null;
        }

        public float[] getCredit() {
            return this.iCredit;
        }

        public Float getCreditMin() {
            return this.iCredit == null ? null : Float.valueOf(this.iCredit[0]);
        }

        public Float getCreditMax() {
            return this.iCredit == null ? null : Float.valueOf(this.iCredit[1]);
        }

        public void setCredit(Float minCredit, Float maxCredit) {
            float[] fArray;
            if (minCredit == null || maxCredit == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = minCredit.floatValue();
                fArray = fArray2;
                fArray2[1] = maxCredit.floatValue();
            }
            this.iCredit = fArray;
        }

        public void setCredit(Float credit) {
            float[] fArray;
            if (credit == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = credit.floatValue();
                fArray = fArray2;
                fArray2[1] = credit.floatValue();
            }
            this.iCredit = fArray;
        }

        public void setCredit(float[] credit) {
            this.iCredit = credit;
        }

        public void setStatus(RequestedCourseStatus status) {
            this.iStatus = status;
        }

        public RequestedCourseStatus getStatus() {
            return this.iStatus;
        }

        public void setStatusNote(String note) {
            this.iStatusNote = note == null ? null : note.replace("<br>", "\n");
        }

        public boolean hasStatusNote() {
            return this.iStatusNote != null && !this.iStatusNote.isEmpty() && !" ".equals(this.iStatusNote);
        }

        public String getStatusNote() {
            return this.iStatusNote;
        }

        public void setOverrideExternalId(String externalId) {
            this.iOverrideExternalId = externalId;
        }

        public String getOverrideExternalId() {
            return this.iOverrideExternalId;
        }

        public void setOverrideTimeStamp(Date timeStamp) {
            this.iOverrideTimeStamp = timeStamp;
        }

        public Date getOverrideTimeStamp() {
            return this.iOverrideTimeStamp;
        }

        public List<FreeTime> getFreeTime() {
            return this.iFreeTime;
        }

        public boolean isFreeTime() {
            return this.iFreeTime != null && !this.iFreeTime.isEmpty();
        }

        public void setFreeTime(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public void addFreeTime(FreeTime freeTime) {
            if (this.iFreeTime == null) {
                this.iFreeTime = new ArrayList<FreeTime>();
            }
            this.iFreeTime.add(freeTime);
        }

        public boolean isReadOnly() {
            return this.iReadOnly != null && this.iReadOnly != false;
        }

        public void setReadOnly(Boolean readOnly) {
            this.iReadOnly = readOnly;
        }

        public boolean isCanDelete() {
            return this.iCanDelete == null || this.iCanDelete != false;
        }

        public void setCanDelete(Boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isEmpty() {
            return !this.isCourse() && !this.isFreeTime();
        }

        public boolean hasSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods != null && !this.iSelectedIntructionalMethods.isEmpty();
        }

        public Set<String> getSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods;
        }

        public void setSelectedIntructionalMethod(String id, boolean value) {
            if (this.iSelectedIntructionalMethods == null) {
                this.iSelectedIntructionalMethods = new HashSet<String>();
            }
            if (value) {
                this.iSelectedIntructionalMethods.add(id);
            } else {
                this.iSelectedIntructionalMethods.remove(id);
            }
        }

        public boolean isSelectedIntructionalMethod(String id) {
            if (this.iSelectedIntructionalMethods == null) {
                return false;
            }
            return this.iSelectedIntructionalMethods.contains(id);
        }

        public int getNrSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods == null ? 0 : this.iSelectedIntructionalMethods.size();
        }

        public boolean sameSelectedIntructionalMethods(RequestedCourse rc) {
            if (this.getNrSelectedIntructionalMethods() != rc.getNrSelectedIntructionalMethods()) {
                return false;
            }
            if (this.hasSelectedIntructionalMethods()) {
                for (String id : this.getSelectedIntructionalMethods()) {
                    if (rc.isSelectedIntructionalMethod(id)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasSelectedClasses() {
            return this.iSelectedClasses != null && !this.iSelectedClasses.isEmpty();
        }

        public Set<String> getSelectedClasses() {
            return this.iSelectedClasses;
        }

        public void setSelectedClasses(Set<String> classes) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<String>();
            } else {
                this.iSelectedClasses.clear();
            }
            if (classes != null) {
                this.iSelectedClasses.addAll(classes);
            }
        }

        public void setSelectedClass(String id, boolean value) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<String>();
            }
            if (value) {
                this.iSelectedClasses.add(id);
            } else {
                this.iSelectedClasses.remove(id);
            }
        }

        public boolean isSelectedClass(String id) {
            if (this.iSelectedClasses == null || id == null) {
                return false;
            }
            return this.iSelectedClasses.contains(id);
        }

        public int getNrSelectedClasses() {
            return this.iSelectedClasses == null ? 0 : this.iSelectedClasses.size();
        }

        public boolean sameSelectedClasses(RequestedCourse rc) {
            if (this.getNrSelectedClasses() != rc.getNrSelectedClasses()) {
                return false;
            }
            if (this.hasSelectedClasses()) {
                for (String id : this.getSelectedClasses()) {
                    if (rc.isSelectedClass(id)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.hasCourseId() ? this.getCourseId().hashCode() : this.getCourseName().hashCode();
        }

        public String toString() {
            if (this.isCourse()) {
                return this.getCourseName() + (this.hasSelectedIntructionalMethods() ? " method:" + this.getSelectedIntructionalMethods() : "") + (this.hasSelectedClasses() ? " section:" + this.getSelectedClasses() : "") + (this.isReadOnly() ? " [S]" : "") + (this.hasCourseId() ? "[i]" : "");
            }
            if (this.isFreeTime()) {
                String ret = "";
                for (FreeTime ft : this.getFreeTime()) {
                    ret = ret + (ret.isEmpty() ? "" : ", ") + ft.toString();
                }
                return ret;
            }
            return "N/A";
        }

        public String toString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                String display = "";
                String lastDays = null;
                for (FreeTime ft : this.getFreeTime()) {
                    if (display.length() > 0) {
                        display = display + ", ";
                    }
                    String days = ft.getDaysString(CONSTANTS.shortDays(), "");
                    if (ft.getDays().size() == CONSTANTS.freeTimeDays().length && !ft.getDays().contains(5) && !ft.getDays().contains(6)) {
                        days = "";
                    }
                    display = display + (days.isEmpty() || days.equals(lastDays) ? "" : days + " ") + ft.getStartString(CONSTANTS.useAmPm()) + " - " + ft.getEndString(CONSTANTS.useAmPm());
                    lastDays = days;
                }
                return CONSTANTS.freePrefix() + display;
            }
            return "";
        }

        public String toAriaString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                String status = "";
                for (FreeTime ft : this.getFreeTime()) {
                    status = status + (status.isEmpty() ? "" : " ") + ft.toAriaString(CONSTANTS.longDays(), CONSTANTS.useAmPm());
                }
                return status;
            }
            return "";
        }

        public boolean equals(Object o) {
            IsSerializable c;
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return ((String)o).equalsIgnoreCase(this.getCourseName());
            }
            if (o instanceof Long) {
                return ((Long)o).equals(this.getCourseId());
            }
            if (o instanceof RequestedCourse) {
                c = (RequestedCourse)o;
                if (c.hasCourseId() && this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (c.hasCourseName() && this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName());
                }
                if (c.isFreeTime() && this.isFreeTime()) {
                    return c.getFreeTime().equals(this.getFreeTime());
                }
            }
            if (o instanceof ClassAssignmentInterface.CourseAssignment) {
                c = (ClassAssignmentInterface.CourseAssignment)o;
                if (this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            if (o instanceof DegreePlanInterface.DegreeCourseInterface) {
                c = (DegreePlanInterface.DegreeCourseInterface)o;
                if (this.hasCourseId() && c.getCourseId() != null) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            return false;
        }

        @Override
        public int compareTo(RequestedCourse o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestedCourseStatus implements IsSerializable,
    Serializable
    {
        NEW_REQUEST,
        ENROLLED,
        SAVED,
        OVERRIDE_APPROVED,
        OVERRIDE_CANCELLED,
        OVERRIDE_PENDING,
        OVERRIDE_NEEDED,
        OVERRIDE_REJECTED,
        CREDIT_LOW,
        CREDIT_HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeTime
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;

        public FreeTime() {
        }

        public FreeTime(List<Integer> days, int start, int length) {
            if (days != null) {
                this.iDays.addAll(days);
            }
            this.iStart = start;
            this.iLength = length;
        }

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public int getDayCode() {
            int ret = 0;
            for (int day : this.iDays) {
                ret += 1 << day;
            }
            return ret;
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int startSlot) {
            this.iStart = startSlot;
        }

        public String getStartString(boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            int h = (this.iStart + this.iLength) / 12;
            int m = 5 * ((this.iStart + this.iLength) % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString(String[] shortDays, boolean useAmPm) {
            return this.getDaysString(shortDays, "") + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String toString() {
            return "Free " + this.toString(new String[]{"M", "T", "W", "R", "F", "S", "U"}, true);
        }

        public String toAriaString(String[] longDays, boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FreeTime)) {
                return false;
            }
            FreeTime f = (FreeTime)o;
            return f.getStart() == this.getStart() && f.getLength() == this.getLength() && f.getDayCode() == this.getDayCode();
        }
    }
}

