/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeFileUpload
extends FormPanel
implements HasValueChangeHandlers<String> {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private FileUpload iUpload;

    public UniTimeFileUpload() {
        this.setEncoding("multipart/form-data");
        this.setMethod("post");
        this.setAction(GWT.getHostPageBaseURL() + "upload");
        this.iUpload = new FileUpload();
        this.iUpload.setName("file");
        this.setWidget((Widget)this.iUpload);
        this.iUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                UniTimeFileUpload.this.submit();
            }
        });
        this.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                String message = event.getResults();
                if (message.startsWith("ERROR:")) {
                    UniTimeNotifications.error(message.substring("ERROR:".length()));
                    UniTimeFileUpload.this.reset();
                } else {
                    UniTimeNotifications.info(message);
                    ValueChangeEvent.fire((HasValueChangeHandlers)UniTimeFileUpload.this, (Object)UniTimeFileUpload.this.iUpload.getFilename());
                }
            }
        });
        this.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                String name = UniTimeFileUpload.this.iUpload.getFilename();
                if (name.indexOf(47) >= 0) {
                    name = name.substring(name.lastIndexOf(47) + 1);
                }
                if (name.indexOf(92) >= 0) {
                    name = name.substring(name.lastIndexOf(92) + 1);
                }
                if (!name.isEmpty()) {
                    UniTimeNotifications.info("Uploading " + name + " ...");
                }
            }
        });
    }

    public void reset() {
        super.reset();
        RPC.execute(new FileUploadRpcRequest(true), new AsyncCallback<FileUploadRpcResponse>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught);
            }

            public void onSuccess(FileUploadRpcResponse result) {
            }
        });
    }

    public void check() {
        RPC.execute(new FileUploadRpcRequest(), new AsyncCallback<FileUploadRpcResponse>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught.getMessage(), caught);
            }

            public void onSuccess(FileUploadRpcResponse result) {
                if (result.hasFile()) {
                    if (!result.getFileName().equals(UniTimeFileUpload.this.getFileName())) {
                        UniTimeFileUpload.this.reset();
                    }
                } else if (UniTimeFileUpload.this.getFileName() != null && !UniTimeFileUpload.this.getFileName().isEmpty()) {
                    UniTimeFileUpload.super.reset();
                }
            }
        });
    }

    public String getFileName() {
        return this.iUpload.getFilename();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public static class FileUploadRpcResponse
    implements GwtRpcResponse {
        private String iName;

        public FileUploadRpcResponse() {
        }

        public FileUploadRpcResponse(String name) {
            this.iName = name;
        }

        public boolean hasFile() {
            return this.iName != null;
        }

        public String getFileName() {
            return this.iName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileUploadRpcRequest
    implements GwtRpcRequest<FileUploadRpcResponse> {
        private boolean iReset = false;

        public FileUploadRpcRequest() {
        }

        public FileUploadRpcRequest(boolean reset) {
            this.iReset = reset;
        }

        public boolean isReset() {
            return this.iReset;
        }

        @Override
        public String toString() {
            return this.iReset ? "reset" : "request";
        }
    }
}

