/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.solver.PreferenceLegend;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentAssignment
extends SimpleForm
implements TakesValue<SuggestionsInterface.ClassAssignmentDetails> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private SuggestionsPageContext iContext = null;
    private SuggestionsInterface.ClassAssignmentDetails iDetails;
    private SuggestionsPageContext.TimeLocations iTimes = null;
    private SuggestionsPageContext.DateLocations iDates = null;
    private SuggestionsPageContext.RoomLocations iRooms = null;
    private UniTimeHeaderPanel iHeader = null;
    private int iMessageRow = 0;
    private HTML iMessage = null;
    private UniTimeHeaderPanel iFooter = null;
    private int iFooterRow = 0;
    private int iLegendRow = 0;

    public CurrentAssignment(SuggestionsPageContext context) {
        this.iContext = context;
        this.iHeader = new UniTimeHeaderPanel();
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("unassign", MESSAGES.buttonUnassign(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ArrayList<SuggestionsInterface.SelectedAssignment> assignments = new ArrayList<SuggestionsInterface.SelectedAssignment>();
                assignments.add(new SuggestionsInterface.SelectedAssignment(CurrentAssignment.this.iDetails.getClazz().getClassId()));
                CurrentAssignment.this.iContext.assign(assignments, CurrentAssignment.this.iFooter);
            }
        });
    }

    public SuggestionsInterface.ClassAssignmentDetails getValue() {
        return this.iDetails;
    }

    public void clearMessage() {
        this.iHeader.clearMessage();
        if (this.iMessage != null) {
            this.iMessage.setHTML("");
            this.getRowFormatter().setVisible(this.iMessageRow, false);
        }
    }

    public void setErrorMessage(String message) {
        this.iHeader.clearMessage();
        if (this.iMessage != null) {
            this.iMessage.setHTML(message);
            this.getRowFormatter().setVisible(this.iMessageRow, true);
        }
    }

    public void showLoading() {
        this.iHeader.showLoading();
        if (this.iMessage != null) {
            this.iMessage.setHTML("");
            this.getRowFormatter().setVisible(this.iMessageRow, false);
        }
    }

    public void setValue(SuggestionsInterface.ClassAssignmentDetails details) {
        this.iDetails = details;
        this.clear();
        this.iHeader.clearMessage();
        String html = "<a href='classDetail.do?cid=" + details.getClazz().getClassId() + "' class='header-link' target='_blank' title='" + MESSAGES.titleOpenClassDetail(SafeHtmlUtils.htmlEscape((String)details.getClazz().getName())) + "'>" + details.getClazz().getName() + "</a>";
        this.iHeader.setHeaderTitle(MESSAGES.headerCurrentAssignment(html));
        this.addHeaderRow((Widget)this.iHeader);
        if (details.getTime() != null) {
            if (details.getTime().hasDatePattern()) {
                this.addRow(MESSAGES.propAssignedDate(), (Widget)this.iContext.createDateLabel(details.getTime().getDatePattern()));
            }
            this.addRow(MESSAGES.propAssignedTime(), (Widget)this.iContext.createTimeLabel(details.getTime(), details.getClazz().getClassId(), true));
            if (details.getRoom() != null) {
                this.addRow(MESSAGES.propAssignedRooms(), (Widget)this.iContext.createRoomsLabel(details.getRoom()));
            }
        } else {
            Label notAssigned = new Label(MESSAGES.classNotAssigned());
            notAssigned.addStyleName("not-assigned");
            this.addRow((Widget)notAssigned);
        }
        if (details.getInstructor() != null) {
            this.addRow(MESSAGES.propInstructor(), (Widget)this.iContext.createInstructorsLabel(details.getInstructor()));
        }
        if (details.getInitialTime() != null) {
            this.addRow(MESSAGES.propInitialAssignment(), (Widget)this.iContext.createAssignmentLabel(details.getInitialTime(), details.getInitialRoom(), details.getClazz().getClassId(), details.getNrDates() > 1));
        }
        if (details.hasStudentConflicts()) {
            this.addRow(MESSAGES.propStudentConflicts(), (Widget)this.iContext.createStudentConflicts(details.getStudentConflicts()));
        }
        if (details.hasViolatedDistributionConflicts() || details.hasBtbInstructorConflicts()) {
            this.addRow(MESSAGES.propViolatedConstraints(), (Widget)this.iContext.createViolatedConstraints(details.getDistributionConflicts(), details.getBtbInstructorConflicts()));
        }
        if (details.hasTimes() && details.getNrDates() > 1) {
            this.iDates = this.iContext.createDateLocations(details.getTimes());
            this.addRow(MESSAGES.propDateLocations(), (Widget)this.iDates);
            if (details.getAssignedTime() != null && details.getAssignedTime().hasDatePattern()) {
                this.iDates.select(details.getAssignedTime().getDatePattern(), false);
            } else if (details.getTime() != null && details.getTime().hasDatePattern()) {
                this.iDates.select(details.getTime().getDatePattern(), false);
            }
        } else {
            this.iDates = null;
        }
        if (details.hasTimes()) {
            this.iTimes = this.iContext.createTimeLocations(details.getClazz().getClassId(), details.getTimes());
            this.addRow(MESSAGES.propTimeLocations(), (Widget)this.iTimes);
            if (details.getAssignedTime() != null) {
                this.iTimes.select(details.getAssignedTime(), false);
            } else if (details.getTime() != null) {
                this.iTimes.select(details.getTime(), false);
            }
        } else {
            this.iTimes = null;
        }
        if (details.hasRooms()) {
            this.iRooms = this.iContext.createRoomLocations(details.getClazz().nrRooms(), details.getRooms());
            this.addRow(MESSAGES.propRoomLocations(), (Widget)this.iRooms);
            if (details.getAssignedRoom() != null) {
                for (SuggestionsInterface.RoomInfo r : details.getAssignedRoom()) {
                    this.iRooms.select(r, false);
                }
            } else if (details.getRoom() != null) {
                for (SuggestionsInterface.RoomInfo r : details.getRoom()) {
                    this.iRooms.select(r, false);
                }
            }
        } else {
            this.iRooms = null;
        }
        if (details.getClazz().nrRooms() > 0 && details.getClazz().getRoomCapacity() > 0) {
            this.addRow(MESSAGES.propMinimumRoomSize(), (Widget)new Label(String.valueOf(details.getClazz().getRoomCapacity())));
        }
        if (details.getClazz().getNote() != null && !details.getClazz().getNote().isEmpty()) {
            this.addRow(MESSAGES.propNote(), (Widget)new HTML(details.getClazz().getNote()));
        }
        this.iMessage = new HTML();
        this.iMessage.addStyleName("error-message");
        this.iMessageRow = this.addRow((Widget)this.iMessage);
        if (details.getTime() != null && details.isCanUnassign()) {
            this.iFooterRow = this.addBottomRow((Widget)this.iFooter);
            this.iFooter.setEnabled("unassign", true);
        } else {
            this.iFooterRow = -1;
        }
        this.iLegendRow = this.addRow((Widget)new PreferenceLegend(this.iContext.getProperties().getPreferences()));
        this.getRowFormatter().setVisible(this.iLegendRow, this.iFooterRow < 0 || this.iFooter.isEnabled("unassign") == false);
    }

    public void setShowUnassign(boolean show) {
        if (show && this.iFooterRow >= 0) {
            this.iFooter.setEnabled("unassign", this.iDetails != null && this.iDetails.isCanUnassign());
            this.getRowFormatter().setVisible(this.iFooterRow, true);
        } else if (!show && this.iFooterRow >= 0) {
            this.iFooter.setEnabled("unassign", false);
            this.getRowFormatter().setVisible(this.iFooterRow, false);
        }
        this.getRowFormatter().setVisible(this.iLegendRow, this.iFooterRow < 0 || this.iFooter.isEnabled("unassign") == false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SuggestionsInterface.SelectedAssignment getSelectedAssignment() {
        SuggestionsInterface.SelectedAssignment selection = new SuggestionsInterface.SelectedAssignment();
        selection.setClassId(this.iDetails.getClazz().getClassId());
        if (this.iDates != null) {
            SuggestionsInterface.DateInfo date = this.iDates.getSelectedDate();
            if (date == null) {
                return null;
            }
            selection.setDatePatternId(date.getDatePatternId());
        } else {
            if (this.iDetails.getNrDates() != 1) return null;
            selection.setDatePatternId(this.iDetails.getTimes().get(0).getDatePatternId());
        }
        if (this.iTimes == null) return null;
        SuggestionsInterface.TimeInfo time = this.iTimes.getSelectedTime();
        if (time == null) {
            return null;
        }
        selection.setDays(time.getDays());
        selection.setPatternId(time.getPatternId());
        selection.setStartSlot(time.getStartSlot());
        if (this.iRooms != null) {
            if (this.iRooms.getNrSelectedRooms() != this.iDetails.getClazz().nrRooms()) return null;
            for (SuggestionsInterface.RoomInfo room : this.iRooms.getSelectedRooms()) {
                selection.addRoomId(room.getId());
            }
            return selection;
        } else {
            if (this.iDetails.getClazz().nrRooms() == 0) return selection;
            return null;
        }
    }

    public void setSelectedAssignment(SuggestionsInterface.SelectedAssignment assignment) {
        if (this.iDates != null) {
            this.iDates.select(assignment == null ? null : new SuggestionsInterface.DateInfo(assignment), false);
        }
        if (this.iTimes != null) {
            this.iTimes.select(assignment == null ? (SuggestionsInterface.TimeInfo)null : new SuggestionsInterface.TimeInfo(assignment), false);
        }
        if (this.iRooms != null) {
            for (int i = 0; i < this.iDetails.getClazz().nrRooms(); ++i) {
                Long roomId = assignment == null ? null : assignment.getRoomId(i);
                this.iRooms.select(roomId == null ? (SuggestionsInterface.RoomInfo)null : new SuggestionsInterface.RoomInfo(roomId), false);
            }
        }
    }

    public void setSelectedTime(SuggestionsInterface.TimeInfo time, boolean fireUpdate) {
        if (this.iDates != null) {
            this.iDates.select(time == null ? null : time.getDatePattern(), false);
        }
        if (this.iTimes != null) {
            this.iTimes.select(time, fireUpdate);
        }
    }
}

