/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.suggestions.ConflictBasedStatisticsTree;
import org.unitime.timetable.gwt.client.solver.suggestions.SuggestionsPageContext;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBSWidget
extends SimpleForm
implements TakesValue<Long> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SuggestionsPageContext iContext;
    private UniTimeHeaderPanel iHeader;
    private ConflictBasedStatisticsTree iTree;
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Long iClassId = null;
    private boolean iCBSComputed = false;

    public CBSWidget(SuggestionsPageContext context) {
        this.iContext = context;
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.headerCBS());
        this.iHeader.setCollapsible(SolverCookie.getInstance().isShowCBS());
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SolverCookie.getInstance().setShowCBS((Boolean)event.getValue());
                if (((Boolean)event.getValue()).booleanValue()) {
                    CBSWidget.this.showCBS();
                } else {
                    CBSWidget.this.hideCBS();
                }
            }
        });
        this.removeStyleName("unitime-NotPrintableBottomLine");
    }

    public void onSelection(SuggestionsInterface.SelectedAssignment assignment) {
    }

    public void setValue(Long classId) {
        this.iHeader.clearMessage();
        this.clear();
        this.iCBSComputed = false;
        if (this.iTree == null) {
            this.iTree = new ConflictBasedStatisticsTree(this.iContext.getProperties()){

                protected void onClick(ClickEvent event, SuggestionsInterface.CBSNode node) {
                    if (node.hasSelection()) {
                        CBSWidget.this.onSelection(node.getSelection());
                    } else if (node.hasClassId()) {
                        CBSWidget.this.onSelection(new SuggestionsInterface.SelectedAssignment(node.getClassId()));
                    } else if (node.hasLink()) {
                        CBSWidget.this.openParent(node.getLink());
                    }
                }
            };
            this.iTree.setVisible(false);
        } else {
            this.iTree.setVisible(false);
        }
        this.addHeaderRow((Widget)this.iHeader);
        this.addRow((Widget)this.iTree);
        this.iClassId = classId;
        if (SolverCookie.getInstance().isShowCBS()) {
            this.showCBS();
        } else {
            this.hideCBS();
        }
    }

    public Long getValue() {
        return this.iClassId;
    }

    protected void hideCBS() {
        this.iTree.setVisible(false);
    }

    protected void showCBS() {
        if (!this.iCBSComputed) {
            this.computeCBS();
        } else {
            this.iTree.setVisible(true);
        }
    }

    protected void computeCBS() {
        this.iCBSComputed = true;
        this.iTree.setVisible(false);
        this.iHeader.showLoading();
        RPC.execute(new SuggestionsInterface.ConflictBasedStatisticsRequest(this.iClassId), new AsyncCallback<GwtRpcResponseList<SuggestionsInterface.CBSNode>>(){

            public void onFailure(Throwable caught) {
                CBSWidget.this.iHeader.setErrorMessage(MESSAGES.failedToComputeConflicts(caught.getMessage()));
            }

            public void onSuccess(GwtRpcResponseList<SuggestionsInterface.CBSNode> result) {
                CBSWidget.this.iHeader.clearMessage();
                CBSWidget.this.iTree.setValue(result);
                CBSWidget.this.iTree.setVisible(true);
            }
        });
    }

    public native void openParent(String var1);
}

