/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class SolverLogPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static DateTimeFormat sLogDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormatSolverLog());
    private SolverInterface.SolverType iType;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private ProgressLog iLog;
    private ListBox iLevel;
    private int iLevelRow = -1;
    private Timer iTimer = null;

    public SolverLogPage() {
        this.addStyleName("unitime-SolverPage");
        this.iType = SolverInterface.SolverType.valueOf(Window.Location.getParameter((String)"type").toUpperCase());
        switch (this.iType) {
            case COURSE: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCourseTimetablingSolverLog());
                break;
            }
            case EXAM: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageExaminationTimetablingSolverLog());
                break;
            }
            case INSTRUCTOR: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageInstructorSchedulingSolverLog());
                break;
            }
            case STUDENT: {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageStudentSchedulingSolverLog());
            }
        }
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectSolverLog());
        this.iHeader.addButton("refresh", MESSAGES.opSolverLogRefresh(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SolverLogPage.this.refresh();
            }
        });
        this.addHeaderRow((Widget)this.iHeader);
        this.iLevel = new ListBox();
        for (String level : CONSTANTS.progressLogLevel()) {
            this.iLevel.addItem(level);
        }
        this.iLevel.setSelectedIndex(SolverCookie.getInstance().getLogLevel());
        this.iLevelRow = this.addRow(MESSAGES.propSolverLogLevel(), (Widget)this.iLevel);
        this.getCellFormatter().getElement(this.iLevelRow, 1).getStyle().setWidth(100.0, Style.Unit.PCT);
        this.iLevel.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SolverLogPage.this.refresh();
            }
        });
        this.iFooter = this.iHeader.clonePanel("");
        this.iTimer = new Timer(){

            public void run() {
                if (SolverLogPage.this.iLog != null && SolverLogPage.this.iLog.getLastDate() != null) {
                    int level = SolverCookie.getInstance().getLogLevel();
                    RPC.execute(new SolverInterface.SolverLogPageRequest(SolverLogPage.this.iType, SolverInterface.ProgressLogLevel.values()[level], SolverLogPage.this.iLog.getLastDate()), new AsyncCallback<SolverInterface.SolverLogPageResponse>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(SolverInterface.SolverLogPageResponse result) {
                            if (result.hasLog()) {
                                SolverLogPage.this.iLog.append(result.getLog());
                            }
                        }
                    });
                }
            }
        };
        this.refresh();
    }

    public void refresh() {
        int level = this.iLevel.getSelectedIndex();
        SolverCookie.getInstance().setLogLevel(level);
        this.iHeader.showLoading();
        this.iTimer.cancel();
        RPC.execute(new SolverInterface.SolverLogPageRequest(this.iType, SolverInterface.ProgressLogLevel.values()[level], null), new AsyncCallback<SolverInterface.SolverLogPageResponse>(){

            public void onFailure(Throwable caught) {
                SolverLogPage.this.iHeader.setErrorMessage(caught.getMessage());
            }

            public void onSuccess(SolverInterface.SolverLogPageResponse result) {
                SolverLogPage.this.iHeader.clearMessage();
                for (int row = SolverLogPage.this.getRowCount() - 1; row > SolverLogPage.this.iLevelRow; --row) {
                    SolverLogPage.this.removeRow(row);
                }
                if (result.hasLog()) {
                    SolverLogPage.this.iLog = new ProgressLog(result.getLog());
                    SolverLogPage.this.addRow((Widget)SolverLogPage.this.iLog);
                    SolverLogPage.this.addBottomRow((Widget)SolverLogPage.this.iFooter);
                    SolverLogPage.this.iTimer.scheduleRepeating(1000);
                } else if (result.hasSolutionLogs()) {
                    for (SolverInterface.SolutionLog log : result.getSolutionLogs()) {
                        if (!log.hasLog()) continue;
                        SolverLogPage.this.addHeaderRow(log.getOwner());
                        SolverLogPage.this.addRow((Widget)new ProgressLog(log.getLog()));
                    }
                    SolverLogPage.this.addBottomRow((Widget)SolverLogPage.this.iFooter);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProgressLog
    extends HTML
    implements TakesValue<List<SolverInterface.ProgressMessage>> {
        private List<SolverInterface.ProgressMessage> iLog;

        public ProgressLog(List<SolverInterface.ProgressMessage> log) {
            this.setValue(log);
        }

        public static String htmlTraceLog(SolverInterface.ProgressMessage m) {
            String[] trace = m.getStackTrace();
            if (trace == null || trace.length == 0) {
                return "";
            }
            StringBuffer ret = new StringBuffer("<BR>" + trace[0]);
            for (int i = 1; i < trace.length; ++i) {
                ret.append("<BR>&nbsp;&nbsp;&nbsp;&nbsp;at " + trace[i]);
            }
            return ret.toString();
        }

        public static String toString(SolverInterface.ProgressMessage m) {
            switch (m.getLevel()) {
                case TRACE: {
                    return sLogDateFormat.format(m.getDate()) + " &nbsp;&nbsp;&nbsp;&nbsp;-- " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case DEBUG: {
                    return sLogDateFormat.format(m.getDate()) + " &nbsp;&nbsp;-- " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case PROGRESS: 
                case INFO: {
                    return sLogDateFormat.format(m.getDate()) + " " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case STAGE: {
                    return "<br>" + sLogDateFormat.format(m.getDate()) + " <span style='font-weight:bold;'>" + m.getMessage() + "</span>" + ProgressLog.htmlTraceLog(m);
                }
                case WARN: {
                    return sLogDateFormat.format(m.getDate()) + " <span style='color:orange;font-weight:bold;'>" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ":</span> " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case ERROR: {
                    return sLogDateFormat.format(m.getDate()) + " <span style='color:red;font-weight:bold;'>" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ":</span> " + m.getMessage() + ProgressLog.htmlTraceLog(m);
                }
                case FATAL: {
                    return sLogDateFormat.format(m.getDate()) + " <span style='color:red;font-weight:bold;'>&gt;&gt;&gt;" + CONSTANTS.progressLogLevel()[m.getLevel().ordinal()].toUpperCase() + ": " + m.getMessage() + " &lt;&lt;&lt;</span>" + ProgressLog.htmlTraceLog(m);
                }
            }
            return sLogDateFormat.format(m.getDate()) + " " + m.getMessage() + ProgressLog.htmlTraceLog(m);
        }

        public void setValue(List<SolverInterface.ProgressMessage> value) {
            this.iLog = value;
            StringBuffer s = new StringBuffer();
            if (this.iLog != null) {
                for (SolverInterface.ProgressMessage m : this.iLog) {
                    if (s.length() > 0) {
                        s.append("<br>");
                    }
                    s.append(ProgressLog.toString(m));
                }
            }
            this.setHTML(s.toString());
        }

        public List<SolverInterface.ProgressMessage> getValue() {
            return this.iLog;
        }

        public Date getLastDate() {
            if (this.iLog == null || this.iLog.isEmpty()) {
                return null;
            }
            return this.iLog.get(this.iLog.size() - 1).getDate();
        }

        public void append(List<SolverInterface.ProgressMessage> log) {
            StringBuffer s = new StringBuffer(this.getHTML());
            for (SolverInterface.ProgressMessage m : log) {
                this.iLog.add(m);
                if (s.length() > 0) {
                    s.append("<br>");
                }
                s.append(ProgressLog.toString(m));
            }
            this.setHTML(s.toString());
        }
    }
}

