/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.DataTable;
import org.unitime.timetable.gwt.client.solver.PreferenceLegend;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionReportsPage
extends P {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);

    public SolutionReportsPage() {
        super("unitime-SolutionReportsPage");
        SolutionReportsPage.createTriggers();
        this.init(null);
    }

    protected void init(final AsyncCallback<Boolean> callback) {
        this.clear();
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(new CourseTimetablingSolverInterface.SolverReportsRequest(), new AsyncCallback<CourseTimetablingSolverInterface.SolverReportsResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(CourseTimetablingSolverInterface.SolverReportsResponse result) {
                LoadingWidget.hideLoading();
                SolutionReportsPage.this.populate(result);
                if (callback != null) {
                    callback.onSuccess((Object)result.hasTables());
                }
            }
        });
    }

    public static native void createTriggers();

    public static void __search() {
        final int left = Window.getScrollLeft();
        final int top = Window.getScrollTop();
        SolutionReportsPage page = (SolutionReportsPage)RootPanel.get((String)"UniTimeGWT:Body").getWidget(0);
        page.init(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    Window.scrollTo((int)left, (int)top);
                }
            }
        });
    }

    protected void print(final TableInterface data) {
        final DataTable table = new DataTable(data);
        com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
        com.google.gwt.user.client.Element tableElement = table.getElement();
        com.google.gwt.user.client.Element thead = DOM.createTHead();
        tableElement.insertFirst((Node)thead);
        headerRow.getParentElement().removeChild((Node)headerRow);
        thead.appendChild((Node)headerRow);
        ToolBox.Page page = new ToolBox.Page(){

            public String getName() {
                return data.getName();
            }

            public String getUser() {
                return "";
            }

            public String getSession() {
                return "";
            }

            public Element getBody() {
                return table.getElement();
            }
        };
        ToolBox.print(page);
    }

    protected void populate(CourseTimetablingSolverInterface.SolverReportsResponse response) {
        this.clear();
        RootPanel cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages");
        if (cpm != null) {
            cpm.clear();
            if (response.hasPageMessages()) {
                for (final SolverInterface.PageMessage pm : response.getPageMessages()) {
                    P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pm.getMessage());
                    if (pm.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pm.hasUrl()) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
        if (response.hasTables()) {
            for (final TableInterface data : response.getTables()) {
                SimpleForm form = new SimpleForm();
                form.removeStyleName("unitime-NotPrintableBottomLine");
                form.addStyleName("single-report");
                UniTimeHeaderPanel header = new UniTimeHeaderPanel(data.getName());
                header.addButton("print", MESSAGES.buttonPrint(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SolutionReportsPage.this.print(data);
                    }
                });
                form.addHeaderRow((Widget)header);
                final DataTable table = new DataTable(data);
                header.addButton("exportCSV", MESSAGES.buttonExportCSV(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SolutionReportsPage.this.exportData("csv", data.getTableId(), table.getValue());
                    }
                });
                header.addButton("exportPDF", MESSAGES.buttonExportPDF(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SolutionReportsPage.this.exportData("pdf", data.getTableId(), table.getValue());
                    }
                });
                form.addRow((Widget)table);
                if (data.hasErrorMessage()) {
                    header.setErrorMessage(data.getErrorMessage());
                }
                if (data.isShowPrefLegend()) {
                    form.addRow((Widget)new PreferenceLegend(response.getPreferences()));
                }
                if (data.hasColumnDescriptions()) {
                    for (TableInterface.TableHeaderIterface h : data.getHeader()) {
                        if (!h.hasDescription()) continue;
                        form.addRow(h.getName(), (Widget)new HTML(h.getDescription()));
                    }
                }
                this.add((Widget)form);
            }
        }
    }

    public void exportData(String format, String tableId, Integer sort) {
        String query = "output=solution-reports." + format + "&sort=" + (sort == null ? 0 : sort) + "&table=" + tableId;
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }
}

