/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFilter
extends SimpleForm
implements HasValue<FilterInterface> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private FilterInterface iFilter;
    private int iFilterHeaderRow = -1;
    private int iFilterLastRow = -1;
    private List<Integer> iCollapsibleRows = new ArrayList<Integer>();
    private Map<String, Widget> iWidgets = new HashMap<String, Widget>();

    public PageFilter() {
        this.addStyleName("unitime-PageFilter");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iHeader.setCollapsible(true);
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                Iterator iterator = PageFilter.this.iCollapsibleRows.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    PageFilter.this.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                }
            }
        });
        this.iFilterLastRow = this.iFilterHeaderRow = this.addHeaderRow((Widget)this.iHeader);
        this.iFooter = this.iHeader.clonePanel(null);
    }

    public UniTimeHeaderPanel getHeader() {
        return this.iHeader;
    }

    public UniTimeHeaderPanel getFooter() {
        return this.iFooter;
    }

    protected Widget getWidget(final FilterInterface.FilterParameterInterface param) {
        if (param.hasOptions()) {
            final ListBox list = new ListBox();
            list.setMultipleSelect(param.isMultiSelect());
            if (!param.isMultiSelect()) {
                list.addItem(MESSAGES.itemSelect());
            }
            for (FilterInterface.ListItem item : param.getOptions()) {
                list.addItem(item.getText(), item.getValue());
                if (param.isMultiSelect()) {
                    list.setItemSelected(list.getItemCount() - 1, param.isDefaultItem(item));
                    continue;
                }
                if (!param.isDefaultItem(item)) continue;
                list.setSelectedIndex(list.getItemCount() - 1);
            }
            list.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (param.isMultiSelect()) {
                        String value = "";
                        for (int i = 0; i < list.getItemCount(); ++i) {
                            if (!list.isItemSelected(i)) continue;
                            value = value + (value.isEmpty() ? "" : ",") + list.getValue(i);
                        }
                        param.setValue(value);
                    } else if (list.getSelectedIndex() <= 0) {
                        param.setValue(null);
                    } else {
                        param.setValue(list.getValue(list.getSelectedIndex()));
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return list;
        }
        if ("boolean".equalsIgnoreCase(param.getType())) {
            CheckBox ch = new CheckBox();
            ch.setValue(Boolean.valueOf("1".equalsIgnoreCase(param.getDefaultValue())));
            ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((Boolean)event.getValue() != false ? "1" : "0");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return ch;
        }
        if ("file".equalsIgnoreCase(param.getType())) {
            UniTimeFileUpload upload = new UniTimeFileUpload();
            upload.reset();
            upload.addValueChangeHandler(new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return upload;
        }
        if ("textarea".equalsIgnoreCase(param.getType())) {
            TextArea textarea = new TextArea();
            textarea.setStyleName("unitime-TextArea");
            textarea.setVisibleLines(5);
            textarea.setCharacterWidth(80);
            if (param.hasDefaultValue()) {
                textarea.setText(param.getDefaultValue());
            }
            textarea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return textarea;
        }
        if ("integer".equalsIgnoreCase(param.getType()) || "int".equalsIgnoreCase(param.getType()) || "long".equalsIgnoreCase(param.getType()) || "short".equalsIgnoreCase(param.getType()) || "byte".equalsIgnoreCase(param.getType())) {
            NumberBox text = new NumberBox();
            text.setDecimal(false);
            text.setNegative(true);
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("number".equalsIgnoreCase(param.getType()) || "float".equalsIgnoreCase(param.getType()) || "double".equalsIgnoreCase(param.getType())) {
            NumberBox text = new NumberBox();
            text.setDecimal(true);
            text.setNegative(true);
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("date".equalsIgnoreCase(param.getType())) {
            SingleDateSelector text = new SingleDateSelector();
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            final DateTimeFormat format = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
            text.addValueChangeHandler(new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue(format.format((Date)event.getValue()));
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        TextBox text = new TextBox();
        text.setStyleName("unitime-TextBox");
        text.setWidth("400px");
        if (param.hasDefaultValue()) {
            text.setText(param.getDefaultValue());
        }
        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() == null) {
                    param.setValue(null);
                } else {
                    param.setValue((String)event.getValue());
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
            }
        });
        return text;
    }

    public FilterInterface getValue() {
        return this.iFilter;
    }

    public void setValue(FilterInterface filter) {
        this.setValue(filter, true);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<FilterInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public void setValue(FilterInterface filter, boolean fireEvents) {
        this.iFilter = filter;
        this.iWidgets.clear();
        for (int row = this.getRowCount() - 1; row > this.iFilterHeaderRow; --row) {
            this.removeRow(row);
        }
        this.iCollapsibleRows.clear();
        for (FilterInterface.FilterParameterInterface param : filter.getParameters()) {
            int row;
            String value = Window.Location.getParameter((String)param.getName());
            if (value != null) {
                param.setDefaultValue(value);
            }
            Widget w = this.getWidget(param);
            this.iWidgets.put(param.getName(), w);
            if (param.hasSuffix()) {
                P panel = new P("panel");
                panel.add(w);
                Label suffix = new Label(param.getSuffix());
                suffix.addStyleName("suffix");
                panel.add((Widget)suffix);
                row = this.addRow(param.getLabel(), (Widget)panel);
            } else {
                row = this.addRow(param.getLabel(), w);
            }
            if (param.isCollapsible()) {
                this.iCollapsibleRows.add(row);
            }
            this.iFilterLastRow = row;
            if (this.iHeader.isCollapsible() == null || this.iHeader.isCollapsible().booleanValue() || !param.isCollapsible()) continue;
            this.getRowFormatter().setVisible(this.iFilterLastRow, false);
        }
        if (this.iCollapsibleRows.isEmpty()) {
            this.iHeader.setCollapsible(null);
        } else if (this.iHeader.isCollapsible() == null) {
            this.iHeader.setCollapsible(false);
        }
        this.addBottomRow((Widget)this.iFooter);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.iFilter);
        }
    }

    public String getQuery() {
        String query = "";
        for (FilterInterface.FilterParameterInterface param : this.iFilter.getParameters()) {
            String value = param.getValue();
            if (value == null) continue;
            query = query + "&" + param.getName() + "=" + URL.encodeQueryString((String)value);
        }
        return query;
    }

    public void setValue(String name, String value) {
        Widget w = this.iWidgets.get(name);
        FilterInterface.FilterParameterInterface param = this.iFilter.getParameter(name);
        if (param != null) {
            param.setValue(value);
        }
        if (w == null) {
            return;
        }
        if (w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf("1".equals(value)));
        } else if (w instanceof ListBox) {
            ListBox list = (ListBox)w;
            if (param != null && param.isMultiSelect()) {
                for (int i = 0; i < list.getItemCount(); ++i) {
                    boolean selected = false;
                    for (String val : value.split(",")) {
                        if (!val.equalsIgnoreCase(list.getValue(i))) continue;
                        selected = true;
                    }
                    list.setItemSelected(i, selected);
                }
            } else {
                for (int i = 0; i < list.getItemCount(); ++i) {
                    if (!value.equalsIgnoreCase(list.getValue(i))) continue;
                    list.setSelectedIndex(i);
                    break;
                }
            }
        } else if (w instanceof HasText) {
            ((HasText)w).setText(value);
        }
    }

    public void setQuery(String query, boolean fireEvents) {
        if (query != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String pair : query.split("\\&")) {
                int idx = pair.indexOf(61);
                if (idx < 0) continue;
                params.put(pair.substring(0, idx), URL.decodeQueryString((String)pair.substring(idx + 1)));
            }
            for (FilterInterface.FilterParameterInterface param : this.iFilter.getParameters()) {
                String value = (String)params.get(param.getName());
                if (value != null) {
                    this.setValue(param.getName(), value);
                    continue;
                }
                if (param.getValue() == null || param.getDefaultValue() == null) continue;
                this.setValue(param.getName(), param.getDefaultValue());
            }
        }
    }
}

