/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeGrid
extends Composite {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private P iContainer;
    private P iPanel;
    private P iGrid;
    private P iHeader;
    private P iDock;
    private P iTimes;
    private P[] iSeparators = new P[7];
    private P iWorkingHours;
    private ScrollPanel iScrollPanel;
    private ImageLink iCalendar = null;
    private P[][] iTimeIntervals = new P[24][4];
    private ArrayList<ArrayList<Meeting>> iMeetings = new ArrayList();
    private ArrayList<Meeting>[][] iMeetingTable = new ArrayList[7][288];
    private int iCellWidth = 150;
    private int iNrDays = 5;
    private int iStart = 0;
    private int iEnd = 24;
    private boolean iPrint = false;
    private ColorProvider iColor = null;
    private ArrayList<MeetingClickHandler> iMeetingClickHandlers = new ArrayList();
    private ArrayList<PinClickHandler> iPinClickHandlers = new ArrayList();
    private ArrayList<ClassAssignmentInterface.ClassAssignment> iClasses = new ArrayList();
    private ArrayList<BusyPanel> iBusy = new ArrayList();

    public TimeGrid() {
        this(new ColorProvider());
    }

    public TimeGrid(ColorProvider color) {
        this(color, 5, Math.min(900, Window.getClientWidth() - 60), false, 0, 24);
    }

    public TimeGrid(ColorProvider color, int nrDays, int width, boolean print, int start, int end) {
        int i;
        this.iColor = color;
        this.iNrDays = nrDays;
        this.iCellWidth = width / this.iNrDays;
        this.iStart = start;
        this.iEnd = end;
        this.iPrint = print;
        this.iContainer = new P("unitime-TimeGrid");
        this.iContainer.setSize(40 + this.iNrDays * this.iCellWidth, this.iPrint ? (double)(25 + 50 * (this.iEnd - this.iStart)) : 575.0);
        this.iHeader = new P("calendar-header");
        this.iHeader.setWidth(this.iNrDays * this.iCellWidth);
        this.iDock = new P("calendar-dock");
        this.iDock.setHeight(50 * (this.iEnd - this.iStart) + 5);
        this.iPanel = new P("calendar-panel");
        this.iPanel.setSize(this.iNrDays * this.iCellWidth + 5, 50 * (this.iEnd - this.iStart));
        this.iTimes = new P("calendar-times");
        this.iTimes.setHeight(50 * (this.iEnd - this.iStart));
        if (CONSTANTS.allowCalendarExport() && !this.iPrint) {
            this.iCalendar = new ImageLink();
            this.iCalendar.setImage(new Image(RESOURCES.calendar()));
            this.iCalendar.setTarget(null);
            this.iCalendar.setTitle(MESSAGES.exportICalendar());
            this.iCalendar.addStyleName("calendar");
            this.iContainer.add(this.iCalendar);
        }
        for (i = 0; i < this.iNrDays; ++i) {
            P sp = new P("header-time-interval");
            sp.setWidth(this.iCellWidth);
            sp.setText(CONSTANTS.longDays()[i]);
            this.iHeader.add((Widget)sp, i * this.iCellWidth, 0);
        }
        this.iGrid = new P("calendar-grid");
        this.iWorkingHours = new P("working-hours");
        this.iWorkingHours.setSize(this.iCellWidth * 5, 500.0);
        this.iGrid.add((Widget)this.iWorkingHours, 0, 375 - 50 * this.iStart);
        for (i = this.iStart; i < this.iEnd; ++i) {
            this.iTimeIntervals[i][0] = new P("major-time-interval");
            this.iGrid.add((Widget)this.iTimeIntervals[i][0], 0, 50 * (i - this.iStart));
            this.iTimeIntervals[i][2] = new P("dummy-time-interval");
            this.iTimeIntervals[i][2].setText(CONSTANTS.useAmPm() ? (i == 0 ? "12am" : (i <= 11 ? i + "am" : (i == 12 ? "12pm" : i - 12 + "pm"))) : String.valueOf(i));
            this.iTimes.add((Widget)this.iTimeIntervals[i][2], 0, 50 * (i - this.iStart));
            this.iTimeIntervals[i][1] = new P("minor-time-interval");
            this.iGrid.add((Widget)this.iTimeIntervals[i][1], 0, 50 * (i - this.iStart) + 25);
            this.iTimeIntervals[i][3] = new P("dummy-time-interval");
            this.iTimes.add((Widget)this.iTimeIntervals[i][3], 0, 50 * (i - this.iStart) + 25);
        }
        for (int day = 0; day < this.iNrDays; ++day) {
            this.iSeparators[day] = new P("day-separator");
            this.iGrid.add((Widget)this.iSeparators[day], this.iCellWidth * day, 0);
        }
        P lastSeparator = new P("day-separator");
        lastSeparator.getElement().getStyle().setRight(0.0, Style.Unit.PX);
        lastSeparator.getElement().getStyle().setTop(0.0, Style.Unit.PX);
        lastSeparator.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        this.iGrid.add((Widget)lastSeparator);
        this.iPanel.add((Widget)this.iGrid, 0, 0);
        this.iDock.add((Widget)this.iTimes, 0, 0);
        this.iDock.add((Widget)this.iPanel, 30, 0);
        this.iContainer.add((Widget)this.iHeader, 30, 0);
        if (!this.iPrint) {
            this.iScrollPanel = new ScrollPanel((Widget)this.iDock);
            this.iScrollPanel.setStyleName("calendar-scroll");
            this.iContainer.add((Widget)this.iScrollPanel, 0, 20);
        } else {
            this.iContainer.add((Widget)this.iDock, 0, 20);
        }
        this.initWidget((Widget)this.iContainer);
    }

    public void addFreeTime(CourseRequestInterface.FreeTime ft) {
        for (int day : ft.getDays()) {
            this.addBusy(CONSTANTS.freePrefix() + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm()), day, ft.getStart(), ft.getLength());
        }
    }

    private void addBusy(String text, int day, int start, int length) {
        this.iBusy.add(new BusyPanel(text, day, start, length));
    }

    public void setCalendarUrl(String url) {
        if (this.iCalendar != null) {
            this.iCalendar.setUrl(url);
        }
    }

    public Widget getPrintWidget(int width) {
        int firstHour = this.firstSlot() / 12;
        int lastHour = 1 + this.lastSlot() / 12;
        TimeGrid tg = new TimeGrid(this.iColor, this.iNrDays, width, true, firstHour < 7 ? firstHour : 7, lastHour > 18 ? lastHour : 18);
        int i = 0;
        for (ClassAssignmentInterface.ClassAssignment c : this.iClasses) {
            for (Meeting m : tg.addClass(c, i++)) {
                m.hidePin();
                m.setDummy();
                m.addStyleName("meeting-selected-noshadow");
            }
        }
        for (BusyPanel busy : this.iBusy) {
            tg.addBusy(busy.getTitle(), busy.getDay(), busy.getStart(), busy.getLength());
        }
        return tg;
    }

    public void shrink(int days, int start, int end) {
        int i;
        int cellWidth = Math.min(900, Window.getClientWidth() - 60) / days;
        if (this.iNrDays == days && this.iStart == start && this.iEnd == end && this.iCellWidth == cellWidth) {
            return;
        }
        this.iNrDays = days;
        this.iStart = start;
        this.iEnd = end;
        this.iCellWidth = cellWidth;
        this.iDock.setHeight(50 * (this.iEnd - this.iStart) + 5);
        this.iContainer.setSize(40 + this.iNrDays * this.iCellWidth, this.iPrint ? (double)(25 + 50 * (this.iEnd - this.iStart)) : 575.0);
        this.iHeader.setWidth(this.iNrDays * this.iCellWidth);
        this.iPanel.setSize(this.iNrDays * this.iCellWidth + 5, 50 * (this.iEnd - this.iStart));
        this.iTimes.setHeight(50 * (this.iEnd - this.iStart));
        this.iWorkingHours.getElement().getStyle().setTop((double)(375 - 50 * this.iStart), Style.Unit.PX);
        this.iWorkingHours.setWidth(this.iCellWidth * 5);
        for (int day = 0; day < 7; ++day) {
            if (day < days) {
                if (this.iSeparators[day] == null) {
                    this.iSeparators[day] = new P("day-separator");
                    this.iGrid.add((Widget)this.iSeparators[day], this.iCellWidth * day, 0);
                    continue;
                }
                this.iSeparators[day].getElement().getStyle().setLeft((double)(this.iCellWidth * day), Style.Unit.PX);
                this.iSeparators[day].setVisible(true);
                continue;
            }
            if (this.iSeparators[day] == null) continue;
            this.iSeparators[day].setVisible(false);
        }
        for (i = 0; i < 24; ++i) {
            int j;
            if (i < start || i >= end) {
                for (j = 0; j < 4; ++j) {
                    if (this.iTimeIntervals[i][j] == null) continue;
                    this.iTimeIntervals[i][j].setVisible(false);
                }
                continue;
            }
            for (j = 0; j < 4; ++j) {
                if (this.iTimeIntervals[i][j] == null) continue;
                this.iTimeIntervals[i][j].getElement().getStyle().setTop((double)(50 * (i - this.iStart) + (j == 1 || j == 3 ? 25 : 0)), Style.Unit.PX);
                this.iTimeIntervals[i][j].setVisible(true);
            }
        }
        this.iHeader.clear();
        for (i = 0; i < this.iNrDays; ++i) {
            P sp = new P("header-time-interval");
            sp.setWidth(this.iCellWidth);
            sp.setText(CONSTANTS.longDays()[i]);
            this.iHeader.add((Widget)sp, i * this.iCellWidth, 0);
        }
        for (ArrayList<Meeting> meetings : this.iMeetings) {
            for (Meeting meeting : meetings) {
                meeting.move();
            }
        }
        for (BusyPanel busy : this.iBusy) {
            busy.move();
        }
    }

    public int firstSlot() {
        for (int slot = 0; slot < 288; ++slot) {
            for (int day = 0; day < 7; ++day) {
                if (this.iMeetingTable[day][slot] == null || this.iMeetingTable[day][slot].isEmpty()) continue;
                return slot;
            }
        }
        return 289;
    }

    public int lastSlot() {
        for (int slot = 287; slot >= 0; --slot) {
            for (int day = 0; day < 7; ++day) {
                if (this.iMeetingTable[day][slot] == null || this.iMeetingTable[day][slot].isEmpty()) continue;
                return slot;
            }
        }
        return 0;
    }

    public void shrink() {
        int lastHour;
        boolean hasSat = false;
        boolean hasSun = false;
        for (int slot = 0; slot < 288; ++slot) {
            if (this.iMeetingTable[5][slot] != null && !this.iMeetingTable[5][slot].isEmpty()) {
                hasSat = true;
            }
            if (this.iMeetingTable[6][slot] == null || this.iMeetingTable[6][slot].isEmpty()) continue;
            hasSun = true;
        }
        for (BusyPanel busy : this.iBusy) {
            if (busy.getDay() == 5) {
                hasSat = true;
            }
            if (busy.getDay() != 6) continue;
            hasSun = true;
        }
        int firstHour = this.firstSlot() / 12;
        if (firstHour > 7) {
            firstHour = 7;
        }
        if ((lastHour = 1 + this.lastSlot() / 12) < 18) {
            lastHour = 18;
        }
        if (!hasSat && !hasSun) {
            this.shrink(5, firstHour, lastHour);
        } else if (!hasSun) {
            this.shrink(6, firstHour, lastHour);
        } else {
            this.shrink(7, firstHour, lastHour);
        }
    }

    public int getWidth() {
        return this.iNrDays * this.iCellWidth + 40;
    }

    public int getHeight() {
        return this.iPrint ? 25 + 50 * (this.iEnd - this.iStart) : 575;
    }

    public ColorProvider getColorProvider() {
        return this.iColor;
    }

    public void scrollDown() {
        if (this.iStart < 7) {
            final int pos = (7 - this.iStart) * 50;
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    if (TimeGrid.this.iScrollPanel != null) {
                        TimeGrid.this.iScrollPanel.setVerticalScrollPosition(pos);
                    }
                }
            });
        }
    }

    public void clear(boolean clearColors) {
        for (ArrayList<Meeting> meetings : this.iMeetings) {
            for (Meeting meeting : meetings) {
                this.iPanel.remove((Widget)meeting);
            }
        }
        this.iMeetings.clear();
        for (int i = 0; i < this.iMeetingTable.length; ++i) {
            for (int j = 0; j < this.iMeetingTable[i].length; ++j) {
                if (this.iMeetingTable[i][j] == null) continue;
                this.iMeetingTable[i][j].clear();
            }
        }
        this.iClasses.clear();
        for (BusyPanel busy : this.iBusy) {
            busy.remove();
        }
        this.iBusy.clear();
        if (clearColors) {
            this.iColor.clear();
        }
    }

    protected Meeting addMeeting(int index, int day, int startSlot, int length, String name, ArrayList<String> body, String note, String title, String color, boolean pinned, ArrayList<Meeting> meetings) {
        int col = -1;
        for (int i = 0; i < length; ++i) {
            if (this.iMeetingTable[day][startSlot + i] == null) continue;
            for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                if (m.getColumn() <= col) continue;
                col = m.getColumn();
            }
        }
        int cols = ++col + 1;
        if (col > 0) {
            int i;
            boolean[] used = new boolean[cols - 1];
            for (i = 0; i < cols - 1; ++i) {
                used[i] = false;
            }
            for (i = 0; i < length; ++i) {
                if (this.iMeetingTable[day][startSlot + i] == null) continue;
                for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                    used[m.getColumn()] = true;
                }
            }
            for (i = 0; i < cols - 1; ++i) {
                if (used[i]) continue;
                col = i;
                --cols;
                break;
            }
        }
        Meeting meeting = new Meeting(index, name, body, note, day, startSlot, length, col, cols, pinned, meetings);
        meeting.addStyleName(color);
        meeting.setTitle(title);
        this.iPanel.add((Widget)meeting);
        for (int i = 0; i < length; ++i) {
            if (this.iMeetingTable[day][startSlot + i] == null) {
                this.iMeetingTable[day][startSlot + i] = new ArrayList();
            }
            for (Meeting m : this.iMeetingTable[day][startSlot + i]) {
                m.setNrColumns(cols);
            }
            this.iMeetingTable[day][startSlot + i].add(meeting);
        }
        return meeting;
    }

    public ArrayList<Meeting> getMeetings(int index) {
        for (ArrayList<Meeting> meetings : this.iMeetings) {
            for (Meeting meeting : meetings) {
                if (meeting.getIndex() != index) continue;
                return meetings;
            }
        }
        return null;
    }

    public ArrayList<Meeting> addClass(ClassAssignmentInterface.ClassAssignment row, int index) {
        if (!row.isAssigned()) {
            return null;
        }
        this.iClasses.add(row);
        String name = row.isFreeTime() ? MESSAGES.freeTimeCourse() + " " + MESSAGES.freeTimeSubject() : row.getSubject() + " " + row.getCourseNbr() + " " + row.getSubpart();
        String longName = name + (row.isFreeTime() ? "" : " " + row.getSection());
        String time = row.getDaysString(CONSTANTS.shortDays()) + " " + row.getStartString(CONSTANTS.useAmPm()) + " - " + row.getEndString(CONSTANTS.useAmPm());
        ArrayList<String> notes = new ArrayList<String>();
        ArrayList<String> notesNoHtml = new ArrayList<String>();
        if (row.hasTitle() && CONSTANTS.showCourseTitle()) {
            notes.add(row.getTitle());
            notesNoHtml.add(row.getTitle());
        }
        if (row.hasRoom()) {
            notes.add(row.getRooms(", "));
            notesNoHtml.add(row.getRooms(", "));
        }
        String color = this.iColor.getColor(row);
        if (row.hasInstructors()) {
            if (!this.iPrint) {
                String instructors = "";
                for (int i = 0; i < row.getInstructors().size(); ++i) {
                    String email;
                    String string = email = row.hasInstructorEmails() && i < row.getInstructorEmails().size() ? row.getInstructorEmails().get(i) : null;
                    if (email != null && !email.isEmpty()) {
                        ImageLink il = new ImageLink(new Image(RESOURCES.email()), "mailto:" + email);
                        il.setTitle(MESSAGES.sendEmail(row.getInstructors().get(i)));
                        il.setStyleName("A.unitime-SimpleLink");
                        il.getElement().getStyle().setMarginRight(1.0, Style.Unit.PX);
                        instructors = instructors + il.getElement().getString() + row.getInstructors().get(i) + (i + 1 < row.getInstructors().size() ? ", " : "");
                        continue;
                    }
                    instructors = instructors + row.getInstructors().get(i) + (i + 1 < row.getInstructors().size() ? ", " : "");
                }
                notes.add(instructors);
                notesNoHtml.add(row.getInstructors(", "));
            } else {
                notes.add(row.getInstructors(", "));
                notesNoHtml.add(row.getInstructors(", "));
            }
        }
        if (row.hasDatePattern()) {
            notes.add(row.getDatePattern());
            notesNoHtml.add(row.getDatePattern());
        }
        String note = "";
        for (String n : notesNoHtml) {
            if (n == null || n.isEmpty()) continue;
            if (!note.isEmpty()) {
                note = note + ", ";
            }
            note = note + n;
        }
        String title = longName + " (" + time + ", " + note + ")";
        if (note.isEmpty()) {
            title = longName + " (" + time + ")";
            note = time;
        }
        ArrayList<Meeting> meetings = new ArrayList<Meeting>();
        Iterator<Object> iterator = row.getDays().iterator();
        while (iterator.hasNext()) {
            int day = iterator.next();
            meetings.add(this.addMeeting(index, day, row.getStart(), row.getLength(), name, notes, row.getNote(), title, color, row.isPinned(), meetings));
        }
        if (row.isPinned()) {
            for (Meeting m : meetings) {
                m.setPinned(true);
            }
        }
        if (row.hasDistanceConflict()) {
            for (Meeting m : meetings) {
                Image dist = new Image(RESOURCES.distantConflict());
                if (this.iPrint) {
                    dist = new Label(MESSAGES.distanceConflict(row.getBackToBackDistance()));
                    dist.setStyleName("label");
                }
                dist.setTitle(MESSAGES.backToBackDistance(row.getBackToBackRooms(), row.getBackToBackDistance()));
                m.addIcon((Widget)dist);
            }
        }
        if (row.isOfHighDemand() && !this.iPrint) {
            for (Meeting m : meetings) {
                Image highDemand = new Image(RESOURCES.highDemand());
                highDemand.setTitle(MESSAGES.highDemand(row.getExpected(), row.getAvailableLimit()));
                m.addIcon((Widget)highDemand);
            }
        }
        if ((row.isSaved() || row.isTeachingAssignment()) && !this.iPrint) {
            for (Meeting m : meetings) {
                if (row.isTeachingAssignment()) {
                    if (row.isInstructing()) {
                        m.setInstructing(true);
                    }
                    m.hidePin();
                    continue;
                }
                m.setSaved(row.isSaved());
            }
        }
        if (row.isCancelled() && !this.iPrint) {
            for (Meeting m : meetings) {
                Image cancelled = new Image(RESOURCES.cancelled());
                cancelled.setTitle(MESSAGES.classCancelled(name));
                m.addIcon((Widget)cancelled);
            }
        }
        this.iMeetings.add(meetings);
        return meetings;
    }

    public void addMeetingClickHandler(MeetingClickHandler h) {
        this.iMeetingClickHandlers.add(h);
    }

    public void addPinClickHandler(PinClickHandler h) {
        this.iPinClickHandlers.add(h);
    }

    public static class ColorProvider {
        private ArrayList<String[]> iColor = new ArrayList();

        public String getColor(ClassAssignmentInterface.ClassAssignment clazz) {
            if (clazz.isFreeTime()) {
                return CONSTANTS.freeTimeColor();
            }
            if (clazz.isTeachingAssignment()) {
                return CONSTANTS.teachingAssignmentColor();
            }
            for (String[] pair : this.iColor) {
                if (!pair[0].equals(clazz.getCourseId().toString())) continue;
                return pair[1];
            }
            String color = CONSTANTS.meetingColors()[this.iColor.size() % CONSTANTS.meetingColors().length];
            this.iColor.add(new String[]{clazz.getCourseId().toString(), color});
            return color;
        }

        public void clear() {
            this.iColor.clear();
        }
    }

    private class BusyPanel
    extends SimplePanel {
        private int iDayOfWeek;
        private int iStartSlot;
        private int iLength;
        private String iText;

        public BusyPanel(String text, int dayOfWeek, int startSlot, int length) {
            this.iText = text;
            this.iDayOfWeek = dayOfWeek;
            this.iStartSlot = startSlot;
            this.iLength = length;
            if (this.iText != null || !this.iText.isEmpty()) {
                this.setTitle(this.iText);
                boolean empty = true;
                for (int i = 0; i < 3; ++i) {
                    if (TimeGrid.this.iMeetingTable[this.iDayOfWeek].length <= this.iStartSlot + i) {
                        empty = false;
                        break;
                    }
                    if (TimeGrid.this.iMeetingTable[this.iDayOfWeek][this.iStartSlot + i] == null || TimeGrid.this.iMeetingTable[this.iDayOfWeek][this.iStartSlot + i].isEmpty()) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    HTML widget = new HTML(text, false);
                    widget.setStyleName("text");
                    this.setWidget((Widget)widget);
                }
            }
            this.setStyleName("busy");
            this.getElement().getStyle().setWidth((double)(TimeGrid.this.iCellWidth + (TimeGrid.this.iPrint ? 3 : (this.iDayOfWeek + 1 < TimeGrid.this.iNrDays ? 3 : 0))), Style.Unit.PX);
            this.getElement().getStyle().setHeight((double)(125 * this.iLength / 30), Style.Unit.PX);
            TimeGrid.this.iGrid.insert((Widget)this, TimeGrid.this.iCellWidth * this.iDayOfWeek, 125 * this.iStartSlot / 30 - 50 * TimeGrid.this.iStart, 1);
        }

        public void move() {
            this.getElement().getStyle().setWidth((double)(TimeGrid.this.iCellWidth + (TimeGrid.this.iPrint ? 3 : (this.iDayOfWeek + 1 < TimeGrid.this.iNrDays ? 3 : 0))), Style.Unit.PX);
            this.getElement().getStyle().setLeft((double)(TimeGrid.this.iCellWidth * this.iDayOfWeek), Style.Unit.PX);
            this.getElement().getStyle().setTop((double)(125 * this.iStartSlot / 30 - 50 * TimeGrid.this.iStart), Style.Unit.PX);
        }

        public int getDay() {
            return this.iDayOfWeek;
        }

        public int getStart() {
            return this.iStartSlot;
        }

        public int getLength() {
            return this.iLength;
        }

        public void remove() {
            TimeGrid.this.iGrid.remove((Widget)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Meeting
    extends AbsolutePanel {
        private String iName;
        private int iIndex;
        private int iColumn;
        private int iDay;
        private int iNrColumns;
        private int iLeft;
        private int iWidth;
        private int iStartSlot;
        private boolean iPinned = false;
        private Image iPin;
        private ArrayList<Meeting> iMeetings;
        private HorizontalPanel iHeaderPanel;
        private Image iSaved;
        private boolean iDummy = false;

        private Meeting(int index, String name, ArrayList<String> body, String note, int day, int start, int length, int column, int nrColumns, boolean pinned, ArrayList<Meeting> meetings) {
            this.iMeetings = meetings;
            this.iIndex = index;
            this.iDay = day;
            this.iStartSlot = start;
            this.iColumn = column;
            this.iNrColumns = nrColumns;
            this.iName = name;
            this.iHeaderPanel = new HorizontalPanel();
            this.iHeaderPanel.setStylePrimaryName("header");
            this.iPinned = pinned;
            this.iPin = new Image(pinned ? RESOURCES.locked() : RESOURCES.unlocked());
            this.iPin.setTitle(pinned ? MESSAGES.hintLocked() : MESSAGES.hintUnlocked());
            this.iHeaderPanel.add((Widget)this.iPin);
            Label nameLabel = new Label(name);
            nameLabel.setStyleName("label");
            this.iHeaderPanel.add((Widget)nameLabel);
            this.iHeaderPanel.setCellHorizontalAlignment((Widget)this.iPin, HasHorizontalAlignment.ALIGN_CENTER);
            this.iSaved = new Image(RESOURCES.saved());
            this.iSaved.setVisible(false);
            this.iSaved.setTitle(MESSAGES.saved(name));
            this.iHeaderPanel.add((Widget)this.iSaved);
            this.iPin.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    boolean pinned = !Meeting.this.getPinned();
                    for (Meeting m : Meeting.this.iMeetings) {
                        m.setPinned(pinned);
                    }
                    PinClickEvent e = new PinClickEvent(Meeting.this);
                    for (PinClickHandler h : TimeGrid.this.iPinClickHandlers) {
                        h.onPinClick(e);
                    }
                    event.stopPropagation();
                }
            });
            SimplePanel mbot = new SimplePanel();
            mbot.setStylePrimaryName("footer");
            String notes = "";
            String delim = "<br>";
            if (body.size() + (note == null || note.isEmpty() ? 0 : 1) > 2 && length <= 14) {
                delim = ", ";
            }
            if (body.size() + (note == null || note.isEmpty() ? 0 : 1) > 3 && length <= 20) {
                delim = ", ";
            }
            for (String n : body) {
                if (n == null || n.isEmpty()) continue;
                if (notes.length() > 0) {
                    notes = notes + delim;
                }
                notes = notes + "<span  style=\"white-space: nowrap\">" + n + "</span>";
            }
            if (note != null && !note.isEmpty()) {
                notes = notes + "<br>" + note;
            }
            mbot.add((Widget)new HTML(notes));
            this.setStylePrimaryName("meeting");
            this.add((Widget)this.iHeaderPanel);
            this.add((Widget)mbot);
            this.iWidth = (TimeGrid.this.iCellWidth - 6) / nrColumns + (column + 1 != nrColumns && nrColumns > 1 ? -3 : 0);
            this.getElement().getStyle().setWidth((double)this.iWidth, Style.Unit.PX);
            this.getElement().getStyle().setHeight((double)(125 * length / 30 - 3), Style.Unit.PX);
            this.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
            this.iLeft = 4 + TimeGrid.this.iCellWidth * day + column * (TimeGrid.this.iCellWidth - 6) / nrColumns;
            this.getElement().getStyle().setLeft((double)this.iLeft, Style.Unit.PX);
            this.getElement().getStyle().setTop((double)(1 + 125 * start / 30 - 50 * TimeGrid.this.iStart), Style.Unit.PX);
            this.sinkEvents(1);
            this.sinkEvents(16);
            this.sinkEvents(64);
            this.sinkEvents(32);
        }

        public void addIcon(Widget image) {
            this.iHeaderPanel.add(image);
        }

        public void setSaved(boolean saved) {
            this.iSaved.setVisible(saved);
        }

        public void setInstructing(boolean instructing) {
            this.iSaved.setResource(RESOURCES.isInstructing());
            this.iSaved.setTitle(MESSAGES.instructing(this.iName));
            this.iSaved.setVisible(instructing);
        }

        public void setPinned(boolean pinned) {
            this.iPinned = pinned;
            this.iPin.setResource(pinned ? RESOURCES.locked() : RESOURCES.unlocked());
            this.iPin.setTitle(pinned ? MESSAGES.hintLocked() : MESSAGES.hintUnlocked());
        }

        public void hidePin() {
            this.iHeaderPanel.remove((Widget)this.iPin);
        }

        public boolean getPinned() {
            return this.iPinned;
        }

        public void onBrowserEvent(Event event) {
            if (this.iDummy) {
                return;
            }
            com.google.gwt.user.client.Element target = DOM.eventGetTarget((Event)event);
            boolean anchor = false;
            while (target != null) {
                String tag = target.getPropertyString("tagName");
                if (tag.equalsIgnoreCase("a")) {
                    anchor = true;
                    break;
                }
                if (tag.equalsIgnoreCase("div")) break;
                target = DOM.getParent((Element)target);
            }
            EventTarget related = event.getRelatedEventTarget();
            switch (DOM.eventGetType((Event)event)) {
                case 1: {
                    this.getElement().getStyle().setWidth((double)this.iWidth, Style.Unit.PX);
                    this.getElement().getStyle().clearZIndex();
                    this.getElement().getStyle().setLeft((double)this.iLeft, Style.Unit.PX);
                    for (Meeting meeting : this.iMeetings) {
                        meeting.removeStyleName("meeting-selected");
                    }
                    if (anchor) break;
                    MeetingClickEvent e = new MeetingClickEvent(this);
                    for (MeetingClickHandler h : TimeGrid.this.iMeetingClickHandlers) {
                        h.onMeetingClick(e);
                    }
                    break;
                }
                case 16: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.getElement().getStyle().setWidth((double)(TimeGrid.this.iCellWidth - 6), Style.Unit.PX);
                    this.getElement().getStyle().setZIndex(1000);
                    this.getElement().getStyle().setLeft((double)(4 + TimeGrid.this.iCellWidth * this.iDay), Style.Unit.PX);
                    for (Meeting meeting : this.iMeetings) {
                        meeting.addStyleName("meeting-selected");
                    }
                    break;
                }
                case 32: {
                    if (related != null && this.getElement().isOrHasChild((Node)((Element)related.cast()))) break;
                    this.getElement().getStyle().setWidth((double)this.iWidth, Style.Unit.PX);
                    this.getElement().getStyle().clearZIndex();
                    this.getElement().getStyle().setLeft((double)this.iLeft, Style.Unit.PX);
                    for (Meeting meeting : this.iMeetings) {
                        meeting.removeStyleName("meeting-selected");
                    }
                    break;
                }
                case 64: {
                    int relativeX = event.getClientX() - this.getElement().getAbsoluteLeft() + this.getElement().getScrollLeft() + this.getElement().getOwnerDocument().getScrollLeft();
                    if (relativeX >= this.iLeft - 6 - this.iDay * TimeGrid.this.iCellWidth && relativeX <= this.iLeft - 2 - this.iDay * TimeGrid.this.iCellWidth + this.iWidth) break;
                    this.getElement().getStyle().setWidth((double)this.iWidth, Style.Unit.PX);
                    this.getElement().getStyle().clearZIndex();
                    this.getElement().getStyle().setLeft((double)this.iLeft, Style.Unit.PX);
                }
            }
            super.onBrowserEvent(event);
        }

        public int getIndex() {
            return this.iIndex;
        }

        public void setNrColumns(int nrColumns) {
            if (nrColumns == this.iNrColumns) {
                return;
            }
            this.iNrColumns = nrColumns;
            this.move();
        }

        public void move() {
            this.iWidth = (TimeGrid.this.iCellWidth - 6) / this.iNrColumns + (this.iColumn + 1 != this.iNrColumns && this.iNrColumns > 1 ? -3 : 0);
            this.iLeft = 4 + TimeGrid.this.iCellWidth * this.iDay + this.iColumn * (TimeGrid.this.iCellWidth - 6) / this.iNrColumns;
            this.getElement().getStyle().setWidth((double)this.iWidth, Style.Unit.PX);
            this.getElement().getStyle().setLeft((double)this.iLeft, Style.Unit.PX);
            this.getElement().getStyle().setTop((double)(1 + 125 * this.iStartSlot / 30 - 50 * TimeGrid.this.iStart), Style.Unit.PX);
        }

        public void setTitle(String title) {
            super.setTitle(title);
        }

        public int getColumn() {
            return this.iColumn;
        }

        public int getDay() {
            return this.iDay;
        }

        public int getNrColumns() {
            return this.iNrColumns;
        }

        public void add(Widget w) {
            super.add(w, (Element)this.getElement());
        }

        public void setDummy() {
            this.iDummy = true;
        }
    }

    public class PinClickEvent {
        private Meeting iMeeting;

        PinClickEvent(Meeting meeting) {
            this.iMeeting = meeting;
        }

        public int getRowIndex() {
            return this.iMeeting.getIndex();
        }

        public boolean isPinChecked() {
            return this.iMeeting.getPinned();
        }
    }

    public static interface PinClickHandler {
        public void onPinClick(PinClickEvent var1);
    }

    public class MeetingClickEvent {
        private Meeting iMeeting;

        MeetingClickEvent(Meeting meeting) {
            this.iMeeting = meeting;
        }

        public int getRowIndex() {
            return this.iMeeting.getIndex();
        }
    }

    public static interface MeetingClickHandler {
        public void onMeetingClick(MeetingClickEvent var1);
    }
}

