/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.pointintimedata;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PointInTimeDataReportsInterface;

public class PointInTimeDataReportsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = null;
    private UniTimeHeaderPanel iHeader = null;
    private UniTimeHeaderPanel iTableHeader = null;
    private UniTimeWidget<ListBox> iReportSelector = null;
    private HTML iDescription = null;
    private List<PointInTimeDataReportsInterface.Report> iReports = new ArrayList<PointInTimeDataReportsInterface.Report>();
    private List<PointInTimeDataReportsInterface.Parameter> iParameters = new ArrayList<PointInTimeDataReportsInterface.Parameter>();
    private UniTimeTable<String[]> iTable = new UniTimeTable();
    private String iFirstField = null;
    private int iLastSort = 0;
    private String iLastHistory = null;

    public PointInTimeDataReportsPage() {
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pagePointInTimeDataReports());
        this.iForm = new SimpleForm(2);
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iHeader.addButton("execute", MESSAGES.buttonExecute(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                PointInTimeDataReportsPage.this.iLastSort = 0;
                PointInTimeDataReportsPage.this.execute();
            }
        });
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                PointInTimeDataReportsInterface.PITDExecuteRpcRequest request = new PointInTimeDataReportsInterface.PITDExecuteRpcRequest();
                String id = ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getValue(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex());
                for (PointInTimeDataReportsInterface.Report q : PointInTimeDataReportsPage.this.iReports) {
                    if (!id.equals(q.getId())) continue;
                    request.setReport(q);
                    break;
                }
                if (request.getReport() == null) {
                    PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
                    return;
                }
                final SimpleForm form = new SimpleForm();
                form.addHeaderRow(request.getReport().getName());
                if (!request.getReport().getDescription().isEmpty()) {
                    form.addRow(MESSAGES.propDescription(), (Widget)new HTML(request.getReport().getDescription()));
                }
                for (int i = 0; i < PointInTimeDataReportsPage.this.iParameters.size(); ++i) {
                    String value;
                    PointInTimeDataReportsInterface.Parameter parameter = (PointInTimeDataReportsInterface.Parameter)PointInTimeDataReportsPage.this.iParameters.get(i);
                    if (!request.getReport().parametersContain(parameter.getType())) continue;
                    if (parameter.isTextField()) {
                        TextBox textBox = (TextBox)((UniTimeWidget)PointInTimeDataReportsPage.this.iForm.getWidget(3 + i, 1)).getWidget();
                        value = textBox.getText();
                        if (value.isEmpty()) {
                            PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                            return;
                        }
                        request.addParameter(parameter.getType(), value);
                        form.addRow(parameter.getName() + ":", (Widget)new Label(value, true));
                        continue;
                    }
                    ListBox list = (ListBox)((UniTimeWidget)PointInTimeDataReportsPage.this.iForm.getWidget(3 + i, 1)).getWidget();
                    value = "";
                    String values = "";
                    boolean allSelected = true;
                    if (list.isMultipleSelect()) {
                        for (int j = 0; j < list.getItemCount(); ++j) {
                            if (list.isItemSelected(j)) {
                                if (!value.isEmpty()) {
                                    value = value + ",";
                                    values = values + ", ";
                                }
                                value = value + list.getValue(j);
                                values = values + list.getItemText(j);
                                continue;
                            }
                            allSelected = false;
                        }
                        if (allSelected) {
                            values = MESSAGES.itemAll();
                        }
                    } else if (list.getSelectedIndex() > 0) {
                        value = list.getValue(list.getSelectedIndex());
                        values = list.getItemText(list.getSelectedIndex());
                    }
                    if (value.isEmpty()) {
                        PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                        return;
                    }
                    request.addParameter(parameter.getType(), value);
                    form.addRow(parameter.getName() + ":", (Widget)new Label(values, true));
                }
                LoadingWidget.getInstance().show(MESSAGES.waitExecuting(request.getReport().getName()));
                RPC.execute(request, new AsyncCallback<PointInTimeDataReportsInterface.Table>(){

                    public void onFailure(Throwable caught) {
                        PointInTimeDataReportsPage.this.iTableHeader.setErrorMessage(caught.getMessage());
                        LoadingWidget.getInstance().hide();
                    }

                    public void onSuccess(PointInTimeDataReportsInterface.Table result) {
                        String name;
                        LoadingWidget.getInstance().hide();
                        if (result == null || result.size() <= 1) {
                            PointInTimeDataReportsPage.this.iTableHeader.setMessage(MESSAGES.errorNoResults());
                            return;
                        }
                        UniTimeTable table = new UniTimeTable();
                        String firstField = null;
                        int nrCols = 0;
                        for (int i = 0; i < result.size(); ++i) {
                            String[] row = result.get(i);
                            ArrayList<HTML> line = new ArrayList<HTML>();
                            if (i == 0) {
                                firstField = row[0];
                                nrCols = row.length;
                                for (String x : row) {
                                    String name2 = x.replace('_', ' ').trim();
                                    UniTimeTableHeader h = new UniTimeTableHeader(name2, 1);
                                    line.add(h);
                                }
                            } else {
                                for (String x : row) {
                                    line.add(new HTML(x == null ? "" : x.replace("\\n", "<br>")));
                                }
                            }
                            table.addRow(i == 0 ? null : row, line);
                        }
                        if (firstField != null && firstField.startsWith("__")) {
                            table.setColumnVisible(0, false);
                        }
                        if (PointInTimeDataReportsPage.this.iLastSort != 0 && Math.abs(PointInTimeDataReportsPage.this.iLastSort) <= nrCols) {
                            table.sort(table.getHeader(Math.abs(PointInTimeDataReportsPage.this.iLastSort) - 1), new Comparator<String[]>(){

                                @Override
                                public int compare(String[] o1, String[] o2) {
                                    return PointInTimeDataReportsPage.compare(o1, o2, Math.abs(PointInTimeDataReportsPage.this.iLastSort) - 1);
                                }
                            }, PointInTimeDataReportsPage.this.iLastSort > 0);
                        }
                        table.getElement().getStyle().setWidth(1040.0, Style.Unit.PX);
                        com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
                        com.google.gwt.user.client.Element tableElement = table.getElement();
                        com.google.gwt.user.client.Element thead = DOM.createTHead();
                        tableElement.insertFirst((Node)thead);
                        headerRow.getParentElement().removeChild((Node)headerRow);
                        thead.appendChild((Node)headerRow);
                        com.google.gwt.user.client.Element div = DOM.createDiv();
                        div.appendChild((Node)form.getElement());
                        div.appendChild((Node)table.getElement());
                        final String pageName = name = MESSAGES.pagePointInTimeDataReports();
                        ToolBox.print(new ToolBox.Page((Element)div){
                            final /* synthetic */ Element val$div;
                            {
                                this.val$div = element;
                            }

                            public String getName() {
                                return pageName;
                            }

                            public String getUser() {
                                return "";
                            }

                            public String getSession() {
                                return "";
                            }

                            public Element getBody() {
                                return this.val$div;
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("export", MESSAGES.buttonExportCSV(), 85, new ClickHandler(){

            public void onClick(ClickEvent event) {
                String id = ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getValue(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex());
                PointInTimeDataReportsInterface.Report query = null;
                for (PointInTimeDataReportsInterface.Report q : PointInTimeDataReportsPage.this.iReports) {
                    if (!id.equals(q.getId())) continue;
                    query = q;
                    break;
                }
                if (query == null) {
                    PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
                    return;
                }
                String params = "";
                for (int i = 0; i < PointInTimeDataReportsPage.this.iParameters.size(); ++i) {
                    String value;
                    PointInTimeDataReportsInterface.Parameter parameter = (PointInTimeDataReportsInterface.Parameter)PointInTimeDataReportsPage.this.iParameters.get(i);
                    if (!query.parametersContain(parameter.getType())) continue;
                    if (parameter.isTextField()) {
                        TextBox textBox = (TextBox)((UniTimeWidget)PointInTimeDataReportsPage.this.iForm.getWidget(3 + i, 1)).getWidget();
                        value = textBox.getText();
                        if (value.isEmpty()) {
                            PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                            return;
                        }
                        if (!params.isEmpty()) {
                            params = params + ":";
                        }
                        params = params + (value == null ? "" : value);
                        continue;
                    }
                    ListBox list = (ListBox)((UniTimeWidget)PointInTimeDataReportsPage.this.iForm.getWidget(3 + i, 1)).getWidget();
                    value = "";
                    boolean allSelected = true;
                    if (list.isMultipleSelect()) {
                        for (int j = 0; j < list.getItemCount(); ++j) {
                            if (list.isItemSelected(j)) {
                                if (!value.isEmpty()) {
                                    value = value + ",";
                                }
                                value = value + list.getValue(j);
                                continue;
                            }
                            allSelected = false;
                        }
                    } else if (list.getSelectedIndex() > 0) {
                        value = list.getValue(list.getSelectedIndex());
                    }
                    if (value.isEmpty()) {
                        PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                        return;
                    }
                    if (!params.isEmpty()) {
                        params = params + ":";
                    }
                    params = params + (list.isMultipleSelect() && allSelected ? "" : value);
                }
                String reportId = ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getValue(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex());
                RPC.execute(EventInterface.EncodeQueryRpcRequest.encode("output=pitd-report.csv&report=" + reportId + "&params=" + params + "&sort=" + PointInTimeDataReportsPage.this.iLastSort), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                    }
                });
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iHeader.setEnabled("execute", false);
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iForm.getColumnFormatter().setWidth(0, "120px");
        this.iForm.getColumnFormatter().setWidth(1, "100%");
        this.iReportSelector = new UniTimeWidget<ListBox>(new ListBox());
        this.iForm.addRow(MESSAGES.propReport(), (Widget)this.iReportSelector);
        this.iReportSelector.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                PointInTimeDataReportsPage.this.iReportSelector.clearHint();
                PointInTimeDataReportsPage.this.iReportSelector.setPrintText(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getItemText(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex()));
                PointInTimeDataReportsPage.this.queryChanged();
            }
        });
        this.iDescription = new HTML("");
        this.iForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
        this.iForm.getCellFormatter().setVerticalAlignment(2, 0, HasVerticalAlignment.ALIGN_TOP);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingReports());
        RPC.execute(new PointInTimeDataReportsInterface.PITDParametersRpcRequest(), new AsyncCallback<PointInTimeDataReportsInterface.PITDParametersInterface>(){

            public void onFailure(Throwable caught) {
                PointInTimeDataReportsPage.this.iHeader.setErrorMessage(caught.getMessage());
                LoadingWidget.getInstance().hide();
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(PointInTimeDataReportsInterface.PITDParametersInterface result) {
                PointInTimeDataReportsPage.this.iParameters = result.getParameters();
                for (int i = 0; i < PointInTimeDataReportsPage.this.iParameters.size(); ++i) {
                    UniTimeWidget<ListBox> u;
                    PointInTimeDataReportsInterface.Parameter parameter = (PointInTimeDataReportsInterface.Parameter)PointInTimeDataReportsPage.this.iParameters.get(i);
                    if (parameter.isTextField()) {
                        TextBox text = new TextBox();
                        if (parameter.getDefaultTextValue() != null) {
                            text.setText(parameter.getDefaultTextValue());
                            text.setValue((Object)parameter.getDefaultTextValue());
                        }
                        u = new UniTimeWidget<TextBox>(text);
                        PointInTimeDataReportsPage.this.iForm.addRow(parameter.getName() + ":", (Widget)u);
                        PointInTimeDataReportsPage.this.iForm.getCellFormatter().setVerticalAlignment(3 + i, 0, HasVerticalAlignment.ALIGN_TOP);
                        PointInTimeDataReportsPage.this.iForm.getRowFormatter().setVisible(3 + i, false);
                        u.setPrintText(text.getValue());
                        text.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                u.clearHint();
                                String entered = ((TextBox)u.getWidget()).getValue();
                                u.setPrintText(entered);
                                PointInTimeDataReportsPage.this.iHeader.clearMessage();
                            }
                        });
                        continue;
                    }
                    ListBox list = new ListBox();
                    list.setMultipleSelect(parameter.isMultiSelect());
                    if (!parameter.isMultiSelect()) {
                        list.addItem(MESSAGES.itemSelect(), "-1");
                    }
                    for (PointInTimeDataReportsInterface.IdValue v : parameter.values()) {
                        list.addItem(v.getText(), v.getValue());
                    }
                    u = new UniTimeWidget<ListBox>(list);
                    PointInTimeDataReportsPage.this.iForm.addRow(parameter.getName() + ":", (Widget)u);
                    PointInTimeDataReportsPage.this.iForm.getCellFormatter().setVerticalAlignment(3 + i, 0, HasVerticalAlignment.ALIGN_TOP);
                    PointInTimeDataReportsPage.this.iForm.getRowFormatter().setVisible(3 + i, false);
                    if (list.isMultipleSelect()) {
                        for (int j = 0; j < list.getItemCount(); ++j) {
                            list.setItemSelected(j, true);
                        }
                        u.setPrintText(MESSAGES.itemAll());
                    } else if (list.getItemCount() == 2) {
                        list.setSelectedIndex(1);
                        u.setPrintText(list.getItemText(1));
                    }
                    list.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent event) {
                            u.clearHint();
                            String selected = "";
                            boolean hasAll = true;
                            for (int i = 0; i < ((ListBox)u.getWidget()).getItemCount(); ++i) {
                                if (((ListBox)u.getWidget()).isItemSelected(i)) {
                                    if (!selected.isEmpty()) {
                                        selected = selected + ",";
                                    }
                                    selected = selected + ((ListBox)u.getWidget()).getItemText(i);
                                    continue;
                                }
                                hasAll = false;
                            }
                            if (hasAll && ((ListBox)u.getWidget()).getItemCount() > 5) {
                                selected = MESSAGES.itemAll();
                            }
                            if (selected.length() > 150) {
                                selected = selected.substring(0, 147) + "...";
                            }
                            u.setPrintText(selected);
                            PointInTimeDataReportsPage.this.iHeader.clearMessage();
                        }
                    });
                }
                PointInTimeDataReportsPage.this.iTableHeader = new UniTimeHeaderPanel(MESSAGES.sectResults());
                PointInTimeDataReportsPage.this.iForm.addHeaderRow((Widget)PointInTimeDataReportsPage.this.iTableHeader);
                PointInTimeDataReportsPage.this.iForm.addRow((Widget)PointInTimeDataReportsPage.this.iTable);
                PointInTimeDataReportsPage.this.iForm.addBottomRow((Widget)PointInTimeDataReportsPage.this.iHeader.clonePanel(""));
                PointInTimeDataReportsPage.this.loadQueries(null, true);
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<String[]>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<String[]> event) {
                if (event.getRow() > 0 && event.getData() != null) {
                    if ("__Class".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "classDetail.do?cid=" + event.getData()[0]);
                    } else if ("__Offering".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?op=view&io=" + event.getData()[0]);
                    } else if ("__Subpart".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "schedulingSubpartDetail.do?ssuid=" + event.getData()[0]);
                    } else if ("__Room".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=rooms&back=1&id=" + event.getData()[0]);
                    } else if ("__Instructor".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructorDetail.do?instructorId=" + event.getData()[0]);
                    } else if ("__Exam".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "examDetail.do?examId=" + event.getData()[0]);
                    } else if ("__Event".equals(PointInTimeDataReportsPage.this.iFirstField)) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=events#event=" + event.getData()[0]);
                    }
                }
            }
        });
        this.initWidget((Widget)this.iForm);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                PointInTimeDataReportsPage.this.reload((String)event.getValue());
            }
        });
    }

    public void loadQueries(final Long select, final boolean reload) {
        if (!LoadingWidget.getInstance().isShowing()) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingReports());
        }
        RPC.execute(new PointInTimeDataReportsInterface.PITDQueriesRpcRequest(), new AsyncCallback<GwtRpcResponseList<PointInTimeDataReportsInterface.Report>>(){

            public void onFailure(Throwable caught) {
                PointInTimeDataReportsPage.this.iHeader.setErrorMessage(caught.getMessage());
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(GwtRpcResponseList<PointInTimeDataReportsInterface.Report> result) {
                String selected;
                String string = selected = select == null ? null : select.toString();
                if (selected == null && ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex() >= 0) {
                    selected = ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getValue(((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).getSelectedIndex());
                }
                ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).clear();
                if (result.isEmpty()) {
                    PointInTimeDataReportsPage.this.iHeader.setErrorMessage(MESSAGES.errorNoReportsAvailable());
                } else {
                    ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).addItem(MESSAGES.itemSelect(), "-1");
                    PointInTimeDataReportsPage.this.iReports = result;
                    for (int i = 0; i < result.size(); ++i) {
                        ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).addItem(((PointInTimeDataReportsInterface.Report)result.get(i)).getName(), ((PointInTimeDataReportsInterface.Report)result.get(i)).getId().toString());
                        if (selected == null || !selected.equals(((PointInTimeDataReportsInterface.Report)result.get(i)).getId().toString())) continue;
                        ((ListBox)PointInTimeDataReportsPage.this.iReportSelector.getWidget()).setSelectedIndex(1 + i);
                    }
                    PointInTimeDataReportsPage.this.queryChanged();
                }
                LoadingWidget.getInstance().hide();
                if (reload) {
                    PointInTimeDataReportsPage.this.reload(History.getToken());
                }
            }
        });
    }

    private void queryChanged() {
        this.iHeader.clearMessage();
        if (this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
            this.iHeader.setEnabled("execute", false);
            this.iDescription.setHTML("");
            for (int i = 0; i < this.iParameters.size(); ++i) {
                this.iForm.getRowFormatter().setVisible(3 + i, false);
            }
        } else {
            this.iHeader.setEnabled("execute", true);
            String id = this.iReportSelector.getWidget().getValue(this.iReportSelector.getWidget().getSelectedIndex());
            for (PointInTimeDataReportsInterface.Report rpt : this.iReports) {
                if (!id.equals(rpt.getId())) continue;
                this.iDescription.setHTML(rpt.getDescription());
                for (int i = 0; i < this.iParameters.size(); ++i) {
                    PointInTimeDataReportsInterface.Parameter parameter = this.iParameters.get(i);
                    this.iForm.getRowFormatter().setVisible(3 + i, rpt.parametersContain(parameter.getType()));
                }
            }
        }
    }

    public static int compare(String[] a, String[] b, int col) {
        for (int i = 0; i < a.length; ++i) {
            int c = (col + i) % a.length;
            try {
                int cmp = Double.valueOf(a[c] == null ? "0" : a[c]).compareTo(Double.valueOf(b[c] == null ? "0" : b[c]));
                if (cmp == 0) continue;
                return cmp;
            }
            catch (NumberFormatException e) {
                int cmp = (a[c] == null ? "" : a[c]).compareTo(b[c] == null ? "" : b[c]);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        return 0;
    }

    public void populate(PointInTimeDataReportsInterface.Table result) {
        if (result == null || result.size() <= 1) {
            this.iTableHeader.setMessage(MESSAGES.errorNoResults());
        } else {
            for (int i = 0; i < result.size(); ++i) {
                String[] row = result.get(i);
                ArrayList<HTML> line = new ArrayList<HTML>();
                if (i == 0) {
                    this.iFirstField = row[0];
                    for (String x : row) {
                        final String name = x.replace('_', ' ').trim();
                        final UniTimeTableHeader h = new UniTimeTableHeader(name, 1);
                        final int col = line.size();
                        h.addOperation(new UniTimeTableHeader.Operation(){

                            public void execute() {
                                PointInTimeDataReportsPage.this.iTable.sort(col, new Comparator<String[]>(){

                                    @Override
                                    public int compare(String[] o1, String[] o2) {
                                        return PointInTimeDataReportsPage.compare(o1, o2, col);
                                    }
                                });
                                PointInTimeDataReportsPage.this.iLastSort = h.getOrder() != null && h.getOrder() != false ? 1 + col : -1 - col;
                                History.newItem((String)(PointInTimeDataReportsPage.this.iLastHistory + ":" + PointInTimeDataReportsPage.this.iLastSort), (boolean)false);
                                PointInTimeDataReportsPage.this.setBack();
                            }

                            public boolean isApplicable() {
                                return true;
                            }

                            public boolean hasSeparator() {
                                return false;
                            }

                            public String getName() {
                                return MESSAGES.opSortBy(name);
                            }
                        });
                        line.add(h);
                    }
                } else {
                    for (String x : row) {
                        line.add(new HTML(x == null ? "" : x.replace("\\n", "<br>")));
                    }
                }
                this.iTable.addRow(i == 0 ? null : row, line);
            }
            if (this.iFirstField != null && this.iFirstField.startsWith("__")) {
                this.iTable.setColumnVisible(0, false);
            }
            this.iHeader.setEnabled("print", true);
            this.iHeader.setEnabled("export", this.iTable.getRowCount() > 1);
            this.iTableHeader.setMessage(MESSAGES.infoShowingAllLines(result.size() - 1));
            if (this.iLastSort != 0) {
                this.iTable.sort(this.iTable.getHeader(Math.abs(this.iLastSort) - 1), new Comparator<String[]>(){

                    @Override
                    public int compare(String[] o1, String[] o2) {
                        return PointInTimeDataReportsPage.compare(o1, o2, Math.abs(PointInTimeDataReportsPage.this.iLastSort) - 1);
                    }
                }, this.iLastSort > 0);
            }
        }
        this.setBack();
    }

    public void setBack() {
        if (this.iFirstField == null || !this.iFirstField.startsWith("__") || this.iTable.getRowCount() <= 1) {
            return;
        }
        PointInTimeDataReportsInterface.PITDSetBackRpcRequest request = new PointInTimeDataReportsInterface.PITDSetBackRpcRequest();
        for (int i = 1; i < this.iTable.getRowCount(); ++i) {
            String[] row = this.iTable.getData(i);
            if (row == null) continue;
            Long id = Long.valueOf(row[0]);
            request.addId(id);
        }
        request.setHistory(History.getToken());
        request.setType(this.iFirstField);
        RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

            public void onFailure(Throwable caught) {
                PointInTimeDataReportsPage.this.iHeader.setErrorMessage(caught.getMessage());
            }

            public void onSuccess(GwtRpcResponseNull result) {
            }
        });
    }

    public void reload(String history) {
        if (history == null) {
            return;
        }
        if (history.indexOf(38) >= 0) {
            history = history.substring(0, history.indexOf(38));
        }
        if (history.isEmpty()) {
            return;
        }
        String[] params = history.split(":");
        String id = params[0];
        PointInTimeDataReportsInterface.Report rpt = null;
        for (int i = 0; i < this.iReports.size(); ++i) {
            PointInTimeDataReportsInterface.Report q = this.iReports.get(i);
            if (!id.equals(q.getId())) continue;
            rpt = q;
            this.iReportSelector.getWidget().setSelectedIndex(1 + i);
            this.queryChanged();
            break;
        }
        if (rpt == null) {
            return;
        }
        int idx = 1;
        block1: for (int i = 0; i < this.iParameters.size(); ++i) {
            int j;
            String param;
            PointInTimeDataReportsInterface.Parameter parameter = this.iParameters.get(i);
            if (!rpt.parametersContain(parameter.getType()) || (param = params[idx++]) == null || param.isEmpty()) continue;
            if (parameter.isTextField()) {
                TextBox text = (TextBox)((UniTimeWidget)this.iForm.getWidget(3 + i, 1)).getWidget();
                text.setText(param);
                continue;
            }
            ListBox list = (ListBox)((UniTimeWidget)this.iForm.getWidget(3 + i, 1)).getWidget();
            if (list.isMultipleSelect()) {
                for (j = 0; j < list.getItemCount(); ++j) {
                    String value = list.getValue(j);
                    boolean contains = false;
                    for (String o : param.split(",")) {
                        if (!o.equals(value)) continue;
                        contains = true;
                        break;
                    }
                    list.setItemSelected(j, contains);
                }
                continue;
            }
            for (j = 1; j < list.getItemCount(); ++j) {
                if (!list.getValue(j).equals(param)) continue;
                list.setSelectedIndex(j);
                continue block1;
            }
        }
        this.iLastSort = Integer.parseInt(params[idx++]);
        this.execute();
    }

    private void execute() {
        PointInTimeDataReportsInterface.PITDExecuteRpcRequest request = new PointInTimeDataReportsInterface.PITDExecuteRpcRequest();
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        String id = this.iReportSelector.getWidget().getValue(this.iReportSelector.getWidget().getSelectedIndex());
        for (PointInTimeDataReportsInterface.Report r : this.iReports) {
            if (!id.equals(r.getId())) continue;
            request.setReport(r);
            break;
        }
        if (request.getReport() == null) {
            this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
            return;
        }
        this.iLastHistory = request.getReport().getId().toString();
        for (int i = 0; i < this.iParameters.size(); ++i) {
            PointInTimeDataReportsInterface.Parameter parameter = this.iParameters.get(i);
            if (!request.getReport().parametersContain(parameter.getType())) continue;
            if (parameter.isTextField()) {
                TextBox textBox = (TextBox)((UniTimeWidget)this.iForm.getWidget(3 + i, 1)).getWidget();
                String value = textBox.getText();
                if (value.isEmpty()) {
                    this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                    return;
                }
                request.addParameter(parameter.getType(), value);
                this.iLastHistory = this.iLastHistory + ":" + (value == null ? "" : value);
                continue;
            }
            PointInTimeDataReportsInterface.IdValue o = new PointInTimeDataReportsInterface.IdValue();
            o.setValue(parameter.getType());
            ListBox list = (ListBox)((UniTimeWidget)this.iForm.getWidget(3 + i, 1)).getWidget();
            String value = "";
            boolean allSelected = true;
            if (list.isMultipleSelect()) {
                for (int j = 0; j < list.getItemCount(); ++j) {
                    if (list.isItemSelected(j)) {
                        if (!value.isEmpty()) {
                            value = value + ",";
                        }
                        value = value + list.getValue(j);
                        continue;
                    }
                    allSelected = false;
                }
            } else if (list.getSelectedIndex() > 0) {
                value = list.getValue(list.getSelectedIndex());
            }
            if (value.isEmpty()) {
                this.iHeader.setErrorMessage(MESSAGES.errorItemNotSelected(parameter.getName()));
                return;
            }
            request.addParameter(parameter.getType(), value);
            this.iLastHistory = this.iLastHistory + ":" + (list.isMultipleSelect() && allSelected ? "" : value);
        }
        this.iTable.clearTable();
        this.iFirstField = null;
        this.iTableHeader.clearMessage();
        this.iHeader.clearMessage();
        LoadingWidget.getInstance().show(MESSAGES.waitExecuting(request.getReport().getName()));
        History.newItem((String)(this.iLastHistory + ":" + this.iLastSort), (boolean)false);
        RPC.execute(request, new AsyncCallback<PointInTimeDataReportsInterface.Table>(){

            public void onFailure(Throwable caught) {
                PointInTimeDataReportsPage.this.iTableHeader.setErrorMessage(caught.getMessage());
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(PointInTimeDataReportsInterface.Table result) {
                PointInTimeDataReportsPage.this.populate(result);
                LoadingWidget.getInstance().hide();
            }
        });
    }
}

