/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorAttributeEdit;
import org.unitime.timetable.gwt.client.instructor.InstructorAttributesTable;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorAttributesPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private ListBox iFilter = null;
    private SimpleForm iAttributesPanel = null;
    private SimplePanel iRootPanel;
    private SimplePanel iPanel = new SimplePanel();
    private UniTimeHeaderPanel iFilterPanel = null;
    private InstructorInterface.InstructorAttributePropertiesInterface iProperties = null;
    private UniTimeHeaderPanel iGlobalAttributesHeader = null;
    private InstructorAttributesTable iGlobalAttributesTable = null;
    private int iGlobalAttributesRow = -1;
    private UniTimeHeaderPanel iDepartmentalAttributesHeader = null;
    private InstructorAttributesTable iDepartmentalAttributesTable = null;
    private int iDepartmentalAttributesRow = -1;
    private InstructorAttributeEdit iInstructorAttributeEdit = null;

    public InstructorAttributesPage() {
        this.iAttributesPanel = new SimpleForm();
        this.iAttributesPanel.setWidth("100%");
        this.iAttributesPanel.removeStyleName("unitime-NotPrintableBottomLine");
        ClickHandler clickSearch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAttributesPage.this.search(null);
            }
        };
        ClickHandler clickNew = new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAttributesPage.this.edit(null);
            }
        };
        this.iInstructorAttributeEdit = null;
        this.iFilterPanel = new UniTimeHeaderPanel(MESSAGES.propDepartment());
        this.iFilter = new ListBox();
        this.iFilter.setStyleName("unitime-TextBox");
        this.iFilterPanel.insertLeft((Widget)this.iFilter, false);
        this.iFilter.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                InstructorInterface.DepartmentInterface dept = InstructorAttributesPage.this.getDepartment();
                InstructorAttributesPage.this.iFilterPanel.setEnabled("search", dept != null && dept.isCanSeeAttributes());
                InstructorAttributesPage.this.iFilterPanel.setEnabled("new", InstructorAttributesPage.this.iProperties != null && (InstructorAttributesPage.this.iProperties.isCanAddGlobalAttribute() || dept != null && dept.isCanAddAttribute()));
            }
        });
        this.iFilter.getElement().getStyle().setMarginLeft(5.0, Style.Unit.PX);
        this.iFilterPanel.addButton("search", MESSAGES.buttonSearch(), clickSearch);
        this.iFilterPanel.addButton("new", MESSAGES.buttonAddNewInstructorAttribute(), clickNew);
        this.iFilterPanel.setEnabled("search", false);
        this.iFilterPanel.setEnabled("new", false);
        int filterRow = this.iAttributesPanel.addHeaderRow((Widget)this.iFilterPanel);
        this.iAttributesPanel.getCellFormatter().setHorizontalAlignment(filterRow, 0, HasHorizontalAlignment.ALIGN_CENTER);
        this.setup();
        this.iGlobalAttributesHeader = new UniTimeHeaderPanel(MESSAGES.headerGlobalInstructorAttributes());
        this.iGlobalAttributesRow = this.iAttributesPanel.addHeaderRow((Widget)this.iGlobalAttributesHeader);
        this.iGlobalAttributesTable = new InstructorAttributesTable(){

            protected void doSort(InstructorInterface.AttributesColumn column) {
                super.doSort(column);
                InstructorAttributesPage.this.iDepartmentalAttributesTable.setSortBy(InstructorCookie.getInstance().getSortAttributesBy());
            }
        };
        this.iAttributesPanel.addRow((Widget)this.iGlobalAttributesTable);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iGlobalAttributesRow, false);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iGlobalAttributesRow + 1, false);
        this.iDepartmentalAttributesHeader = new UniTimeHeaderPanel(MESSAGES.headerDepartmentalInstructorAttributes());
        this.iDepartmentalAttributesRow = this.iAttributesPanel.addHeaderRow((Widget)this.iDepartmentalAttributesHeader);
        this.iDepartmentalAttributesTable = new InstructorAttributesTable(){

            protected void doSort(InstructorInterface.AttributesColumn column) {
                super.doSort(column);
                InstructorAttributesPage.this.iGlobalAttributesTable.setSortBy(InstructorCookie.getInstance().getSortAttributesBy());
            }
        };
        this.iAttributesPanel.addRow((Widget)this.iDepartmentalAttributesTable);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iDepartmentalAttributesRow, false);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iDepartmentalAttributesRow + 1, false);
        this.iRootPanel = new SimplePanel((Widget)this.iAttributesPanel);
        this.iPanel.setWidget((Widget)this.iRootPanel);
        this.iGlobalAttributesTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.AttributeInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.AttributeInterface> event) {
                if (event.getData() != null && (event.getData().canAssign() || event.getData().canDelete())) {
                    InstructorAttributesPage.this.edit(event.getData());
                }
            }
        });
        this.iDepartmentalAttributesTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.AttributeInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.AttributeInterface> event) {
                if (event.getData() != null && (event.getData().canAssign() || event.getData().canDelete())) {
                    InstructorAttributesPage.this.edit(event.getData());
                }
            }
        });
        this.initWidget((Widget)this.iPanel);
    }

    protected InstructorInterface.DepartmentInterface getDepartment() {
        if (this.iFilter.getSelectedIndex() >= 0) {
            return this.iProperties.getDepartment(Long.valueOf(this.iFilter.getValue(this.iFilter.getSelectedIndex())));
        }
        return null;
    }

    private void edit(InstructorInterface.AttributeInterface attribute) {
        if (this.iInstructorAttributeEdit == null) {
            return;
        }
        InstructorInterface.DepartmentInterface dept = this.getDepartment();
        this.iInstructorAttributeEdit.setAttribute(attribute, dept);
        if (dept == null) {
            this.iFilterPanel.clearMessage();
            this.iInstructorAttributeEdit.setInstructors(new ArrayList<InstructorInterface>());
            this.iInstructorAttributeEdit.show();
        } else {
            InstructorInterface.GetInstructorsRequest request = new InstructorInterface.GetInstructorsRequest();
            request.setDepartmentId(dept.getId());
            LoadingWidget.execute(request, new AsyncCallback<GwtRpcResponseList<InstructorInterface>>(){

                public void onFailure(Throwable caught) {
                    InstructorAttributesPage.this.iFilterPanel.setErrorMessage(MESSAGES.failedToLoadRooms(caught.getMessage()));
                    UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
                }

                public void onSuccess(GwtRpcResponseList<InstructorInterface> result) {
                    InstructorAttributesPage.this.iFilterPanel.clearMessage();
                    InstructorAttributesPage.this.iInstructorAttributeEdit.setInstructors(result);
                    InstructorAttributesPage.this.iInstructorAttributeEdit.show();
                }
            }, MESSAGES.waitLoadingInstructors());
        }
    }

    protected void setup() {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new InstructorInterface.InstructorAttributePropertiesRequest(), new AsyncCallback<InstructorInterface.InstructorAttributePropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                InstructorAttributesPage.this.iFilterPanel.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorAttributePropertiesInterface result) {
                LoadingWidget.getInstance().hide();
                InstructorAttributesPage.this.iProperties = result;
                InstructorAttributesPage.this.iInstructorAttributeEdit = new InstructorAttributeEdit(InstructorAttributesPage.this.iProperties){

                    protected void onShow() {
                        RoomHint.hideHint();
                        InstructorAttributesPage.this.iRootPanel.setWidget((Widget)InstructorAttributesPage.this.iInstructorAttributeEdit);
                        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    }

                    protected void onHide(boolean refresh, InstructorInterface.AttributeInterface attribute) {
                        InstructorAttributesPage.this.iRootPanel.setWidget((Widget)InstructorAttributesPage.this.iAttributesPanel);
                        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageInstructorAttributes());
                        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                        if (refresh && (InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().isVisible(InstructorAttributesPage.this.iGlobalAttributesRow) || InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().isVisible(InstructorAttributesPage.this.iDepartmentalAttributesRow))) {
                            InstructorAttributesPage.this.search(attribute == null ? null : attribute.getId());
                        }
                    }
                };
                InstructorAttributesPage.this.iFilter.clear();
                InstructorAttributesPage.this.iFilter.addItem(MESSAGES.itemSelect(), "-1");
                InstructorAttributesPage.this.iFilter.setSelectedIndex(0);
                for (InstructorInterface.DepartmentInterface d : InstructorAttributesPage.this.iProperties.getDepartments()) {
                    if (!d.isCanSeeAttributes()) continue;
                    InstructorAttributesPage.this.iFilter.addItem(d.getDeptCode() + " - " + d.getLabel(), d.getId().toString());
                    if (!d.getId().equals(InstructorAttributesPage.this.iProperties.getLastDepartmentId())) continue;
                    InstructorAttributesPage.this.iFilter.setSelectedIndex(InstructorAttributesPage.this.iFilter.getItemCount() - 1);
                }
                InstructorInterface.DepartmentInterface dept = InstructorAttributesPage.this.getDepartment();
                InstructorAttributesPage.this.iFilterPanel.setEnabled("search", dept != null && dept.isCanSeeAttributes());
                InstructorAttributesPage.this.iFilterPanel.setEnabled("new", InstructorAttributesPage.this.iProperties != null && (InstructorAttributesPage.this.iProperties.isCanAddGlobalAttribute() || dept != null && dept.isCanAddAttribute()));
            }
        });
    }

    protected void hideResults() {
        this.iGlobalAttributesTable.clearTable(1);
        this.iDepartmentalAttributesTable.clearTable(1);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iGlobalAttributesRow, false);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iGlobalAttributesRow + 1, false);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iDepartmentalAttributesRow, false);
        this.iAttributesPanel.getRowFormatter().setVisible(this.iDepartmentalAttributesRow + 1, false);
    }

    protected void search(final Long attributeId) {
        this.hideResults();
        final InstructorInterface.DepartmentInterface dept = this.getDepartment();
        InstructorInterface.GetInstructorAttributesRequest request = new InstructorInterface.GetInstructorAttributesRequest();
        if (dept != null) {
            request.setDepartmentId(dept.getId());
            RPC.execute(new InstructorInterface.SetLastDepartmentRequest(dept.getId()), new AsyncCallback<GwtRpcResponseNull>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(GwtRpcResponseNull result) {
                }
            });
        }
        LoadingWidget.execute(request, new AsyncCallback<GwtRpcResponseList<InstructorInterface.AttributeInterface>>(){

            public void onFailure(Throwable caught) {
                InstructorAttributesPage.this.iFilterPanel.setErrorMessage(MESSAGES.failedToLoadInstructorAttributes(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadInstructorAttributes(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<InstructorInterface.AttributeInterface> result) {
                InstructorAttributesPage.this.iFilterPanel.clearMessage();
                if (result == null || result.isEmpty()) {
                    InstructorAttributesPage.this.iFilterPanel.setErrorMessage(MESSAGES.errorNoInstructorAttributes());
                } else {
                    for (InstructorInterface.AttributeInterface attribute : result) {
                        if (attribute.isDepartmental()) {
                            if (dept != null && !dept.equals(attribute.getDepartment())) continue;
                            InstructorAttributesPage.this.iDepartmentalAttributesTable.addAttribute(attribute);
                            continue;
                        }
                        InstructorAttributesPage.this.iGlobalAttributesTable.addAttribute(attribute);
                    }
                    InstructorAttributesPage.this.iDepartmentalAttributesTable.sort();
                    InstructorAttributesPage.this.iGlobalAttributesTable.sort();
                }
                InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().setVisible(InstructorAttributesPage.this.iGlobalAttributesRow, InstructorAttributesPage.this.iGlobalAttributesTable.getRowCount() > 1);
                InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().setVisible(InstructorAttributesPage.this.iGlobalAttributesRow + 1, InstructorAttributesPage.this.iGlobalAttributesTable.getRowCount() > 1);
                InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().setVisible(InstructorAttributesPage.this.iDepartmentalAttributesRow, InstructorAttributesPage.this.iDepartmentalAttributesTable.getRowCount() > 1);
                InstructorAttributesPage.this.iAttributesPanel.getRowFormatter().setVisible(InstructorAttributesPage.this.iDepartmentalAttributesRow + 1, InstructorAttributesPage.this.iDepartmentalAttributesTable.getRowCount() > 1);
                InstructorAttributesPage.this.iDepartmentalAttributesTable.scrollTo(attributeId);
                InstructorAttributesPage.this.iGlobalAttributesTable.scrollTo(attributeId);
            }
        }, MESSAGES.waitLoadingInstructorAttributes());
    }

    protected void export(String format) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected String query(String format) {
        InstructorCookie cookie = InstructorCookie.getInstance();
        String query = "output=" + format + "&sort=" + cookie.getSortAttributesBy();
        InstructorInterface.DepartmentInterface dept = this.getDepartment();
        if (dept != null) {
            query = query + "&department=" + dept.getId();
        }
        return query;
    }
}

