/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniTimeFilterBox<T extends EventInterface.FilterRpcRequest>
extends Composite
implements HasValue<String>,
Focusable,
HasAllKeyHandlers,
HasAllFocusHandlers,
HasAriaLabel {
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private AcademicSessionProvider iAcademicSession;
    protected UniTimeWidget<FilterBox> iFilter = new UniTimeWidget<FilterBox>(new FilterBox());
    private boolean iInitialized = false;

    public UniTimeFilterBox(AcademicSessionProvider session) {
        this.iFilter.addStyleName("unitime-FilterBoxContainer");
        this.iFilter.getWidget().setSuggestionsProvider(new FilterBox.SuggestionsProvider(){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, final AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                Long sessionId;
                Long l = sessionId = UniTimeFilterBox.this.iAcademicSession == null ? null : UniTimeFilterBox.this.iAcademicSession.getAcademicSessionId();
                if (sessionId == null && UniTimeFilterBox.this.iAcademicSession != null) {
                    callback.onSuccess(null);
                    return;
                }
                RPC.execute(UniTimeFilterBox.this.createRpcRequest(EventInterface.FilterRpcRequest.Command.SUGGESTIONS, UniTimeFilterBox.this.iAcademicSession == null ? null : UniTimeFilterBox.this.iAcademicSession.getAcademicSessionId(), chips, text), new AsyncCallback<EventInterface.FilterRpcResponse>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(EventInterface.FilterRpcResponse result) {
                        ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                        if (result.hasSuggestions()) {
                            for (EventInterface.FilterRpcResponse.Entity s : result.getSuggestions()) {
                                UniTimeFilterBox.this.addSuggestion(suggestions, s);
                            }
                        }
                        callback.onSuccess(suggestions);
                    }
                });
            }
        });
        this.initWidget((Widget)this.iFilter);
        this.iAcademicSession = session;
        if (this.iAcademicSession != null) {
            this.iAcademicSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

                public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                    if (event.isChanged()) {
                        UniTimeFilterBox.this.init(true, event.getNewAcademicSessionId(), null);
                    }
                }
            });
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                UniTimeFilterBox.this.init(true, UniTimeFilterBox.this.iAcademicSession == null ? null : UniTimeFilterBox.this.iAcademicSession.getAcademicSessionId(), null);
            }
        });
    }

    protected void addSuggestion(List<FilterBox.Suggestion> suggestions, EventInterface.FilterRpcResponse.Entity entity) {
        String command = entity.getProperty("command", null);
        if (command == null) {
            suggestions.add(new FilterBox.Suggestion(entity.getName(), entity.getAbbreviation(), entity.getProperty("hint", null)));
        } else {
            FilterBox.Chip old = "true".equals(entity.getProperty("single", "true")) ? this.getChip(command) : null;
            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip(command, entity.getAbbreviation()).withLabel(entity.getName()).withToolTip(entity.getProperty("hint", null)), old));
        }
    }

    protected void initAsync() {
        this.setValue(this.getValue());
    }

    protected void init(final boolean init, Long academicSessionId, final Command onSuccess) {
        if (academicSessionId == null && this.iAcademicSession != null) {
            this.setHint(MESSAGES.hintNoSession());
        } else {
            if (init) {
                this.setHint(MESSAGES.waitLoadingDataForSession(this.iAcademicSession == null ? "" : this.iAcademicSession.getAcademicSessionName()));
                this.iInitialized = false;
            }
            final String value = this.iFilter.getWidget().getValue();
            RPC.execute(this.createRpcRequest(EventInterface.FilterRpcRequest.Command.LOAD, academicSessionId, this.iFilter.getWidget().getChips(null), this.iFilter.getWidget().getText()), new AsyncCallback<EventInterface.FilterRpcResponse>(){

                public void onFailure(Throwable caught) {
                    UniTimeFilterBox.this.setErrorHint(caught.getMessage());
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(EventInterface.FilterRpcResponse result) {
                    UniTimeFilterBox.this.clearHint();
                    if (!value.equals(UniTimeFilterBox.this.iFilter.getWidget().getValue())) {
                        return;
                    }
                    UniTimeFilterBox.this.onLoad(result);
                    for (FilterBox.Filter filter : UniTimeFilterBox.this.iFilter.getWidget().getFilters()) {
                        UniTimeFilterBox.this.populateFilter(filter, result.getEntities(filter.getCommand()));
                    }
                    if (onSuccess != null) {
                        onSuccess.execute();
                    }
                    if (init) {
                        UniTimeFilterBox.this.iInitialized = true;
                        UniTimeFilterBox.this.initAsync();
                    }
                }
            });
        }
    }

    protected void onLoad(EventInterface.FilterRpcResponse result) {
    }

    public boolean isInitialized() {
        return this.iInitialized;
    }

    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if (filter != null && filter instanceof FilterBox.StaticSimpleFilter) {
            FilterBox.StaticSimpleFilter simple = (FilterBox.StaticSimpleFilter)filter;
            ArrayList<FilterBox.Chip> chips = new ArrayList<FilterBox.Chip>();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    FilterBox.Chip chip = new FilterBox.Chip(filter.getCommand(), entity.getAbbreviation()).withLabel(entity.getName()).withCount(entity.getCount()).withTranslatedCommand(filter.getLabel()).withTranslatedValue(entity.getProperty("translated-value", null)).withToolTip(entity.getProperty("hint", null));
                    chips.add(chip);
                    if (chip.getValue().equals(chip.getTranslatedValue())) continue;
                    this.iFilter.getWidget().fixLabel(chip);
                }
            }
            simple.setValues(chips);
            return true;
        }
        return false;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.iFilter.getWidget().addValueChangeHandler(handler);
    }

    public String getValue() {
        return this.iFilter.getWidget().getValue().trim();
    }

    public void setValue(String value) {
        this.iFilter.getWidget().setValue(value);
    }

    public void setValue(String value, boolean fireEvents) {
        this.iFilter.getWidget().setValue(value, fireEvents);
        if (fireEvents) {
            this.init(false, this.iAcademicSession == null ? null : this.iAcademicSession.getAcademicSessionId(), new Command(){

                public void execute() {
                    if (UniTimeFilterBox.this.iFilter.getWidget().isFilterPopupShowing()) {
                        UniTimeFilterBox.this.iFilter.getWidget().showFilterPopup();
                    }
                }
            });
        }
    }

    public void clearHint() {
        this.iFilter.clearHint();
        this.iFilter.getWidget().setAriaLabel(this.toAriaString());
    }

    public void setErrorHint(String error) {
        this.iFilter.setErrorHint(error);
    }

    public void setHint(String hint) {
        this.iFilter.setHint(hint);
    }

    protected abstract T createRpcRequest();

    protected T createRpcRequest(EventInterface.FilterRpcRequest.Command command, Long sessionId, List<FilterBox.Chip> chips, String text) {
        T request = this.createRpcRequest();
        ((EventInterface.FilterRpcRequest)request).setCommand(command);
        ((EventInterface.EventRpcRequest)request).setSessionId(sessionId);
        if (chips != null) {
            for (FilterBox.Chip chip : chips) {
                ((EventInterface.FilterRpcRequest)request).addOption(chip.getCommand(), chip.getValue());
            }
        }
        ((EventInterface.FilterRpcRequest)request).setText(text);
        return request;
    }

    public void getElements(final AsyncCallback<List<EventInterface.FilterRpcResponse.Entity>> callback) {
        RPC.execute(this.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(EventInterface.FilterRpcResponse result) {
                callback.onSuccess(result.getResults());
            }
        });
    }

    public T getElementsRequest() {
        return this.createRpcRequest(EventInterface.FilterRpcRequest.Command.ENUMERATE, this.iAcademicSession == null ? null : this.iAcademicSession.getAcademicSessionId(), this.iFilter.getWidget().getChips(null), this.iFilter.getWidget().getText());
    }

    public void addFilter(FilterBox.Filter filter) {
        this.iFilter.getWidget().addFilter(filter);
    }

    public FilterBox.Chip getChip(String command) {
        return this.iFilter.getWidget().getChip(command);
    }

    public void addChip(FilterBox.Chip chip, boolean fireEvents) {
        this.iFilter.getWidget().addChip(chip, fireEvents);
    }

    public boolean removeChip(FilterBox.Chip chip, boolean fireEvents) {
        return this.iFilter.getWidget().removeChip(chip, fireEvents);
    }

    public boolean hasChip(FilterBox.Chip chip) {
        return this.iFilter.getWidget().hasChip(chip);
    }

    protected void fireValueChangeEvent() {
        ValueChangeEvent.fire((HasValueChangeHandlers)this.iFilter.getWidget(), (Object)this.iFilter.getWidget().getValue());
    }

    public boolean isFilterPopupShowing() {
        return this.iFilter.getWidget().isFilterPopupShowing();
    }

    public void showFilterPopup() {
        this.iFilter.getWidget().showFilterPopup();
    }

    public void hideFilterPopup() {
        this.iFilter.getWidget().hideFilterPopup();
    }

    protected Long getAcademicSessionId() {
        return this.iAcademicSession == null ? null : this.iAcademicSession.getAcademicSessionId();
    }

    public int getTabIndex() {
        return this.iFilter.getWidget().getTabIndex();
    }

    public void setTabIndex(int index) {
        this.iFilter.getWidget().setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.iFilter.getWidget().setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.iFilter.getWidget().setFocus(focused);
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.iFilter.getWidget().addKeyUpHandler(handler);
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.iFilter.getWidget().addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.iFilter.getWidget().addKeyPressHandler(handler);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.iFilter.getWidget().addFocusHandler(handler);
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.iFilter.getWidget().addBlurHandler(handler);
    }

    public boolean isShowSuggestionsOnFocus() {
        return this.iFilter.getWidget().isShowSuggestionsOnFocus();
    }

    public void setShowSuggestionsOnFocus(boolean showSuggestionsOnFocus) {
        this.iFilter.getWidget().setShowSuggestionsOnFocus(showSuggestionsOnFocus);
    }

    public String toAriaString() {
        return this.iFilter.getWidget().toAriaString();
    }

    @Override
    public String getAriaLabel() {
        return this.iFilter.getWidget().getAriaLabel();
    }

    @Override
    public void setAriaLabel(String text) {
        this.iFilter.getWidget().setAriaLabel(text);
    }

    public void setDefaultValueProvider(TakesValue<String> defaultValue) {
        this.iFilter.getWidget().setDefaultValueProvider(defaultValue);
    }

    public TakesValue<String> getDefaultValueProvider() {
        return this.iFilter.getWidget().getDefaultValueProvider();
    }
}

