/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.curricula.CurriculaClassifications;
import org.unitime.timetable.gwt.client.curricula.CurriculaCourses;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumEdit
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private SimpleForm iCurriculaTable;
    private UniTimeHeaderPanel iTitleAndButtons;
    private UniTimeWidget<TextBox> iCurriculumAbbv;
    private UniTimeWidget<TextBox> iCurriculumName;
    private UniTimeWidget<ListBox> iCurriculumMajors;
    private UniTimeWidget<ListBox> iCurriculumArea;
    private UniTimeWidget<ListBox> iCurriculumDept;
    private UniTimeWidget<CheckBox> iMultipleMajor;
    private CurriculaClassificationsPanel iCurriculumClasfTable = null;
    private boolean iDefaultAbbv = false;
    private boolean iDefaultName = false;
    private List<CurriculumInterface.AcademicAreaInterface> iAreas = new ArrayList<CurriculumInterface.AcademicAreaInterface>();
    private List<CurriculumInterface.DepartmentInterface> iDepts = new ArrayList<CurriculumInterface.DepartmentInterface>();
    private List<CurriculumInterface.MajorInterface> iMajors = new ArrayList<CurriculumInterface.MajorInterface>();
    private List<CurriculumInterface.AcademicClassificationInterface> iClassifications = new ArrayList<CurriculumInterface.AcademicClassificationInterface>();
    private CurriculumInterface iCurriculum = null;
    private CurriculaCourses iCurriculumCourses;
    private List<EditFinishedHandler> iEditFinishedHandlers = new ArrayList<EditFinishedHandler>();
    private boolean iAreaHasNoMajors = false;
    private Mode iMode;
    private boolean iSaved = false;
    private NavigationProvider iNavigation = null;

    public CurriculumEdit(NavigationProvider navigation) {
        this.iNavigation = navigation;
        ClickHandler backHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CurriculumEdit.this.iMode == Mode.EDIT) {
                    CurriculumEdit.this.reload(Mode.DETAILS);
                } else {
                    EditFinishedEvent e = new EditFinishedEvent();
                    for (EditFinishedHandler h : CurriculumEdit.this.iEditFinishedHandlers) {
                        if (CurriculumEdit.this.iSaved) {
                            h.onSave(e);
                            continue;
                        }
                        h.onBack(e);
                    }
                }
            }
        };
        ClickHandler saveHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CurriculumEdit.this.saveCurriculum()) {
                    CurriculumEdit.this.showLoading(MESSAGES.waitSavingCurriculum(CurriculumEdit.this.iCurriculum.getName()));
                    CurriculumEdit.this.iService.saveCurriculum(CurriculumEdit.this.iCurriculum, new AsyncCallback<Long>(){

                        public void onFailure(Throwable caught) {
                            CurriculumEdit.this.hideLoading();
                            CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidation(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedValidation(caught.getMessage()), caught);
                        }

                        public void onSuccess(Long result) {
                            if (CurriculumEdit.this.iMode == Mode.EDIT) {
                                CurriculumEdit.this.iCurriculum.setId(result);
                                CurriculumEdit.this.reload(Mode.DETAILS);
                                CurriculumEdit.this.iSaved = true;
                            } else {
                                EditFinishedEvent e = new EditFinishedEvent();
                                for (EditFinishedHandler h : CurriculumEdit.this.iEditFinishedHandlers) {
                                    h.onSave(e);
                                }
                            }
                            CurriculumEdit.this.hideLoading();
                        }
                    });
                } else {
                    CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationSeeBelow());
                }
            }
        };
        ClickHandler deleteHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!Window.confirm((String)MESSAGES.confirmDeleteThisCurriculum())) {
                    return;
                }
                CurriculumEdit.this.showLoading(MESSAGES.waitDeletingCurriculum(CurriculumEdit.this.iCurriculum.getName()));
                CurriculumEdit.this.iService.deleteCurriculum(CurriculumEdit.this.iCurriculum.getId(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedDelete(CurriculumEdit.this.iCurriculum.getName(), caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedDelete(CurriculumEdit.this.iCurriculum.getName(), caught.getMessage()), caught);
                        CurriculumEdit.this.hideLoading();
                    }

                    public void onSuccess(Boolean result) {
                        EditFinishedEvent e = new EditFinishedEvent();
                        for (EditFinishedHandler h : CurriculumEdit.this.iEditFinishedHandlers) {
                            h.onDelete(e);
                        }
                        CurriculumEdit.this.hideLoading();
                    }
                });
            }
        };
        ClickHandler printHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.print();
            }
        };
        ClickHandler editHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculumEdit.this.loadCurriculum(Mode.EDIT);
            }
        };
        ClickHandler nextHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculumInterface next;
                CurriculumInterface curriculumInterface = next = CurriculumEdit.this.iNavigation == null ? null : CurriculumEdit.this.iNavigation.next(CurriculumEdit.this.iCurriculum);
                if (next == null) {
                    CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.errorNoNextCurriculum());
                    return;
                }
                if (CurriculumEdit.this.getMode().isEditable()) {
                    if (CurriculumEdit.this.saveCurriculum()) {
                        CurriculumEdit.this.showLoading(MESSAGES.waitSavingCurriculum(CurriculumEdit.this.iCurriculum.getName()));
                        CurriculumEdit.this.iService.saveCurriculum(CurriculumEdit.this.iCurriculum, new AsyncCallback<Long>(){

                            public void onFailure(Throwable caught) {
                                CurriculumEdit.this.hideLoading();
                                CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidation(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedValidation(caught.getMessage()), caught);
                            }

                            public void onSuccess(Long result) {
                                CurriculumEdit.this.iSaved = false;
                                CurriculumEdit.this.iCurriculum = next;
                                CurriculumEdit.this.reload(CurriculumEdit.this.iMode);
                                CurriculumEdit.this.iNavigation.onChange(CurriculumEdit.this.iCurriculum);
                                CurriculumEdit.this.hideLoading();
                            }
                        });
                    } else {
                        CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationSeeBelow());
                    }
                } else {
                    CurriculumEdit.this.iSaved = false;
                    CurriculumEdit.this.iCurriculum = next;
                    CurriculumEdit.this.reload(CurriculumEdit.this.iMode);
                    CurriculumEdit.this.iNavigation.onChange(CurriculumEdit.this.iCurriculum);
                }
            }
        };
        ClickHandler previousHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculumInterface previous;
                CurriculumInterface curriculumInterface = previous = CurriculumEdit.this.iNavigation == null ? null : CurriculumEdit.this.iNavigation.previous(CurriculumEdit.this.iCurriculum);
                if (previous == null) {
                    CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.errorNoPreviousCurriculum());
                    return;
                }
                if (CurriculumEdit.this.getMode().isEditable()) {
                    if (CurriculumEdit.this.saveCurriculum()) {
                        CurriculumEdit.this.showLoading(MESSAGES.waitSavingCurriculum(CurriculumEdit.this.iCurriculum.getName()));
                        CurriculumEdit.this.iService.saveCurriculum(CurriculumEdit.this.iCurriculum, new AsyncCallback<Long>(){

                            public void onFailure(Throwable caught) {
                                CurriculumEdit.this.hideLoading();
                                CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidation(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedValidation(caught.getMessage()), caught);
                            }

                            public void onSuccess(Long result) {
                                CurriculumEdit.this.iSaved = false;
                                CurriculumEdit.this.iCurriculum = previous;
                                CurriculumEdit.this.reload(CurriculumEdit.this.iMode);
                                CurriculumEdit.this.iNavigation.onChange(CurriculumEdit.this.iCurriculum);
                                CurriculumEdit.this.hideLoading();
                            }
                        });
                    } else {
                        CurriculumEdit.this.iTitleAndButtons.setErrorMessage(MESSAGES.failedValidationSeeBelow());
                    }
                } else {
                    CurriculumEdit.this.iSaved = false;
                    CurriculumEdit.this.iCurriculum = previous;
                    CurriculumEdit.this.reload(CurriculumEdit.this.iMode);
                    CurriculumEdit.this.iNavigation.onChange(CurriculumEdit.this.iCurriculum);
                }
            }
        };
        this.iCurriculaTable = new SimpleForm();
        this.iTitleAndButtons = new UniTimeHeaderPanel(MESSAGES.headerCurriculumDetails());
        this.iTitleAndButtons.addButton("edit", MESSAGES.buttonEdit(), 75, editHandler);
        this.iTitleAndButtons.addButton("save", MESSAGES.buttonSave(), 75, saveHandler);
        this.iTitleAndButtons.addButton("previous", MESSAGES.buttonPrevious(), 75, previousHandler);
        this.iTitleAndButtons.addButton("next", MESSAGES.buttonNext(), 75, nextHandler);
        this.iTitleAndButtons.addButton("delete", MESSAGES.buttonDelete(), 75, deleteHandler);
        this.iTitleAndButtons.addButton("print", MESSAGES.buttonPrint(), 75, printHandler);
        this.iTitleAndButtons.addButton("back", MESSAGES.buttonBack(), 75, backHandler);
        this.iCurriculaTable.addHeaderRow((Widget)this.iTitleAndButtons);
        this.iCurriculumAbbv = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox(40, 300, ValueBoxBase.TextAlignment.LEFT));
        this.iCurriculaTable.addRow(MESSAGES.propAbbreviation(), (Widget)this.iCurriculumAbbv);
        this.iCurriculumAbbv.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CurriculumEdit.this.iDefaultAbbv = false;
                CurriculumEdit.this.iCurriculumAbbv.clearHint();
            }
        });
        this.iCurriculumName = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox(100, 700));
        this.iCurriculaTable.addRow(MESSAGES.propName(), (Widget)this.iCurriculumName);
        this.iCurriculumName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CurriculumEdit.this.iDefaultName = false;
                CurriculumEdit.this.iCurriculumName.clearHint();
            }
        });
        this.iCurriculumArea = new UniTimeWidget<ListBox>(new ListBox());
        this.iCurriculumArea.getWidget().setMultipleSelect(false);
        this.iCurriculumArea.getWidget().setWidth("300px");
        this.iCurriculumArea.getWidget().setStyleName("unitime-TextBox");
        this.iCurriculumArea.getWidget().setVisibleItemCount(1);
        this.iCurriculaTable.addRow(MESSAGES.propAcademicArea(), (Widget)this.iCurriculumArea);
        this.iCurriculumArea.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (CurriculumEdit.this.iDefaultName || CurriculumEdit.this.iDefaultAbbv) {
                    try {
                        if (((ListBox)CurriculumEdit.this.iCurriculumArea.getWidget()).getSelectedIndex() == 0) {
                            if (CurriculumEdit.this.iDefaultAbbv) {
                                ((TextBox)CurriculumEdit.this.iCurriculumAbbv.getWidget()).setText("");
                            }
                            if (CurriculumEdit.this.iDefaultName) {
                                ((TextBox)CurriculumEdit.this.iCurriculumName.getWidget()).setText("");
                            }
                        } else {
                            CurriculumInterface.AcademicAreaInterface area = (CurriculumInterface.AcademicAreaInterface)CurriculumEdit.this.iAreas.get(((ListBox)CurriculumEdit.this.iCurriculumArea.getWidget()).getSelectedIndex() - 1);
                            if (CurriculumEdit.this.iDefaultAbbv) {
                                ((TextBox)CurriculumEdit.this.iCurriculumAbbv.getWidget()).setText(area.getAbbv());
                            }
                            if (CurriculumEdit.this.iDefaultName) {
                                ((TextBox)CurriculumEdit.this.iCurriculumName.getWidget()).setText(area.getName());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                CurriculumEdit.this.iCurriculumArea.clearHint();
                CurriculumEdit.this.loadMajors(true, true);
            }
        });
        this.iMultipleMajor = new UniTimeWidget<CheckBox>(new CheckBox(MESSAGES.infoMultipleMajorsOff()));
        this.iMultipleMajor.getWidget().setValue(Boolean.valueOf(false));
        this.iMultipleMajor.getWidget().addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                CurriculumEdit.this.loadMajors(true, true);
                CurriculumEdit.this.iCurriculumArea.clearHint();
                ((CheckBox)CurriculumEdit.this.iMultipleMajor.getWidget()).setText((Boolean)event.getValue() != false ? MESSAGES.infoMultipleMajorsOn() : MESSAGES.infoMultipleMajorsOff());
            }
        });
        this.iMultipleMajor.addStyleName("unitime-CurriculumMultipleMajors");
        this.iCurriculaTable.addRow(MESSAGES.propMultipleMajors(), (Widget)this.iMultipleMajor);
        this.iCurriculumMajors = new UniTimeWidget<ListBox>(new ListBox());
        this.iCurriculumMajors.getWidget().setMultipleSelect(true);
        this.iCurriculumMajors.getWidget().setWidth("300px");
        this.iCurriculumMajors.getWidget().setStyleName("unitime-TextBox");
        this.iCurriculumMajors.getWidget().setVisibleItemCount(3);
        this.iCurriculumMajors.getWidget().setHeight("100px");
        this.iCurriculaTable.addRow(MESSAGES.propMajorOrMajors(), (Widget)this.iCurriculumMajors);
        this.iCurriculumMajors.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                try {
                    String defaultAbbv = "";
                    String defaultName = "";
                    CurriculumInterface.AcademicAreaInterface area = (CurriculumInterface.AcademicAreaInterface)CurriculumEdit.this.iAreas.get(((ListBox)CurriculumEdit.this.iCurriculumArea.getWidget()).getSelectedIndex() - 1);
                    defaultAbbv = area.getAbbv();
                    defaultName = area.getName();
                    String majors = "";
                    for (int i = 0; i < ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).getItemCount(); ++i) {
                        if (!((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).isItemSelected(i)) continue;
                        CurriculumInterface.MajorInterface m = (CurriculumInterface.MajorInterface)CurriculumEdit.this.iMajors.get(i);
                        if (!defaultAbbv.contains("/")) {
                            defaultAbbv = defaultAbbv + "/";
                            defaultName = defaultName + " / ";
                        } else {
                            defaultAbbv = defaultAbbv + ",";
                            defaultName = defaultName + ", ";
                        }
                        defaultAbbv = defaultAbbv + m.getCode();
                        defaultName = defaultName + m.getName();
                        if (!majors.isEmpty()) {
                            majors = majors + "<br>";
                        }
                        majors = majors + m.getName();
                    }
                    if (defaultName.length() > 100) {
                        defaultName = defaultName.substring(0, 100);
                    }
                    if (defaultAbbv.length() > 40) {
                        defaultAbbv = defaultAbbv.substring(0, 40);
                    }
                    if (CurriculumEdit.this.iDefaultAbbv) {
                        ((TextBox)CurriculumEdit.this.iCurriculumAbbv.getWidget()).setText(defaultAbbv);
                    }
                    if (CurriculumEdit.this.iDefaultName) {
                        ((TextBox)CurriculumEdit.this.iCurriculumName.getWidget()).setText(defaultName);
                    }
                    CurriculumEdit.this.iCurriculumMajors.setPrintText(majors);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CurriculumEdit.this.loadEnrollments(true, true);
            }
        });
        this.iCurriculumDept = new UniTimeWidget<ListBox>(new ListBox());
        this.iCurriculumDept.getWidget().setMultipleSelect(false);
        this.iCurriculumDept.getWidget().setWidth("300px");
        this.iCurriculumDept.getWidget().setStyleName("unitime-TextBox");
        this.iCurriculumDept.getWidget().setVisibleItemCount(1);
        this.iCurriculaTable.addRow(MESSAGES.propDepartment(), (Widget)this.iCurriculumDept);
        this.iCurriculaTable.addRow(MESSAGES.propLastChange(), (Widget)new Label("", false));
        this.iCurriculaTable.getRowFormatter().setVisible(7, false);
        this.iCurriculumDept.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CurriculumEdit.this.iCurriculumDept.clearHint();
            }
        });
        this.iCurriculaTable.addHeaderRow(MESSAGES.headerCurriculumClassifications());
        this.iCurriculumClasfTable = new CurriculaClassificationsPanel(new CurriculaClassifications());
        this.iCurriculaTable.addRow((Widget)this.iCurriculumClasfTable);
        this.iCurriculumCourses = new CurriculaCourses();
        this.iCurriculaTable.addHeaderRow(MESSAGES.headerCourseProjections());
        this.iCurriculaTable.addRow((Widget)this.iCurriculumCourses);
        this.iCurriculaTable.addNotPrintableBottomRow((Widget)this.iTitleAndButtons.clonePanel(null));
        this.initWidget((Widget)this.iCurriculaTable);
    }

    public Mode getMode() {
        return this.iMode;
    }

    private void loadCurriculum(Mode mode) {
        int i;
        this.iMode = mode;
        if (this.iMode.hasTitle()) {
            UniTimePageLabel.getInstance().setPageName(this.iMode.getTitle());
        }
        if (this.iCurriculum.getId() == null) {
            this.iDefaultAbbv = true;
            this.iDefaultName = true;
        } else {
            this.iDefaultAbbv = false;
            this.iDefaultName = false;
        }
        if (this.iDepts.isEmpty() || this.iAreas.isEmpty()) {
            this.iCurriculum.setEditable(false);
        }
        this.iCurriculumAbbv.clearHint();
        this.iCurriculumName.clearHint();
        this.iCurriculumArea.clearHint();
        this.iMultipleMajor.clearHint();
        this.iCurriculumDept.clearHint();
        this.iCurriculumClasfTable.clearHint();
        this.iTitleAndButtons.clearMessage();
        this.iTitleAndButtons.setEnabled("delete", this.iMode == Mode.DETAILS && this.iCurriculum.getId() != null && this.iCurriculum.isEditable());
        this.iTitleAndButtons.setEnabled("save", this.iCurriculum.isEditable() && this.iMode.isEditable());
        this.iTitleAndButtons.setEnabled("edit", this.iCurriculum.isEditable() && !this.iMode.isEditable());
        this.iTitleAndButtons.setEnabled("print", this.iMode == Mode.DETAILS);
        this.iTitleAndButtons.setEnabled("previous", this.iNavigation != null && this.iNavigation.previous(this.iCurriculum) != null);
        this.iTitleAndButtons.setEnabled("next", this.iNavigation != null && this.iNavigation.next(this.iCurriculum) != null);
        if (this.iCurriculum.hasLastChange() && this.iMode == Mode.DETAILS) {
            ((Label)this.iCurriculaTable.getWidget(7, 1)).setText(this.iCurriculum.getLastChange());
            this.iCurriculaTable.getRowFormatter().setVisible(7, true);
        } else {
            this.iCurriculaTable.getRowFormatter().setVisible(7, false);
        }
        this.iCurriculumAbbv.getWidget().setText(this.iCurriculum.getAbbv());
        this.iCurriculumAbbv.getWidget().setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iCurriculumName.getWidget().setText(this.iCurriculum.getName());
        this.iCurriculumName.getWidget().setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iCurriculumArea.getWidget().setSelectedIndex(0);
        if (this.iCurriculum.getAcademicArea() != null) {
            for (i = 0; i < this.iAreas.size(); ++i) {
                if (!this.iAreas.get(i).getId().equals(this.iCurriculum.getAcademicArea().getId())) continue;
                this.iCurriculumArea.getWidget().setSelectedIndex(1 + i);
            }
        }
        this.iCurriculumArea.setText(this.iCurriculum.getAcademicArea() == null ? "" : this.iCurriculum.getAcademicArea().getName());
        this.iCurriculumArea.setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iCurriculumDept.getWidget().setSelectedIndex(0);
        if (this.iCurriculum.getDepartment() != null) {
            for (i = 0; i < this.iDepts.size(); ++i) {
                if (!this.iDepts.get(i).getId().equals(this.iCurriculum.getDepartment().getId())) continue;
                this.iCurriculumDept.getWidget().setSelectedIndex(1 + i);
            }
        }
        this.iCurriculumDept.setText(this.iCurriculum.getDepartment() == null ? "" : this.iCurriculum.getDepartment().getLabel());
        this.iCurriculumDept.setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iMultipleMajor.setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iMultipleMajor.getWidget().setValue(Boolean.valueOf(this.iCurriculum.isMultipleMajors()));
        this.iMultipleMajor.getWidget().setText(this.iCurriculum.isMultipleMajors() ? MESSAGES.infoMultipleMajorsOn() : MESSAGES.infoMultipleMajorsOff());
        this.iMultipleMajor.setReadOnlyWidget((Widget)new Check(this.iCurriculum.isMultipleMajors(), MESSAGES.infoMultipleMajorsOn(), MESSAGES.infoMultipleMajorsOff()));
        this.iCurriculumMajors.setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.areDetailsEditable() || !this.iMode.isEditable());
        this.iCurriculumMajors.setText(this.iCurriculum.getCodeMajorNames("<br>"));
        this.iCurriculumMajors.setPrintText(this.iCurriculum.getCodeMajorNames("<br>"));
        this.loadMajors(this.iMode.areDetailsEditable(), false);
        this.iCurriculumClasfTable.populate(this.iCurriculum.getClassifications());
        this.iCurriculumClasfTable.setReadOnly(!this.iCurriculum.isEditable() || !this.iMode.isEditable());
        this.iCurriculumCourses.populate(this.iCurriculum, this.iMode.isEditable());
        for (int col = 0; col < this.iClassifications.size(); ++col) {
            if (((CurriculaClassifications)((Object)this.iCurriculumClasfTable.getWidget())).getExpected(col) != null) continue;
            this.iCurriculumCourses.setVisible(col, false);
        }
    }

    public boolean saveCurriculum() {
        CurriculumInterface.MajorInterface m;
        int i;
        boolean ret = true;
        this.iCurriculum.setAbbv(this.iCurriculumAbbv.getWidget().getText());
        if (this.iCurriculum.getAbbv().isEmpty()) {
            this.iCurriculumAbbv.setErrorHint(MESSAGES.hintCurriculumAbbreviationNotSet());
            ret = false;
        }
        this.iCurriculum.setName(this.iCurriculumName.getWidget().getText());
        if (this.iCurriculum.getName().isEmpty()) {
            this.iCurriculumName.setErrorHint(MESSAGES.hintCurriculumNameNotSet());
            ret = false;
        }
        this.iCurriculum.setMultipleMajors(this.iMultipleMajor.getWidget().getValue());
        if (this.iCurriculumArea.getWidget().getSelectedIndex() <= 0) {
            this.iCurriculumArea.setErrorHint(MESSAGES.hintAcademicAreaNotSelected());
            ret = false;
        } else {
            CurriculumInterface.AcademicAreaInterface a = new CurriculumInterface.AcademicAreaInterface();
            a.setId(Long.valueOf(this.iCurriculumArea.getWidget().getValue(this.iCurriculumArea.getWidget().getSelectedIndex())));
            this.iCurriculum.setAcademicArea(a);
        }
        if (this.iCurriculum.hasMajors()) {
            this.iCurriculum.getMajors().clear();
        }
        for (i = 0; i < this.iCurriculumMajors.getWidget().getItemCount(); ++i) {
            if (!this.iCurriculumMajors.getWidget().isItemSelected(i)) continue;
            m = new CurriculumInterface.MajorInterface();
            m.setId(Long.valueOf(this.iCurriculumMajors.getWidget().getValue(i)));
            this.iCurriculum.addMajor(m);
        }
        if (!this.iCurriculum.hasMajors() && !this.iMultipleMajor.getWidget().getValue().booleanValue()) {
            for (i = 0; i < this.iCurriculumMajors.getWidget().getItemCount(); ++i) {
                m = new CurriculumInterface.MajorInterface();
                m.setId(Long.valueOf(this.iCurriculumMajors.getWidget().getValue(i)));
                this.iCurriculum.addMajor(m);
            }
        }
        if (this.iCurriculumMajors.getWidget().getItemCount() == 0 && this.iCurriculumArea.getWidget().getSelectedIndex() > 0 && !this.iAreaHasNoMajors && !this.iMultipleMajor.getWidget().getValue().booleanValue()) {
            this.iCurriculumArea.setErrorHint(MESSAGES.hintAcademicAreaHasNoMajors());
            ret = false;
        }
        if (this.iCurriculumDept.getWidget().getSelectedIndex() <= 0) {
            this.iCurriculumDept.setErrorHint(MESSAGES.hintControllingDepartmentNotSelected());
            ret = false;
        } else {
            CurriculumInterface.DepartmentInterface d = new CurriculumInterface.DepartmentInterface();
            d.setId(Long.valueOf(this.iCurriculumDept.getWidget().getValue(this.iCurriculumDept.getWidget().getSelectedIndex())));
            this.iCurriculum.setDepartment(d);
        }
        if (!((CurriculaClassifications)((Object)this.iCurriculumClasfTable.getWidget())).saveCurriculum(this.iCurriculum)) {
            ret = false;
        }
        if (!this.iCurriculum.hasClassifications()) {
            this.iCurriculumClasfTable.setErrorHint(MESSAGES.hintNoStudentExpectations());
            ret = false;
        }
        if (!this.iCurriculumCourses.saveCurriculum(this.iCurriculum)) {
            ret = false;
        }
        return ret;
    }

    private void loadMajors(final boolean showEmptyCourses, final boolean changed) {
        if (this.iCurriculumArea.getWidget().getSelectedIndex() > 0) {
            this.showLoading("Loading majors ...");
            this.iService.loadMajors(this.iCurriculum.getId(), Long.valueOf(this.iCurriculumArea.getWidget().getValue(this.iCurriculumArea.getWidget().getSelectedIndex())), this.iMultipleMajor.getWidget().getValue(), new AsyncCallback<TreeSet<CurriculumInterface.MajorInterface>>(){

                public void onFailure(Throwable caught) {
                    CurriculumEdit.this.hideLoading();
                }

                public void onSuccess(TreeSet<CurriculumInterface.MajorInterface> result) {
                    if (result == null) {
                        CurriculumEdit.this.iAreaHasNoMajors = true;
                        result = new TreeSet();
                    } else {
                        CurriculumEdit.this.iAreaHasNoMajors = false;
                    }
                    String defaultAbbv = "";
                    String defaultName = "";
                    CurriculumInterface.AcademicAreaInterface area = null;
                    try {
                        if (((ListBox)CurriculumEdit.this.iCurriculumArea.getWidget()).getSelectedIndex() > 0) {
                            area = (CurriculumInterface.AcademicAreaInterface)CurriculumEdit.this.iAreas.get(((ListBox)CurriculumEdit.this.iCurriculumArea.getWidget()).getSelectedIndex() - 1);
                            defaultAbbv = area.getAbbv();
                            defaultName = area.getName();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CurriculumEdit.this.iMajors.clear();
                    CurriculumEdit.this.iMajors.addAll(result);
                    ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).clear();
                    int idx = 0;
                    boolean allSelected = true;
                    CurriculumCookie.getInstance().getCurriculaDisplayMode();
                    for (CurriculumInterface.MajorInterface m : result) {
                        ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).addItem(m.getCode() + " - " + m.getName(), m.getId().toString());
                        if (CurriculumEdit.this.iCurriculum != null && CurriculumEdit.this.iCurriculum.hasMajors()) {
                            ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).setItemSelected(idx, CurriculumEdit.this.iCurriculum.getMajors().contains(m));
                            if (CurriculumEdit.this.iCurriculum.getMajors().contains(m)) {
                                if (!defaultAbbv.contains("/")) {
                                    defaultAbbv = defaultAbbv + "/";
                                    defaultName = defaultName + " / ";
                                } else {
                                    defaultAbbv = defaultAbbv + ",";
                                    defaultName = defaultName + ", ";
                                }
                                defaultAbbv = defaultAbbv + m.getCode();
                                defaultName = defaultName + m.getName();
                            } else {
                                allSelected = false;
                            }
                        }
                        ++idx;
                    }
                    if (defaultName.length() > 100) {
                        defaultName = defaultName.substring(0, 100);
                    }
                    if (defaultAbbv.length() > 40) {
                        defaultAbbv = defaultAbbv.substring(0, 40);
                    }
                    CurriculumEdit.this.iDefaultAbbv = defaultAbbv.equals(((TextBox)CurriculumEdit.this.iCurriculumAbbv.getWidget()).getText());
                    CurriculumEdit.this.iDefaultName = defaultName.equalsIgnoreCase(((TextBox)CurriculumEdit.this.iCurriculumName.getWidget()).getText());
                    if (!CurriculumEdit.this.iDefaultAbbv && allSelected && area != null && area.getAbbv().equals(((TextBox)CurriculumEdit.this.iCurriculumAbbv.getWidget()).getText())) {
                        CurriculumEdit.this.iDefaultAbbv = true;
                    }
                    if (!CurriculumEdit.this.iDefaultName && allSelected && area != null && area.getName().equalsIgnoreCase(((TextBox)CurriculumEdit.this.iCurriculumName.getWidget()).getText())) {
                        CurriculumEdit.this.iDefaultName = true;
                    }
                    ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).setVisibleItemCount(((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).getItemCount() <= 3 ? 3 : (((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).getItemCount() > 10 ? 10 : ((ListBox)CurriculumEdit.this.iCurriculumMajors.getWidget()).getItemCount()));
                    CurriculumEdit.this.loadEnrollments(showEmptyCourses, changed);
                    CurriculumEdit.this.hideLoading();
                }
            });
        } else {
            this.iCurriculumMajors.getWidget().clear();
        }
    }

    private void loadEnrollments(final boolean showEmptyCourses, final boolean changed) {
        if (this.iCurriculumArea.getWidget().getSelectedIndex() >= 0) {
            int i;
            final Long areaId = Long.valueOf(this.iCurriculumArea.getWidget().getValue(this.iCurriculumArea.getWidget().getSelectedIndex()));
            final ArrayList<Long> majorIds = new ArrayList<Long>();
            for (i = 0; i < this.iCurriculumMajors.getWidget().getItemCount(); ++i) {
                if (!this.iCurriculumMajors.getWidget().isItemSelected(i)) continue;
                majorIds.add(Long.valueOf(this.iCurriculumMajors.getWidget().getValue(i)));
            }
            if (majorIds.isEmpty() && !this.iMultipleMajor.getWidget().getValue().booleanValue()) {
                for (i = 0; i < this.iCurriculumMajors.getWidget().getItemCount(); ++i) {
                    majorIds.add(Long.valueOf(this.iCurriculumMajors.getWidget().getValue(i)));
                }
            }
            if (majorIds.isEmpty() && !this.iMultipleMajor.getWidget().getValue().booleanValue() && !this.iAreaHasNoMajors) {
                return;
            }
            this.showLoading(MESSAGES.waitLoadingCourseEnrollments());
            this.iService.computeEnrollmentsAndLastLikes(areaId, majorIds, this.iMultipleMajor.getWidget().getValue(), new AsyncCallback<HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]>>(){

                public void onFailure(Throwable caught) {
                    CurriculumEdit.this.hideLoading();
                }

                public void onSuccess(final HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]> result) {
                    if (((CheckBox)CurriculumEdit.this.iMultipleMajor.getWidget()).getValue().booleanValue() && CurriculumEdit.this.iMode.isEditable() && changed) {
                        CurriculumEdit.this.iService.loadTemplate(areaId, majorIds, new AsyncCallback<CurriculumInterface>(){

                            public void onSuccess(CurriculumInterface template) {
                                CurriculumEdit.this.iCurriculumCourses.populateTemplate(template);
                                CurriculumInterface.CurriculumStudentsInterface[] x = (CurriculumInterface.CurriculumStudentsInterface[])result.get("");
                                for (int col = 0; col < CurriculumEdit.this.iClassifications.size(); ++col) {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setEnrollment(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getEnrollment()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setLastLike(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getLastLike()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setProjection(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getProjection()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setRequested(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getRequested()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setSnapshotProjection(col, x == null || x[col] == null ? null : (!x[col].isSessionHasSnapshotData() ? null : Integer.valueOf(x[col].getSnapshotProjection())));
                                }
                                CurriculumEdit.this.iCurriculumCourses.updateEnrollmentsAndLastLike(result, showEmptyCourses);
                                if (CurriculumEdit.this.iCurriculumClasfTable.isShowingAllColumns()) {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).showAllColumns();
                                } else {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyColumns();
                                }
                                ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyRows();
                                CurriculumEdit.this.hideLoading();
                            }

                            public void onFailure(Throwable caught) {
                                CurriculumInterface.CurriculumStudentsInterface[] x = (CurriculumInterface.CurriculumStudentsInterface[])result.get("");
                                for (int col = 0; col < CurriculumEdit.this.iClassifications.size(); ++col) {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setEnrollment(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getEnrollment()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setLastLike(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getLastLike()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setProjection(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getProjection()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setRequested(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getRequested()));
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setSnapshotProjection(col, x == null || x[col] == null ? null : (!x[col].isSessionHasSnapshotData() ? null : Integer.valueOf(x[col].getSnapshotProjection())));
                                }
                                CurriculumEdit.this.iCurriculumCourses.updateEnrollmentsAndLastLike(result, showEmptyCourses);
                                if (CurriculumEdit.this.iCurriculumClasfTable.isShowingAllColumns()) {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).showAllColumns();
                                } else {
                                    ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyColumns();
                                }
                                ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyRows();
                                CurriculumEdit.this.hideLoading();
                            }
                        });
                    } else {
                        CurriculumInterface.CurriculumStudentsInterface[] x = result.get("");
                        for (int col = 0; col < CurriculumEdit.this.iClassifications.size(); ++col) {
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setEnrollment(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getEnrollment()));
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setLastLike(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getLastLike()));
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setProjection(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getProjection()));
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setRequested(col, x == null || x[col] == null ? null : Integer.valueOf(x[col].getRequested()));
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).setSnapshotProjection(col, x == null || x[col] == null ? null : (!x[col].isSessionHasSnapshotData() ? null : Integer.valueOf(x[col].getSnapshotProjection())));
                        }
                        CurriculumEdit.this.iCurriculumCourses.updateEnrollmentsAndLastLike(result, showEmptyCourses);
                        if (CurriculumEdit.this.iCurriculumClasfTable.isShowingAllColumns()) {
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).showAllColumns();
                        } else {
                            ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyColumns();
                        }
                        ((CurriculaClassifications)((Object)CurriculumEdit.this.iCurriculumClasfTable.getWidget())).hideEmptyRows();
                        CurriculumEdit.this.hideLoading();
                    }
                }
            });
        }
    }

    public void showLoading(String message) {
        LoadingWidget.getInstance().show(message);
    }

    public void hideLoading() {
        LoadingWidget.getInstance().hide();
    }

    public void addEditFinishedHandler(EditFinishedHandler h) {
        this.iEditFinishedHandlers.add(h);
    }

    public void addNew() {
        this.iSaved = false;
        this.iCurriculum = new CurriculumInterface();
        this.iCurriculum.setEditable(true);
        if (this.iDepts.size() == 1) {
            CurriculumInterface.DepartmentInterface d = this.iDepts.get(0);
            this.iCurriculumDept.getWidget().setSelectedIndex(1);
            this.iCurriculum.setDepartment(d);
        }
        this.loadCurriculum(Mode.ADD);
    }

    public void edit(CurriculumInterface curriculum, boolean detailsEditable) {
        this.iSaved = false;
        this.iCurriculum = curriculum;
        this.loadCurriculum(detailsEditable ? Mode.DETAILS : Mode.DIALOG);
    }

    public void setupAreas(TreeSet<CurriculumInterface.AcademicAreaInterface> result) {
        this.iAreas.clear();
        this.iAreas.addAll(result);
        this.iCurriculumArea.getWidget().clear();
        this.iCurriculumArea.getWidget().addItem(MESSAGES.itemSelect(), "");
        for (CurriculumInterface.AcademicAreaInterface area : result) {
            this.iCurriculumArea.getWidget().addItem(area.getAbbv() + " - " + area.getName(), area.getId().toString());
        }
    }

    public void setupDepartments(TreeSet<CurriculumInterface.DepartmentInterface> result) {
        this.iDepts.clear();
        this.iDepts.addAll(result);
        this.iCurriculumDept.getWidget().clear();
        this.iCurriculumDept.getWidget().addItem(MESSAGES.itemSelect(), "");
        for (CurriculumInterface.DepartmentInterface dept : result) {
            this.iCurriculumDept.getWidget().addItem(dept.getLabel(), dept.getId().toString());
        }
    }

    public void setupClassifications(TreeSet<CurriculumInterface.AcademicClassificationInterface> result) {
        this.iClassifications.clear();
        this.iClassifications.addAll(result);
        ((CurriculaClassifications)((Object)this.iCurriculumClasfTable.getWidget())).setup(this.iClassifications);
        this.iCurriculumCourses.link((CurriculaClassifications)((Object)this.iCurriculumClasfTable.getWidget()));
    }

    public void showOnlyCourses(TreeSet<CurriculumInterface.CourseInterface> courses) {
        this.iCurriculumCourses.showOnlyCourses(courses);
    }

    public void reload(final Mode mode) {
        this.showLoading(MESSAGES.waitLoadingCurriculumWithName(this.iCurriculum.getName()));
        this.iService.loadCurriculum(this.iCurriculum.getId(), new AsyncCallback<CurriculumInterface>(){

            public void onFailure(Throwable caught) {
                CurriculumEdit.this.hideLoading();
            }

            public void onSuccess(CurriculumInterface result) {
                CurriculumEdit.this.iCurriculum = result;
                CurriculumEdit.this.loadCurriculum(mode);
                CurriculumEdit.this.hideLoading();
            }
        });
    }

    public CurriculumInterface getCurriculum() {
        return this.iCurriculum;
    }

    static class Check
    extends P {
        Check(boolean value, String onMessage, String offMessage) {
            super(new String[0]);
            Image image = new Image(value ? RESOURCES.on() : RESOURCES.off());
            image.addStyleName("image");
            this.add((Widget)image);
            InlineHTML text = new InlineHTML(value ? onMessage : offMessage);
            text.addStyleName("message");
            this.add((Widget)text);
            if (value) {
                this.addStyleName("check-enabled");
            } else {
                this.addStyleName("check-disabled");
            }
        }
    }

    public static interface NavigationProvider {
        public CurriculumInterface previous(CurriculumInterface var1);

        public CurriculumInterface next(CurriculumInterface var1);

        public void onChange(CurriculumInterface var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurriculaClassificationsPanel
    extends UniTimeWidget<CurriculaClassifications>
    implements SimpleForm.HasMobileScroll {
        private Label iHint = new Label();

        public CurriculaClassificationsPanel(CurriculaClassifications classifications) {
            super(classifications);
            this.iHint.setStyleName("unitime-Hint");
            this.iHint.setVisible(true);
            this.iHint.addStyleName("unitime-NoPrint");
            this.getPanel().insert((Widget)this.iHint, 1);
            this.iHint.setText(MESSAGES.hintShowAllColumns());
            this.iHint.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (CurriculaClassificationsPanel.this.isShowingAllColumns()) {
                        ((CurriculaClassifications)((Object)CurriculaClassificationsPanel.this.getWidget())).hideEmptyColumns();
                        CurriculaClassificationsPanel.this.iHint.setText(MESSAGES.hintShowAllColumns());
                    } else {
                        ((CurriculaClassifications)((Object)CurriculaClassificationsPanel.this.getWidget())).showAllColumns();
                        CurriculaClassificationsPanel.this.iHint.setText(MESSAGES.hintHideEmptyColumns());
                    }
                }
            });
            ((CurriculaClassifications)((Object)this.getWidget())).addExpectedChangedHandler(new CurriculaClassifications.ExpectedChangedHandler(){

                public void expectedChanged(CurriculaClassifications.ExpectedChangedEvent e) {
                    CurriculaClassificationsPanel.this.clearHint();
                }
            });
            ((CurriculaClassifications)((Object)this.getWidget())).addNameChangedHandler(new CurriculaClassifications.NameChangedHandler(){

                public void nameChanged(CurriculaClassifications.NameChangedEvent e) {
                    CurriculaClassificationsPanel.this.clearHint();
                }
            });
        }

        public boolean isShowingAllColumns() {
            return this.iHint.getText().equals(MESSAGES.hintHideEmptyColumns());
        }

        public void populate(TreeSet<CurriculumInterface.CurriculumClassificationInterface> classifications) {
            ((CurriculaClassifications)((Object)this.getWidget())).populate(classifications);
            if (this.isShowingAllColumns()) {
                ((CurriculaClassifications)((Object)this.getWidget())).showAllColumns();
            } else {
                ((CurriculaClassifications)((Object)this.getWidget())).hideEmptyColumns();
            }
            ((CurriculaClassifications)((Object)this.getWidget())).hideEmptyRows();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            ((CurriculaClassifications)((Object)this.getWidget())).setEnabled(!readOnly);
            this.iHint.setVisible(!readOnly);
        }
    }

    public static interface EditFinishedHandler {
        public void onBack(EditFinishedEvent var1);

        public void onDelete(EditFinishedEvent var1);

        public void onSave(EditFinishedEvent var1);
    }

    public static class EditFinishedEvent {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ADD(MESSAGES.pageAddCurriculum(), true, true),
        EDIT(MESSAGES.pageEditCurriculum(), true, true),
        DETAILS(MESSAGES.pageCurriculumDetails(), false, false),
        DIALOG(null, true, false);

        private String iTitle;
        private boolean iEditable;
        private boolean iEditableDetails;

        private Mode(String title, boolean editable, boolean details) {
            this.iTitle = title;
            this.iEditable = editable;
            this.iEditableDetails = details;
        }

        public boolean hasTitle() {
            return this.iTitle != null;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public boolean areDetailsEditable() {
            return this.iEditableDetails;
        }
    }
}

