/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.gwt.shared.TaskInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksTable
extends UniTimeTable<TaskInterface>
implements TakesValue<List<TaskInterface>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private TasksTableColumn iSortBy = null;
    private boolean iAsc = true;
    private TaskInterface.TaskOptionsInterface iOptions;
    private static DateTimeFormat sDateFormatShort = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormatShort());
    private static DateTimeFormat sDateFormatLong = ServerDateTimeFormat.getFormat(CONSTANTS.eventDateFormatLong());

    public TasksTable() {
        this.setStyleName("unitime-PeriodicTaskTable");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final TasksTableColumn column : TasksTableColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final TasksTableColumn column : TasksTableColumn.values()) {
            if (!TasksTableComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    TasksTable.this.doSort(column);
                }

                public boolean isApplicable() {
                    return TasksTable.this.getRowCount() > 1 && h.isVisible();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(AdminCookie.getInstance().getSortTasksBy());
    }

    public void setOptions(TaskInterface.TaskOptionsInterface options) {
        this.iOptions = options;
    }

    public TaskInterface.TaskOptionsInterface getOptions() {
        return this.iOptions;
    }

    protected void doSort(TasksTableColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortTasksBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = TasksTableColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = TasksTableColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = TasksTableColumn.NAME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new TasksTableComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(TasksTableColumn column) {
        switch (column) {
            default: 
        }
        return 1;
    }

    public String getColumnName(TasksTableColumn column, int idx) {
        switch (column) {
            case NAME: {
                return MESSAGES.colTaskName();
            }
            case SCRIPT: {
                return MESSAGES.colTaskScript();
            }
            case OWNER: {
                return MESSAGES.colTaskOwner();
            }
            case PARAMETERS: {
                return MESSAGES.colTaskParameters();
            }
            case DATE: {
                return MESSAGES.colTaskScheduleDate();
            }
            case TIME: {
                return MESSAGES.colTaskScheduleTime();
            }
            case STATUS: {
                return MESSAGES.colTaskStatus();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(TasksTableColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(TasksTableColumn column) {
        int ret = 0;
        for (TasksTableColumn c : TasksTableColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(TaskInterface task, TasksTableColumn column, int idx) {
        switch (column) {
            case NAME: {
                return new Label(task.getName());
            }
            case SCRIPT: {
                return new Label(task.getScript().getName());
            }
            case OWNER: {
                return new Label(task.getOwner().getFormattedName(false));
            }
            case PARAMETERS: {
                String parameters = "";
                if (task.getScript().hasParameters()) {
                    for (ScriptInterface.ScriptParameterInterface parameter : task.getScript().getParameters()) {
                        String value = task.getParameter(parameter.getName());
                        if (parameter.hasOptions() && value != null && !value.isEmpty()) {
                            if (parameter.isMultiSelect()) {
                                String ids = value;
                                value = "";
                                for (String id : ids.split(",")) {
                                    value = value + (value.isEmpty() ? "" : ", ") + parameter.getOption(id);
                                }
                            } else {
                                value = parameter.getOption(value);
                            }
                        }
                        if ("slot".equalsIgnoreCase(parameter.getType()) || "time".equalsIgnoreCase(parameter.getType()) && value != null && !value.isEmpty()) {
                            try {
                                value = TimeSelector.TimeUtils.slot2time(Integer.parseInt(value));
                            }
                            catch (Exception ids) {
                                // empty catch block
                            }
                        }
                        if (value == null) continue;
                        parameters = parameters + (parameters.isEmpty() ? "" : "<br>") + parameter.getLabel() + ": " + value;
                    }
                }
                final P p = new P("parameters");
                p.setHTML(parameters);
                p.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        GwtHint.showHint(event.getRelativeElement(), (Widget)new HTML(p.getHTML(), true));
                    }
                });
                p.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        GwtHint.hideHint();
                    }
                });
                return p;
            }
            case DATE: {
                String dates = "";
                for (TaskInterface.MultiExecutionInterface exec : TaskInterface.getMultiExecutions(task.getExecutions(), false)) {
                    if (exec.getNrMeetings() == 1) {
                        dates = dates + (dates.isEmpty() ? "" : "<br>") + "<span class='status-" + exec.getStatus().name().toLowerCase() + "'>" + exec.getDays(this.iOptions.getFirstDayOfWeek(), CONSTANTS) + " " + sDateFormatLong.format(exec.getFirstExecutionDate()) + "</span>";
                        continue;
                    }
                    dates = dates + (dates.isEmpty() ? "" : "<br>") + "<span class='status-" + exec.getStatus().name().toLowerCase() + "'>" + exec.getDays(this.iOptions.getFirstDayOfWeek(), CONSTANTS) + " " + sDateFormatShort.format(exec.getFirstExecutionDate()) + " - " + sDateFormatLong.format(exec.getLastExecutionDate()) + "</span>";
                }
                return new HTML(dates, false);
            }
            case TIME: {
                String times = "";
                for (TaskInterface.MultiExecutionInterface exec : TaskInterface.getMultiExecutions(task.getExecutions(), false)) {
                    if (exec.getNrMeetings() == 1) {
                        times = times + (times.isEmpty() ? "" : "<br>") + "<span class='status-" + exec.getStatus().name().toLowerCase() + "'>" + exec.getExecutionTime(CONSTANTS) + "</span>";
                        continue;
                    }
                    times = times + (times.isEmpty() ? "" : "<br>") + "<span class='status-" + exec.getStatus().name().toLowerCase() + "'>" + exec.getExecutionTime(CONSTANTS) + "</span>";
                }
                return new HTML(times, false);
            }
            case STATUS: {
                String statuses = "";
                for (TaskInterface.MultiExecutionInterface exec : TaskInterface.getMultiExecutions(task.getExecutions(), false)) {
                    statuses = statuses + (statuses.isEmpty() ? "" : "<br>") + "<span class='status-" + exec.getStatus().name().toLowerCase() + "'>" + CONSTANTS.taskStatus()[exec.getStatus().ordinal()] + "</span>";
                }
                return new HTML(statuses, false);
            }
        }
        return null;
    }

    public int getRow(Long taskId) {
        if (taskId == null) {
            return -1;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            TaskInterface task = (TaskInterface)this.getData(row);
            if (task == null || !taskId.equals(task.getId())) continue;
            return row;
        }
        return -1;
    }

    public void scrollToTask(Long taskId) {
        if (taskId == null) {
            return;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            TaskInterface task = (TaskInterface)this.getData(row);
            if (task == null || !taskId.equals(task.getId())) continue;
            this.getRowFormatter().getElement(row).scrollIntoView();
            return;
        }
    }

    public int addTask(TaskInterface task) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (TasksTableColumn column : TasksTableColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(task, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(task, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    public void setValue(List<TaskInterface> value) {
        this.clearTable(1);
        if (value != null) {
            for (TaskInterface task : value) {
                this.addTask(task);
            }
        }
        this.sort();
    }

    public List<TaskInterface> getValue() {
        return this.getData();
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TasksTableColumn {
        NAME,
        OWNER,
        SCRIPT,
        PARAMETERS,
        DATE,
        TIME,
        STATUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TasksTableComparator
    implements Comparator<TaskInterface> {
        private TasksTableColumn iColumn;
        private boolean iAsc;

        public TasksTableComparator(TasksTableColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        protected int compareByName(TaskInterface t1, TaskInterface t2) {
            return this.compare(t1.getName(), t2.getName());
        }

        protected int compareByOwner(TaskInterface t1, TaskInterface t2) {
            return this.compare(t1.getOwner() == null ? "" : t1.getOwner().getLastName() + ", " + t1.getOwner().getFirstName() + " " + t1.getOwner().getMiddleName(), t2.getOwner() == null ? "" : t2.getOwner().getLastName() + ", " + t2.getOwner().getFirstName() + " " + t2.getOwner().getMiddleName());
        }

        protected int compareByScript(TaskInterface t1, TaskInterface t2) {
            return this.compare(t1.getScript() == null ? "" : t1.getScript().getName(), t2.getScript() == null ? "" : t2.getScript().getName());
        }

        protected int compareByDate(TaskInterface t1, TaskInterface t2) {
            int cmp = this.compare(t1.getLastExecuted(), t2.getLastExecuted());
            if (cmp != 0) {
                return cmp;
            }
            TaskInterface.TaskExecutionInterface e1 = null;
            TaskInterface.TaskExecutionInterface e2 = null;
            for (TaskInterface.TaskExecutionInterface e : t1.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e1 = e;
                break;
            }
            for (TaskInterface.TaskExecutionInterface e : t2.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e2 = e;
                break;
            }
            return e1 == null ? (e2 == null ? 0 : -1) : (e2 == null ? 1 : e1.compareTo(e2));
        }

        protected int compareByTime(TaskInterface t1, TaskInterface t2) {
            int cmp = this.compare(t1.getLastExecuted(), t2.getLastExecuted());
            if (cmp != 0) {
                return cmp;
            }
            TaskInterface.TaskExecutionInterface e1 = null;
            TaskInterface.TaskExecutionInterface e2 = null;
            for (TaskInterface.TaskExecutionInterface e : t1.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e1 = e;
                break;
            }
            for (TaskInterface.TaskExecutionInterface e : t2.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e2 = e;
                break;
            }
            return e1 == null ? (e2 == null ? 0 : -1) : (e2 == null ? 1 : e1.compareTo(e2));
        }

        protected int compareByTime(TaskInterface.TaskExecutionInterface t1, TaskInterface.TaskExecutionInterface t2) {
            int cmp = new Integer(t1.getSlot()).compareTo(t2.getSlot());
            if (cmp != 0) {
                return cmp;
            }
            return t1.getDayOfYear().compareTo(t2.getDayOfYear());
        }

        protected int compareByStatus(TaskInterface t1, TaskInterface t2) {
            int cmp;
            int n = t1.getLastStatus() == null ? (t1.getLastStatus() == null ? 0 : -1) : (cmp = t2.getLastStatus() == null ? 1 : t1.getLastStatus().compareTo(t2.getLastStatus()));
            if (cmp != 0) {
                return cmp;
            }
            TaskInterface.TaskExecutionInterface e1 = null;
            TaskInterface.TaskExecutionInterface e2 = null;
            for (TaskInterface.TaskExecutionInterface e : t1.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e1 = e;
                break;
            }
            for (TaskInterface.TaskExecutionInterface e : t2.getExecutions()) {
                if (e.getStatus() != TaskInterface.ExecutionStatus.CREATED) continue;
                e2 = e;
                break;
            }
            return e1 == null ? (e2 == null ? 0 : -1) : (e2 == null ? 1 : e1.compareTo(e2));
        }

        protected int compareByColumn(TaskInterface t1, TaskInterface t2) {
            switch (this.iColumn) {
                case NAME: {
                    return this.compareByName(t1, t2);
                }
                case SCRIPT: {
                    return this.compareByScript(t1, t2);
                }
                case OWNER: {
                    return this.compareByOwner(t1, t2);
                }
                case DATE: {
                    return this.compareByDate(t1, t2);
                }
                case TIME: {
                    return this.compareByTime(t1, t2);
                }
                case STATUS: {
                    return this.compareByStatus(t1, t2);
                }
            }
            return t1.compareTo(t2);
        }

        public static boolean isApplicable(TasksTableColumn column) {
            switch (column) {
                case NAME: 
                case SCRIPT: 
                case OWNER: 
                case DATE: 
                case TIME: 
                case STATUS: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(TaskInterface t1, TaskInterface t2) {
            int cmp = this.compareByColumn(t1, t2);
            if (cmp != 0) {
                return this.iAsc ? cmp : -cmp;
            }
            return this.iAsc ? t1.compareTo(t2) : t2.compareTo(t1);
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Date n1, Date n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : n1.compareTo(n2));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }
    }
}

