/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.Session;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.dao.RoomTypeDAO;

public class RoomTypeEditForm
extends ActionForm {
    private static final long serialVersionUID = 3139971302727896389L;
    private String iOp;
    private Long iUniqueId;
    private String iReference;
    private String iLabel;
    private boolean iCanEdit = false;
    private int iType = 0;
    private int iOrder = -1;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iReference == null || this.iReference.trim().length() == 0) {
            errors.add("reference", new ActionMessage("errors.required", (Object)""));
        } else {
            try {
                RoomType rt = RoomType.findByReference(this.iReference);
                if (rt != null && !rt.getUniqueId().equals(this.iUniqueId)) {
                    errors.add("reference", new ActionMessage("errors.exists", (Object)this.iReference));
                }
            }
            catch (Exception e) {
                errors.add("reference", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        if (this.iLabel == null || this.iLabel.trim().length() == 0) {
            errors.add("label", new ActionMessage("errors.required", (Object)""));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = "List";
        this.iUniqueId = new Long(-1L);
        this.iReference = null;
        this.iLabel = null;
        this.iCanEdit = false;
        this.iType = 0;
        this.iOrder = RoomType.findAll().size();
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    public String getReference() {
        return this.iReference;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public String getLabel() {
        return this.iLabel;
    }

    public void setOrder(int order) {
        this.iOrder = order;
    }

    public int getOrder() {
        return this.iOrder;
    }

    public void setCanEdit(boolean canEdit) {
        this.iCanEdit = canEdit;
    }

    public boolean getCanEdit() {
        return this.iCanEdit;
    }

    public void setType(int type) {
        this.iType = type;
    }

    public int getType() {
        return this.iType;
    }

    public void load(RoomType t) {
        if (t == null) {
            this.reset(null, null);
            this.setCanEdit(true);
            this.setOp("Save");
        } else {
            this.setUniqueId(t.getUniqueId());
            this.setReference(t.getReference());
            this.setLabel(t.getLabel());
            this.setType(t.isRoom() != false ? 0 : 1);
            this.setCanEdit(t.countRooms() == 0);
            this.setOrder(t.getOrd());
            this.setOp("Update");
        }
    }

    public RoomType saveOrUpdate(Session hibSession) throws Exception {
        RoomType t = null;
        if (this.getUniqueId().intValue() >= 0) {
            t = (RoomType)RoomTypeDAO.getInstance().get(this.getUniqueId());
        }
        if (t == null) {
            t = new RoomType();
        }
        t.setReference(this.getReference());
        t.setLabel(this.getLabel());
        t.setRoom(this.getType() == 0);
        if (t.getOrd() == null) {
            t.setOrd(RoomType.findAll().size());
        }
        hibSession.saveOrUpdate((Object)t);
        this.setUniqueId(t.getUniqueId());
        return t;
    }

    public void delete(Session hibSession) throws Exception {
        if (this.getUniqueId().intValue() < 0) {
            return;
        }
        RoomType t = (RoomType)RoomTypeDAO.getInstance().get(this.getUniqueId());
        if (t != null) {
            for (RoomType other : RoomTypeDAO.getInstance().findAll(hibSession)) {
                if (other.getOrd() <= t.getOrd()) continue;
                other.setOrd(other.getOrd() - 1);
                hibSession.saveOrUpdate((Object)other);
            }
            hibSession.delete((Object)t);
        }
    }
}

