/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.webutil.WebTextValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRoomForm
extends ActionForm {
    private static final long serialVersionUID = 9208856268545264291L;
    private String doit;
    private String id;
    private String name;
    private String capacity;
    private Boolean ignoreTooFar;
    private Boolean ignoreRoomCheck;
    private String controlDept;
    private String eventDepartment;
    private String bldgName;
    private String bldgId;
    private String coordX;
    private String coordY;
    private String externalId;
    private Long type;
    private boolean room;
    private Map<String, Boolean> examEnabled = new HashMap<String, Boolean>();
    private String examCapacity;
    private String area;
    private String breakTime;
    private String note;
    private Integer eventStatus;

    public Boolean getIgnoreTooFar() {
        return this.ignoreTooFar;
    }

    public Boolean getIgnoreRoomCheck() {
        return this.ignoreRoomCheck;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public Boolean isIgnoreTooFar() {
        return this.ignoreTooFar;
    }

    public void setIgnoreTooFar(Boolean ignoreTooFar) {
        this.ignoreTooFar = ignoreTooFar;
    }

    public Boolean isIgnoreRoomCheck() {
        return this.ignoreRoomCheck;
    }

    public void setIgnoreRoomCheck(Boolean ignoreRoomCheck) {
        this.ignoreRoomCheck = ignoreRoomCheck;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setControlDept(String controlDept) {
        this.controlDept = controlDept;
    }

    public String getControlDept() {
        return this.controlDept;
    }

    public String getBldgName() {
        return this.bldgName;
    }

    public void setBldgName(String bldgName) {
        this.bldgName = bldgName;
    }

    public String getCoordX() {
        return this.coordX;
    }

    public void setCoordX(String coordX) {
        this.coordX = coordX;
    }

    public String getCoordY() {
        return this.coordY;
    }

    public void setCoordY(String coordY) {
        this.coordY = coordY;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = "".equals(id) ? null : id;
    }

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public boolean isRoom() {
        return this.room;
    }

    public void setRoom(boolean room) {
        this.room = room;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public String getBldgId() {
        return this.bldgId;
    }

    public void setBldgId(String bldgId) {
        this.bldgId = bldgId;
    }

    private static SessionContext getSessionContext(HttpSession session) {
        return HttpSessionContext.getSessionContext(session.getServletContext());
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (!(this.id != null && this.id.length() != 0 || this.bldgId != null && this.bldgId.length() != 0)) {
            errors.add("Building", new ActionMessage("errors.required", (Object)"Building"));
        }
        if (this.name == null || this.name.equalsIgnoreCase("")) {
            errors.add("Name", new ActionMessage("errors.required", (Object)"Name"));
        }
        if (!this.room && this.name != null && this.name.length() > 0) {
            Debug.info("checking location regex 2");
            String nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
            String nonUniversityLocationInfo = ApplicationProperty.NonUniversityLocationPatternInfo.value();
            if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                try {
                    Pattern pattern = Pattern.compile(nonUniversityLocationRegex);
                    Matcher matcher = pattern.matcher(this.name);
                    if (!matcher.find()) {
                        errors.add("nonUniversityLocation", new ActionMessage("errors.generic", (Object)nonUniversityLocationInfo));
                    }
                }
                catch (Exception e) {
                    errors.add("nonUniversityLocation", new ActionMessage("errors.generic", (Object)("Non University Location cannot be matched to regular expression: " + nonUniversityLocationRegex + ". Reason: " + e.getMessage())));
                }
            } else if (!WebTextValidation.isTextValid(this.name, true)) {
                errors.add("nonUniversityLocation", new ActionMessage("errors.invalidCharacters", (Object)"Name"));
            }
        }
        if (this.room && this.name != null && this.name.length() > 0) {
            Room room;
            if (this.id == null || this.id.length() == 0) {
                if (this.bldgId != null && this.bldgId.length() > 0) {
                    try {
                        room = Room.findByBldgIdRoomNbr(Long.valueOf(this.bldgId), this.name, EditRoomForm.getSessionContext(request.getSession()).getUser().getCurrentAcademicSessionId());
                        if (room != null) {
                            errors.add("Name", new ActionMessage("errors.exists", (Object)room.getLabel()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    room = Room.findByBldgIdRoomNbr(((Room)new RoomDAO().get(Long.valueOf(this.id))).getBuilding().getUniqueId(), this.name, EditRoomForm.getSessionContext(request.getSession()).getUser().getCurrentAcademicSessionId());
                    if (room != null && !room.getUniqueId().toString().equals(this.id)) {
                        errors.add("Name", new ActionMessage("errors.exists", (Object)room.getLabel()));
                    }
                }
                catch (Exception room2) {
                    // empty catch block
                }
            }
        }
        if (this.capacity == null || this.capacity.equalsIgnoreCase("")) {
            errors.add("Capacity", new ActionMessage("errors.required", (Object)"Capacity"));
        }
        boolean exams = false;
        for (Boolean x : this.examEnabled.values()) {
            if (!x.booleanValue()) continue;
            exams = true;
            break;
        }
        if (exams && (this.examCapacity == null || this.examCapacity.equalsIgnoreCase(""))) {
            errors.add("examCapacity", new ActionMessage("errors.required", (Object)"Examination Seating Capacity"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.bldgName = null;
        this.capacity = null;
        this.coordX = null;
        this.coordY = null;
        this.doit = null;
        this.externalId = null;
        this.id = null;
        this.name = null;
        this.room = true;
        this.type = null;
        this.bldgId = null;
        this.ignoreTooFar = Boolean.FALSE;
        this.ignoreRoomCheck = Boolean.FALSE;
        this.examEnabled.clear();
        this.examCapacity = null;
        this.eventStatus = RoomTypeOption.getDefaultStatus();
    }

    public boolean getExamEnabled(String type) {
        Boolean enabled = this.examEnabled.get(type);
        return enabled != null && enabled != false;
    }

    public void setExamEnabled(String type, boolean examEnabled) {
        this.examEnabled.put(type, examEnabled);
    }

    public String getExamCapacity() {
        return this.examCapacity;
    }

    public void setExamCapacity(String examCapacity) {
        this.examCapacity = examCapacity;
    }

    public Set<RoomType> getRoomTypes() {
        return RoomType.findAll(this.room);
    }

    public String getEventDepartment() {
        return this.eventDepartment;
    }

    public void setEventDepartment(String eventDepartment) {
        this.eventDepartment = eventDepartment;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getBreakTime() {
        return this.breakTime;
    }

    public void setBreakTime(String breakTime) {
        this.breakTime = breakTime;
    }

    public Integer getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(Integer eventStatus) {
        this.eventStatus = eventStatus;
    }

    public List<IdValue> getEventStates() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        ret.add(new IdValue(-1L, "Default"));
        for (RoomTypeOption.Status state : RoomTypeOption.Status.values()) {
            ret.add(new IdValue(new Long(state.ordinal()), state.toString()));
        }
        return ret;
    }
}

