/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.TilesUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;

public class PageAccessFilter
implements Filter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(PageAccessFilter.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private ServletContext iContext;
    private Hashtable<String, String> iPath2Tile = new Hashtable();
    private long debugTime = 30000L;
    private long dumpTime = 300000L;
    private boolean dumpSessionAttribues = false;

    public void init(FilterConfig cfg) throws ServletException {
        this.iContext = cfg.getServletContext();
        try {
            Document config = new SAXReader().read(cfg.getServletContext().getResource(cfg.getInitParameter("config")));
            Iterator i = config.getRootElement().element("action-mappings").elementIterator("action");
            while (i.hasNext()) {
                Element action = (Element)i.next();
                String path = action.attributeValue("path");
                String input = action.attributeValue("input");
                if (path == null || input == null) continue;
                this.iPath2Tile.put(path + ".do", input);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to read config " + cfg.getInitParameter("config") + ", reason: " + e.getMessage()));
        }
        if (cfg.getInitParameter("debug-time") != null) {
            this.debugTime = Long.parseLong(cfg.getInitParameter("debug-time"));
        }
        if (cfg.getInitParameter("dump-time") != null) {
            this.dumpTime = Long.parseLong(cfg.getInitParameter("dump-time"));
        }
        if (cfg.getInitParameter("session-attributes") != null) {
            this.dumpSessionAttribues = Boolean.parseBoolean(cfg.getInitParameter("session-attributes"));
        }
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest r;
            long t0;
            block30: {
                HttpServletRequest r2;
                t0 = System.currentTimeMillis();
                UserContext user = this.getUser();
                if (user != null) {
                    ApplicationProperties.setSessionId(user.getCurrentAcademicSessionId());
                }
                if (request instanceof HttpServletRequest && (r2 = (HttpServletRequest)request).getRequestURI().endsWith(".do")) {
                    ComponentDefinition c;
                    HttpServletResponse x;
                    block33: {
                        block31: {
                            block32: {
                                x = (HttpServletResponse)response;
                                String def = r2.getRequestURI().substring(r2.getContextPath().length());
                                if (!this.iPath2Tile.containsKey(def)) break block30;
                                String tile = this.iPath2Tile.get(def);
                                c = TilesUtil.getDefinition((String)tile, (ServletRequest)request, (ServletContext)this.iContext);
                                HttpSession s = r2.getSession();
                                if (c == null || !"true".equals(c.getAttribute("checkLogin")) || user != null) break block31;
                                sLog.warn((Object)("Page " + r2.getRequestURI() + " denied: user not logged in"));
                                if (s.isNew()) {
                                    x.sendRedirect(x.encodeURL(r2.getContextPath() + "/loginRequired.do?message=" + MESSAGES.authenticationExpired()));
                                    break block32;
                                }
                                x.sendRedirect(x.encodeURL(r2.getContextPath() + "/loginRequired.do?message=" + MESSAGES.authenticationRequired()));
                            }
                            Object var16_15 = null;
                            ApplicationProperties.setSessionId(null);
                            return;
                        }
                        if (c == null || !"true".equals(c.getAttribute("checkRole")) || user != null && user.getCurrentAuthority() != null && user.getCurrentAuthority().hasRight(Right.HasRole)) break block33;
                        sLog.warn((Object)("Page " + r2.getRequestURI() + " denined: no role"));
                        x.sendRedirect(x.encodeURL(r2.getContextPath() + "/loginRequired.do?message=" + MESSAGES.authenticationInsufficient()));
                        Object var16_16 = null;
                        ApplicationProperties.setSessionId(null);
                        return;
                    }
                    try {
                        if (c == null || !"true".equals(c.getAttribute("checkAdmin")) || user != null && user.getCurrentAuthority() != null && user.getCurrentAuthority().hasRight(Right.IsAdmin)) break block30;
                        sLog.warn((Object)("Page " + r2.getRequestURI() + " denied: user not admin"));
                        x.sendRedirect(x.encodeURL(r2.getContextPath() + "/loginRequired.do?message=" + MESSAGES.authenticationInsufficient()));
                    }
                    catch (Exception e) {
                        sLog.warn((Object)("Unable to check page access for " + r2.getRequestURI() + ", reason: " + e.getMessage()), (Throwable)e);
                    }
                    Object var16_17 = null;
                    ApplicationProperties.setSessionId(null);
                    return;
                }
            }
            Throwable exception = null;
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                exception = t;
            }
            long t1 = System.currentTimeMillis();
            if (request instanceof HttpServletRequest && (t1 - t0 > this.debugTime || exception != null)) {
                UserContext u;
                r = (HttpServletRequest)request;
                String message = "Page " + r.getRequestURI() + " took " + sDF.format((double)(t1 - t0) / 1000.0) + " s.";
                if (exception != null) {
                    message = exception + " seen on page " + r.getRequestURI() + " (page took " + sDF.format((double)(t1 - t0) / 1000.0) + " s).";
                }
                if (exception == null && t1 - t0 <= this.dumpTime) {
                    u = this.getUser();
                    message = u == null ? message + "  (User: no user)" : message + "  (User: " + u.getUsername() + (u.getCurrentAuthority() != null ? " (" + u.getCurrentAuthority() + ")" : "");
                } else {
                    String n;
                    u = null;
                    try {
                        u = this.getUser();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    message = u == null ? message + "\n  User: no user" : message + "\n  User: " + u.getUsername() + (u.getCurrentAuthority() != null ? " (" + u.getCurrentAuthority() + ")" : "");
                    message = message + "\n  Request parameters:";
                    Enumeration e = r.getParameterNames();
                    while (e.hasMoreElements()) {
                        n = (String)e.nextElement();
                        if ("password".equals(n)) continue;
                        message = message + "\n    " + n + "=" + r.getParameter(n);
                    }
                    try {
                        if (this.dumpSessionAttribues && r.getSession() != null) {
                            message = message + "\n  Session attributes:";
                            e = r.getSession().getAttributeNames();
                            while (e.hasMoreElements()) {
                                n = (String)e.nextElement();
                                message = message + "\n    " + n + "=" + r.getSession().getAttribute(n);
                            }
                        }
                    }
                    catch (IllegalStateException e2) {
                        message = message + "\n    INVALID SESSION";
                    }
                }
                if (exception != null) {
                    sLog.warn((Object)message);
                } else {
                    sLog.info((Object)message);
                }
            }
            if (exception != null) {
                if (exception instanceof PageAccessException && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                    r = (HttpServletRequest)request;
                    HttpServletResponse x = (HttpServletResponse)response;
                    String message = exception.getMessage();
                    if (message == null || message.isEmpty()) {
                        HttpSession s = r.getSession();
                        message = this.getUser() == null ? (s.isNew() ? MESSAGES.authenticationExpired() : MESSAGES.authenticationRequired()) : MESSAGES.authenticationInsufficient();
                    }
                    x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + message));
                } else {
                    if (exception instanceof ServletException) {
                        throw (ServletException)exception;
                    }
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (!(exception instanceof RuntimeException)) throw new ServletException(exception);
                    throw (RuntimeException)exception;
                }
            }
            Object var16_18 = null;
            ApplicationProperties.setSessionId(null);
            return;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            ApplicationProperties.setSessionId(null);
            throw throwable;
        }
    }

    public void destroy() {
    }
}

