/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.students;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusPage;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:student-dashboard.csv")
public class StudentSchedulingDashboardExportCSV
implements Exporter {
    protected static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static DecimalFormat sCreditFormat = new DecimalFormat("0.#");
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public String reference() {
        return "student-dashboard.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        boolean online = "1".equals(helper.getParameter("online"));
        int tab = 0;
        try {
            tab = Integer.parseInt(helper.getParameter("tab"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String query = helper.getParameter("query");
        int sort = 0;
        try {
            sort = Integer.parseInt(helper.getParameter("sort"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter = new SectioningStatusFilterBox.SectioningStatusFilterRpcRequest();
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("f:text")) {
                filter.setText(helper.getParameter("e:text"));
                continue;
            }
            if (!command.startsWith("f:")) continue;
            for (String value : helper.getParameterValues(command)) {
                filter.addOption(command.substring(2), value);
            }
        }
        SectioningService service = (SectioningService)this.applicationContext.getBean("sectioning.gwt");
        if (tab == 0) {
            List<ClassAssignmentInterface.EnrollmentInfo> enrollments;
            HashSet<Long> courseIds = new HashSet<Long>();
            if (helper.getParameter("c") != null) {
                for (String value : helper.getParameterValues("c")) {
                    courseIds.add(Long.valueOf(value));
                }
            }
            if ((enrollments = service.findEnrollmentInfos(online, query, filter, null)) != null && sort != 0) {
                boolean asc = sort > 0;
                SectioningStatusPage.EnrollmentComparator.SortBy sortBy = SectioningStatusPage.EnrollmentComparator.SortBy.values()[Math.abs(sort) - 1];
                Collections.sort(enrollments, new SectioningStatusPage.EnrollmentComparator(sortBy, asc));
                if (!asc) {
                    Collections.reverse(enrollments);
                }
            }
            if (!courseIds.isEmpty() && enrollments != null) {
                ArrayList<ClassAssignmentInterface.EnrollmentInfo> allEnrollments = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
                for (ClassAssignmentInterface.EnrollmentInfo e2 : enrollments) {
                    List<ClassAssignmentInterface.EnrollmentInfo> classEnrollments;
                    allEnrollments.add(e2);
                    if (e2.getCourseId() == null || !courseIds.contains(e2.getCourseId()) || (classEnrollments = service.findEnrollmentInfos(online, query, filter, e2.getCourseId())) == null) continue;
                    allEnrollments.addAll(classEnrollments);
                }
                this.populateCourseTable(helper, allEnrollments);
            } else {
                this.populateCourseTable(helper, enrollments);
            }
        } else if (tab == 1) {
            List<ClassAssignmentInterface.StudentInfo> students = service.findStudentInfos(online, query, filter);
            if (students != null && sort != 0) {
                boolean asc = sort > 0;
                SectioningStatusPage.StudentComparator.SortBy sortBy = SectioningStatusPage.StudentComparator.SortBy.values()[Math.abs(sort) - 1];
                Collections.sort(students, new SectioningStatusPage.StudentComparator(sortBy, asc));
                if (!asc) {
                    Collections.reverse(students);
                }
            }
            this.populateStudentTable(helper, online, students);
        } else if (online) {
            List<ClassAssignmentInterface.SectioningAction> changelog = service.changeLog(query);
            if (changelog != null && sort != 0) {
                boolean asc = sort > 0;
                SectioningStatusPage.ChangeLogComparator.SortBy sortBy = SectioningStatusPage.ChangeLogComparator.SortBy.values()[Math.abs(sort) - 1];
                Collections.sort(changelog, new SectioningStatusPage.ChangeLogComparator(sortBy));
                if (!asc) {
                    Collections.reverse(changelog);
                }
            }
            this.populateChangeLogTable(helper, changelog);
        } else {
            throw new IllegalArgumentException("Wrong tab and online parameter combination.");
        }
    }

    protected void populateCourseTable(ExportHelper helper, List<ClassAssignmentInterface.EnrollmentInfo> enrollments) throws IOException {
        CSVPrinter out = new CSVPrinter(helper.getWriter(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        out.printHeader(MESSAGES.colSubject() + "\n  " + MESSAGES.colSubpart(), MESSAGES.colCourse() + "\n" + MESSAGES.colClass(), MESSAGES.colTitle() + "\n" + MESSAGES.colTime(), "\n" + MESSAGES.colDate(), MESSAGES.colConsent() + "\n" + MESSAGES.colRoom(), MESSAGES.colAvailable(), MESSAGES.colProjection(), MESSAGES.colEnrollment(), MESSAGES.colWaitListed(), MESSAGES.colUnassignedAlternative().replace("<br>", "\n"), MESSAGES.colReserved(), MESSAGES.colNeedConsent().replace("<br>", "\n"), MESSAGES.colNeedOverride().replace("<br>", "\n"));
        out.flush();
        if (enrollments != null) {
            for (ClassAssignmentInterface.EnrollmentInfo e : enrollments) {
                if (e.getConfigId() == null) {
                    out.printLine(e.getSubject(), e.getCourseNbr(), e.getTitle(), "", e.getConsent(), e.getCourseId() == null ? this.number(e.getAvailable(), e.getLimit()) : this.available(e), this.number(null, e.getProjection()), this.number(e.getEnrollment(), e.getTotalEnrollment()), this.waitlist(e), this.number(e.getUnassignedAlternative(), e.getTotalUnassignedAlternative()), this.number(e.getReservation(), e.getTotalReservation()), this.number(e.getConsentNeeded(), e.getTotalConsentNeeded()), this.number(e.getOverrideNeeded(), e.getTotalOverrideNeeded()));
                    continue;
                }
                out.printLine("  " + (e.getSubpart() == null ? "" : e.getIndent("  ") + e.getSubpart()), e.getClazz() == null ? "" : e.getIndent("  ") + e.getClazz(), e.getAssignment().getDays().isEmpty() ? "" : e.getAssignment().getDaysString(CONSTANTS.shortDays()) + " " + e.getAssignment().getStartString(CONSTANTS.useAmPm()) + " - " + e.getAssignment().getEndString(CONSTANTS.useAmPm()), !e.getAssignment().hasDatePattern() ? "" : e.getAssignment().getDatePattern(), e.getAssignment().getRooms(","), e.getCourseId() == null ? this.number(e.getAvailable(), e.getLimit()) : this.available(e), this.number(null, e.getProjection()), this.number(e.getEnrollment(), e.getTotalEnrollment()), this.waitlist(e), this.number(e.getUnassignedAlternative(), e.getTotalUnassignedAlternative()), this.number(e.getReservation(), e.getTotalReservation()), this.number(e.getConsentNeeded(), e.getTotalConsentNeeded()), this.number(e.getOverrideNeeded(), e.getTotalOverrideNeeded()));
            }
        }
        out.flush();
        out.close();
    }

    protected void populateStudentTable(ExportHelper helper, boolean online, List<ClassAssignmentInterface.StudentInfo> students) throws IOException {
        CSVPrinter out = new CSVPrinter(helper.getWriter(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        boolean hasExtId = false;
        if (students != null) {
            for (ClassAssignmentInterface.StudentInfo e : students) {
                if (e.getStudent() == null || !e.getStudent().isCanShowExternalId()) continue;
                hasExtId = true;
                break;
            }
        }
        if (!hasExtId) {
            out.hideColumn(0);
        }
        boolean hasEnrollment = false;
        boolean hasWaitList = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConsent = false;
        boolean hasReqCredit = false;
        boolean hasCredit = false;
        boolean hasDistances = false;
        boolean hasOverlaps = false;
        boolean hasFreeTimeOverlaps = false;
        boolean hasPrefIMConfs = false;
        boolean hasPrefSecConfs = false;
        boolean hasNote = false;
        boolean hasEmailed = false;
        boolean hasOverride = false;
        if (students != null) {
            for (ClassAssignmentInterface.StudentInfo e : students) {
                if (e.getStudent() == null) continue;
                if (e.getTotalEnrollment() != null && e.getTotalEnrollment() > 0) {
                    hasEnrollment = true;
                }
                if (e.getTotalUnassigned() != null && e.getTotalUnassigned() > 0) {
                    hasWaitList = true;
                }
                if (e.getStudent().hasArea()) {
                    hasArea = true;
                }
                if (e.getStudent().hasMajor()) {
                    hasMajor = true;
                }
                if (e.getStudent().hasGroup()) {
                    hasGroup = true;
                }
                if (e.getStudent().hasAccommodation()) {
                    hasAcmd = true;
                }
                if (e.getTotalReservation() != null && e.getTotalReservation() > 0) {
                    hasReservation = true;
                }
                if (e.getRequestedDate() != null) {
                    hasRequestedDate = true;
                }
                if (e.getEnrolledDate() != null) {
                    hasEnrolledDate = true;
                }
                if (e.getTotalConsentNeeded() != null && e.getTotalConsentNeeded() > 0) {
                    hasConsent = true;
                }
                if (e.getTotalOverrideNeeded() != null && e.getTotalOverrideNeeded() > 0) {
                    hasOverride = true;
                }
                if (e.hasTotalRequestCredit()) {
                    hasReqCredit = true;
                }
                if (e.hasTotalCredit()) {
                    hasCredit = true;
                }
                if (e.hasTotalDistanceConflicts()) {
                    hasDistances = true;
                }
                if (e.hasOverlappingMinutes()) {
                    hasOverlaps = true;
                }
                if (e.hasFreeTimeOverlappingMins()) {
                    hasFreeTimeOverlaps = true;
                }
                if (e.hasTotalPrefInstrMethConflict()) {
                    hasPrefIMConfs = true;
                }
                if (e.hasTotalPrefSectionConflict()) {
                    hasPrefSecConfs = true;
                }
                if (e.hasNote()) {
                    hasNote = true;
                }
                if (e.getEmailDate() == null) continue;
                hasEmailed = true;
            }
        }
        if (!hasArea) {
            out.hideColumn(2);
            out.hideColumn(3);
        }
        if (!hasMajor) {
            out.hideColumn(4);
        }
        if (!hasGroup) {
            out.hideColumn(5);
        }
        if (!hasAcmd) {
            out.hideColumn(6);
        }
        if (!hasEnrollment) {
            out.hideColumn(8);
        }
        if (!hasWaitList) {
            out.hideColumn(9);
        }
        if (!hasReservation) {
            out.hideColumn(10);
        }
        if (!hasConsent) {
            out.hideColumn(11);
        }
        if (!hasOverride) {
            out.hideColumn(12);
        }
        if (!hasReqCredit) {
            out.hideColumn(13);
        }
        if (!hasCredit) {
            out.hideColumn(14);
        }
        if (!hasDistances) {
            out.hideColumn(15);
            out.hideColumn(16);
        }
        if (!hasOverlaps) {
            out.hideColumn(17);
        }
        if (!hasFreeTimeOverlaps) {
            out.hideColumn(18);
        }
        if (!hasPrefIMConfs) {
            out.hideColumn(19);
        }
        if (!hasPrefSecConfs) {
            out.hideColumn(20);
        }
        if (!hasRequestedDate) {
            out.hideColumn(21);
        }
        if (!hasEnrolledDate) {
            out.hideColumn(22);
        }
        if (!hasNote) {
            out.hideColumn(23);
        }
        if (!hasEmailed) {
            out.hideColumn(24);
        }
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
        out.printHeader(MESSAGES.colStudentExternalId(), MESSAGES.colStudent(), MESSAGES.colArea(), MESSAGES.colClassification(), MESSAGES.colMajor(), MESSAGES.colGroup(), MESSAGES.colAccommodation(), MESSAGES.colStatus(), MESSAGES.colEnrollment(), MESSAGES.colWaitListed(), MESSAGES.colReservation(), MESSAGES.colConsent(), MESSAGES.colPendingOverrides().replace("<br>", "\n"), MESSAGES.colRequestCredit().replace("<br>", "\n"), MESSAGES.colEnrollCredit().replace("<br>", "\n"), MESSAGES.colDistanceConflicts().replace("<br>", "\n"), MESSAGES.colLongestDistance().replace("<br>", "\n"), MESSAGES.colOverlapMins(), MESSAGES.colFreeTimeOverlapMins(), MESSAGES.colPrefInstrMethConfs().replace("<br>", "\n"), MESSAGES.colPrefSectionConfs().replace("<br>", "\n"), MESSAGES.colRequestTimeStamp(), MESSAGES.colEnrollmentTimeStamp(), MESSAGES.colStudentNote(), MESSAGES.colEmailTimeStamp());
        out.flush();
        if (students != null) {
            for (ClassAssignmentInterface.StudentInfo info : students) {
                if (info.getStudent() != null) {
                    out.printLine(info.getStudent().isCanShowExternalId() ? info.getStudent().getExternalId() : "", info.getStudent().getName(), info.getStudent().getArea("<br>"), info.getStudent().getClassification("<br>"), info.getStudent().getMajor("<br>"), info.getStudent().getGroup("<br>"), info.getStudent().getAccommodation("<br>"), info.getStatus(), this.number(info.getEnrollment(), info.getTotalEnrollment()), this.waitlist(info), this.number(info.getReservation(), info.getTotalReservation()), this.number(info.getConsentNeeded(), info.getTotalConsentNeeded()), this.number(info.getOverrideNeeded(), info.getTotalOverrideNeeded()), this.reqCredit(info.getRequestCreditMin(), info.getRequestCreditMax(), info.getTotalRequestCreditMin(), info.getTotalRequestCreditMax()), this.credit(info.getCredit(), info.getTotalCredit()), this.number(info.getNrDistanceConflicts(), info.getTotalNrDistanceConflicts()), this.number(info.getLongestDistanceMinutes(), info.getTotalLongestDistanceMinutes()), this.number(info.getOverlappingMinutes(), info.getTotalOverlappingMinutes()), this.number(info.getFreeTimeOverlappingMins(), info.getTotalFreeTimeOverlappingMins()), this.number(info.getPrefInstrMethConflict(), info.getTotalPrefInstrMethConflict()), this.number(info.getPrefSectionConflict(), info.getTotalPrefSectionConflict()), info.getRequestedDate() == null ? null : df.format(info.getRequestedDate()), info.getEnrolledDate() == null ? null : df.format(info.getEnrolledDate()), info.hasNote() ? info.getNote() : "", info.getEmailDate() == null ? null : df.format(info.getEmailDate()));
                    continue;
                }
                out.printLine(MESSAGES.total(), hasExtId ? null : MESSAGES.total(), this.number(null, students.size() - 1), null, null, null, null, null, this.number(info.getEnrollment(), info.getTotalEnrollment()), this.waitlist(info), this.number(info.getReservation(), info.getTotalReservation()), this.number(info.getConsentNeeded(), info.getTotalConsentNeeded()), this.number(info.getOverrideNeeded(), info.getTotalOverrideNeeded()), this.reqCredit(info.getRequestCreditMin(), info.getRequestCreditMax(), info.getTotalRequestCreditMin(), info.getTotalRequestCreditMax()), this.credit(info.getCredit(), info.getTotalCredit()), this.number(info.getNrDistanceConflicts(), info.getTotalNrDistanceConflicts()), this.number(info.getLongestDistanceMinutes(), info.getTotalLongestDistanceMinutes()), this.number(info.getOverlappingMinutes(), info.getTotalOverlappingMinutes()), this.number(info.getFreeTimeOverlappingMins(), info.getTotalFreeTimeOverlappingMins()), this.number(info.getPrefInstrMethConflict(), info.getTotalPrefInstrMethConflict()), this.number(info.getPrefSectionConflict(), info.getTotalPrefSectionConflict()), null, null, null, null);
            }
        }
        out.flush();
        out.close();
    }

    protected void populateChangeLogTable(ExportHelper helper, List<ClassAssignmentInterface.SectioningAction> changelog) throws IOException {
        CSVPrinter out = new CSVPrinter(helper.getWriter(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        out.printHeader(MESSAGES.colStudent(), MESSAGES.colOperation(), MESSAGES.colTimeStamp(), MESSAGES.colExecutionTime(), MESSAGES.colResult(), MESSAGES.colUser(), MESSAGES.colMessage());
        out.flush();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        Formats.Format<Number> nf = Formats.getNumberFormat(CONSTANTS.executionTimeFormat());
        if (changelog != null) {
            for (ClassAssignmentInterface.SectioningAction log : changelog) {
                out.printLine(log.getStudent().getName(), log.getOperation(), df.format(log.getTimeStamp()), log.getWallTime() == null ? "" : nf.format(0.001 * (double)log.getWallTime().longValue()), log.getResult(), log.getUser(), log.getMessage() == null ? null : log.getMessage().replace("<br>", "\n"));
            }
        }
        out.flush();
        out.close();
    }

    public String number(Integer value, Integer total) {
        if (value == null) {
            if (total != null) {
                return total == 0 ? "-" : (total < 0 ? "\u221e" : total.toString());
            }
            return null;
        }
        if (value.equals(total)) {
            return total == 0 ? "-" : (total < 0 ? "\u221e" : total.toString());
        }
        return (value < 0 ? "\u221e" : value.toString()) + " / " + (total < 0 ? "\u221e" : total.toString());
    }

    public String available(ClassAssignmentInterface.EnrollmentInfo e) {
        int other;
        int n = other = e.getOther() == null ? 0 : e.getOther();
        if (e.getLimit() == null) {
            return "-";
        }
        if (e.getLimit() < 0) {
            if (e.getAvailable() != null && e.getAvailable() == 0) {
                return "\u221e" + MESSAGES.csvReservationSign();
            }
            return "\u221e";
        }
        if (e.getAvailable() == e.getLimit() - e.getTotalEnrollment() - other) {
            return e.getAvailable() + " / " + e.getLimit();
        }
        if (e.getAvailable() == 0 && e.getLimit() > e.getTotalEnrollment() + other) {
            return e.getLimit() - e.getTotalEnrollment() - other + MESSAGES.csvReservationSign() + " / " + e.getLimit();
        }
        return e.getAvailable() + " + " + (e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other) + MESSAGES.csvReservationSign() + " / " + e.getLimit();
    }

    public String waitlist(int wait, int tWait, int unasg, int tUnasg, Integer topWaitingPriority) {
        if (tWait == 0 || tWait == tUnasg) {
            if (unasg == tUnasg) {
                return (unasg == 0 ? "-" : String.valueOf(unasg)) + (tWait > 0 ? MESSAGES.csvWaitListSign() : "") + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
            }
            return unasg + " / " + tUnasg + (tWait > 0 ? MESSAGES.csvWaitListSign() : "") + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
        }
        if (wait == tWait && unasg == tUnasg) {
            return (wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.csvWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign())) + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
        }
        return (wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.csvWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign())) + " / " + tUnasg + (topWaitingPriority != null ? MESSAGES.csvFirstWaitListedPrioritySign(topWaitingPriority) : "");
    }

    public String waitlist(ClassAssignmentInterface.StudentInfo e) {
        return this.waitlist(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassigned() : 0, e.hasTotalUnassigned() ? e.getTotalUnassigned() : 0, e.getTopWaitingPriority());
    }

    public String waitlist(ClassAssignmentInterface.EnrollmentInfo e) {
        return this.waitlist(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassignedPrimary() : 0, e.hasTotalUnassigned() ? e.getTotalUnassignedPrimary() : 0, null);
    }

    public String reqCredit(float min, float max, float totalMin, float totalMax) {
        if (totalMax > 0.0f) {
            if (min == totalMin && max == totalMax) {
                return totalMin == totalMax ? sCreditFormat.format(totalMin) : sCreditFormat.format(totalMin) + " - " + sCreditFormat.format(totalMax);
            }
            return (min == max ? sCreditFormat.format(min) : sCreditFormat.format(min) + " - " + sCreditFormat.format(max)) + " / " + (totalMin == totalMax ? sCreditFormat.format(totalMin) : sCreditFormat.format(totalMin) + " - " + sCreditFormat.format(totalMax));
        }
        return null;
    }

    public String credit(Float value, Float total) {
        if (total != null && total.floatValue() > 0.0f) {
            if (total.equals(value)) {
                return sCreditFormat.format(total);
            }
            return sCreditFormat.format(value) + " / " + sCreditFormat.format(total);
        }
        return null;
    }
}

