/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.solver.TableExporter;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

@Service(value="org.unitime.timetable.export.Exporter:timetable.pdf")
public class ExportTimetablePDF
extends TableExporter {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static Formats.Format<Date> sDateFormatMeeting = Formats.getDateFormat(Formats.Pattern.TIMETABLE_GRID_DATE);
    protected static Formats.Format<Number> sUtilizationFormat = Formats.getConcurrentNumberFormat(Formats.Pattern.UTILIZATION);
    protected static int sHeaderWidth = 100;
    protected static int sLineHeight = 13;
    @Autowired
    private ApplicationContext applicationContext;

    public String reference() {
        return "timetable.pdf";
    }

    public void export(ExportHelper helper) throws IOException {
        GwtRpcImplementation filterService = (GwtRpcImplementation)this.applicationContext.getBean(TimetableGridInterface.TimetableGridFilterRequest.class.getName());
        TimetableGridInterface.TimetableGridFilterResponse filter = (TimetableGridInterface.TimetableGridFilterResponse)filterService.execute(new TimetableGridInterface.TimetableGridFilterRequest(), helper.getSessionContext());
        this.fillInFilter(filter, helper);
        GwtRpcImplementation service = (GwtRpcImplementation)this.applicationContext.getBean(TimetableGridInterface.TimetableGridRequest.class.getName());
        TimetableGridInterface.TimetableGridRequest request = new TimetableGridInterface.TimetableGridRequest();
        request.setFilter(filter);
        TimetableGridInterface.TimetableGridResponse response = (TimetableGridInterface.TimetableGridResponse)service.execute(request, helper.getSessionContext());
        this.printTables(filter, response, helper);
    }

    protected void printTables(FilterInterface filter, TimetableGridInterface.TimetableGridResponse response, ExportHelper helper) throws IOException {
        helper.setup("application/pdf", this.reference(), true);
        try {
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)helper.getOutputStream());
            writer.setPageEvent((PdfPageEvent)new PdfEventHandler());
            int index = 0;
            int margin = 50;
            int width = 1000;
            for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                width = Math.max(width, this.pageWidth(filter, model, response.getWeekOffset()));
            }
            int displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
            int height = displayMode == 2 ? (2 * margin + width) * 22 / 17 - 2 * margin : (2 * margin + width) * 17 / 22 - 2 * margin;
            for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                height = Math.max(height, this.pageHeight(filter, model, response.getWeekOffset(), true));
            }
            document.setPageSize(new Rectangle((float)(width + 2 * margin), (float)(height + 2 * margin)));
            document.setMargins((float)margin, (float)margin, (float)margin, (float)margin);
            document.open();
            int used = 0;
            if (Integer.valueOf(filter.getParameterValue("dispMode", "0")) == 0) {
                int i;
                boolean[] hasDay = new boolean[]{true, true, true, true, true, false, false};
                String days = filter.getParameterValue("days");
                if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
                    for (i = 0; i < 7; ++i) {
                        hasDay[i] = days.charAt(i) == '1';
                    }
                }
                for (i = 0; i < 7; ++i) {
                    if (!hasDay[i]) continue;
                    String d = "";
                    for (int j = 0; j < 7; ++j) {
                        d = d + (i == j ? "1" : "0");
                    }
                    filter.getParameter("days").setValue(d);
                    boolean first = true;
                    for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                        if (used > 0 && this.pageHeight(filter, model, response.getWeekOffset(), first) > height - used) {
                            document.newPage();
                            used = 0;
                        }
                        TimetableGrid tg = new TimetableGrid(filter, model, index++, width, response.getWeekOffset(), used == 0 || first);
                        PdfContentByte canvas = writer.getDirectContent();
                        tg.print(canvas, margin, margin + used, height + 2 * margin, null);
                        used += tg.getHeight();
                        first = false;
                    }
                    used += 25;
                }
            } else {
                for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                    if (used > 0 && this.pageHeight(filter, model, response.getWeekOffset(), false) > height - used) {
                        document.newPage();
                        used = 0;
                    }
                    TimetableGrid tg = new TimetableGrid(filter, model, index++, width, response.getWeekOffset(), used == 0);
                    PdfContentByte canvas = writer.getDirectContent();
                    tg.print(canvas, margin, margin + used, height + 2 * margin, null);
                    used += tg.getHeight() + 25;
                }
            }
            if (document != null) {
                document.close();
            }
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static float textWidth(Font font, TimetableGridInterface.TimetableGridCell cell, boolean showRoom, boolean showInstructor, boolean showTime, boolean showPreference, boolean showDate) {
        float width = 0.0f;
        if (cell.getNrNames() > 0) {
            for (String name : cell.getNames()) {
                width = Math.max(width, font.getBaseFont().getWidthPoint(name, font.getSize()));
            }
        }
        if (showTime && cell.hasTime()) {
            width = Math.max(width, font.getBaseFont().getWidthPoint(cell.getTime(), font.getSize()));
        }
        if (showDate && cell.hasDate()) {
            width = Math.max(width, font.getBaseFont().getWidthPoint(cell.getDate(), font.getSize()));
        }
        if (showRoom && cell.getNrRooms() > 0) {
            for (String room : cell.getRooms()) {
                width = Math.max(width, font.getBaseFont().getWidthPoint(room, font.getSize()));
            }
        }
        if (showInstructor && cell.getNrInstructors() > 0) {
            for (String instructor : cell.getInstructors()) {
                width = Math.max(width, font.getBaseFont().getWidthPoint(instructor, font.getSize()));
            }
        }
        if (showPreference && cell.hasPreference()) {
            width = Math.max(width, font.getBaseFont().getWidthPoint(cell.getPreference().replaceAll("\\<[^>]*>", ""), font.getSize()));
        }
        return width;
    }

    protected int pageWidth(FilterInterface filter, TimetableGridInterface.TimetableGridModel model, int weekOffset) {
        int displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
        boolean[] hasDay = new boolean[]{true, true, true, true, true, false, false};
        String days = filter.getParameterValue("days");
        if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
            for (int i = 0; i < 7; ++i) {
                hasDay[i] = days.charAt(i) == '1';
            }
        }
        int nrTimes = 20;
        int startSlot = 90;
        int step = 6;
        String[] times = filter.getParameterValue("times", "90|222|6").split("\\|");
        if (times != null && times.length == 3) {
            startSlot = Integer.parseInt(times[0]);
            step = Integer.parseInt(times[2]);
            nrTimes = (Integer.parseInt(times[1]) - startSlot) / step;
        }
        int endSlot = startSlot + step * nrTimes;
        boolean showPreferences = "1".equals(filter.getParameterValue("showPreferences"));
        boolean showInstructors = "1".equals(filter.getParameterValue("showInstructors"));
        boolean showTimes = "1".equals(filter.getParameterValue("showTimes"));
        boolean showRoom = !"0".equals(filter.getParameterValue("resource"));
        boolean showDate = "-100".equals(filter.getParameterValue("weeks"));
        Font font = PdfFont.getSmallFont();
        int nrColumns = 0;
        for (int i = 0; i < 7; ++i) {
            int d = (i + weekOffset) % 7;
            if (!hasDay[d]) continue;
            nrColumns += model.getNrLines(d, 1);
        }
        float widthPerSlot = 50.0f / (float)step;
        float widthPerColumn = 50.0f;
        for (TimetableGridInterface.TimetableGridCell cell : model.getCells()) {
            if (!hasDay[cell.getDay()] || cell.getSlot() + cell.getLength() <= startSlot || cell.getSlot() >= startSlot + step * nrTimes) continue;
            float textWidth = ExportTimetablePDF.textWidth(font, cell, showRoom, showInstructors, showTimes, showPreferences, showDate) + 10.0f;
            int start = cell.getSlot();
            int stop = cell.getSlot() + cell.getLength();
            if (start < startSlot) {
                start = startSlot;
            }
            if (stop > endSlot) {
                stop = endSlot;
            }
            widthPerSlot = Math.max(widthPerSlot, textWidth / (float)(stop - start));
            widthPerColumn = Math.max(widthPerColumn, textWidth);
        }
        if (displayMode == 0) {
            return Math.round((float)sHeaderWidth + (float)(step * nrTimes) * widthPerSlot);
        }
        if (displayMode == 2) {
            return Math.round((float)sHeaderWidth + (float)nrColumns * widthPerColumn);
        }
        return Math.min(1500, Math.round((float)sHeaderWidth + (float)(step * nrTimes) * widthPerSlot));
    }

    protected int pageHeight(FilterInterface filter, TimetableGridInterface.TimetableGridModel model, int weekOffset, boolean showHeader) {
        int displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
        boolean[] hasDay = new boolean[]{true, true, true, true, true, false, false};
        String days = filter.getParameterValue("days");
        if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
            for (int i = 0; i < 7; ++i) {
                hasDay[i] = days.charAt(i) == '1';
            }
        }
        int nrTimes = 20;
        int startSlot = 90;
        int step = 6;
        String[] times = filter.getParameterValue("times", "90|222|6").split("\\|");
        if (times != null && times.length == 3) {
            startSlot = Integer.parseInt(times[0]);
            step = Integer.parseInt(times[2]);
            nrTimes = (Integer.parseInt(times[1]) - startSlot) / step;
        }
        String comment = ExportTimetablePDF.getComment(model);
        if (displayMode == 0) {
            int headerLines = showHeader ? 1 : 0;
            int nrLines = 0;
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                int dayLines = model.getNrLines(d, 2);
                if (!hasDay[d] || nrLines >= dayLines) continue;
                nrLines = dayLines;
            }
            return (headerLines + nrLines) * sLineHeight + 1;
        }
        if (displayMode == 1) {
            int nrLines = 0;
            for (int i = 0; i < 7; ++i) {
                int d = (i + weekOffset) % 7;
                if (!hasDay[d]) continue;
                nrLines += model.getNrLines(d, 2);
            }
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            return (headerLines + nrLines) * sLineHeight + 2;
        }
        if (displayMode == 2) {
            int linesPerTime = 2;
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            return (headerLines + linesPerTime * nrTimes) * sLineHeight + 2;
        }
        if (displayMode == 3) {
            int nrLines = 0;
            for (int d = 0; d < 365; ++d) {
                int day;
                int date = d + model.getFirstSessionDay();
                if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || !hasDay[day = d % 7] || !model.hasDate(day, date)) continue;
                nrLines += model.getNrDateLines(day, date, 2);
            }
            int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
            return (headerLines + nrLines) * sLineHeight + 2;
        }
        return 0;
    }

    protected static String getComment(TimetableGridInterface.TimetableGridModel model) {
        if (model.getResourceType() == 0) {
            return "(" + model.getSize() + ", " + sUtilizationFormat.format(model.getUtilization()) + ")";
        }
        if (model.getResourceType() >= 2) {
            return "(" + model.getSize() + ")";
        }
        return null;
    }

    protected static Date getDate(Date firstDate, int date) {
        Date ret = new Date(firstDate.getTime());
        ret.setDate(ret.getDate() + date);
        return ret;
    }

    public static String slot2time(int slot) {
        if (CONSTANTS.useAmPm()) {
            if (slot == 0) {
                return CONSTANTS.timeMidnight();
            }
            if (slot == 144) {
                return CONSTANTS.timeNoon();
            }
            if (slot == 288) {
                return CONSTANTS.timeMidnightEnd();
            }
        }
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + " " + (h == 24 ? CONSTANTS.timeAm() : (h >= 12 ? CONSTANTS.timePm() : CONSTANTS.timeAm()));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    protected static class Background
    extends P {
        private TimetableGridInterface.TimetableGridBackground iBackground;

        public Background(TimetableGridInterface.TimetableGridBackground background) {
            super("background");
            this.iBackground = background;
            if (background.hasBackground()) {
                this.setBackgroundColor(background.getBackground());
            }
        }

        public TimetableGridInterface.TimetableGridBackground getBackground() {
            return this.iBackground;
        }
    }

    protected static class Meeting
    extends P {
        private TimetableGridInterface.TimetableGridCell iCell;
        private P iHeader;
        private P iFooter;

        private Meeting(TimetableGridInterface.TimetableGridCell cell, boolean showRoom, boolean showInstructor, boolean showTime, boolean showPreference, boolean showDate) {
            super("meeting");
            this.iCell = cell;
            if (cell.hasBackground()) {
                this.setBackgroundColor(cell.getBackground());
            }
            this.iHeader = new P("header");
            this.iHeader.setHeight(sLineHeight * cell.getNrNames());
            this.iHeader.setText(cell.getName("\n"));
            if (cell.isItalics()) {
                this.iHeader.setItalics(true);
            }
            this.add(this.iHeader, 0, 0);
            this.iFooter = new P("footer");
            String notes = "";
            if (showTime && cell.hasTime()) {
                notes = notes + (notes.isEmpty() ? "" : "\n") + cell.getTime();
            }
            if (showDate && cell.hasDate()) {
                notes = notes + (notes.isEmpty() ? "" : "\n") + cell.getDate();
            }
            if (showRoom && cell.getNrRooms() > 0) {
                notes = notes + (notes.isEmpty() ? "" : "\n") + cell.getRoom("\n");
            }
            if (showInstructor && cell.getNrInstructors() > 0) {
                notes = notes + (notes.isEmpty() ? "" : "\n") + cell.getInstructor("\n");
            }
            if (showPreference && cell.hasPreference()) {
                notes = notes + (notes.isEmpty() ? "" : "\n") + cell.getPreference().replaceAll("\\<[^>]*>", "");
            }
            this.iFooter.setText(notes);
            this.add(this.iFooter, 0, this.iHeader.getHeight());
        }

        public void setHeight(int height) {
            super.setHeight(height);
            this.iFooter.setHeight(height - this.iHeader.getHeight());
        }

        public void setWidth(int width) {
            super.setWidth(width);
            this.iHeader.setWidth(width);
            this.iFooter.setWidth(width);
        }

        public TimetableGridInterface.TimetableGridCell getCell() {
            return this.iCell;
        }
    }

    protected static class TimetableGrid
    extends P {
        private List<Meeting> iMeetings;
        private List<Background> iBackbrounds;
        private int iCellWidth;

        public TimetableGrid(FilterInterface filter, TimetableGridInterface.TimetableGridModel model, int index, int pageWidth, int weekOffset, boolean showHeader) {
            block58: {
                int stop;
                int start;
                int day;
                String comment;
                boolean showDate;
                boolean showRoom;
                boolean showTimes;
                boolean showInstructors;
                boolean showPreferences;
                int endSlot;
                int step;
                int startSlot;
                int nrTimes;
                boolean[] hasDay;
                int displayMode;
                block60: {
                    block59: {
                        block57: {
                            int d;
                            super("unitime-TimetableGrid");
                            this.iMeetings = new ArrayList<Meeting>();
                            this.iBackbrounds = new ArrayList<Background>();
                            displayMode = Integer.valueOf(filter.getParameterValue("dispMode", "0"));
                            hasDay = new boolean[]{true, true, true, true, true, false, false};
                            String days = filter.getParameterValue("days");
                            int nrDays = 0;
                            if (days != null && days.length() == 7 && days.indexOf(49) >= 0) {
                                for (int i = 0; i < 7; ++i) {
                                    if (days.charAt(i) == '1') {
                                        hasDay[i] = true;
                                        ++nrDays;
                                        continue;
                                    }
                                    hasDay[i] = false;
                                }
                            }
                            nrTimes = 20;
                            startSlot = 90;
                            step = 6;
                            String[] times = filter.getParameterValue("times", "90|222|6").split("\\|");
                            if (times != null && times.length == 3) {
                                startSlot = Integer.parseInt(times[0]);
                                step = Integer.parseInt(times[2]);
                                nrTimes = (Integer.parseInt(times[1]) - startSlot) / step;
                            }
                            endSlot = startSlot + step * nrTimes;
                            showPreferences = "1".equals(filter.getParameterValue("showPreferences"));
                            showInstructors = "1".equals(filter.getParameterValue("showInstructors"));
                            showTimes = "1".equals(filter.getParameterValue("showTimes"));
                            showRoom = !"0".equals(filter.getParameterValue("resource"));
                            showDate = "-100".equals(filter.getParameterValue("weeks"));
                            comment = ExportTimetablePDF.getComment(model);
                            if (displayMode != 0) break block57;
                            int headerLines = showHeader ? 1 : 0;
                            int nrLines = 0;
                            int[] dayIndex = new int[7];
                            int x = 0;
                            int[] dayLines = new int[7];
                            for (int i = 0; i < 7; ++i) {
                                int d2 = (i + weekOffset) % 7;
                                dayLines[d2] = model.getNrLines(d2, 2);
                                if (hasDay[d2] && nrLines < dayLines[d2]) {
                                    nrLines = dayLines[d2];
                                }
                                dayIndex[d2] = x++;
                                if (!hasDay[d2]) continue;
                            }
                            this.iCellWidth = (pageWidth - sHeaderWidth) / (nrDays * nrTimes);
                            if (this.iCellWidth < 50) {
                                this.iCellWidth = 50;
                            }
                            this.setSize(sHeaderWidth + nrDays * nrTimes * this.iCellWidth + 2 * nrDays, (headerLines + nrLines) * sLineHeight + 1);
                            if (headerLines > 0) {
                                P name = new P("grid-name");
                                name.setSize(sHeaderWidth, headerLines * sLineHeight);
                                for (int i = 0; i < 7; ++i) {
                                    d = (i + weekOffset) % 7;
                                    if (!hasDay[d]) continue;
                                    name.setText(CONSTANTS.longDays()[d]);
                                    break;
                                }
                                this.add(name);
                            }
                            P verticalHeader = new P("vertical-header");
                            verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
                            this.add(verticalHeader, 0, headerLines * sLineHeight);
                            P panel = new P("timetable-panel");
                            panel.setSize(nrDays * nrTimes * this.iCellWidth + 2 * nrDays, nrLines * sLineHeight + 1);
                            if (headerLines > 0) {
                                P horizontalHeader = new P("horizontal-header");
                                horizontalHeader.setSize(nrDays * nrTimes * this.iCellWidth + 2 * nrDays, headerLines * sLineHeight);
                                this.add(horizontalHeader, sHeaderWidth, 0);
                                for (int i = 0; i < 7; ++i) {
                                    int d3 = (i + weekOffset) % 7;
                                    if (!hasDay[d3]) continue;
                                    for (int t = 0; t < nrTimes; ++t) {
                                        int j = dayIndex[d3] * nrTimes + t;
                                        P p = new P("header-interval");
                                        p.setSize(this.iCellWidth, headerLines * sLineHeight);
                                        p.setText(ExportTimetablePDF.slot2time(startSlot + t * step));
                                        horizontalHeader.add(p, j * this.iCellWidth + 2 * dayIndex[d3], 0);
                                        if (t == 0 && dayIndex[d3] > 0) {
                                            P p2 = new P("vertical-double-separator");
                                            panel.add(p2, j * this.iCellWidth + 2 * dayIndex[d3] - 2, 0);
                                            P p3 = new P("vertical-double-separator");
                                            horizontalHeader.add(p3, j * this.iCellWidth + 2 * dayIndex[d3] - 2, 0);
                                            continue;
                                        }
                                        P p4 = new P("vertical-separator");
                                        panel.add(p4, j * this.iCellWidth + 2 * dayIndex[d3], 0);
                                    }
                                }
                                P lastVShead = new P("vertical-separator");
                                lastVShead.setRight(0);
                                lastVShead.setTop(0);
                                horizontalHeader.add(lastVShead);
                            } else {
                                for (d = 0; d < 7; ++d) {
                                    if (!hasDay[d]) continue;
                                    for (int t = 0; t < nrTimes; ++t) {
                                        P vs;
                                        int i = dayIndex[d] * nrTimes + t;
                                        if (t == 0 && dayIndex[d] > 0) {
                                            vs = new P("vertical-double-separator");
                                            panel.add(vs, i * this.iCellWidth + 2 * dayIndex[d] - 2, 0);
                                            continue;
                                        }
                                        vs = new P("vertical-separator");
                                        panel.add(vs, i * this.iCellWidth + 2 * dayIndex[d], 0);
                                    }
                                }
                            }
                            this.add(panel, sHeaderWidth, headerLines * sLineHeight);
                            P lastVSpan = new P("vertical-separator");
                            lastVSpan.setRight(0);
                            lastVSpan.setTop(0);
                            panel.add(lastVSpan);
                            P hs = new P("horizontal-separator");
                            panel.add(hs, 0, 0);
                            P hi = new P("header-interval");
                            hi.setSize(sHeaderWidth, nrLines * sLineHeight);
                            hi.setText(model.getName() + (comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                            if (model.hasNameColor()) {
                                hi.setColor(model.getNameColor());
                            }
                            verticalHeader.add(hi, 0, 0);
                            P lastHSpan = new P("horizontal-separator");
                            lastHSpan.setLeft(0);
                            lastHSpan.setBottom(0);
                            panel.add(lastHSpan);
                            P lastHShead = new P("horizontal-separator");
                            lastHShead.setLeft(0);
                            lastHShead.setBottom(0);
                            verticalHeader.add(lastHShead);
                            for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                                if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                                Background background = new Background(timetableGridBackground);
                                this.iBackbrounds.add(background);
                                background.setHeight(nrLines * sLineHeight);
                                int start3 = timetableGridBackground.getSlot();
                                int stop3 = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                                if (start3 < startSlot) {
                                    start3 = startSlot;
                                }
                                if (stop3 > endSlot) {
                                    stop3 = endSlot;
                                }
                                background.setWidth(stop3 * this.iCellWidth / step - start3 * this.iCellWidth / step);
                                panel.add(background, dayIndex[timetableGridBackground.getDay()] * nrTimes * this.iCellWidth + (start3 - startSlot) * this.iCellWidth / step + 2 * dayIndex[timetableGridBackground.getDay()], 0);
                            }
                            for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                                if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                                Meeting meeting = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                                this.iMeetings.add(meeting);
                                int lines = timetableGridCell.getNrLines();
                                if (dayLines[timetableGridCell.getDay()] < nrLines && timetableGridCell.getIndex() + timetableGridCell.getNrLines() == dayLines[timetableGridCell.getDay()]) {
                                    lines += nrLines - dayLines[timetableGridCell.getDay()];
                                }
                                meeting.setHeight(1 + lines * sLineHeight);
                                int start4 = timetableGridCell.getSlot();
                                int stop4 = timetableGridCell.getSlot() + timetableGridCell.getLength();
                                if (start4 < startSlot) {
                                    start4 = startSlot;
                                }
                                if (stop4 > endSlot) {
                                    stop4 = endSlot;
                                }
                                meeting.setWidth(1 + (stop4 - startSlot) * this.iCellWidth / step - (start4 - startSlot) * this.iCellWidth / step);
                                panel.add(meeting, dayIndex[timetableGridCell.getDay()] * nrTimes * this.iCellWidth + (start4 - startSlot) * this.iCellWidth / step + 2 * dayIndex[timetableGridCell.getDay()], timetableGridCell.getIndex() * sLineHeight);
                            }
                            break block58;
                        }
                        if (displayMode != 1) break block59;
                        int nrLines = 0;
                        int[] dayIndex = new int[8];
                        int[] toDayIdx = new int[7];
                        for (int i = 0; i < 7; ++i) {
                            int d = (i + weekOffset) % 7;
                            dayIndex[i] = nrLines;
                            toDayIdx[d] = i;
                            if (!hasDay[d]) continue;
                            nrLines += model.getNrLines(d, 2);
                        }
                        dayIndex[7] = nrLines;
                        int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                        this.iCellWidth = (pageWidth - sHeaderWidth) / nrTimes;
                        this.setSize(sHeaderWidth + nrTimes * this.iCellWidth + 2, (headerLines + nrLines) * sLineHeight + 2);
                        P name = new P("grid-name");
                        name.setSize(sHeaderWidth, headerLines * sLineHeight);
                        name.setText(model.getName() + (comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                        if (model.hasNameColor()) {
                            name.setColor(model.getNameColor());
                        }
                        this.add(name);
                        P verticalHeader = new P("vertical-header");
                        verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
                        this.add(verticalHeader, 0, headerLines * sLineHeight);
                        P horizontalHeader = new P("horizontal-header");
                        horizontalHeader.setSize(nrTimes * this.iCellWidth + 1, headerLines * sLineHeight);
                        this.add(horizontalHeader, sHeaderWidth, 0);
                        P panel = new P("timetable-panel");
                        panel.setSize(nrTimes * this.iCellWidth + 1, nrLines * sLineHeight + 1);
                        this.add(panel, sHeaderWidth, headerLines * sLineHeight);
                        for (int i = 0; i < nrTimes; ++i) {
                            P hi = new P("header-interval");
                            hi.setSize(this.iCellWidth, headerLines * sLineHeight);
                            hi.setText(ExportTimetablePDF.slot2time(startSlot + i * step));
                            horizontalHeader.add(hi, i * this.iCellWidth, 0);
                            P vs = new P("vertical-separator");
                            panel.add(vs, i * this.iCellWidth, 0);
                        }
                        P lastVSpan = new P("vertical-separator");
                        lastVSpan.setRight(0);
                        lastVSpan.setTop(0);
                        panel.add(lastVSpan);
                        P lastVShead = new P("vertical-separator");
                        lastVShead.setRight(0);
                        lastVShead.setTop(0);
                        horizontalHeader.add(lastVShead);
                        for (int i = 0; i < 7; ++i) {
                            int d = (i + weekOffset) % 7;
                            if (!hasDay[d]) continue;
                            P p = new P("horizontal-separator");
                            panel.add(p, 0, sLineHeight * dayIndex[i]);
                            P p5 = new P("header-interval");
                            p5.setSize(sHeaderWidth, (dayIndex[1 + i] - dayIndex[i]) * sLineHeight);
                            p5.setText(CONSTANTS.longDays()[d]);
                            verticalHeader.add(p5, 0, sLineHeight * dayIndex[i]);
                        }
                        P lastHSpan = new P("horizontal-separator");
                        lastHSpan.setLeft(0);
                        lastHSpan.setBottom(0);
                        panel.add(lastHSpan);
                        P lastHShead = new P("horizontal-separator");
                        lastHShead.setLeft(0);
                        lastHShead.setBottom(0);
                        verticalHeader.add(lastHShead);
                        for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                            if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                            Background background = new Background(timetableGridBackground);
                            this.iBackbrounds.add(background);
                            int i = toDayIdx[timetableGridBackground.getDay()];
                            background.setHeight((dayIndex[i + 1] - dayIndex[i]) * sLineHeight);
                            int start5 = timetableGridBackground.getSlot();
                            int stop5 = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                            if (start5 < startSlot) {
                                start5 = startSlot;
                            }
                            if (stop5 > endSlot) {
                                stop5 = endSlot;
                            }
                            background.setWidth(stop5 * this.iCellWidth / step - start5 * this.iCellWidth / step);
                            panel.add(background, (start5 - startSlot) * this.iCellWidth / step, dayIndex[i] * sLineHeight);
                        }
                        for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                            if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                            Meeting meeting = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                            this.iMeetings.add(meeting);
                            meeting.setHeight(1 + timetableGridCell.getNrLines() * sLineHeight);
                            int start6 = timetableGridCell.getSlot();
                            int stop6 = timetableGridCell.getSlot() + timetableGridCell.getLength();
                            if (start6 < startSlot) {
                                start6 = startSlot;
                            }
                            if (stop6 > endSlot) {
                                stop6 = endSlot;
                            }
                            meeting.setWidth(1 + (stop6 - startSlot) * this.iCellWidth / step - (start6 - startSlot) * this.iCellWidth / step);
                            panel.add(meeting, (start6 - startSlot) * this.iCellWidth / step, (dayIndex[toDayIdx[timetableGridCell.getDay()]] + timetableGridCell.getIndex()) * sLineHeight);
                        }
                        break block58;
                    }
                    if (displayMode != 2) break block60;
                    int nrColumns = 0;
                    int[] colIndex = new int[8];
                    int[] toDayIdx = new int[7];
                    for (int i = 0; i < 7; ++i) {
                        int d = (i + weekOffset) % 7;
                        colIndex[i] = nrColumns;
                        toDayIdx[d] = i;
                        if (!hasDay[d]) continue;
                        nrColumns += model.getNrLines(d, 1);
                    }
                    colIndex[7] = nrColumns;
                    int linesPerTime = 2;
                    int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                    this.iCellWidth = (pageWidth - sHeaderWidth) / nrColumns;
                    this.setSize(sHeaderWidth + nrColumns * this.iCellWidth + 2, (headerLines + linesPerTime * nrTimes) * sLineHeight + 2);
                    P name = new P("grid-name");
                    name.setSize(sHeaderWidth, headerLines * sLineHeight);
                    name.setText(model.getName() + (comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                    if (model.hasNameColor()) {
                        name.setColor(model.getNameColor());
                    }
                    this.add(name);
                    P verticalHeader = new P("vertical-header");
                    verticalHeader.setSize(sHeaderWidth, linesPerTime * nrTimes * sLineHeight + 1);
                    this.add(verticalHeader, 0, headerLines * sLineHeight);
                    P horizontalHeader = new P("horizontal-header");
                    horizontalHeader.setSize(nrColumns * this.iCellWidth + 1, headerLines * sLineHeight);
                    this.add(horizontalHeader, sHeaderWidth, 0);
                    P panel = new P("timetable-panel");
                    panel.setSize(nrColumns * this.iCellWidth + 1, linesPerTime * nrTimes * sLineHeight + 1);
                    this.add(panel, sHeaderWidth, headerLines * sLineHeight);
                    for (int i = 0; i < 7; ++i) {
                        int d = (i + weekOffset) % 7;
                        if (!hasDay[d]) continue;
                        P hi = new P("header-interval");
                        hi.setSize(this.iCellWidth * model.getNrLines(d, 1), headerLines * sLineHeight);
                        hi.setText(CONSTANTS.longDays()[d]);
                        horizontalHeader.add(hi, colIndex[i] * this.iCellWidth, 0);
                        P p = new P("vertical-separator");
                        panel.add(p, colIndex[i] * this.iCellWidth, 0);
                    }
                    P lastVSpan = new P("vertical-separator");
                    lastVSpan.setRight(0);
                    lastVSpan.setTop(0);
                    panel.add(lastVSpan);
                    P lastVShead = new P("vertical-separator");
                    lastVShead.setRight(0);
                    lastVShead.setTop(0);
                    horizontalHeader.add(lastVShead);
                    for (int i = 0; i < nrTimes; ++i) {
                        P p = new P("horizontal-separator");
                        panel.add(p, 0, sLineHeight * linesPerTime * i);
                        P p6 = new P("header-interval");
                        p6.setSize(sHeaderWidth, linesPerTime * sLineHeight);
                        p6.setText(ExportTimetablePDF.slot2time(startSlot + step * i));
                        verticalHeader.add(p6, 0, sLineHeight * linesPerTime * i);
                    }
                    P lastHSpan = new P("horizontal-separator");
                    lastHSpan.setLeft(0);
                    lastHSpan.setBottom(0);
                    panel.add(lastHSpan);
                    P p = new P("horizontal-separator");
                    p.setLeft(0);
                    p.setBottom(0);
                    verticalHeader.add(p);
                    for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                        if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                        Background b = new Background(timetableGridBackground);
                        this.iBackbrounds.add(b);
                        int start2 = timetableGridBackground.getSlot();
                        int stop2 = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                        if (start2 < startSlot) {
                            start2 = startSlot;
                        }
                        if (stop2 > endSlot) {
                            stop2 = endSlot;
                        }
                        b.setHeight(stop2 * sLineHeight * linesPerTime / step - start2 * sLineHeight * linesPerTime / step);
                        int i = toDayIdx[timetableGridBackground.getDay()];
                        b.setWidth((colIndex[1 + i] - colIndex[i]) * this.iCellWidth);
                        panel.add(b, colIndex[i] * this.iCellWidth, (start2 - startSlot) * sLineHeight * linesPerTime / step);
                    }
                    for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                        if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                        Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                        this.iMeetings.add(m);
                        int start2 = timetableGridCell.getSlot();
                        int stop2 = timetableGridCell.getSlot() + timetableGridCell.getLength();
                        if (start2 < startSlot) {
                            start2 = startSlot;
                        }
                        if (stop2 > endSlot) {
                            stop2 = endSlot;
                        }
                        m.setHeight(1 + (stop2 - startSlot) * sLineHeight * linesPerTime / step - (start2 - startSlot) * sLineHeight * linesPerTime / step);
                        m.setWidth(1 + this.iCellWidth * timetableGridCell.getNrLines());
                        panel.add(m, (colIndex[toDayIdx[timetableGridCell.getDay()]] + timetableGridCell.getIndex()) * this.iCellWidth, (start2 - startSlot) * sLineHeight * linesPerTime / step);
                    }
                    break block58;
                }
                if (displayMode != 3) break block58;
                int nrLines = 0;
                int[] dayIndex = new int[366];
                for (int d = 0; d < 365; ++d) {
                    int day2;
                    dayIndex[d] = nrLines;
                    int date2 = d + model.getFirstSessionDay();
                    if (model.getFirstDay() >= 0 && (date2 < model.getFirstDay() || date2 > model.getFirstDay() + 6) || !hasDay[day2 = d % 7] || !model.hasDate(day2, date2)) continue;
                    nrLines += model.getNrDateLines(day2, date2, 2);
                }
                dayIndex[365] = nrLines;
                int headerLines = 1 + (comment != null && !comment.isEmpty() ? 1 : 0);
                this.iCellWidth = (pageWidth - sHeaderWidth) / nrTimes;
                this.setSize(sHeaderWidth + nrTimes * this.iCellWidth + 2, (headerLines + nrLines) * sLineHeight + 2);
                P name = new P("grid-name");
                name.setSize(sHeaderWidth, headerLines * sLineHeight);
                name.setText(model.getName() + (comment != null && !comment.isEmpty() ? "\n" + comment : ""));
                if (model.hasNameColor()) {
                    name.setColor(model.getNameColor());
                }
                this.add(name);
                P verticalHeader = new P("vertical-header");
                verticalHeader.setSize(sHeaderWidth, nrLines * sLineHeight + 1);
                this.add(verticalHeader, 0, headerLines * sLineHeight);
                P horizontalHeader = new P("horizontal-header");
                horizontalHeader.setSize(nrTimes * this.iCellWidth + 1, headerLines * sLineHeight);
                this.add(horizontalHeader, sHeaderWidth, 0);
                P panel = new P("timetable-panel");
                panel.setSize(nrTimes * this.iCellWidth + 1, nrLines * sLineHeight + 1);
                this.add(panel, sHeaderWidth, headerLines * sLineHeight);
                for (int i = 0; i < nrTimes; ++i) {
                    P hi = new P("header-interval");
                    hi.setSize(this.iCellWidth, headerLines * sLineHeight);
                    hi.setText(ExportTimetablePDF.slot2time(startSlot + i * step));
                    horizontalHeader.add(hi, i * this.iCellWidth, 0);
                    P vs = new P("vertical-separator");
                    panel.add(vs, i * this.iCellWidth, 0);
                }
                P lastVSpan = new P("vertical-separator");
                lastVSpan.setRight(0);
                lastVSpan.setTop(0);
                panel.add(lastVSpan);
                P lastVShead = new P("vertical-separator");
                lastVShead.setRight(0);
                lastVShead.setTop(0);
                horizontalHeader.add(lastVShead);
                for (int d = 0; d < 365; ++d) {
                    int day3;
                    int date3 = d + model.getFirstSessionDay();
                    if (model.getFirstDay() >= 0 && (date3 < model.getFirstDay() || date3 > model.getFirstDay() + 6) || !hasDay[day3 = d % 7] || !model.hasDate(day3, date3)) continue;
                    P p = new P("horizontal-separator");
                    panel.add(p, 0, sLineHeight * dayIndex[d]);
                    P p7 = new P("header-interval");
                    p7.setSize(sHeaderWidth, (dayIndex[1 + d] - dayIndex[d]) * sLineHeight);
                    p7.setText(sDateFormatMeeting.format(ExportTimetablePDF.getDate(model.getFirstDate(), d)));
                    verticalHeader.add(p7, 0, sLineHeight * dayIndex[d]);
                }
                P lastHSpan = new P("horizontal-separator");
                lastHSpan.setLeft(0);
                lastHSpan.setBottom(0);
                panel.add(lastHSpan);
                P lastHShead = new P("horizontal-separator");
                lastHShead.setLeft(0);
                lastHShead.setBottom(0);
                verticalHeader.add(lastHShead);
                for (TimetableGridInterface.TimetableGridBackground timetableGridBackground : model.getBackgrounds()) {
                    if (!hasDay[timetableGridBackground.getDay()] || timetableGridBackground.getSlot() + timetableGridBackground.getLength() <= startSlot || timetableGridBackground.getSlot() >= startSlot + step * nrTimes) continue;
                    for (int i = 0; i < 365; ++i) {
                        int n = i + model.getFirstSessionDay();
                        day = i % 7;
                        if (model.getFirstDay() >= 0 && (n < model.getFirstDay() || n > model.getFirstDay() + 6) || timetableGridBackground.getDay() != day) continue;
                        Background b = new Background(timetableGridBackground);
                        this.iBackbrounds.add(b);
                        b.setHeight((dayIndex[1 + i] - dayIndex[i]) * sLineHeight);
                        start = timetableGridBackground.getSlot();
                        stop = timetableGridBackground.getSlot() + timetableGridBackground.getLength();
                        if (start < startSlot) {
                            start = startSlot;
                        }
                        if (stop > endSlot) {
                            stop = endSlot;
                        }
                        b.setWidth(stop * this.iCellWidth / step - start * this.iCellWidth / step);
                        panel.add(b, (start - startSlot) * this.iCellWidth / step, dayIndex[i] * sLineHeight);
                    }
                }
                for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                    if (!hasDay[timetableGridCell.getDay()] || timetableGridCell.getSlot() + timetableGridCell.getLength() <= startSlot || timetableGridCell.getSlot() >= startSlot + step * nrTimes) continue;
                    for (int i = 0; i < 365; ++i) {
                        int n = i + model.getFirstSessionDay();
                        if (model.getFirstDay() >= 0 && (n < model.getFirstDay() || n > model.getFirstDay() + 6)) continue;
                        day = i % 7;
                        if (timetableGridCell.getDay() != day || !timetableGridCell.hasDate(n)) continue;
                        Meeting m = new Meeting(timetableGridCell, showRoom, showInstructors, showTimes, showPreferences, showDate);
                        this.iMeetings.add(m);
                        m.setHeight(1 + timetableGridCell.getNrLines() * sLineHeight);
                        start = timetableGridCell.getSlot();
                        stop = timetableGridCell.getSlot() + timetableGridCell.getLength();
                        if (start < startSlot) {
                            start = startSlot;
                        }
                        if (stop > endSlot) {
                            stop = endSlot;
                        }
                        m.setWidth(1 + (stop - startSlot) * this.iCellWidth / step - (start - startSlot) * this.iCellWidth / step);
                        panel.add(m, (start - startSlot) * this.iCellWidth / step, (dayIndex[i] + timetableGridCell.getIndex()) * sLineHeight);
                    }
                }
            }
        }
    }

    protected static class P {
        private Integer iLeft;
        private Integer iTop;
        private Integer iRight;
        private Integer iBottom;
        private Integer iWidth;
        private Integer iHeight;
        private String iText;
        private String iStyle;
        private boolean iItalics = false;
        private String iColor;
        private String iBgColor;
        private List<P> iContent = new ArrayList<P>();

        public P(String style) {
            this.iStyle = style;
        }

        public void setWidth(int width) {
            this.iWidth = width;
        }

        public void setHeight(int height) {
            this.iHeight = height;
        }

        public void setSize(int width, int height) {
            this.setWidth(width);
            this.setHeight(height);
        }

        public void setText(String text) {
            this.iText = text;
        }

        public void setLeft(int left) {
            this.iLeft = left;
        }

        public void setRight(int right) {
            this.iRight = right;
        }

        public void setBottom(int bottom) {
            this.iBottom = bottom;
        }

        public void setTop(int top) {
            this.iTop = top;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public void setBackgroundColor(String color) {
            this.iBgColor = color;
        }

        public void setItalics(boolean italics) {
            this.iItalics = italics;
        }

        public void add(P p) {
            this.iContent.add(p);
        }

        public void add(P p, int left, int top) {
            p.iTop = top;
            p.iLeft = left;
            this.iContent.add(p);
        }

        public int getLeft() {
            if (this.iLeft != null) {
                return this.iLeft;
            }
            if (this.iRight != null) {
                return this.getWidth() - this.iRight;
            }
            return 0;
        }

        public int getTop() {
            if (this.iTop != null) {
                return this.iTop;
            }
            if (this.iBottom != null) {
                return this.getHeight() - this.iBottom;
            }
            return 0;
        }

        public int getWidth() {
            if (this.iWidth != null) {
                return this.iWidth;
            }
            int width = 0;
            for (P p : this.iContent) {
                int w = p.getLeft() + p.getWidth();
                if (w <= width) continue;
                width = w;
            }
            return width;
        }

        public int getHeight() {
            if (this.iHeight != null) {
                return this.iHeight;
            }
            int height = 0;
            for (P p : this.iContent) {
                int h = p.getTop() + p.getHeight();
                if (h <= height) continue;
                height = h;
            }
            return height;
        }

        public boolean hasText() {
            return this.iText != null && !this.iText.isEmpty();
        }

        public String getText() {
            return this.iText;
        }

        public String getStyle() {
            return this.iStyle;
        }

        public boolean isStyle(String ... style) {
            for (String s : style) {
                if (!s.equals(this.iStyle)) continue;
                return true;
            }
            return false;
        }

        protected void print(PdfContentByte canvas, int x, int y, int pageHeight, P parent) throws DocumentException {
            Pattern p;
            Matcher m;
            if (this.isStyle("unitime-TimetableGrid")) {
                this.setHeight(this.getHeight() - 2);
                this.setWidth(this.getWidth() - 1);
            }
            if (this.isStyle("vertical-separator")) {
                this.setHeight(parent.getHeight());
                this.setHeight(this.getHeight() - 1);
            }
            if (this.isStyle("horizontal-separator")) {
                this.setWidth(parent.getWidth());
                this.setWidth(this.getWidth() - 1);
            }
            Rectangle rect = new Rectangle((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())), (float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop() + this.getHeight() - 1)));
            if (parent != null && parent.isStyle("meeting")) {
                rect.setBackgroundColor(Color.WHITE);
            }
            if (this.iBgColor != null && (m = (p = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)")).matcher(this.iBgColor)).matches()) {
                rect.setBackgroundColor(new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))));
            }
            if (parent != null && parent.isStyle("meeting")) {
                if (parent.iBgColor != null) {
                    p = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)");
                    m = p.matcher(parent.iBgColor);
                    if (m.matches()) {
                        Color color = new Color(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
                        if (this.isStyle("header")) {
                            rect.setBackgroundColor(color.darker());
                        } else {
                            rect.setBackgroundColor(color);
                        }
                    }
                } else {
                    Color color = new Color(240, 240, 240);
                    if (this.isStyle("header")) {
                        rect.setBackgroundColor(color.darker());
                    } else {
                        rect.setBackgroundColor(color);
                    }
                }
            }
            if (rect.getBackgroundColor() != null) {
                canvas.rectangle(rect);
            }
            if (this.hasText()) {
                Pattern p2;
                Matcher m2;
                boolean bold = this.isStyle("grid-name", "horizontal-header", "vertical-header");
                if (this.isStyle("header") && parent.isStyle("meeting")) {
                    bold = true;
                }
                boolean italics = this.iItalics;
                int alignment = 1;
                Font font = PdfFont.getSmallFont(bold, italics);
                if (this.iColor != null && (m2 = (p2 = Pattern.compile("rgb\\(([0-9]+),([0-9]+),([0-9]+)\\)")).matcher(this.iColor)).matches()) {
                    font.setColor(new Color(Integer.parseInt(m2.group(1)), Integer.parseInt(m2.group(2)), Integer.parseInt(m2.group(3))));
                }
                int idx = 0;
                for (String line : this.getText().split("\\n")) {
                    Phrase p3 = new Phrase(line, font);
                    ColumnText ct = new ColumnText(canvas);
                    ct.setSimpleColumn(p3, (float)(x + this.getLeft() + 2), (float)(pageHeight - (y + this.getTop() + 2 + sLineHeight * idx)), (float)(x + this.getLeft() + this.getWidth() - 4), (float)pageHeight - ((float)(y + this.getTop() + 2 + sLineHeight * idx) + 15.0f), 8.0f, alignment);
                    ct.go();
                    ++idx;
                }
            }
            if (this.isStyle("footer") && parent.isStyle("meeting")) {
                canvas.setColorStroke(Color.BLACK);
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight() - 1)));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop() + this.getHeight() - 1)));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop())));
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.closePathStroke();
            }
            if (this.isStyle("header") && parent.isStyle("meeting")) {
                canvas.setColorStroke(Color.BLACK);
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.closePathStroke();
            }
            if (this.isStyle("vertical-separator")) {
                canvas.setColorStroke(Color.GRAY);
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.closePathStroke();
            }
            if (this.isStyle("horizontal-separator")) {
                canvas.setColorStroke(Color.GRAY);
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth()), (float)(pageHeight - (y + this.getTop())));
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.closePathStroke();
            }
            if (this.isStyle("header-interval")) {
                canvas.setColorStroke(Color.GRAY);
                canvas.moveTo((float)(x + this.getLeft() + this.getWidth()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.moveTo((float)(x + this.getLeft() + this.getWidth()), (float)(pageHeight - (y + this.getTop())));
                canvas.closePathStroke();
            }
            if (this.isStyle("unitime-TimetableGrid")) {
                canvas.setColorStroke(Color.GRAY);
                canvas.moveTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop())));
                canvas.lineTo((float)(x + this.getLeft() + this.getWidth() - 1), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.lineTo((float)(x + this.getLeft()), (float)(pageHeight - (y + this.getTop() + this.getHeight())));
                canvas.closePathStroke();
            }
            for (P p4 : this.iContent) {
                p4.print(canvas, x + this.getLeft(), y + this.getTop(), pageHeight, this);
            }
        }
    }
}

