/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.solver.TableExporter;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

@Service(value="org.unitime.timetable.export.Exporter:solution-reports.pdf")
public class ExportSolutionReportsPDF
extends TableExporter {
    @Autowired
    private ApplicationContext applicationContext;

    public String reference() {
        return "solution-reports.pdf";
    }

    public void export(ExportHelper helper) throws IOException {
        String tableId = helper.getParameter("table");
        GwtRpcImplementation service = (GwtRpcImplementation)this.applicationContext.getBean(CourseTimetablingSolverInterface.SolverReportsRequest.class.getName());
        CourseTimetablingSolverInterface.SolverReportsRequest request = new CourseTimetablingSolverInterface.SolverReportsRequest();
        CourseTimetablingSolverInterface.SolverReportsResponse response = (CourseTimetablingSolverInterface.SolverReportsResponse)service.execute(request, helper.getSessionContext());
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), true);
        if (response.hasTables()) {
            for (TableInterface table : response.getTables()) {
                if (!table.getTableId().equals(tableId)) continue;
                this.printTablePDF(table, helper);
                return;
            }
        }
    }
}

