/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.base.BaseCourseEvent;
import org.unitime.timetable.model.base.BaseMeeting;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventRoomAvailabilityRpcRequest.class)
public class EventRoomAvailabilityBackend
extends EventAction<EventInterface.EventRoomAvailabilityRpcRequest, EventInterface.EventRoomAvailabilityRpcResponse> {
    @Override
    public EventInterface.EventRoomAvailabilityRpcResponse execute(EventInterface.EventRoomAvailabilityRpcRequest request, EventAction.EventContext context) {
        EventInterface.ContactInterface contact;
        HashMap<Long, EventInterface.ContactInterface> contacts;
        EventInterface.MeetingConflictInterface conflict;
        EventInterface.EventRoomAvailabilityRpcResponse response = new EventInterface.EventRoomAvailabilityRpcResponse();
        Session session = (Session)SessionDAO.getInstance().get(request.getSessionId());
        String nameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (request.hasDates() && request.hasLocations()) {
            for (int idx = 0; idx < request.getLocations().size(); idx += 1000) {
                int i;
                String dates = "";
                for (int i2 = 0; i2 < request.getDates().size(); ++i2) {
                    dates = dates + (dates.isEmpty() ? "" : ",") + ":d" + i2;
                }
                String locations = "";
                for (int i3 = 0; i3 + idx < request.getLocations().size() && i3 < 1000; ++i3) {
                    locations = locations + (locations.isEmpty() ? "" : ",") + ":l" + i3;
                }
                Query query = EventDAO.getInstance().getSession().createQuery("select m from Meeting m, Location l where m.startPeriod<:stopTime and m.stopPeriod>:startTime and m.approvalStatus <= 1 and l.session.uniqueId = :sessionId and l.permanentId in (" + locations + ") and l.ignoreRoomCheck = false and m.locationPermanentId = l.permanentId and m.meetingDate in (" + dates + ")");
                query.setInteger("startTime", request.getStartSlot().intValue());
                query.setInteger("stopTime", request.getEndSlot().intValue());
                query.setLong("sessionId", request.getSessionId().longValue());
                for (i = 0; i < request.getDates().size(); ++i) {
                    Date date = CalendarUtils.dateOfYear2date(session.getSessionStartYear(), request.getDates().get(i));
                    query.setDate("d" + i, date);
                }
                for (i = 0; i + idx < request.getLocations().size() && i < 1000; ++i) {
                    query.setLong("l" + i, request.getLocations().get(idx + i).longValue());
                }
                for (Object m : query.list()) {
                    Event ce;
                    conflict = new EventInterface.MeetingConflictInterface();
                    if (request.hasEventId() && ((BaseMeeting)m).getEvent().getUniqueId().equals(request.getEventId())) continue;
                    conflict.setEventId(((BaseMeeting)m).getEvent().getUniqueId());
                    conflict.setName(((BaseMeeting)m).getEvent().getEventName());
                    conflict.setType(EventInterface.EventType.values()[((BaseMeeting)m).getEvent().getEventType()]);
                    conflict.setLimit(((BaseMeeting)m).getEvent().getMaxCapacity());
                    if (((BaseMeeting)m).getEvent().getSponsoringOrganization() != null) {
                        EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                        sponsor.setEmail(((BaseMeeting)m).getEvent().getSponsoringOrganization().getEmail());
                        sponsor.setName(((BaseMeeting)m).getEvent().getSponsoringOrganization().getName());
                        sponsor.setUniqueId(((BaseMeeting)m).getEvent().getSponsoringOrganization().getUniqueId());
                        conflict.setSponsor(sponsor);
                    }
                    if (0 == ((BaseMeeting)m).getEvent().getEventType()) {
                        ce = ((BaseMeeting)m).getEvent() instanceof ClassEvent ? (ClassEvent)((BaseMeeting)m).getEvent() : (ClassEvent)ClassEventDAO.getInstance().get(((BaseMeeting)m).getEvent().getUniqueId());
                        Class_ clazz = ((BaseClassEvent)ce).getClazz();
                        conflict.setEnrollment(clazz.getEnrollment());
                        if (clazz.getDisplayInstructor().booleanValue()) {
                            for (ClassInstructor i4 : clazz.getClassInstructors()) {
                                if (i4.getResponsibility() != null && i4.getResponsibility().hasOption(TeachingResponsibility.Option.noevents)) continue;
                                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                instructor.setFirstName(i4.getInstructor().getFirstName());
                                instructor.setMiddleName(i4.getInstructor().getMiddleName());
                                instructor.setLastName(i4.getInstructor().getLastName());
                                instructor.setAcademicTitle(i4.getInstructor().getAcademicTitle());
                                instructor.setEmail(i4.getInstructor().getEmail());
                                instructor.setFormattedName(i4.getInstructor().getName(nameFormat));
                                if (i4.getResponsibility() != null) {
                                    instructor.setResponsibility(i4.getResponsibility().getLabel());
                                    instructor.setResponsibilityAbbreviation(i4.getResponsibility().getAbbreviation());
                                }
                                conflict.addInstructor(instructor);
                            }
                        }
                    } else if (1 == ((BaseMeeting)m).getEvent().getEventType() || 2 == ((BaseMeeting)m).getEvent().getEventType()) {
                        ExamEvent xe = ((BaseMeeting)m).getEvent() instanceof ExamEvent ? (ExamEvent)((BaseMeeting)m).getEvent() : (ExamEvent)ExamEventDAO.getInstance().get(((BaseMeeting)m).getEvent().getUniqueId());
                        conflict.setEnrollment(xe.getExam().countStudents());
                        for (DepartmentalInstructor departmentalInstructor : xe.getExam().getInstructors()) {
                            EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                            instructor.setFirstName(departmentalInstructor.getFirstName());
                            instructor.setMiddleName(departmentalInstructor.getMiddleName());
                            instructor.setLastName(departmentalInstructor.getLastName());
                            instructor.setAcademicTitle(departmentalInstructor.getAcademicTitle());
                            instructor.setEmail(departmentalInstructor.getEmail());
                            instructor.setFormattedName(departmentalInstructor.getName(nameFormat));
                            conflict.addInstructor(instructor);
                        }
                    } else if (3 == ((BaseMeeting)m).getEvent().getEventType()) {
                        ce = ((BaseMeeting)m).getEvent() instanceof CourseEvent ? (CourseEvent)((BaseMeeting)m).getEvent() : (CourseEvent)CourseEventDAO.getInstance().get(((BaseMeeting)m).getEvent().getUniqueId());
                        int enrl = 0;
                        for (RelatedCourseInfo owner : ((BaseCourseEvent)ce).getRelatedCourses()) {
                            enrl += owner.countStudents();
                        }
                        conflict.setEnrollment(enrl);
                    }
                    conflict.setId(((BaseMeeting)m).getUniqueId());
                    conflict.setMeetingDate(((BaseMeeting)m).getMeetingDate());
                    conflict.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), ((BaseMeeting)m).getMeetingDate()));
                    conflict.setStartOffset(((BaseMeeting)m).getStartOffset() == null ? 0 : ((BaseMeeting)m).getStartOffset());
                    conflict.setEndOffset(((BaseMeeting)m).getStopOffset() == null ? 0 : ((BaseMeeting)m).getStopOffset());
                    conflict.setStartSlot(((BaseMeeting)m).getStartPeriod());
                    conflict.setEndSlot(((BaseMeeting)m).getStopPeriod());
                    conflict.setApprovalDate(((BaseMeeting)m).getApprovalDate());
                    conflict.setApprovalStatus(((BaseMeeting)m).getApprovalStatus());
                    if (context.hasPermission(Right.EventCanViewMeetingContacts)) {
                        contacts = new HashMap<Long, EventInterface.ContactInterface>();
                        for (EventContact eventContact : ((BaseMeeting)m).getMeetingContacts()) {
                            contact = (EventInterface.ContactInterface)contacts.get(eventContact.getUniqueId());
                            if (contact == null) {
                                contact = new EventInterface.ContactInterface();
                                contact.setFirstName(eventContact.getFirstName());
                                contact.setMiddleName(eventContact.getMiddleName());
                                contact.setLastName(eventContact.getLastName());
                                contact.setAcademicTitle(eventContact.getAcademicTitle());
                                contact.setExternalId(eventContact.getExternalUniqueId());
                                contact.setPhone(eventContact.getPhone());
                                contact.setEmail(eventContact.getEmailAddress());
                                contact.setFormattedName(eventContact.getName(nameFormat));
                                contacts.put(eventContact.getUniqueId(), contact);
                            }
                            conflict.addMeetingContact(contact);
                        }
                    }
                    response.addOverlap(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), ((BaseMeeting)m).getMeetingDate()), ((BaseMeeting)m).getLocationPermanentId(), conflict);
                }
                query = EventDAO.getInstance().getSession().createQuery("from Location where session.uniqueId = :sessionId and permanentId in (" + locations + ")");
                for (int i6 = 0; i6 + idx < request.getLocations().size() && i6 < 1000; ++i6) {
                    query.setLong("l" + i6, request.getLocations().get(idx + i6).longValue());
                }
                for (Location location : query.setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list()) {
                    if (context.hasPermission(location, request.getEventType() == EventInterface.EventType.Unavailabile ? Right.EventLocationUnavailable : Right.EventLocation)) {
                        TreeSet<EventInterface.MeetingConflictInterface> conflicts = EventRoomAvailabilityBackend.generateUnavailabilityMeetings(location, request.getDates(), request.getStartSlot(), request.getEndSlot());
                        if (conflicts == null || conflicts.isEmpty()) continue;
                        for (EventInterface.MeetingConflictInterface conflict2 : conflicts) {
                            response.addOverlap(conflict2.getDayOfYear(), location.getPermanentId(), conflict2);
                        }
                        continue;
                    }
                    for (Integer date : request.getDates()) {
                        String string;
                        EventInterface.MeetingConflictInterface conflict2 = new EventInterface.MeetingConflictInterface();
                        if (location == null || location.getEventDepartment() == null || !location.getEventDepartment().isAllowEvents().booleanValue()) {
                            conflict2.setName(MESSAGES.conflictNotEventRoom(location.getLabel()));
                        } else if (request.getEventType() == EventInterface.EventType.Unavailabile) {
                            conflict2.setName(MESSAGES.conflictCannotMakeUnavailable(location.getLabel()));
                        } else {
                            conflict2.setName(MESSAGES.conflictRoomDenied(location.getLabel()));
                        }
                        if (location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue() && (string = location.getEventMessage()) != null && !string.isEmpty()) {
                            conflict2.setName(string);
                        }
                        conflict2.setType(EventInterface.EventType.Unavailabile);
                        conflict2.setMeetingDate(CalendarUtils.dateOfYear2date(session.getSessionStartYear(), date));
                        conflict2.setDayOfYear(date);
                        conflict2.setStartOffset(0);
                        conflict2.setEndOffset(0);
                        conflict2.setStartSlot(0);
                        conflict2.setEndSlot(288);
                        response.addOverlap(date, location.getPermanentId(), conflict2);
                    }
                }
            }
        }
        if (request.hasMeetings()) {
            response.setMeetings(request.getMeetings());
            for (EventInterface.MeetingInterface meeting : response.getMeetings()) {
                int tooEarly;
                if (meeting.hasConflicts()) {
                    meeting.getConflicts().clear();
                }
                if (meeting.getMeetingDate() == null) {
                    meeting.setMeetingDate(CalendarUtils.dateOfYear2date(session.getSessionStartYear(), meeting.getDayOfYear()));
                    meeting.setDayOfWeek(Constants.getDayOfWeek(meeting.getMeetingDate()));
                }
                if (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted || meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled || meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected) continue;
                if (context.isPastOrOutside(meeting.getMeetingDate())) {
                    EventInterface.MeetingConflictInterface conflict4 = new EventInterface.MeetingConflictInterface();
                    conflict4.setName(MESSAGES.conflictPastOrOutside(session.getLabel()));
                    conflict4.setType(meeting.getId() == null ? EventInterface.EventType.Unavailabile : EventInterface.EventType.Message);
                    conflict4.setMeetingDate(meeting.getMeetingDate());
                    conflict4.setDayOfYear(meeting.getDayOfYear());
                    conflict4.setStartOffset(0);
                    conflict4.setEndOffset(0);
                    conflict4.setStartSlot(0);
                    conflict4.setEndSlot(288);
                    conflict4.setPast(true);
                    meeting.addConflict(conflict4);
                }
                if (!meeting.hasLocation()) continue;
                meeting.setCanApprove(context.hasPermission(meeting.getLocation().getId(), "Location", Right.EventLocationApprove));
                Location location = (Location)LocationDAO.getInstance().get(meeting.getLocation().getId());
                boolean available = true;
                meeting.setAutomaticallyApproved(location != null && location.getEffectiveEventStatus().isAutomaticApproval());
                if (location == null || !context.hasPermission(location, Right.EventLocation)) {
                    String message;
                    EventInterface.MeetingConflictInterface conflict5 = new EventInterface.MeetingConflictInterface();
                    if (location == null || location.getEventDepartment() == null || !location.getEventDepartment().isAllowEvents().booleanValue()) {
                        conflict5.setName(MESSAGES.conflictNotEventRoom(meeting.getLocationName()));
                    } else {
                        conflict5.setName(MESSAGES.conflictRoomDenied(meeting.getLocationName()));
                    }
                    if (location != null && location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue() && (message = location.getEventMessage()) != null && !message.isEmpty()) {
                        conflict5.setName(message);
                    }
                    conflict5.setType(meeting.getId() == null ? EventInterface.EventType.Unavailabile : EventInterface.EventType.Message);
                    conflict5.setMeetingDate(meeting.getMeetingDate());
                    conflict5.setDayOfYear(meeting.getDayOfYear());
                    conflict5.setStartOffset(0);
                    conflict5.setEndOffset(0);
                    conflict5.setStartSlot(0);
                    conflict5.setEndSlot(288);
                    meeting.addConflict(conflict5);
                    available = false;
                } else if (request.getEventType() == EventInterface.EventType.Unavailabile && !context.hasPermission(location, Right.EventLocationUnavailable)) {
                    EventInterface.MeetingConflictInterface conflict6 = new EventInterface.MeetingConflictInterface();
                    if (location == null || location.getEventDepartment() == null || !location.getEventDepartment().isAllowEvents().booleanValue()) {
                        conflict6.setName(MESSAGES.conflictNotEventRoom(meeting.getLocationName()));
                    } else {
                        conflict6.setName(MESSAGES.conflictCannotMakeUnavailable(meeting.getLocationName()));
                    }
                    conflict6.setType(meeting.getId() == null ? EventInterface.EventType.Unavailabile : EventInterface.EventType.Message);
                    conflict6.setMeetingDate(meeting.getMeetingDate());
                    conflict6.setDayOfYear(meeting.getDayOfYear());
                    conflict6.setStartOffset(0);
                    conflict6.setEndOffset(0);
                    conflict6.setStartSlot(0);
                    conflict6.setEndSlot(288);
                    meeting.addConflict(conflict6);
                    available = false;
                }
                if (!location.isIgnoreRoomCheck().booleanValue()) {
                    for (Object m : EventDAO.getInstance().getSession().createQuery("select m from Meeting m, Location l where m.startPeriod < :stopTime and m.stopPeriod > :startTime and m.approvalStatus <= 1 and m.locationPermanentId = l.permanentId and l.uniqueId = :locationdId and m.meetingDate = :meetingDate and m.uniqueId != :meetingId").setInteger("startTime", meeting.getStartSlot()).setInteger("stopTime", meeting.getEndSlot()).setDate("meetingDate", meeting.getMeetingDate()).setLong("locationdId", meeting.getLocation().getId().longValue()).setLong("meetingId", meeting.getId() == null ? -1L : meeting.getId()).list()) {
                        conflict = new EventInterface.MeetingConflictInterface();
                        if (request.hasEventId() && ((BaseMeeting)m).getEvent().getUniqueId().equals(request.getEventId())) continue;
                        conflict.setEventId(((BaseMeeting)m).getEvent().getUniqueId());
                        conflict.setName(((BaseMeeting)m).getEvent().getEventName());
                        conflict.setType(EventInterface.EventType.values()[((BaseMeeting)m).getEvent().getEventType()]);
                        conflict.setId(((BaseMeeting)m).getUniqueId());
                        conflict.setMeetingDate(((BaseMeeting)m).getMeetingDate());
                        conflict.setDayOfYear(meeting.getDayOfYear());
                        conflict.setStartSlot(((BaseMeeting)m).getStartPeriod());
                        conflict.setEndSlot(((BaseMeeting)m).getStopPeriod());
                        conflict.setStartOffset(((BaseMeeting)m).getStartOffset() == null ? 0 : ((BaseMeeting)m).getStartOffset());
                        conflict.setEndOffset(((BaseMeeting)m).getStopOffset() == null ? 0 : ((BaseMeeting)m).getStopOffset());
                        conflict.setApprovalDate(((BaseMeeting)m).getApprovalDate());
                        conflict.setApprovalStatus(((BaseMeeting)m).getApprovalStatus());
                        if (context.hasPermission(Right.EventCanViewMeetingContacts)) {
                            contacts = new HashMap();
                            for (EventContact eventContact : ((BaseMeeting)m).getMeetingContacts()) {
                                contact = (EventInterface.ContactInterface)contacts.get(eventContact.getUniqueId());
                                if (contact == null) {
                                    contact = new EventInterface.ContactInterface();
                                    contact.setFirstName(eventContact.getFirstName());
                                    contact.setMiddleName(eventContact.getMiddleName());
                                    contact.setLastName(eventContact.getLastName());
                                    contact.setAcademicTitle(eventContact.getAcademicTitle());
                                    contact.setExternalId(eventContact.getExternalUniqueId());
                                    contact.setPhone(eventContact.getPhone());
                                    contact.setEmail(eventContact.getEmailAddress());
                                    contact.setFormattedName(eventContact.getName(nameFormat));
                                    contacts.put(eventContact.getUniqueId(), contact);
                                }
                                conflict.addMeetingContact(contact);
                            }
                        }
                        meeting.addConflict(conflict);
                    }
                }
                if (location != null && location.getEventAvailability() != null && location.getEventAvailability().length() == 288 * Constants.DAY_CODES.length) {
                    for (int slot = meeting.getStartSlot(); slot < meeting.getEndSlot(); ++slot) {
                        Object m;
                        if (location.getEventAvailability().charAt(meeting.getDayOfWeek() * 288 + slot) != '1') continue;
                        m = EventRoomAvailabilityBackend.generateUnavailabilityMeetings(location, meeting).iterator();
                        while (m.hasNext()) {
                            conflict = (EventInterface.MeetingConflictInterface)m.next();
                            meeting.addConflict(conflict);
                        }
                        break;
                    }
                }
                if (!available) continue;
                if (location.getEventDepartment() == null || !location.getEventDepartment().isAllowEvents().booleanValue()) {
                    EventInterface.MeetingConflictInterface conflict7 = new EventInterface.MeetingConflictInterface();
                    conflict7.setName(MESSAGES.conflictNotEventRoom(meeting.getLocationName()));
                    conflict7.setType(EventInterface.EventType.Message);
                    conflict7.setMeetingDate(meeting.getMeetingDate());
                    conflict7.setDayOfYear(meeting.getDayOfYear());
                    conflict7.setStartOffset(0);
                    conflict7.setEndOffset(0);
                    conflict7.setStartSlot(0);
                    conflict7.setEndSlot(288);
                    meeting.addConflict(conflict7);
                } else {
                    String message = location.getEventMessage();
                    if (message != null && !message.isEmpty()) {
                        EventInterface.MeetingConflictInterface conflict3 = new EventInterface.MeetingConflictInterface();
                        conflict3.setName(message);
                        conflict3.setType(EventInterface.EventType.Message);
                        conflict3.setMeetingDate(meeting.getMeetingDate());
                        conflict3.setDayOfYear(meeting.getDayOfYear());
                        conflict3.setStartOffset(0);
                        conflict3.setEndOffset(0);
                        conflict3.setStartSlot(0);
                        conflict3.setEndSlot(288);
                        meeting.addConflict(conflict3);
                    }
                }
                if ((tooEarly = ApplicationProperty.EventTooEarlySlot.intValue().intValue()) < 0 || (meeting.getStartSlot() <= 0 || meeting.getStartSlot() > tooEarly) && (meeting.getStartSlot() != 0 || meeting.getEndSlot() > tooEarly)) continue;
                EventInterface.MeetingConflictInterface conflict3 = new EventInterface.MeetingConflictInterface();
                conflict3.setName(MESSAGES.warnMeetingTooEarly(meeting.getAllocatedTime(CONSTANTS)));
                conflict3.setType(EventInterface.EventType.Message);
                conflict3.setMeetingDate(meeting.getMeetingDate());
                conflict3.setDayOfYear(meeting.getDayOfYear());
                conflict3.setStartOffset(0);
                conflict3.setEndOffset(0);
                conflict3.setStartSlot(0);
                conflict3.setEndSlot(288);
                meeting.addConflict(conflict3);
            }
        }
        return response;
    }

    public static TreeSet<EventInterface.MeetingConflictInterface> generateUnavailabilityMeetings(Location location, List<Integer> dates, int startSlot, int endSlot) {
        if (location.getEventAvailability() == null || location.getEventAvailability().length() != 288 * Constants.DAY_CODES.length) {
            return null;
        }
        TreeSet<EventInterface.MeetingConflictInterface> ret = new TreeSet<EventInterface.MeetingConflictInterface>();
        EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
        resource.setType(EventInterface.ResourceType.ROOM);
        resource.setId(location.getUniqueId());
        resource.setName(location.getLabel());
        resource.setSize(location.getCapacity());
        resource.setRoomType(location.getRoomTypeLabel());
        resource.setBreakTime(location.getEffectiveBreakTime());
        resource.setMessage(location.getEventMessage());
        resource.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        resource.setDisplayName(location.getDisplayName());
        Calendar calendar = Calendar.getInstance();
        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
            int startTime = 0;
            while (startTime < 288) {
                int endTime;
                if (location.getEventAvailability().charAt(day * 288 + startTime) != '1') {
                    ++startTime;
                    continue;
                }
                for (endTime = startTime + 1; endTime < 288 && location.getEventAvailability().charAt(day * 288 + endTime) == '1'; ++endTime) {
                }
                if (startTime < endSlot && startSlot < endTime) {
                    calendar.setTime(location.getSession().getEventBeginDate());
                    int dayOfYear = CalendarUtils.date2dayOfYear(location.getSession().getSessionStartYear(), calendar.getTime());
                    do {
                        if (dates.contains(dayOfYear)) {
                            int dayOfWeek = -1;
                            switch (calendar.get(7)) {
                                case 2: {
                                    dayOfWeek = 0;
                                    break;
                                }
                                case 3: {
                                    dayOfWeek = 1;
                                    break;
                                }
                                case 4: {
                                    dayOfWeek = 2;
                                    break;
                                }
                                case 5: {
                                    dayOfWeek = 3;
                                    break;
                                }
                                case 6: {
                                    dayOfWeek = 4;
                                    break;
                                }
                                case 7: {
                                    dayOfWeek = 5;
                                    break;
                                }
                                case 1: {
                                    dayOfWeek = 6;
                                }
                            }
                            if (day == dayOfWeek) {
                                EventInterface.MeetingConflictInterface m = new EventInterface.MeetingConflictInterface();
                                m.setName(MESSAGES.unavailableEventDefaultName());
                                m.setType(EventInterface.EventType.Unavailabile);
                                m.setStartSlot(startTime);
                                m.setEndSlot(endTime);
                                m.setDayOfWeek(dayOfWeek);
                                m.setMeetingDate(calendar.getTime());
                                m.setDayOfYear(dayOfYear);
                                m.setLocation(resource);
                                ret.add(m);
                            }
                        }
                        calendar.add(6, 1);
                        ++dayOfYear;
                    } while (!calendar.getTime().after(location.getSession().getEventEndDate()));
                }
                startTime = endTime;
            }
        }
        return ret;
    }

    public static TreeSet<EventInterface.MeetingConflictInterface> generateUnavailabilityMeetings(Location location, EventInterface.MeetingInterface meeting) {
        if (location.getEventAvailability() == null || location.getEventAvailability().length() != 288 * Constants.DAY_CODES.length) {
            return null;
        }
        TreeSet<EventInterface.MeetingConflictInterface> ret = new TreeSet<EventInterface.MeetingConflictInterface>();
        EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
        resource.setType(EventInterface.ResourceType.ROOM);
        resource.setId(location.getUniqueId());
        resource.setName(location.getLabel());
        resource.setSize(location.getCapacity());
        resource.setRoomType(location.getRoomTypeLabel());
        resource.setBreakTime(location.getEffectiveBreakTime());
        resource.setMessage(location.getEventMessage());
        resource.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        resource.setDisplayName(location.getDisplayName());
        int day = meeting.getDayOfWeek();
        int startTime = 0;
        while (startTime < 288) {
            int endTime;
            if (location.getEventAvailability().charAt(day * 288 + startTime) != '1') {
                ++startTime;
                continue;
            }
            for (endTime = startTime + 1; endTime < 288 && location.getEventAvailability().charAt(day * 288 + endTime) == '1'; ++endTime) {
            }
            if (startTime < meeting.getEndSlot() && meeting.getStartSlot() < endTime) {
                EventInterface.MeetingConflictInterface m = new EventInterface.MeetingConflictInterface();
                m.setName(MESSAGES.unavailableEventDefaultName());
                m.setType(EventInterface.EventType.Unavailabile);
                m.setStartSlot(startTime);
                m.setEndSlot(endTime);
                m.setDayOfWeek(meeting.getDayOfWeek());
                m.setMeetingDate(meeting.getMeetingDate());
                m.setDayOfYear(meeting.getDayOfYear());
                m.setLocation(resource);
                ret.add(m);
            }
            startTime = endTime;
        }
        return ret;
    }
}

