/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventLookupRpcRequest.class)
public class EventLookupBackend
extends EventAction<EventInterface.EventLookupRpcRequest, GwtRpcResponseList<EventInterface>> {
    private static Logger sLog = Logger.getLogger(EventLookupBackend.class);

    @Override
    public GwtRpcResponseList<EventInterface> execute(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        if (request.getResourceType() == EventInterface.ResourceType.PERSON) {
            if (!request.hasResourceExternalId()) {
                request.setResourceExternalId(context.isAuthenticated() ? context.getUser().getExternalUserId() : null);
            } else if (!request.getResourceExternalId().equals(context.isAuthenticated() ? context.getUser().getExternalUserId() : null)) {
                context.checkPermission(Right.EventLookupSchedule);
                Set<String> roles = request.getEventFilter().getOptions("role");
                if (roles == null) {
                    roles = new HashSet<String>();
                    if (context.hasPermission(Right.CanLookupStudents)) {
                        roles.add("Student");
                    }
                    if (context.hasPermission(Right.CanLookupInstructors)) {
                        roles.add("Instructor");
                        roles.add("Coordinator");
                    }
                    if (context.hasPermission(Right.CanLookupEventContacts)) {
                        roles.add("Contact");
                    }
                    if (roles.size() < 4) {
                        request.getEventFilter().setOptions("role", roles);
                    }
                } else {
                    if (!context.hasPermission(Right.CanLookupStudents)) {
                        roles.remove("Student");
                        roles.remove("student");
                    }
                    if (!context.hasPermission(Right.CanLookupInstructors)) {
                        roles.remove("Instructor");
                        roles.remove("instructor");
                        roles.remove("Coordinator");
                        roles.remove("coordinator");
                    }
                    if (!context.hasPermission(Right.CanLookupStudents)) {
                        roles.remove("Contact");
                        roles.remove("contact");
                    }
                }
            }
        }
        if (request.getEventFilter() == null) {
            EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
            eventFilter.setSessionId(request.getSessionId());
            request.setEventFilter(eventFilter);
        }
        return this.findEvents(request, context);
    }

    private static boolean hasChild(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.contains(clazz.getUniqueId())) {
            return true;
        }
        for (Class_ child : clazz.getChildClasses()) {
            if (!EventLookupBackend.hasChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasClassRestrictionChild(Set<Long> restrictions, SchedulingSubpart subpart) {
        for (Class_ other : subpart.getClasses()) {
            if (!restrictions.contains(other.getUniqueId())) continue;
            return true;
        }
        for (SchedulingSubpart child : subpart.getChildSubparts()) {
            if (!EventLookupBackend.hasClassRestrictionChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasClassRestriction(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.isEmpty()) {
            return false;
        }
        for (SchedulingSubpart parent = clazz.getSchedulingSubpart().getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
            for (Class_ other : parent.getClasses()) {
                if (!restrictions.contains(other.getUniqueId())) continue;
                return true;
            }
        }
        return EventLookupBackend.hasClassRestrictionChild(restrictions, clazz.getSchedulingSubpart());
    }

    public static boolean hide(Set<Long>[] restrictions, Class_ clazz) {
        if (!restrictions[0].isEmpty() && !restrictions[0].contains(clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId())) {
            return true;
        }
        if (EventLookupBackend.hasClassRestriction(restrictions[1], clazz)) {
            for (Class_ parent = clazz; parent != null; parent = parent.getParentClass()) {
                if (!restrictions[1].contains(parent.getUniqueId())) continue;
                return false;
            }
            for (Class_ child : clazz.getChildClasses()) {
                if (!EventLookupBackend.hasChild(restrictions[1], child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public GwtRpcResponseList<EventInterface> findEvents(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static EventInterface generateUnavailabilityEvent(Location location, EventInterface parent) {
        TreeSet<EventInterface.MeetingInterface> meetings = EventLookupBackend.generateUnavailabilityMeetings(location, false);
        if (meetings == null || meetings.isEmpty()) {
            return null;
        }
        EventInterface event = new EventInterface();
        event.setId(-location.getUniqueId().longValue());
        event.setName(MESSAGES.unavailableEventDefaultName());
        event.setType(EventInterface.EventType.Unavailabile);
        if (parent == null) {
            event.setMeetings(meetings);
        } else {
            for (EventInterface.MeetingInterface m : meetings) {
                if (!parent.inConflict(m)) continue;
                event.addMeeting(m);
            }
        }
        if (location.getNote() != null && !location.getNote().isEmpty()) {
            EventInterface.NoteInterface n = new EventInterface.NoteInterface();
            n.setNote(location.getNote());
            event.addNote(n);
        }
        return event;
    }

    public static TreeSet<EventInterface.MeetingInterface> generateUnavailabilityMeetings(Location location, boolean conflict) {
        if (location.getEventAvailability() == null || location.getEventAvailability().length() != 288 * Constants.DAY_CODES.length) {
            return null;
        }
        TreeSet<EventInterface.MeetingInterface> ret = new TreeSet<EventInterface.MeetingInterface>();
        EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
        resource.setType(EventInterface.ResourceType.ROOM);
        resource.setId(location.getUniqueId());
        resource.setName(location.getLabel());
        resource.setSize(location.getCapacity());
        resource.setRoomType(location.getRoomTypeLabel());
        resource.setBreakTime(location.getEffectiveBreakTime());
        resource.setMessage(location.getEventMessage());
        resource.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        resource.setDisplayName(location.getDisplayName());
        Calendar calendar = Calendar.getInstance();
        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
            int startTime = 0;
            while (startTime < 288) {
                int endTime;
                if (location.getEventAvailability().charAt(day * 288 + startTime) != '1') {
                    ++startTime;
                    continue;
                }
                for (endTime = startTime + 1; endTime < 288 && location.getEventAvailability().charAt(day * 288 + endTime) == '1'; ++endTime) {
                }
                calendar.setTime(location.getSession().getEventBeginDate());
                int dayOfYear = CalendarUtils.date2dayOfYear(location.getSession().getSessionStartYear(), calendar.getTime());
                do {
                    int dayOfWeek = -1;
                    switch (calendar.get(7)) {
                        case 2: {
                            dayOfWeek = 0;
                            break;
                        }
                        case 3: {
                            dayOfWeek = 1;
                            break;
                        }
                        case 4: {
                            dayOfWeek = 2;
                            break;
                        }
                        case 5: {
                            dayOfWeek = 3;
                            break;
                        }
                        case 6: {
                            dayOfWeek = 4;
                            break;
                        }
                        case 7: {
                            dayOfWeek = 5;
                            break;
                        }
                        case 1: {
                            dayOfWeek = 6;
                        }
                    }
                    if (day == dayOfWeek) {
                        EventInterface.MeetingInterface m = null;
                        if (conflict) {
                            EventInterface.MeetingConflictInterface c = new EventInterface.MeetingConflictInterface();
                            c.setName(MESSAGES.unavailableEventDefaultName());
                            c.setType(EventInterface.EventType.Unavailabile);
                            m = c;
                        } else {
                            m = new EventInterface.MeetingInterface();
                        }
                        m.setStartSlot(startTime);
                        m.setEndSlot(endTime);
                        m.setDayOfWeek(dayOfWeek);
                        m.setMeetingDate(calendar.getTime());
                        m.setDayOfYear(dayOfYear);
                        m.setLocation(resource);
                        ret.add(m);
                    }
                    calendar.add(6, 1);
                    ++dayOfYear;
                } while (!calendar.getTime().after(location.getSession().getEventEndDate()));
                startTime = endTime;
            }
        }
        return ret;
    }
}

