/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventEmail;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.dao.EventDAO;

public class EventExpirationService
extends Thread {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Logger sLog = Logger.getLogger(EventExpirationService.class);
    private long iSleepTimeInMinutes = 5L;
    private boolean iActive = true;
    private static EventExpirationService sInstance;
    private Long iLastExpirationCheck = null;

    private EventExpirationService() {
        this.setName("EventExpirationService");
        this.setDaemon(true);
        this.iSleepTimeInMinutes = ApplicationProperty.EventExpirationServiceUpdateInterval.intValue().intValue();
    }

    protected void checkForExpiredEventsIfNeeded() {
        long ts = System.currentTimeMillis();
        if (this.iLastExpirationCheck != null && ts - this.iLastExpirationCheck < 3600000L) {
            return;
        }
        if (this.iLastExpirationCheck == null || Calendar.getInstance().get(11) == 0) {
            try {
                sLog.info((Object)"Checking for expired events ...");
                this.checkForExpiredEvents();
                this.iLastExpirationCheck = ts;
            }
            catch (Exception e) {
                sLog.error((Object)("Expired events check failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForExpiredEvents() throws Exception {
        Session hibSession = EventDAO.getInstance().getSession();
        try {
            Transaction tx = hibSession.beginTransaction();
            try {
                Date now = new Date();
                for (Event event : hibSession.createQuery("select distinct e from Event e inner join e.meetings m where e.expirationDate is not null and m.approvalStatus = 0 and e.expirationDate < " + HibernateUtil.date(new Date())).list()) {
                    HashSet<Meeting> affectedMeetings = new HashSet<Meeting>();
                    String affectedMeetingStr = "";
                    for (Meeting meeting : event.getMeetings()) {
                        if (meeting.getStatus() != Meeting.Status.PENDING) continue;
                        meeting.setStatus(Meeting.Status.CANCELLED);
                        meeting.setApprovalDate(now);
                        hibSession.saveOrUpdate((Object)meeting);
                        affectedMeetings.add(meeting);
                        if (!affectedMeetingStr.isEmpty()) {
                            affectedMeetingStr = affectedMeetingStr + "<br>";
                        }
                        affectedMeetingStr = affectedMeetingStr + meeting.getTimeLabel() + (meeting.getLocation() == null ? "" : " " + meeting.getLocation().getLabel());
                    }
                    EventNote note = new EventNote();
                    note.setEvent(event);
                    note.setNoteType(7);
                    note.setTimeStamp(now);
                    note.setUser("SYSTEM");
                    note.setAffectedMeetings(affectedMeetings);
                    note.setMeetings(affectedMeetingStr);
                    note.setTextNote(MESSAGES.noteEventExpired());
                    event.getNotes().add(note);
                    hibSession.saveOrUpdate((Object)note);
                    hibSession.update((Object)event);
                    try {
                        EventEmail.eventExpired(event, affectedMeetings);
                    }
                    catch (Exception e) {
                        sLog.warn((Object)("Failed to sent notification for " + event.getEventName()), (Throwable)e);
                    }
                }
                tx.commit();
                tx = null;
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                sLog.error((Object)("Failed to expire some events: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
    }

    public static EventExpirationService getInstance() {
        if (sInstance == null) {
            sInstance = new EventExpirationService();
        }
        return sInstance;
    }

    public void run() {
        try {
            sLog.info((Object)"Event expiration service started.");
            while (this.iActive) {
                this.checkForExpiredEventsIfNeeded();
                try {
                    EventExpirationService.sleep(this.iSleepTimeInMinutes * 60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            sLog.info((Object)"Event expiration service stopped.");
        }
        catch (Exception e) {
            sLog.info((Object)("Event expiration service failed, " + e.getMessage()), (Throwable)e);
        }
    }

    public void interrupt() {
        this.iActive = false;
        super.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

