/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupType;

public class StudentGroupImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("studentGroups")) {
            throw new Exception("Given XML file is not student groups load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, StudentGroup> id2group = new Hashtable<String, StudentGroup>();
            Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
            for (StudentGroup group : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (group.getExternalUniqueId() != null) {
                    id2group.put(group.getExternalUniqueId(), group);
                }
                code2group.put(group.getGroupAbbreviation(), group);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String code = element.attributeValue("code");
                String name = element.attributeValue("name");
                String size = element.attributeValue("size");
                String type = element.attributeValue("type");
                StudentGroup group = null;
                if (externalId != null) {
                    group = (StudentGroup)id2group.remove(externalId);
                }
                if (group == null) {
                    group = (StudentGroup)code2group.get(code);
                }
                if (group == null) {
                    group = new StudentGroup();
                    group.setSession(session);
                    this.info("Group " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Group " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                group.setExternalUniqueId(externalId);
                group.setGroupAbbreviation(code);
                group.setGroupName(name);
                group.setType(type == null ? null : StudentGroupType.findByReference(type, this.getHibSession()));
                try {
                    group.setExpectedSize(size == null || size.isEmpty() ? null : Integer.valueOf(size));
                }
                catch (NumberFormatException e) {
                    group.setExpectedSize(null);
                }
                this.getHibSession().saveOrUpdate((Object)group);
            }
            for (StudentGroup group : id2group.values()) {
                this.info("Group " + group.getGroupAbbreviation() + " (" + group.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)group);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

