/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;

public class StudentAdvisorsExport
extends BaseExport {
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("studentAdvisors");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("created", new Date().toString());
            document.addDocType("studentAdvisors", "-//UniTime//UniTime Student Advisors DTD/EN", "http://www.unitime.org/interface/StudentAdvisors.dtd");
            for (Advisor advisor : this.getHibSession().createQuery("from Advisor a where a.session.uniqueId = :sessionId order by a.lastName, a.firstName, a.externalUniqueId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                Element advisorEl = root.addElement("studentAdvisor");
                advisorEl.addAttribute("externalId", advisor.getExternalUniqueId());
                if (advisor.getFirstName() != null) {
                    advisorEl.addAttribute("firstName", advisor.getFirstName());
                }
                if (advisor.getMiddleName() != null) {
                    advisorEl.addAttribute("middleName", advisor.getMiddleName());
                }
                if (advisor.getLastName() != null) {
                    advisorEl.addAttribute("lastName", advisor.getLastName());
                }
                if (advisor.getAcademicTitle() != null) {
                    advisorEl.addAttribute("acadTitle", advisor.getAcademicTitle());
                }
                if (advisor.getEmail() != null) {
                    advisorEl.addAttribute("email", advisor.getEmail());
                }
                if (advisor.getRole() != null) {
                    advisorEl.addAttribute("role", advisor.getRole().getReference());
                }
                Element updateStudentsEl = advisorEl.addElement("updateStudents");
                if (advisor.getStudents() == null) continue;
                for (Student student : advisor.getStudents()) {
                    if (student.getExternalUniqueId() == null) continue;
                    updateStudentsEl.addElement("student").addAttribute("externalId", student.getExternalUniqueId());
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }
}

