/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SubjectAreaDAO;

public class LastLikeCourseDemandImport
extends BaseImport {
    private HashMap<String, SubjectArea> subjectAreas = new HashMap();
    private HashMap<String, String> courseOfferings = new HashMap();
    private HashMap<String, String> externalIdCoursePermId = new HashMap();
    private HashMap<String, String> externalIdCourseNumber = new HashMap();
    private HashMap<String, SubjectArea> externalIdSubjectArea = new HashMap();
    protected TimetableManager manager = null;
    protected boolean trimLeadingZerosFromExternalId = false;

    public void loadXml(Element root) throws Exception {
        this.trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
        try {
            String rootElementName = "lastLikeCourseDemand";
            if (!root.getName().equalsIgnoreCase(rootElementName)) {
                throw new Exception("Given XML file is not a Course Offerings load file.");
            }
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = this.getOptionalStringAttribute(root, "created");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            this.loadSubjectAreas(session.getSessionId());
            this.loadCourseOfferings(session.getSessionId());
            this.beginTransaction();
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_LASTLIKE_DEMAND, ChangeLog.Operation.UPDATE, null, null);
            }
            this.getHibSession().createQuery("delete LastLikeCourseDemand ll where ll.subjectArea.uniqueId in (select s.uniqueId from SubjectArea s where s.session.uniqueId=:sessionId)").setLong("sessionId", session.getUniqueId().longValue()).executeUpdate();
            this.flush(true);
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Student student;
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                if (this.trimLeadingZerosFromExternalId) {
                    try {
                        Integer num = new Integer(externalId);
                        externalId = num.toString();
                    }
                    catch (Exception num) {
                        // empty catch block
                    }
                }
                if ((student = this.fetchStudent(externalId, session.getSessionId())) == null) {
                    student = new Student();
                    student.setFirstName("Unknown");
                    student.setLastName("Student");
                    student.setExternalUniqueId(externalId);
                    student.setFreeTimeCategory(new Integer(0));
                    student.setSchedulePreference(new Integer(0));
                    student.setSession(session);
                    this.getHibSession().save((Object)student);
                    this.getHibSession().flush();
                    this.getHibSession().refresh((Object)student);
                }
                this.loadCourses(element, student, session);
                this.flushIfNeeded(true);
            }
            this.flush(true);
            this.getHibSession().createQuery("update CourseOffering c set c.demand=(select count(distinct d.student) from LastLikeCourseDemand d where (c.subjectArea=d.subjectArea and c.courseNbr=d.courseNbr)) where c.permId is null and c.subjectArea.uniqueId in (select sa.uniqueId from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", session.getUniqueId().longValue()).executeUpdate();
            this.getHibSession().createQuery("update CourseOffering c set c.demand=(select count(distinct d.student) from LastLikeCourseDemand d where d.student.session=c.subjectArea.session and c.permId=d.coursePermId) where c.permId is not null and c.subjectArea.uniqueId in (select sa.uniqueId from SubjectArea sa where sa.session.uniqueId=:sessionId)").setLong("sessionId", session.getUniqueId().longValue()).executeUpdate();
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    Student fetchStudent(String externalId, Long sessionId) {
        return (Student)this.getHibSession().createQuery("select distinct a from Student as a where a.externalUniqueId=:externalId and a.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    private void loadCourses(Element studentEl, Student student, Session session) throws Exception {
        int row = 0;
        Iterator it = studentEl.elementIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String subject = this.getOptionalStringAttribute(el, "subject");
            String courseNumber = this.getOptionalStringAttribute(el, "courseNumber");
            String externalIdStr = this.getOptionalStringAttribute(el, "externalId");
            if (externalIdStr == null && (subject == null || courseNumber == null)) {
                throw new Exception("Either a Subject and Course Number is required or an External Id is required.");
            }
            SubjectArea area = null;
            String permId = null;
            if (externalIdStr != null) {
                area = this.externalIdSubjectArea.get(externalIdStr);
                courseNumber = this.externalIdCourseNumber.get(externalIdStr);
                permId = this.externalIdCoursePermId.get(externalIdStr);
                if (area == null) {
                    this.warn("Course not found " + externalIdStr + " not found");
                    continue;
                }
            } else {
                area = this.subjectAreas.get(subject);
                if (area == null) {
                    this.warn("Subject area " + subject + " not found");
                    continue;
                }
                permId = this.courseOfferings.get(courseNumber + area.getUniqueId().toString());
            }
            LastLikeCourseDemand demand = new LastLikeCourseDemand();
            demand.setCoursePermId(permId);
            demand.setCourseNbr(courseNumber);
            demand.setStudent(student);
            demand.setSubjectArea(area);
            demand.setPriority(Integer.decode(el.attributeValue("priority", String.valueOf(row++))));
            this.getHibSession().save((Object)demand);
        }
    }

    private void loadSubjectAreas(Long sessionId) {
        List areas = new ArrayList();
        areas = new SubjectAreaDAO().getSession().createQuery("select distinct a from SubjectArea as a where a.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        for (SubjectArea area : areas) {
            this.subjectAreas.put(area.getSubjectAreaAbbreviation(), area);
        }
    }

    private void loadCourseOfferings(Long sessionId) {
        for (CourseOffering offer : CourseOffering.findAll(sessionId)) {
            if (offer.getPermId() != null) {
                this.courseOfferings.put(offer.getCourseNbr() + offer.getSubjectArea().getUniqueId().toString(), offer.getPermId());
            }
            this.externalIdSubjectArea.put(offer.getExternalUniqueId(), offer.getSubjectArea());
            this.externalIdCourseNumber.put(offer.getExternalUniqueId(), offer.getCourseNbr());
            this.externalIdCoursePermId.put(offer.getExternalUniqueId(), offer.getPermId());
        }
    }
}

