/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Date;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.CacheMode;
import org.unitime.timetable.api.JsonApiHelper;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryFileApiHelper
extends JsonApiHelper {
    public BinaryFileApiHelper(HttpServletRequest request, HttpServletResponse response, SessionContext context, CacheMode cacheMode) {
        super(request, response, context, cacheMode);
    }

    @Override
    public <P> P getRequest(Type requestType) throws IOException {
        if (requestType.equals(BinaryFile.class)) {
            int read;
            ServletInputStream is = this.iRequest.getInputStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            BinaryFile output = new BinaryFile(buffer.toByteArray(), this.iRequest.getContentType(), this.getFileName());
            return (P)output;
        }
        return super.getRequest(requestType);
    }

    protected String getFileName() {
        String param = this.iRequest.getHeader("Content-Disposition");
        if (param != null) {
            for (String cd : param.split(";")) {
                if (!cd.trim().startsWith("filename")) continue;
                String fileName = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
                return fileName.substring(fileName.lastIndexOf(47) + 1).substring(fileName.lastIndexOf(92) + 1);
            }
        }
        return null;
    }

    @Override
    public <R> void setResponse(R response) throws IOException {
        if (response instanceof BinaryFile) {
            BinaryFile file = (BinaryFile)response;
            this.iResponse.setContentType(file.getContentType());
            this.iResponse.setHeader("Pragma", "no-cache");
            this.iResponse.addHeader("Cache-Control", "must-revalidate");
            this.iResponse.addHeader("Cache-Control", "no-cache");
            this.iResponse.addHeader("Cache-Control", "no-store");
            this.iResponse.setDateHeader("Date", new Date().getTime());
            this.iResponse.setDateHeader("Expires", 0L);
            this.iResponse.setHeader("Content-Disposition", "attachment; filename=\"" + file.getFileName() + "\"");
            ServletOutputStream out = this.iResponse.getOutputStream();
            out.write(file.getBytes());
            out.flush();
        } else {
            super.setResponse(response);
        }
    }

    public static class BinaryFile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        byte[] iBuffer;
        public String iContentType;
        public String iFileName;

        public BinaryFile(byte[] buffer, String contentType, String fileName) {
            this.iBuffer = buffer;
            this.iContentType = contentType;
            this.iFileName = fileName;
        }

        public byte[] getBytes() {
            return this.iBuffer;
        }

        public String getContentType() {
            return this.iContentType;
        }

        public String getFileName() {
            return this.iFileName;
        }
    }
}

