/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="/studentScheduling")
public class StudentSchedulingAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;
    @Autowired
    ApplicationContext applicationContext;

    protected boolean matchCampus(AcademicSessionProvider.AcademicSessionInfo info, String campus) {
        if (info.hasExternalCampus() && campus.equalsIgnoreCase(info.getExternalCampus())) {
            return true;
        }
        return campus.equalsIgnoreCase(info.getCampus());
    }

    protected boolean matchTerm(AcademicSessionProvider.AcademicSessionInfo info, String term) {
        if (info.hasExternalTerm() && term.equalsIgnoreCase(info.getExternalTerm())) {
            return true;
        }
        return term.equalsIgnoreCase(info.getTerm() + info.getYear()) || term.equalsIgnoreCase(info.getYear() + info.getTerm()) || term.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus());
    }

    protected boolean matchSession(AcademicSessionProvider.AcademicSessionInfo info, String session) {
        if (info.hasExternalTerm() && info.hasExternalCampus() && session.equalsIgnoreCase(info.getExternalTerm() + info.hasExternalCampus())) {
            return true;
        }
        return session.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus()) || session.equalsIgnoreCase(info.getTerm() + info.getYear()) || session.equals(info.getSessionId().toString());
    }

    public boolean match(HttpServletRequest request, AcademicSessionProvider.AcademicSessionInfo info) {
        String campus = request.getParameter("campus");
        if (campus != null && !this.matchCampus(info, campus)) {
            return false;
        }
        String term = request.getParameter("term");
        if (term != null && !this.matchTerm(info, term)) {
            return false;
        }
        String session = request.getParameter("session");
        if (session != null && !this.matchSession(info, session)) {
            return false;
        }
        if (campus == null && term == null && session == null) {
            return info.getSessionId().equals(this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        return true;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = null;
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String string : (String[])entry.getValue()) {
                target = target == null ? (String)entry.getKey() + "=" + URLEncoder.encode(string, "UTF-8") : target + "&" + (String)entry.getKey() + "=" + URLEncoder.encode(string, "UTF-8");
            }
        }
        SectioningService service = (SectioningService)this.applicationContext.getBean("sectioning.gwt");
        if (this.sessionContext.isAuthenticated()) {
            UserAuthority preferredAuthority = null;
            try {
                for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : service.listAcademicSessions(true)) {
                    if (!this.match(request, academicSessionInfo)) continue;
                    for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, new SimpleQualifier("Session", academicSessionInfo.getSessionId()))) {
                        if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                        preferredAuthority = userAuthority;
                    }
                }
            }
            catch (SectioningException sectioningException) {
                // empty catch block
            }
            if (preferredAuthority == null && this.sessionContext.getUser().getCurrentAuthority() != null) {
                for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, this.sessionContext.getUser().getCurrentAuthority().getAcademicSession())) {
                    if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                    preferredAuthority = userAuthority;
                }
            }
            if (preferredAuthority != null) {
                this.sessionContext.getUser().setCurrentAuthority(preferredAuthority);
            }
        }
        if (this.sessionContext.hasPermission(Right.SchedulingDashboard)) {
            if (!this.sessionContext.hasPermission(Right.StudentSchedulingAdmin)) {
                Number myStudents = (Number)CourseOfferingDAO.getInstance().getSession().createQuery("select count(s) from Advisor a inner join a.students s where a.externalUniqueId = :user and a.role.reference = :role and a.session.uniqueId = :sessionId").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("user", this.sessionContext.getUser().getExternalUserId()).setString("role", this.sessionContext.getUser().getCurrentAuthority().getRole()).setCacheable(true).uniqueResult();
                response.sendRedirect("gwt.jsp?page=onlinesctdash" + (target == null ? "" : "&" + target) + (myStudents.intValue() > 0 ? "#mode:%22My%20Students%22@" : ""));
            } else {
                response.sendRedirect("gwt.jsp?page=onlinesctdash" + (target == null ? "" : "&" + target));
            }
            return null;
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(true)) {
                StudentSectioningStatus status;
                Student student;
                List<? extends UserQualifier> q;
                OnlineSectioningServer onlineSectioningServer;
                if (!this.match(request, session) || (onlineSectioningServer = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(session.getSessionId().toString())) == null || !onlineSectioningServer.getAcademicSession().isSectioningEnabled() || "Student".equals(this.sessionContext.getUser().getCurrentAuthority().getRole()) && ((q = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Student")) == null || q.isEmpty() || (student = (Student)StudentDAO.getInstance().get((Long)q.get(0).getQualifierId())) == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enrollment))) continue;
                response.sendRedirect("gwt.jsp?page=sectioning" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(false)) {
                StudentSectioningStatus studentSectioningStatus;
                Student student;
                List<? extends UserQualifier> list;
                if (!this.match(request, session) || "Student".equals(this.sessionContext.getUser().getCurrentAuthority().getRole()) && ((list = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Student")) == null || list.isEmpty() || (student = (Student)StudentDAO.getInstance().get((Long)list.get(0).getQualifierId())) == null || (studentSectioningStatus = student.getEffectiveStatus()) != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.regenabled))) continue;
                response.sendRedirect("gwt.jsp?page=requests" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(true)) {
                if (!this.match(request, session)) continue;
                response.sendRedirect("gwt.jsp?page=sectioning" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : service.listAcademicSessions(false)) {
                if (!this.match(request, session)) continue;
                response.sendRedirect("gwt.jsp?page=requests" + (target == null ? "" : "&" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        response.sendRedirect("main.jsp");
        return null;
    }
}

