/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.RoomTypeEditForm;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/roomTypeEdit")
public class RoomTypeEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Session hibSession;
            Transaction tx;
            String op;
            RoomTypeEditForm myForm = (RoomTypeEditForm)form;
            this.sessionContext.checkPermission(Right.RoomTypes);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
                op = request.getParameter("op2");
            }
            if (op == null) {
                myForm.reset(mapping, request);
            }
            if ("Back".equals(op)) {
                myForm.reset(mapping, request);
            }
            if ("Add Room Type".equals(op)) {
                myForm.load(null);
            }
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    Transaction tx2 = null;
                    try {
                        Session hibSession2 = RoomTypeDAO.getInstance().getSession();
                        if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                            tx2 = hibSession2.beginTransaction();
                        }
                        myForm.saveOrUpdate(hibSession2);
                        if (tx2 != null) {
                            tx2.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx2 != null) {
                            tx2.rollback();
                        }
                        throw e;
                    }
                    myForm.reset(mapping, request);
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("reference", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors);
                } else {
                    RoomType t = (RoomType)RoomTypeDAO.getInstance().get(new Long(id));
                    if (t == null) {
                        errors.add("reference", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                        this.saveErrors(request, errors);
                    } else {
                        myForm.load(t);
                    }
                }
            }
            if ("Delete".equals(op)) {
                tx = null;
                try {
                    hibSession = RoomTypeDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.delete(hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.reset(mapping, request);
            }
            if ("Move Up".equals(op) || "Move Down".equals(op)) {
                tx = null;
                try {
                    hibSession = RoomTypeDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    RoomType curType = (RoomType)RoomTypeDAO.getInstance().get(myForm.getUniqueId());
                    if ("Move Up".equals(op)) {
                        boolean found = false;
                        for (RoomType s : RoomType.findAll()) {
                            if (s.getOrd() + 1 != curType.getOrd()) continue;
                            s.setOrd(s.getOrd() + 1);
                            hibSession.saveOrUpdate((Object)s);
                            found = true;
                        }
                        if (found) {
                            curType.setOrd(curType.getOrd() - 1);
                            myForm.setOrder(curType.getOrd());
                            hibSession.saveOrUpdate((Object)curType);
                        }
                    } else {
                        boolean found = false;
                        for (RoomType s : RoomType.findAll()) {
                            if (s.getOrd() - 1 != curType.getOrd()) continue;
                            s.setOrd(s.getOrd() - 1);
                            hibSession.saveOrUpdate((Object)s);
                            found = true;
                        }
                        if (found) {
                            curType.setOrd(curType.getOrd() + 1);
                            myForm.setOrder(curType.getOrd());
                            hibSession.saveOrUpdate((Object)curType);
                        }
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                myForm.reset(mapping, request);
            }
            if ("List".equals(myForm.getOp())) {
                this.getRoomTypeList(request);
                return mapping.findForward("list");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void getRoomTypeList(HttpServletRequest request) throws Exception {
        WebTable.setOrder(this.sessionContext, "roomTypes.ord", request.getParameter("ord"), 2);
        WebTable webTable = new WebTable(5, null, "roomTypeEdit.do?ord=%%", new String[]{"", "Reference", "Label", "Type", "Rooms"}, new String[]{"left", "left", "left", "left", "left"}, null);
        TreeSet<RoomType> types = RoomType.findAll();
        if (types.isEmpty()) {
            webTable.addLine(null, new String[]{"No status defined."}, null, null);
        }
        Iterator<RoomType> i = types.iterator();
        while (i.hasNext()) {
            RoomType t = i.next();
            String onClick = "onClick=\"document.location='roomTypeEdit.do?op=Edit&id=" + t.getUniqueId() + "';\"";
            String ops = "";
            ops = t.getOrd() > 0 ? ops + "<img src='images/arrow_up.png' border='0' align='absmiddle' title='Move Up' onclick=\"roomTypeEditForm.op2.value='Move Up';roomTypeEditForm.uniqueId.value='" + t.getUniqueId() + "';roomTypeEditForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            ops = i.hasNext() ? ops + "<img src='images/arrow_down.png' border='0' align='absmiddle' title='Move Down' onclick=\"roomTypeEditForm.op2.value='Move Down';roomTypeEditForm.uniqueId.value='" + t.getUniqueId() + "';roomTypeEditForm.submit(); event.cancelBubble=true;\">" : ops + "<img src='images/blank.png' border='0' align='absmiddle'>";
            int nrRooms = t.countRooms();
            webTable.addLine(onClick, new String[]{ops, t.getReference(), t.getLabel(), t.isRoom() != false ? "Room" : "Other", String.valueOf(nrRooms)}, new Comparable[]{t.getOrd(), t.getOrd(), t.getLabel(), Integer.valueOf(t.isRoom() != false ? 0 : 1), Integer.valueOf(nrRooms)});
        }
        request.setAttribute("RoomType.last", (Object)new Integer(types.size() - 1));
        request.setAttribute("RoomType.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "roomTypes.ord")));
    }
}

