/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomListForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Service(value="/roomSearch")
public class RoomSearchAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomListForm roomListForm = (RoomListForm)form;
        this.sessionContext.checkPermission(Right.Rooms);
        roomListForm.load(request.getSession());
        String deptCode = roomListForm.getDeptCodeX();
        if (deptCode == null) {
            deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
        }
        if (deptCode == null && (deptCode = request.getParameter("default")) != null) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)deptCode);
        }
        if (deptCode != null && !deptCode.isEmpty() && ("All".equals(deptCode) || deptCode.matches("Exam[0-9]*") || Department.findByDeptCode(deptCode, this.sessionContext.getUser().getCurrentAcademicSessionId()) != null)) {
            roomListForm.setDeptCodeX(deptCode);
            return mapping.findForward("roomList");
        }
        if (this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").size() == 1) {
            roomListForm.setDeptCodeX(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department").get(0).getQualifierReference());
            return mapping.findForward("roomList");
        }
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("showRoomSearch");
    }
}

