/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.EditRoomForm;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LocationPermIdGenerator;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="/editRoom")
public class EditRoomAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EditRoomForm editRoomForm = (EditRoomForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = editRoomForm.getDoit();
        if (doit != null && doit.equals(rsc.getMessage("button.returnToRoomDetail"))) {
            if (editRoomForm.getId() == null || editRoomForm.getId().length() == 0) {
                response.sendRedirect("roomList.do");
            } else {
                response.sendRedirect("roomDetail.do?id=" + editRoomForm.getId());
            }
            return null;
        }
        if (doit != null && (doit.equals(rsc.getMessage("button.update")) || doit.equals(rsc.getMessage("button.save")))) {
            ActionMessages errors = new ActionMessages();
            errors = editRoomForm.validate(mapping, request);
            if (errors.size() == 0) {
                if (editRoomForm.getId() == null || editRoomForm.getId().isEmpty()) {
                    this.doSave(editRoomForm, request);
                } else {
                    this.doUpdate(editRoomForm, request);
                }
                response.sendRedirect("roomDetail.do?id=" + editRoomForm.getId());
                return null;
            }
            this.saveErrors(request, errors);
            if (editRoomForm.getId() == null || editRoomForm.getId().isEmpty()) {
                EditRoomAction.setupDepartments(request, this.sessionContext);
            } else {
                EditRoomAction.setupDepartments(request, this.sessionContext, (Location)LocationDAO.getInstance().get(Long.valueOf(editRoomForm.getId())));
            }
            this.setupBuildings(request);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return mapping.findForward(editRoomForm.getId() == null || editRoomForm.getId().length() == 0 ? "showAddRoom" : "showEditRoom");
        }
        if (request.getParameter("id") != null && request.getParameter("id").length() > 0) {
            LocationDAO ldao = new LocationDAO();
            Long id = Long.valueOf(request.getParameter("id"));
            Location location = (Location)ldao.get(id);
            if (location instanceof Room) {
                Room r = (Room)location;
                this.sessionContext.checkPermission(r, Right.RoomEdit);
                editRoomForm.setName(r.getRoomNumber());
                editRoomForm.setBldgName(r.getBuildingAbbv());
                editRoomForm.setRoom(true);
            } else {
                this.sessionContext.checkPermission((NonUniversityLocation)location, Right.NonUniversityLocationEdit);
                editRoomForm.setName(((NonUniversityLocation)location).getName());
                editRoomForm.setBldgName("");
                editRoomForm.setRoom(false);
            }
            editRoomForm.setExternalId(location.getExternalUniqueId());
            editRoomForm.setType(location.getRoomType().getUniqueId());
            editRoomForm.setCapacity(location.getCapacity().toString());
            if (location.getExamCapacity() != null && (location.hasAnyExamsEnabled() || location.getExamCapacity() != 0)) {
                editRoomForm.setExamCapacity(location.getExamCapacity().toString());
            }
            for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                editRoomForm.setExamEnabled(type.getUniqueId().toString(), location.getExamTypes().contains(type));
            }
            editRoomForm.setIgnoreTooFar(location.isIgnoreTooFar());
            editRoomForm.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
            editRoomForm.setCoordX(location.getCoordinateX() == null ? null : location.getCoordinateX().toString());
            editRoomForm.setCoordY(location.getCoordinateY() == null ? null : location.getCoordinateY().toString());
            editRoomForm.setArea(location.getArea() == null ? null : new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).format(location.getArea()));
            editRoomForm.setControlDept(location.getControllingDepartment() == null ? null : location.getControllingDepartment().getUniqueId().toString());
            editRoomForm.setEventDepartment(location.getEventDepartment() == null ? null : location.getEventDepartment().getUniqueId().toString());
            editRoomForm.setEventStatus(location.getEventStatus() == null ? -1 : location.getEventStatus());
            editRoomForm.setBreakTime(location.getBreakTime() == null ? "" : location.getBreakTime().toString());
            editRoomForm.setNote(location.getNote() == null ? "" : location.getNote());
            if (this.sessionContext.hasPermission(location, Right.RoomEditChangeExaminationStatus)) {
                for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                    if (type.getType() == 1) {
                        MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(location.getSession(), type);
                        epx.load(location);
                        epx.setName("mp" + type.getUniqueId());
                        request.setAttribute("PeriodPrefs" + type.getUniqueId(), (Object)epx.print(true));
                        continue;
                    }
                    PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), type.getUniqueId());
                    px.load(location);
                    px.setAllowRequired(false);
                    RequiredTimeTable rttPx = new RequiredTimeTable(px);
                    rttPx.setName("PeriodPrefs" + type.getUniqueId());
                    request.setAttribute("PeriodPrefs" + type.getUniqueId(), (Object)rttPx.print(true, CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(this.sessionContext.getUser()))));
                }
            }
            EditRoomAction.setupDepartments(request, this.sessionContext, location);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        } else {
            Department d;
            this.sessionContext.checkPermission(Right.AddRoom);
            editRoomForm.reset(mapping, request);
            if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null && (d = Department.findByDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom), this.sessionContext.getUser().getCurrentAcademicSessionId())) != null) {
                editRoomForm.setControlDept(d.getUniqueId().toString());
            }
            editRoomForm.setEventDepartment(null);
            EditRoomAction.setupDepartments(request, this.sessionContext);
            this.setupBuildings(request);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        return mapping.findForward(editRoomForm.getId() == null || editRoomForm.getId().length() == 0 ? "showAddRoom" : "showEditRoom");
    }

    public static void setupDepartments(HttpServletRequest request, SessionContext context, Location location) throws Exception {
        Vector<LabelValueBean> availableDepts = new Vector<LabelValueBean>();
        for (RoomDept rd : new TreeSet<RoomDept>(location.getRoomDepts())) {
            Department d = rd.getDepartment();
            availableDepts.add(new LabelValueBean(d.getDeptCode() + " - " + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        Vector<LabelValueBean> eventDepts = new Vector<LabelValueBean>();
        TreeSet<Department> userDepartments = Department.getUserDepartments(context.getUser());
        if (location.getEventDepartment() != null) {
            userDepartments.add(location.getEventDepartment());
        }
        for (Department d : userDepartments) {
            if (!d.isAllowEvents().booleanValue()) continue;
            eventDepts.add(new LabelValueBean(d.getDeptCode() + " - " + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute("eventDepts", eventDepts);
    }

    public static void setupDepartments(HttpServletRequest request, SessionContext context) throws Exception {
        Vector<LabelValueBean> availableDepts = new Vector<LabelValueBean>();
        for (Department d : Department.getUserDepartments(context.getUser())) {
            availableDepts.add(new LabelValueBean(d.getDeptCode() + " - " + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        Vector<LabelValueBean> eventDepts = new Vector<LabelValueBean>();
        for (Department d : Department.getUserDepartments(context.getUser())) {
            if (!d.isAllowEvents().booleanValue()) continue;
            eventDepts.add(new LabelValueBean(d.getDeptCode() + " - " + d.getName(), d.getUniqueId().toString()));
        }
        request.setAttribute("eventDepts", eventDepts);
    }

    private void setupBuildings(HttpServletRequest request) throws Exception {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        for (Building b : Building.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            list.add(new LabelValueBean(b.getAbbreviation() + "-" + b.getName(), b.getUniqueId().toString()));
        }
        request.setAttribute(Building.BLDG_LIST_ATTR_NAME, list);
    }

    private void doUpdate(EditRoomForm editRoomForm, HttpServletRequest request) throws Exception {
        Long id = Long.valueOf(editRoomForm.getId());
        LocationDAO ldao = new LocationDAO();
        org.hibernate.Session hibSession = ldao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Location location = (Location)ldao.get(id, hibSession);
            if (location instanceof Room) {
                this.sessionContext.checkPermission((Room)location, Right.RoomEdit);
            } else {
                this.sessionContext.checkPermission((NonUniversityLocation)location, Right.NonUniversityLocationEdit);
            }
            if (editRoomForm.getName() != null && !editRoomForm.getName().trim().equalsIgnoreCase("")) {
                if (location instanceof Room) {
                    ((Room)location).setRoomNumber(editRoomForm.getName());
                } else {
                    ((NonUniversityLocation)location).setName(editRoomForm.getName());
                }
            }
            if (editRoomForm.getCapacity() != null && !editRoomForm.getCapacity().trim().equalsIgnoreCase("")) {
                location.setCapacity(Integer.valueOf(editRoomForm.getCapacity().trim()));
            }
            if (editRoomForm.isIgnoreTooFar() == null || !editRoomForm.isIgnoreTooFar().booleanValue()) {
                location.setIgnoreTooFar(Boolean.FALSE);
            } else {
                location.setIgnoreTooFar(Boolean.TRUE);
            }
            if (editRoomForm.isIgnoreRoomCheck() == null || !editRoomForm.isIgnoreRoomCheck().booleanValue()) {
                location.setIgnoreRoomCheck(Boolean.FALSE);
            } else {
                location.setIgnoreRoomCheck(Boolean.TRUE);
            }
            location.setExternalUniqueId(editRoomForm.getExternalId());
            location.setRoomType((RoomType)RoomTypeDAO.getInstance().get(editRoomForm.getType()));
            location.setCoordinateX(editRoomForm.getCoordX() == null || editRoomForm.getCoordX().length() == 0 ? null : Double.valueOf(editRoomForm.getCoordX()));
            location.setCoordinateY(editRoomForm.getCoordY() == null || editRoomForm.getCoordY().length() == 0 ? null : Double.valueOf(editRoomForm.getCoordY()));
            Double area = null;
            if (editRoomForm.getArea() != null && !editRoomForm.getArea().isEmpty()) {
                try {
                    area = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).parse(editRoomForm.getArea()).doubleValue();
                }
                catch (NumberFormatException e) {
                    area = location.getArea();
                }
            }
            location.setArea(area);
            if (this.sessionContext.hasPermission(location, Right.RoomEditChangeEventProperties)) {
                location.setEventDepartment(editRoomForm.getEventDepartment() == null || editRoomForm.getEventDepartment().isEmpty() ? null : (Department)new DepartmentDAO().get(Long.valueOf(editRoomForm.getEventDepartment())));
                location.setBreakTime(editRoomForm.getBreakTime() == null || editRoomForm.getBreakTime().isEmpty() ? null : Integer.valueOf(Integer.parseInt(editRoomForm.getBreakTime())));
                location.setEventStatus(editRoomForm.getEventStatus() == null || editRoomForm.getEventStatus() < 0 ? null : editRoomForm.getEventStatus());
            }
            String oldNote = location.getNote();
            location.setNote(editRoomForm.getNote() == null ? "" : (editRoomForm.getNote().length() > 2048 ? editRoomForm.getNote().substring(0, 2048) : editRoomForm.getNote()));
            if (this.sessionContext.hasPermission(location, Right.RoomEditChangeExaminationStatus)) {
                if (editRoomForm.getExamCapacity() != null && !editRoomForm.getExamCapacity().trim().equalsIgnoreCase("")) {
                    location.setExamCapacity(Integer.valueOf(editRoomForm.getExamCapacity().trim()));
                }
                boolean examTypesChanged = false;
                for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                    if (editRoomForm.getExamEnabled(type.getUniqueId().toString()) == location.getExamTypes().contains(type)) continue;
                    examTypesChanged = true;
                    break;
                }
                if (examTypesChanged) {
                    if (!location.getExamTypes().isEmpty()) {
                        location.getExamTypes().clear();
                        hibSession.update((Object)location);
                        hibSession.flush();
                    }
                    for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                        if (!editRoomForm.getExamEnabled(type.getUniqueId().toString())) continue;
                        location.getExamTypes().add(type);
                    }
                }
                for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                    if (location.getExamTypes().contains(type)) {
                        if (type.getType() == 1) {
                            MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(location.getSession(), type);
                            epx.setName("mp" + type.getUniqueId());
                            epx.load(request);
                            epx.save(location);
                            continue;
                        }
                        PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), type.getUniqueId());
                        RequiredTimeTable rttPx = new RequiredTimeTable(px);
                        rttPx.setName("PeriodPrefs" + type.getUniqueId());
                        rttPx.update((ServletRequest)request);
                        px.save(location);
                        continue;
                    }
                    location.clearExamPreferences(type);
                }
            }
            for (RoomDept rd : location.getRoomDepts()) {
                boolean newControl = editRoomForm.getControlDept() != null && editRoomForm.getControlDept().equals(rd.getDepartment().getUniqueId().toString());
                if (newControl == rd.isControl()) continue;
                rd.setControl(new Boolean(newControl));
                hibSession.saveOrUpdate((Object)rd);
            }
            hibSession.saveOrUpdate((Object)location);
            if (!ToolBox.equals((Object)oldNote, (Object)location.getNote())) {
                ChangeLog.addChange(hibSession, this.sessionContext, location, location.getNote() == null || location.getNote().isEmpty() ? "-" : location.getNote(), ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.NOTE, null, location.getControllingDepartment());
            }
            ChangeLog.addChange(hibSession, this.sessionContext, location, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.UPDATE, null, location.getControllingDepartment());
            hibSession.flush();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private void doSave(EditRoomForm editRoomForm, HttpServletRequest request) throws Exception {
        this.sessionContext.checkPermission((Serializable)((Object)editRoomForm.getControlDept()), "Department", Right.AddRoom);
        LocationDAO ldao = new LocationDAO();
        org.hibernate.Session hibSession = ldao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Room room = new Room();
            room.setRoomNumber(editRoomForm.getName());
            Building building = (Building)new BuildingDAO().get(Long.valueOf(editRoomForm.getBldgId()));
            room.setBuilding(building);
            if (building != null) {
                room.setBuildingAbbv(building.getAbbreviation());
            }
            room.setRoomDepts(new HashSet<RoomDept>());
            RoomDept rd = new RoomDept();
            rd.setRoom(room);
            rd.setDepartment((Department)new DepartmentDAO().get(Long.valueOf(editRoomForm.getControlDept())));
            rd.setControl(Boolean.TRUE);
            room.setEventDepartment(editRoomForm.getEventDepartment() == null || editRoomForm.getEventDepartment().isEmpty() ? null : (Department)new DepartmentDAO().get(Long.valueOf(editRoomForm.getEventDepartment())));
            room.getRoomDepts().add(rd);
            room.setCapacity(Integer.valueOf(editRoomForm.getCapacity().trim()));
            room.setExamCapacity(editRoomForm.getExamCapacity() == null || editRoomForm.getExamCapacity().trim().isEmpty() ? 0 : Integer.valueOf(editRoomForm.getExamCapacity().trim()));
            room.setExamTypes(new HashSet<ExamType>());
            for (ExamType type : ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                if (!editRoomForm.getExamEnabled(type.getUniqueId().toString())) continue;
                room.getExamTypes().add(type);
            }
            room.setIgnoreTooFar(Boolean.FALSE);
            room.setIgnoreRoomCheck(editRoomForm.isIgnoreRoomCheck() != null && editRoomForm.isIgnoreRoomCheck() != false);
            room.setExternalUniqueId(editRoomForm.getExternalId());
            room.setRoomType((RoomType)RoomTypeDAO.getInstance().get(editRoomForm.getType()));
            room.setCoordinateX(editRoomForm.getCoordX() == null || editRoomForm.getCoordX().length() == 0 ? null : Double.valueOf(editRoomForm.getCoordX()));
            room.setCoordinateY(editRoomForm.getCoordY() == null || editRoomForm.getCoordY().length() == 0 ? null : Double.valueOf(editRoomForm.getCoordY()));
            Double area = null;
            if (editRoomForm.getArea() != null && !editRoomForm.getArea().isEmpty()) {
                try {
                    area = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).parse(editRoomForm.getArea()).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            room.setArea(area);
            room.setSession(room.getControllingDepartment() == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession) : room.getControllingDepartment().getSession());
            room.setBreakTime(editRoomForm.getBreakTime() == null || editRoomForm.getBreakTime().isEmpty() ? null : Integer.valueOf(Integer.parseInt(editRoomForm.getBreakTime())));
            room.setEventStatus(editRoomForm.getEventStatus() == null || editRoomForm.getEventStatus() < 0 ? null : editRoomForm.getEventStatus());
            room.setNote(editRoomForm.getNote() == null ? "" : (editRoomForm.getNote().length() > 2048 ? editRoomForm.getNote().substring(0, 2048) : editRoomForm.getNote()));
            LocationPermIdGenerator.setPermanentId(room);
            hibSession.saveOrUpdate((Object)room);
            ChangeLog.addChange(hibSession, this.sessionContext, room, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.CREATE, null, room.getControllingDepartment());
            hibSession.flush();
            tx.commit();
            editRoomForm.setId(room.getUniqueId().toString());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }
}

