/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.backup.BackupProgress;
import org.unitime.timetable.backup.SessionBackupInterface;
import org.unitime.timetable.backup.SessionRestoreInterface;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.DataImportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;

@Service(value="/dataImport")
public class DataImportAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WebTable table;
        ActionErrors errors;
        DataImportForm myForm = (DataImportForm)form;
        String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        this.sessionContext.checkPermission(Right.DataExchange);
        if (op == null) {
            myForm.setAddress(this.sessionContext.getUser().getEmail());
        }
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if ("Import".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("display");
            }
            this.solverServerService.getQueueProcessor().add(new ImportQueItem(session, this.sessionContext.getUser(), myForm, request));
        }
        if ("Export".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("display");
            }
            this.solverServerService.getQueueProcessor().add(new ExportQueItem(session, this.sessionContext.getUser(), myForm, request));
        }
        if (request.getParameter("remove") != null) {
            this.solverServerService.getQueueProcessor().remove(request.getParameter("remove"));
        }
        if ((table = this.getQueueTable(request)) != null) {
            request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "dataImport.ord")));
        }
        return mapping.findForward("display");
    }

    private WebTable getQueueTable(HttpServletRequest request) {
        WebTable.setOrder(this.sessionContext, "dataImport.ord", request.getParameter("ord"), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = this.solverServerService.getQueueProcessor().getItems(null, null, "Data Exchange");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, "Data exchange in progress", "dataImport.do?ord=%%", new String[]{"Name", "Status", "Progress", "Owner", "Session", "Created", "Started", "Finished", "Output"}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this data exchange?')) document.location='dataImport.do?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='dataImport.do?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='" + item.getOutputLink() + "'>" + item.getOutputName().substring(item.getOutputName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{Long.valueOf(item.created().getTime()), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log != null && log.equals(item.getId().toString())) {
                request.setAttribute("logname", (Object)name);
                request.setAttribute("logid", (Object)item.getId().toString());
                request.setAttribute("log", (Object)item.log());
                line.setBgColor("rgb(168,187,225)");
            }
            if (log != null || item.started() == null || item.finished() != null || !this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId())) continue;
            request.setAttribute("logname", (Object)name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    public static class NotClosingInputStream
    extends InputStream {
        private InputStream iParent;

        public NotClosingInputStream(InputStream in) {
            this.iParent = in;
        }

        public int read() throws IOException {
            return this.iParent.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.iParent.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.iParent.skip(n);
        }

        public int available() throws IOException {
            return this.iParent.available();
        }

        public void close() throws IOException {
        }
    }

    public static class ExportQueItem
    extends DataExchangeQueueItem {
        private static final long serialVersionUID = 1L;

        public ExportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeDataExchange() throws Exception {
            block7: {
                DataImportForm.ExportType type = this.iForm.getExportType();
                if (type == DataImportForm.ExportType.SESSION) {
                    FileOutputStream out = new FileOutputStream(this.createOutput("session", "dat"));
                    try {
                        SessionBackupInterface backup = (SessionBackupInterface)Class.forName(ApplicationProperty.SessionBackupInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        backup.backup(out, this, this.getSessionId());
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                    {
                        break block7;
                    }
                }
                Properties params = new Properties();
                type.setOptions(params);
                Document document = DataExchangeHelper.exportDocument(type.getType(), this.getSession(), params, this);
                if (document == null) {
                    this.error("XML document not created: unknown reason.");
                } else {
                    FileOutputStream fos = new FileOutputStream(this.createOutput(type.getType(), "xml"));
                    try {
                        new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
                        fos.flush();
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    {
                    }
                }
            }
        }
    }

    public static class ImportQueItem
    extends DataExchangeQueueItem {
        private static final long serialVersionUID = 1L;

        public ImportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, true);
        }

        protected void executeDataExchange() throws Exception {
            if (this.iForm.getFile().getFileName().toLowerCase().endsWith(".dat")) {
                SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                restore.restore(this.iForm.getFile().getInputStream(), this);
            } else if (this.iForm.getFile().getFileName().toLowerCase().endsWith(".dat.gz") || this.iForm.getFile().getFileName().toLowerCase().endsWith(".zdat")) {
                SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                GZIPInputStream gzipInput = new GZIPInputStream(this.iForm.getFile().getInputStream());
                restore.restore(gzipInput, this);
                gzipInput.close();
            } else if (this.iForm.getFile().getFileName().toLowerCase().endsWith(".xml.gz") || this.iForm.getFile().getFileName().toLowerCase().endsWith(".zxml")) {
                GZIPInputStream gzipInput = new GZIPInputStream(this.iForm.getFile().getInputStream());
                DataExchangeHelper.importDocument(new SAXReader().read((InputStream)gzipInput), this.getOwnerId(), this);
                gzipInput.close();
            } else if (this.iForm.getFile().getFileName().toLowerCase().endsWith(".zip")) {
                ZipInputStream zipInput = new ZipInputStream(this.iForm.getFile().getInputStream());
                ZipEntry ze = null;
                while ((ze = zipInput.getNextEntry()) != null) {
                    if (ze.isDirectory()) continue;
                    this.setStatus("Importing " + ze.getName() + "...");
                    if (ze.getName().endsWith(".dat")) {
                        SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        restore.restore(zipInput, this);
                        continue;
                    }
                    DataExchangeHelper.importDocument(new SAXReader().read((InputStream)new NotClosingInputStream(zipInput)), this.getOwnerId(), this);
                }
                zipInput.close();
            } else {
                DataExchangeHelper.importDocument(new SAXReader().read(this.iForm.getFile().getInputStream()), this.getOwnerId(), this);
            }
        }
    }

    public static abstract class DataExchangeQueueItem
    extends QueueItem
    implements DataExchangeHelper.LogWriter,
    BackupProgress {
        private static final long serialVersionUID = 1L;
        DataImportForm iForm;
        String iUrl;
        boolean iImport;
        String iSessionName;

        public DataExchangeQueueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request, boolean isImport) {
            super(session, owner);
            this.iForm = (DataImportForm)((Object)form.clone());
            this.iUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            this.iImport = isImport;
            this.iSessionName = session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative();
        }

        public String type() {
            return "Data Exchange";
        }

        public String name() {
            return this.iImport ? "Import of " + this.iForm.getFile().getFileName() : "Export of " + this.iForm.getExportType().getLabel();
        }

        public void println(String message) {
            this.log(message);
        }

        abstract void executeDataExchange() throws Exception;

        public void info(String message) {
            super.info(message);
        }

        public void warn(String message) {
            super.warn(message);
        }

        public void error(String message) {
            super.error(message);
        }

        public void setPhase(String phase, double max) {
            super.setStatus(phase, max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute() throws Exception {
            block9: {
                try {
                    try {
                        this.log(this.iImport ? "Importing " + this.iForm.getFile().getFileName() + " (" + this.iForm.getFile().getFileSize() + " bytes)..." : "Exporting " + this.iForm.getExportType().getType() + "...");
                        Long start = System.currentTimeMillis();
                        this.executeDataExchange();
                        Long stop = System.currentTimeMillis();
                        this.log((this.iImport ? "Import" : "Export") + " finished in " + new DecimalFormat("0.00").format((double)(stop - start) / 1000.0) + " seconds.");
                    }
                    catch (Exception e) {
                        this.error("Unable to " + (this.iImport ? "import " + this.iForm.getFile().getFileName() : "export") + ": " + e.getMessage());
                        Debug.error(e);
                        this.setError(e);
                        Object var4_6 = null;
                        Progress.removeInstance((Object)this);
                        break block9;
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    Progress.removeInstance((Object)this);
                    throw throwable;
                }
                Progress.removeInstance((Object)this);
            }
            if (!this.iForm.getEmail()) return;
            String address = this.iForm.getAddress();
            if (address == null || address.isEmpty()) {
                address = this.getOwnerEmail();
            }
            if (address == null) return;
            if (address.isEmpty()) return;
            try {
                Email mail = Email.createEmail();
                mail.setSubject("Data " + (this.iImport ? "import" : "export") + " finished.");
                mail.setHTML(this.log() + "<br><br>This email was automatically generated at " + this.iUrl + ", by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                mail.addRecipient(address, this.getOwnerName());
                if (ApplicationProperty.EmailNotificationDataExchange.isTrue()) {
                    mail.addNotifyCC();
                }
                if (!this.iImport && this.hasOutput() && this.output().exists()) {
                    mail.addAttachment(this.output(), this.iSessionName + "_" + this.iForm.getExportType().getType() + "." + this.output().getName().substring(this.output().getName().lastIndexOf(46) + 1));
                }
                mail.send();
                return;
            }
            catch (Exception e) {
                this.error("Unable to send email: " + e.getMessage());
                Debug.error(e);
                this.setError(e);
            }
        }
    }
}

