/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;

public class UniqueIdGenerator
implements IdentifierGenerator,
Configurable {
    IdentifierGenerator iGenerator = null;
    private static String sGenClass = null;
    private static String sDefaultSchema = null;
    private static ObjectNameNormalizer sNormalizer = null;

    public static void configure(Configuration config) {
        sGenClass = config.getProperty("tmtbl.uniqueid.generator");
        if (sGenClass == null) {
            sGenClass = "org.hibernate.id.SequenceGenerator";
        }
        sDefaultSchema = config.getProperty("default_schema");
        sNormalizer = config.createMappings().getObjectNameNormalizer();
    }

    public IdentifierGenerator getGenerator() throws HibernateException {
        if (this.iGenerator == null) {
            if (sGenClass == null) {
                throw new HibernateException("UniqueIdGenerator is not configured, please call configure(Config) first.");
            }
            try {
                this.iGenerator = (IdentifierGenerator)Class.forName(sGenClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to initialize uniqueId generator, reason: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.iGenerator;
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        return this.getGenerator().generate(session, object);
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        if (this.getGenerator() instanceof Configurable) {
            if (params.getProperty("schema") == null && sDefaultSchema != null) {
                params.setProperty("schema", sDefaultSchema);
            }
            if (params.get("identifier_normalizer") == null && sNormalizer != null) {
                params.put("identifier_normalizer", sNormalizer);
            }
            ((Configurable)this.getGenerator()).configure(type, params, d);
        }
    }
}

