/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.HibernateException;
import org.unitime.commons.hibernate.connection.DBCPConnectionProvider;

public class LoggingDBCPConnectionProvider
extends DBCPConnectionProvider {
    private static final long serialVersionUID = 1L;
    private static final Log sLog = LogFactory.getLog(LoggingDBCPConnectionProvider.class);
    private static final DecimalFormat sDF = new DecimalFormat("#,##0.00");
    private List<Lease> iLeases = new ArrayList<Lease>();
    private LeaseLogger iLogger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        List<Lease> list = this.iLeases;
        synchronized (list) {
            this.iLeases.add(new Lease(connection));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws SQLException {
        List<Lease> list = this.iLeases;
        synchronized (list) {
            Iterator<Lease> i = this.iLeases.iterator();
            while (i.hasNext()) {
                Lease lease = i.next();
                if (!lease.getConnection().equals(connection)) continue;
                i.remove();
            }
        }
        super.closeConnection(connection);
    }

    public void configure(Properties props) throws HibernateException {
        super.configure(props);
        this.iLogger = new LeaseLogger();
        this.iLogger.start();
    }

    public void destroy() throws HibernateException {
        super.destroy();
        this.iLogger.interrupt();
    }

    public class LeaseLogger
    extends Thread {
        private boolean iActive;

        public LeaseLogger() {
            super("DBCP:Logger");
            this.iActive = true;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            sLog.info((Object)"Database connection pool logging is enabled.");
            while (this.iActive) {
                try {
                    try {
                        LeaseLogger.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    List list = LoggingDBCPConnectionProvider.this.iLeases;
                    synchronized (list) {
                        ArrayList<Lease> suspicious = new ArrayList<Lease>();
                        for (Lease lease : LoggingDBCPConnectionProvider.this.iLeases) {
                            if (!(lease.getLeaseTime() > 60.0) && lease.getState() != Thread.State.TERMINATED) continue;
                            suspicious.add(lease);
                        }
                        if (!suspicious.isEmpty()) {
                            sLog.info((Object)("Suspicious leases:" + ToolBox.col2string((Collection)LoggingDBCPConnectionProvider.this.iLeases, (int)2)));
                        }
                        for (Lease lease : suspicious) {
                            if (lease.getState() != Thread.State.TERMINATED) continue;
                            sLog.fatal((Object)("Releasing connection of a terminated thread " + lease.getName() + "." + lease.getStackTrace()));
                            LoggingDBCPConnectionProvider.this.closeConnection(lease.getConnection());
                        }
                    }
                }
                catch (Exception e) {
                    sLog.warn((Object)("Logging failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }

        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Lease {
        private Connection iConnection;
        private Thread iThread;
        private StackTraceElement[] iTrace;
        private long iTimeStamp;

        public Lease(Connection connection) {
            this.iConnection = connection;
            this.iThread = Thread.currentThread();
            this.iTrace = Thread.currentThread().getStackTrace();
            this.iTimeStamp = System.currentTimeMillis();
        }

        public Connection getConnection() {
            return this.iConnection;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Connection) {
                return this.getConnection().equals(o);
            }
            if (o instanceof Lease) {
                return this.getConnection().equals(((Lease)o).getConnection());
            }
            return false;
        }

        public double getLeaseTime() {
            return (double)(System.currentTimeMillis() - this.iTimeStamp) / 1000.0;
        }

        public Thread.State getState() {
            return this.iThread.getState();
        }

        public String getName() {
            return this.iThread.getName();
        }

        public String getStackTrace() {
            int first = 0;
            for (int i = 3; i < this.iTrace.length; ++i) {
                if (!this.iTrace[i].getClassName().startsWith("org.unitime.") || this.iTrace[i].getClassName().endsWith("._BaseRootDAO")) continue;
                first = i;
                break;
            }
            StringBuffer ret = new StringBuffer();
            for (int i = first; i < this.iTrace.length; ++i) {
                ret.append("\n  " + this.iTrace[i]);
            }
            return ret.toString();
        }

        public String toString() {
            StackTraceElement trace = null;
            for (int i = 3; i < this.iTrace.length; ++i) {
                if (!this.iTrace[i].getClassName().startsWith("org.unitime.") || this.iTrace[i].getClassName().endsWith("._BaseRootDAO")) continue;
                trace = this.iTrace[i];
                break;
            }
            return sDF.format(this.getLeaseTime()) + " " + (Object)((Object)this.getState()) + " " + this.getName() + " " + trace;
        }
    }
}

