/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.timegrid.TimetableGridCell;
import org.unitime.timetable.webutil.timegrid.TimetableGridModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridTable;

public class PdfTimetableGridTable {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
    protected static Formats.Format<Number> sUtF = Formats.getNumberFormat("0.00");
    private TimetableGridTable iTable = null;
    private PdfWriter iWriter = null;
    private Document iDocument = null;
    private PdfPTable iPdfTable = null;
    private int iDay = 0;
    private static Color sBorderColor = new Color(100, 100, 100);

    protected PdfTimetableGridTable(TimetableGridTable table) {
        this.iTable = table;
    }

    public static void export2Pdf(TimetableGridTable table, OutputStream out) throws Exception {
        PdfTimetableGridTable x = new PdfTimetableGridTable(table);
        x.export(out);
    }

    public void export(OutputStream out) throws Exception {
        int nrCols = this.getNrColumns();
        this.iDocument = this.iTable.isDispModePerWeekVertical() ? new Document(new Rectangle(60.0f + 7.0f * (float)nrCols, 60.0f + 9.3f * (float)nrCols), 30.0f, 30.0f, 30.0f, 30.0f) : new Document(new Rectangle(60.0f + 10.0f * (float)nrCols, 60.0f + 7.5f * (float)nrCols), 30.0f, 30.0f, 30.0f, 30.0f);
        this.iWriter = PdfEventHandler.initFooter(this.iDocument, out);
        this.iDocument.open();
        if (this.iTable.isDispModeInRow()) {
            this.iDay = this.iTable.startDay();
            while (this.iDay <= this.iTable.endDay()) {
                if (!this.iTable.skipDay(this.iDay)) {
                    int rowNumber = 0;
                    Enumeration e = this.iTable.models().elements();
                    while (e.hasMoreElements()) {
                        this.printToPdf((TimetableGridModel)e.nextElement(), rowNumber);
                        ++rowNumber;
                    }
                    this.flushTable();
                }
                ++this.iDay;
            }
        } else {
            int rowNumber = 0;
            Enumeration e = this.iTable.models().elements();
            while (e.hasMoreElements()) {
                this.printToPdf((TimetableGridModel)e.nextElement(), rowNumber);
                ++rowNumber;
            }
        }
        this.printLegend();
        this.iDocument.close();
    }

    public int getNrColumns() {
        return 12 + (1 + this.iTable.lastSlot() - this.iTable.firstSlot());
    }

    public PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(sBorderColor);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        cell.setBorderWidthTop(1.0f);
        cell.setBorderWidthBottom(1.0f);
        cell.setBorderWidthLeft(1.0f);
        cell.setBorderWidthRight(1.0f);
        return cell;
    }

    public PdfPCell createCellNoBorder() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(sBorderColor);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        return cell;
    }

    public void addText(PdfPCell cell, String text) {
        if (text == null) {
            return;
        }
        this.addText(cell, text, false);
    }

    public void addText(PdfPCell cell, String text, boolean bold) {
        if (text == null) {
            return;
        }
        if (text.indexOf("<span") >= 0) {
            text = text.replaceAll("</span>", "").replaceAll("<span .*>", "");
        }
        if (cell.getPhrase() == null) {
            cell.setPhrase((Phrase)new Paragraph(text, PdfFont.getSmallFont(bold)));
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(1);
        } else {
            cell.getPhrase().add((Object)new Chunk("\n" + text, PdfFont.getSmallFont(bold)));
        }
    }

    public void addTextVertical(PdfPCell cell, String text) throws Exception {
        if (text == null) {
            return;
        }
        this.addTextVertical(cell, text, false);
    }

    public void addTextVertical(PdfPCell cell, String text, boolean bold) throws Exception {
        if (text == null) {
            return;
        }
        if (text.indexOf("<span") >= 0) {
            text = text.replaceAll("</span>", "").replaceAll("<span .*>", "");
        }
        Font font = PdfFont.getFont(bold);
        BaseFont bf = font.getBaseFont();
        float width = bf.getWidthPoint(text, font.getSize());
        PdfTemplate template = this.iWriter.getDirectContent().createTemplate(2.0f * font.getSize() + 4.0f, width);
        template.beginText();
        template.setColorFill(Color.BLACK);
        template.setFontAndSize(bf, font.getSize());
        template.setTextMatrix(0.0f, 2.0f);
        template.showText(text);
        template.endText();
        template.setWidth(width);
        template.setHeight(font.getSize() + 2.0f);
        Image img = Image.getInstance((PdfTemplate)template);
        img.setRotationDegrees(270.0f);
        Chunk ck = new Chunk(img, 0.0f, 0.0f);
        if (cell.getPhrase() == null) {
            cell.setPhrase((Phrase)new Paragraph(ck));
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(2);
        } else {
            cell.getPhrase().add((Object)ck);
        }
    }

    public void printHeader(TimetableGridModel model, int rowNumber) throws Exception {
        if (this.iTable.isDispModePerWeekVertical()) {
            for (int slot = this.iTable.lastSlot(); slot >= this.iTable.firstSlot(); slot -= this.iTable.nrSlotsPerPeriod()) {
                int time = (slot - this.iTable.nrSlotsPerPeriod() + 1) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                PdfPCell c = this.createCell();
                c.setColspan(this.iTable.nrSlotsPerPeriod());
                if (slot < this.iTable.lastSlot()) {
                    c.setBorderWidthLeft(0.0f);
                }
                this.addTextVertical(c, Constants.toTime(time), true);
                this.iPdfTable.addCell(c);
            }
            PdfPCell c = this.createCell();
            c.setColspan(12);
            c.setBorderWidthLeft(0.0f);
            if (model.getResourceType() == 0) {
                this.addTextVertical(c, "(" + model.getSize() + ", " + sUtF.format(model.getUtilization() / (double)this.iTable.nrSlotsPerPeriod()) + ")");
            } else if (model.getResourceType() == 3) {
                this.addTextVertical(c, "(" + model.getSize() + ")");
            } else if (model.getResourceType() == 5) {
                this.addTextVertical(c, "(" + model.getSize() + ", " + sUtF.format(100.0 * model.getUtilization()) + "%)");
            } else if (model.getSize() > 0) {
                this.addTextVertical(c, "(" + model.getSize() + ")");
            }
            this.addTextVertical(c, model.getName(), true);
            this.iPdfTable.addCell(c);
        } else {
            PdfPCell c = this.createCell();
            c.setColspan(12);
            if (this.iTable.isDispModeInRow()) {
                this.addText(c, CONSTANTS.days()[this.iDay], true);
            } else {
                this.addText(c, model.getName(), true);
                if (model.getResourceType() == 0) {
                    this.addText(c, "(" + model.getSize() + ", " + sUtF.format(model.getUtilization() / (double)this.iTable.nrSlotsPerPeriod()) + ")");
                } else if (model.getResourceType() == 3) {
                    this.addText(c, "(" + model.getSize() + ")");
                } else if (model.getResourceType() == 5) {
                    this.addText(c, "(" + model.getSize() + ", " + sUtF.format(100.0 * model.getUtilization()) + "%)");
                } else if (model.getSize() > 0) {
                    this.addText(c, "(" + model.getSize() + ")");
                }
            }
            this.iPdfTable.addCell(c);
            for (int slot = this.iTable.firstSlot(); slot <= this.iTable.lastSlot(); slot += this.iTable.nrSlotsPerPeriod()) {
                int time = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                c = this.createCell();
                c.setBorderWidthLeft(0.0f);
                c.setColspan(this.iTable.nrSlotsPerPeriod());
                this.addText(c, Constants.toTime(time), true);
                this.iPdfTable.addCell(c);
            }
        }
        this.iPdfTable.setHeaderRows(1);
    }

    private Color getColor(String rgbColor) {
        StringTokenizer x = new StringTokenizer(rgbColor.substring("rgb(".length(), rgbColor.length() - ")".length()), ",");
        return new Color(Integer.parseInt(x.nextToken()), Integer.parseInt(x.nextToken()), Integer.parseInt(x.nextToken()));
    }

    private void createTable() {
        this.iPdfTable = new PdfPTable(this.getNrColumns());
        this.iPdfTable.setWidthPercentage(100.0f);
        this.iPdfTable.getDefaultCell().setPadding(3.0f);
        this.iPdfTable.getDefaultCell().setBorderWidth(1.0f);
        this.iPdfTable.setSplitRows(false);
        this.iPdfTable.setSpacingBefore(10.0f);
        if (this.iTable.isDispModePerWeek()) {
            this.iPdfTable.setKeepTogether(true);
        }
    }

    private void flushTable() throws Exception {
        this.iDocument.add((Element)this.iPdfTable);
    }

    public void printToPdf(TimetableGridModel model, int rowNumber) throws Exception {
        model.clearRendered();
        if (this.iTable.isDispModePerWeek()) {
            this.createTable();
            this.printHeader(model, 0);
        } else if (rowNumber == 0) {
            this.createTable();
            this.printHeader(model, 0);
        }
        if (this.iTable.isDispModeInRow()) {
            int maxIdx = model.getMaxIdxForDay(this.iDay, this.iTable.firstSlot(), this.iTable.lastSlot());
            for (int idx = 0; idx <= maxIdx; ++idx) {
                PdfPCell c = this.createCell();
                c.setBorderWidthTop(0.0f);
                if (idx == 0) {
                    this.addText(c, model.getName() + (model.getSize() > 0 ? " (" + model.getSize() + ")" : ""), true);
                }
                c.setBorderWidthBottom(idx == maxIdx ? 1.0f : 0.0f);
                c.setColspan(12);
                this.iPdfTable.addCell(c);
                for (int slot = this.iTable.firstSlot(); slot <= this.iTable.lastSlot(); ++slot) {
                    String bgColor;
                    int colSpan;
                    int slotsToEnd = this.iTable.lastSlot() - slot + 1;
                    TimetableGridCell cell = model.getCell(this.iDay, slot, idx);
                    int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                    int n = colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                    if (cell == null) {
                        bgColor = model.getBackground(this.iDay, slot);
                        if (bgColor == null && !model.isAvailable(this.iDay, slot)) {
                            bgColor = TimetableGridCell.sBgColorNotAvailable;
                        }
                        c = this.createCell();
                        c.setBorderWidthTop(0.0f);
                        c.setBorderWidthBottom(idx == maxIdx ? 1.0f : (model.getCell(this.iDay, slot, idx + 1) != null ? 1.0f : 0.0f));
                        c.setBorderWidthLeft(0.0f);
                        boolean eod = slot == this.iTable.lastSlot();
                        boolean in = !eod && model.getCell(this.iDay, slot + 1, idx) == null && (slot + 1 - this.iTable.firstSlot()) % this.iTable.nrSlotsPerPeriod() != 0;
                        c.setBorderWidthRight(eod || !in ? 1.0f : 0.0f);
                        c.setColspan(colSpan);
                        if (bgColor != null) {
                            c.setBackgroundColor(this.getColor(bgColor));
                        }
                        this.iPdfTable.addCell(c);
                        continue;
                    }
                    bgColor = cell.getBackground();
                    if (this.iTable.getBgMode() == 0) {
                        for (int i = 0; i < length; ++i) {
                            if (model.isAvailable(this.iDay, slot + i)) continue;
                            bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                            break;
                        }
                    }
                    c = this.createCell();
                    c.setBorderWidthTop(0.0f);
                    c.setBorderWidthLeft(0.0f);
                    c.setColspan(colSpan);
                    c.setBackgroundColor(this.getColor(bgColor));
                    this.addText(c, cell.getName());
                    if (this.iTable.getShowTimes()) {
                        this.addText(c, cell.getTime());
                    }
                    if (this.iTable.getResourceType() != 0) {
                        this.addText(c, cell.getRoomName());
                    }
                    if (this.iTable.getResourceType() != 1 && this.iTable.getShowInstructors() && !cell.getInstructor().isEmpty()) {
                        this.addText(c, cell.getInstructor());
                    }
                    if (this.iTable.getShowComments()) {
                        this.addText(c, cell.getShortCommentNoColors() == null ? null : cell.getShortCommentNoColors());
                    }
                    if (this.iTable.getWeek() == -100 && cell.hasDays() && !cell.getDays().equals(this.iTable.getDefaultDatePatternName())) {
                        this.addText(c, cell.getDays());
                    }
                    this.iPdfTable.addCell(c);
                    slot += length - 1;
                }
            }
        } else if (this.iTable.isDispModePerWeekHorizontal()) {
            for (int day = this.iTable.startDay(); day <= this.iTable.endDay(); ++day) {
                if (this.iTable.skipDay(day)) continue;
                int maxIdx = model.getMaxIdxForDay(day, this.iTable.firstSlot(), this.iTable.lastSlot());
                for (int idx = 0; idx <= maxIdx; ++idx) {
                    PdfPCell c = this.createCell();
                    c.setBorderWidthTop(0.0f);
                    if (idx == 0) {
                        this.addText(c, CONSTANTS.days()[day], true);
                    }
                    c.setBorderWidthBottom(idx == maxIdx ? 1.0f : 0.0f);
                    c.setColspan(12);
                    this.iPdfTable.addCell(c);
                    for (int slot = this.iTable.firstSlot(); slot <= this.iTable.lastSlot(); ++slot) {
                        String bgColor;
                        int colSpan;
                        int slotsToEnd = this.iTable.lastSlot() - slot + 1;
                        TimetableGridCell cell = model.getCell(day, slot, idx);
                        int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                        int n = colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            c = this.createCell();
                            c.setBorderWidthTop(0.0f);
                            c.setBorderWidthBottom(idx == maxIdx ? 1.0f : (model.getCell(day, slot, idx + 1) != null ? 1.0f : 0.0f));
                            c.setBorderWidthLeft(0.0f);
                            boolean eod = slot == this.iTable.lastSlot();
                            boolean in = !eod && model.getCell(day, slot + 1, idx) == null && (slot + 1 - this.iTable.firstSlot()) % this.iTable.nrSlotsPerPeriod() != 0;
                            c.setBorderWidthRight(eod || !in ? 1.0f : 0.0f);
                            this.iPdfTable.addCell(c);
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.iTable.getBgMode() == 0) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        c = this.createCell();
                        c.setBorderWidthTop(0.0f);
                        c.setBorderWidthLeft(0.0f);
                        c.setColspan(colSpan);
                        if (bgColor != null) {
                            c.setBackgroundColor(this.getColor(bgColor));
                        }
                        this.addText(c, cell.getName());
                        if (this.iTable.getShowTimes()) {
                            this.addText(c, cell.getTime());
                        }
                        if (this.iTable.getResourceType() != 0) {
                            this.addText(c, cell.getRoomName());
                        }
                        if (this.iTable.getResourceType() != 1 && this.iTable.getShowInstructors() && !cell.getInstructor().isEmpty()) {
                            this.addText(c, cell.getInstructor());
                        }
                        if (this.iTable.getShowComments()) {
                            this.addText(c, cell.getShortCommentNoColors() == null ? null : cell.getShortCommentNoColors());
                        }
                        if (this.iTable.getWeek() == -100 && cell.hasDays() && !cell.getDays().equals(this.iTable.getDefaultDatePatternName())) {
                            this.addText(c, cell.getDays());
                        }
                        this.iPdfTable.addCell(c);
                        slot += length - 1;
                    }
                }
            }
        } else if (this.iTable.isDispModeWeekByWeekHorizontal()) {
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(this.iTable.iFirstDate);
            for (int d = 0; d < 365; ++d) {
                int day;
                if (d > 0) {
                    cal.add(6, 1);
                }
                int date = d + this.iTable.iFirstDay;
                if (model.getFirstDay() >= 0 && (date < model.getFirstDay() || date > model.getFirstDay() + 6) || (day = d % 7) < this.iTable.startDay() || day > this.iTable.endDay() || this.iTable.skipDay(day)) continue;
                boolean hasClasses = false;
                for (int slot = this.iTable.firstSlot(); slot <= this.iTable.lastSlot(); ++slot) {
                    if (model.getCell(day, slot, 0, date) == null) continue;
                    hasClasses = true;
                    break;
                }
                if (!hasClasses) continue;
                int maxIdx = model.getMaxIdxForDay(day, this.iTable.firstSlot(), this.iTable.lastSlot(), date);
                for (int idx = 0; idx <= maxIdx; ++idx) {
                    PdfPCell c = this.createCell();
                    c.setBorderWidthTop(0.0f);
                    if (idx == 0) {
                        this.addText(c, CONSTANTS.days()[day] + " " + sDF.format(cal.getTime()), true);
                    }
                    c.setBorderWidthBottom(idx == maxIdx ? 1.0f : 0.0f);
                    c.setColspan(12);
                    this.iPdfTable.addCell(c);
                    for (int slot = this.iTable.firstSlot(); slot <= this.iTable.lastSlot(); ++slot) {
                        String bgColor;
                        int colSpan;
                        int slotsToEnd = this.iTable.lastSlot() - slot + 1;
                        TimetableGridCell cell = model.getCell(day, slot, idx, date);
                        int length = cell == null ? 1 : cell.getLength() + cell.getSlot() - slot;
                        int n = colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            c = this.createCell();
                            c.setBorderWidthTop(0.0f);
                            c.setBorderWidthBottom(idx == maxIdx ? 1.0f : (model.getCell(day, slot, idx + 1, date) != null ? 1.0f : 0.0f));
                            c.setBorderWidthLeft(0.0f);
                            boolean eod = slot == this.iTable.lastSlot();
                            boolean in = !eod && model.getCell(day, slot + 1, idx, date) == null && (slot + 1 - this.iTable.firstSlot()) % this.iTable.nrSlotsPerPeriod() != 0;
                            c.setBorderWidthRight(eod || !in ? 1.0f : 0.0f);
                            this.iPdfTable.addCell(c);
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.iTable.getBgMode() == 0) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot + i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        c = this.createCell();
                        c.setBorderWidthTop(0.0f);
                        c.setBorderWidthLeft(0.0f);
                        c.setColspan(colSpan);
                        if (bgColor != null) {
                            c.setBackgroundColor(this.getColor(bgColor));
                        }
                        this.addText(c, cell.getName());
                        if (this.iTable.getShowTimes()) {
                            this.addText(c, cell.getTime());
                        }
                        if (this.iTable.getResourceType() != 0) {
                            this.addText(c, cell.getRoomName());
                        }
                        if (this.iTable.getResourceType() != 1 && this.iTable.getShowInstructors() && !cell.getInstructor().isEmpty()) {
                            this.addText(c, cell.getInstructor());
                        }
                        if (this.iTable.getShowComments()) {
                            this.addText(c, cell.getShortCommentNoColors() == null ? null : cell.getShortCommentNoColors());
                        }
                        this.iPdfTable.addCell(c);
                        slot += length - 1;
                    }
                }
            }
        } else {
            for (int day = this.iTable.startDay(); day <= this.iTable.endDay(); ++day) {
                if (this.iTable.skipDay(day)) continue;
                int maxIdx = model.getMaxIdxForDay(day, this.iTable.firstSlot(), this.iTable.lastSlot());
                for (int idx = 0; idx <= maxIdx; ++idx) {
                    PdfPCell c = null;
                    for (int slot = this.iTable.lastSlot(); slot >= this.iTable.firstSlot(); --slot) {
                        String bgColor;
                        int colSpan;
                        int slotsToEnd = slot + 1 - this.iTable.firstSlot();
                        TimetableGridCell cell = model.getCell(day, slot, idx);
                        int length = cell == null ? 1 : 1 + slot - cell.getSlot();
                        int n = colSpan = cell == null ? 1 : Math.min(length, slotsToEnd);
                        if (cell == null) {
                            bgColor = model.getBackground(day, slot);
                            if (bgColor == null && !model.isAvailable(day, slot)) {
                                bgColor = TimetableGridCell.sBgColorNotAvailable;
                            }
                            c = this.createCell();
                            c.setBorderWidthTop(0.0f);
                            c.setMinimumHeight(100.0f);
                            c.setBorderWidthBottom(idx == maxIdx ? 1.0f : (model.getCell(day, slot, idx + 1) != null ? 1.0f : 0.0f));
                            c.setBorderWidthLeft(slot == this.iTable.lastSlot() ? 1.0f : 0.0f);
                            boolean eod = slot == this.iTable.firstSlot();
                            boolean in = !eod && model.getCell(day, slot - 1, idx) == null && (slot - this.iTable.firstSlot()) % this.iTable.nrSlotsPerPeriod() != 0;
                            c.setBorderWidthRight(eod || !in ? 1.0f : 0.0f);
                            this.iPdfTable.addCell(c);
                            continue;
                        }
                        bgColor = cell.getBackground();
                        if (this.iTable.getBgMode() == 0) {
                            for (int i = 0; i < length; ++i) {
                                if (model.isAvailable(day, slot - i)) continue;
                                bgColor = TimetableGridCell.sBgColorNotAvailableButAssigned;
                                break;
                            }
                        }
                        c = this.createCell();
                        c.setBorderWidthTop(0.0f);
                        c.setBorderWidthLeft(slot == this.iTable.lastSlot() ? 1.0f : 0.0f);
                        c.setColspan(colSpan);
                        if (bgColor != null) {
                            c.setBackgroundColor(this.getColor(bgColor));
                        }
                        if (this.iTable.getWeek() == -100 && cell.hasDays() && !cell.getDays().equals(this.iTable.getDefaultDatePatternName())) {
                            this.addTextVertical(c, cell.getDays());
                        }
                        if (this.iTable.getShowTimes()) {
                            this.addText(c, cell.getTime());
                        }
                        if (this.iTable.getResourceType() != 0) {
                            this.addTextVertical(c, cell.getRoomName());
                        }
                        if (this.iTable.getResourceType() != 1 && this.iTable.getShowInstructors() && !cell.getInstructor().isEmpty()) {
                            this.addTextVertical(c, cell.getInstructor());
                        }
                        if (this.iTable.getShowComments()) {
                            this.addTextVertical(c, cell.getShortCommentNoColors() == null ? null : cell.getShortCommentNoColors());
                        }
                        this.addTextVertical(c, cell.getName());
                        this.iPdfTable.addCell(c);
                        slot -= length - 1;
                    }
                    c = this.createCell();
                    c.setBorderWidthTop(0.0f);
                    c.setBorderWidthLeft(0.0f);
                    if (idx == 0) {
                        this.addTextVertical(c, CONSTANTS.days()[day], true);
                    }
                    c.setBorderWidthBottom(idx == maxIdx ? 1.0f : 0.0f);
                    c.setColspan(12);
                    this.iPdfTable.addCell(c);
                }
            }
        }
        if (this.iTable.isDispModePerWeek()) {
            this.flushTable();
        }
    }

    private void addLegendRow(String color, String text) {
        PdfPCell c = this.createCellNoBorder();
        c.setBorderWidth(1.0f);
        c.setBackgroundColor(this.getColor(color));
        this.iPdfTable.addCell(c);
        c = this.createCellNoBorder();
        this.addText(c, "  " + text);
        c.setHorizontalAlignment(0);
        this.iPdfTable.addCell(c);
    }

    public void printLegend() throws Exception {
        PdfPCell c;
        this.iPdfTable = new PdfPTable(2);
        this.iPdfTable.setWidths(new float[]{10.0f, 200.0f});
        this.iPdfTable.getDefaultCell().setPadding(3.0f);
        this.iPdfTable.getDefaultCell().setBorderWidth(1.0f);
        this.iPdfTable.setHorizontalAlignment(0);
        this.iPdfTable.setSplitRows(false);
        this.iPdfTable.setSpacingBefore(10.0f);
        this.iPdfTable.setKeepTogether(true);
        if (this.iTable.getBgMode() != 0) {
            c = this.createCellNoBorder();
            c.setColspan(2);
            this.addText(c, "Assigned classes:");
            c.setHorizontalAlignment(0);
            this.iPdfTable.addCell(c);
        }
        if (this.iTable.getBgMode() == 1) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sRequired), "Required time");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred), "Strongly preferred time");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sPreferred), "Preferred time");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No time preference");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Discouraged time");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Strongly discouraged time");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Prohibited time");
        } else if (this.iTable.getBgMode() == 2) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sRequired), "Required room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred), "Strongly preferred room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sPreferred), "Preferred room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No room preference");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Discouraged room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Strongly discouraged room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Prohibited room");
        } else if (this.iTable.getBgMode() == 3) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2color(nrConflicts);
                this.addLegendRow(color, "" + nrConflicts + " " + (nrConflicts == 15 ? "or more " : "") + "student conflicts");
            }
        } else if (this.iTable.getBgMode() == 4) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No instructor back-to-back preference (distance=0)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Discouraged back-to-back (0<distance<=5)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Strongly discouraged back-to-back (5<distance<=20)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Prohibited back-to-back (20<distance)");
        } else if (this.iTable.getBgMode() == 5) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No violated constraint(distance=0)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Discouraged/preferred constraint violated");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Strongly discouraged/preferred constraint violated");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Required/prohibited constraint violated");
        } else if (this.iTable.getBgMode() == 6) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred), "No change");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No initial assignment");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Room changed");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Time changed");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Both time and room changed");
        } else if (this.iTable.getBgMode() == 7) {
            for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2color(nrConflicts);
                this.addLegendRow(color, "" + (nrConflicts == 0 ? "Zero perturbation penalty" : (nrConflicts == 15 ? "Perturbation penalty above 15" : "Perturbation penalty below or equal to " + nrConflicts)) + "");
            }
        } else if (this.iTable.getBgMode() == 8) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sRequired), "Required time and room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyPreferred), "Can be moved in room with no hard conflict");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sPreferred), "Can be moved in room (but there is a hard conflict), can be moved in time with no conflict");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "Can be moved in room (but there is a hard conflict)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Can be moved in time with no hard conflict, cannot be moved in room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Can be moved in time (but there is a hard conflict), cannot be moved in room");
        } else if (this.iTable.getBgMode() == 9) {
            for (int nrConflicts = 0; nrConflicts <= 3; ++nrConflicts) {
                String color = TimetableGridCell.conflicts2colorFast(nrConflicts);
                this.addLegendRow(color, "" + (nrConflicts == 0 ? "Zero penalty" : (nrConflicts == 3 ? "Penalty equal or above 3" : "Penalty equal to " + nrConflicts)) + "");
            }
        } else if (this.iTable.getBgMode() == 10) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sRequired), "Assigned room is smaller than room limit of a class");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "Assigned room is not more than 25% bigger than the smallest avaialable room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Assigned room is not more than 50% bigger than the smallest avaialable room");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Assigned room is more than 50% bigger than the smallest avaialable room");
        } else if (this.iTable.getBgMode() == 11) {
            this.addLegendRow(TimetableGridCell.percentage2color(100), "All students of the group are in this class");
            for (int p = 95; p >= 5; p -= 5) {
                this.addLegendRow(TimetableGridCell.percentage2color(p), "More than " + p + "% students of the group are in this class");
            }
            this.addLegendRow(TimetableGridCell.percentage2color(0), "Less than 5% students of the group are in this class");
        }
        c = this.createCellNoBorder();
        c.setColspan(2);
        this.addText(c, "Free times:");
        c.setHorizontalAlignment(0);
        this.iPdfTable.addCell(c);
        this.addLegendRow(TimetableGridCell.sBgColorNotAvailable, "Time not available");
        this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sNeutral), "No preference");
        if (this.iTable.getShowUselessTimes()) {
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sDiscouraged), "Standard (MWF or TTh) time pattern is broken (time cannot be used for MW, WF, MF or TTh class)");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sStronglyDiscouraged), "Useless half-hour");
            this.addLegendRow(TimetableGridCell.pref2color(PreferenceLevel.sProhibited), "Useless half-hour and broken standard time pattern");
        }
        if (this.iTable.isDispModePerWeekVertical()) {
            this.iDocument.newPage();
        }
        this.iDocument.add((Element)this.iPdfTable);
    }
}

